/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.tool;

import com.tcbj.crm.tool.Configuration;
import com.tcbj.crm.tool.DisplayField;
import com.tcbj.crm.tool.FM;
import com.tcbj.crm.tool.InputType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class Templet {
    protected List<DisplayField> masterFieldList;
    protected Map<String, List<DisplayField>> slaveMap = new HashMap<String, List<DisplayField>>();
    protected Class<?> masterClazz;
    protected List<Class<?>> slaveList;
    Configuration config;

    public Templet setTextClass(String textClass) {
        return this;
    }

    public Templet(Class<?> clazz) {
        this.masterClazz = clazz;
        this.masterFieldList = Templet.getDisplayFieldList(clazz);
    }

    public Templet(Class<?> clazz, List<Class<?>> slaveList) {
        if (clazz == null) {
            throw new NullPointerException("\u4e3b\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.masterClazz = clazz;
        this.slaveList = slaveList;
        this.masterFieldList = Templet.getDisplayFieldList(clazz);
        for (Class<?> cls : slaveList) {
            List<DisplayField> l = Templet.getDisplayFieldList(cls);
            this.slaveMap.put(cls.getName(), l);
        }
    }

    public String getClassName(Class<?> clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    public static List<DisplayField> getDisplayFieldList(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<DisplayField> list = new ArrayList<DisplayField>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            FM fm = field.getAnnotation(FM.class);
            if (fm != null) {
                list.add(new DisplayField(fm, field));
            }
            ++n2;
        }
        Collections.sort(list, new Comparator<DisplayField>(){

            @Override
            public int compare(DisplayField df1, DisplayField df2) {
                return df1.getOrder() - df2.getOrder();
            }
        });
        return list;
    }

    protected String getTemplet() throws IOException {
        URL url = this.getClass().getResource(this.getTempletPage());
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new FileNotFoundException("listTemplet.ftl\u6a21\u677f\u6587\u4ef6\u672a\u627e\u5230");
        }
        File file = new File(uri);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            byte[] buff = new byte[((InputStream)in).available()];
            ((InputStream)in).read(buff);
            String templet = new String(buff);
            return templet;
        }
        throw new FileNotFoundException("listTemplet.ftl\u6a21\u677f\u6587\u4ef6\u672a\u627e\u5230");
    }

    public abstract String getTempletPage();

    public final String create(Configuration config) throws Exception {
        this.config = config;
        String templet = this.createPage();
        templet = templet.replaceAll("\\&amp;", "\\&");
        templet = templet.replaceAll("\\&lt;", "\\<");
        templet = templet.replaceAll("\\&gt;", "\\>");
        return templet;
    }

    public abstract String createPage() throws Exception;

    public static void appendAttributeValue(Element e, String name, String value) {
        String classValue = e.attributeValue(name);
        if (classValue != null) {
            e.remove(e.attribute(name));
            e.addAttribute(name, String.valueOf(classValue) + " " + value);
        } else {
            e.addAttribute(name, value);
        }
    }

    public Element getInputText(DisplayField df) {
        InputType type = df.getInputType();
        String name = df.getValue();
        boolean required = df.isRequired();
        Element input = type.toElement(this.firstToLowerCase(this.getMinName()), df);
        input.addAttribute("name", name);
        if (df.getInputType() == InputType.date) {
            input.addAttribute("value", "<#if " + this.firstToLowerCase(this.getMinName()) + "?? #and# " + this.firstToLowerCase(this.getMinName()) + "." + name + "?? >\\${" + this.firstToLowerCase(this.getMinName()) + "." + name + "?date}</#if>");
        } else {
            input.addAttribute("value", "\\${(" + this.firstToLowerCase(this.getMinName()) + "." + name + ")!}");
        }
        if (required) {
            Templet.appendAttributeValue(input, "class", "required");
        }
        return input;
    }

    protected String getMinName() {
        String fullName = this.masterClazz.getName();
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    protected String getPackageName() {
        return this.config.getPackageName();
    }

    protected String createTableContent() {
        Element tbody = DocumentHelper.createElement((String)"tbody");
        Element tr = null;
        Element hiddenTr = DocumentHelper.createElement((String)"tr").addAttribute("style", "display:none;");
        int j = 0;
        tbody.add(hiddenTr);
        int i = 0;
        while (i < this.masterFieldList.size()) {
            DisplayField df = this.masterFieldList.get(i);
            if (df.hidden) {
                this.createInput(hiddenTr, df);
            } else {
                if (j % this.config.getClos() == 0) {
                    tr = DocumentHelper.createElement((String)"tr");
                    tbody.add(tr);
                }
                ++j;
                this.createInput(tr, df);
            }
            ++i;
        }
        return tbody.asXML();
    }

    protected String createTable() {
        Element tbody = DocumentHelper.createElement((String)"tbody");
        Element tr = null;
        Element hiddenTr = DocumentHelper.createElement((String)"tr").addAttribute("style", "display:none;");
        int j = 0;
        tbody.add(hiddenTr);
        int i = 0;
        while (i < this.masterFieldList.size()) {
            DisplayField df = this.masterFieldList.get(i);
            if (df.hidden) {
                this.createLable(hiddenTr, df);
            } else {
                if (j % this.config.getClos() == 0) {
                    tr = DocumentHelper.createElement((String)"tr");
                    tbody.add(tr);
                }
                ++j;
                this.createLable(tr, df);
            }
            ++i;
        }
        return tbody.asXML();
    }

    private void createLable(Element tr, DisplayField df) {
        Element rtd = DocumentHelper.createElement((String)"td").addAttribute("class", "right").addAttribute("width", "80px;");
        rtd.addText(df.getName());
        if (df.isRequired()) {
            rtd.add(DocumentHelper.createElement((String)"i").addText("*"));
        }
        Element ltd = DocumentHelper.createElement((String)"td").addAttribute("class", "left");
        tr.add(rtd);
        tr.add(ltd);
        ltd.addText("\\${(" + this.firstToLowerCase(this.getMinName()) + "." + df.getValue() + ")!}");
    }

    private void createInput(Element tr, DisplayField df) {
        Element rtd = DocumentHelper.createElement((String)"td").addAttribute("class", "right").addAttribute("width", "80px;");
        rtd.addText(df.getName());
        if (df.isRequired()) {
            rtd.add(DocumentHelper.createElement((String)"i").addText("*"));
        }
        Element ltd = DocumentHelper.createElement((String)"td").addAttribute("class", "left");
        tr.add(rtd);
        tr.add(ltd);
        ltd.add(this.getInputText(df));
    }

    public String firstToLowerCase(String name) {
        char c = name.charAt(0);
        String s = String.valueOf(c).toLowerCase();
        s = String.valueOf(s) + name.substring(1);
        return s;
    }
}

