/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.util;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.util.ExcelRow;
import com.tcbj.crm.util.PartnerForExcel;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ImportData {
    private static String OrgId = "1-1JK1";

    public static List<ExcelRow> get(BaseDao dao) {
        PartnerContact e;
        List employeeShops = dao.findEntity("from ContactShop", ContactShop.class);
        List shops = dao.findEntity("from ShopView", ShopView.class);
        List partners = dao.findEntity("from PartnerForExcel", PartnerForExcel.class);
        HashMap shopEmployeeMap = new HashMap();
        Map<Object, Object> employeeMap = new HashMap();
        HashMap<String, PartnerForExcel> partnerMap = new HashMap<String, PartnerForExcel>();
        employeeMap = Cache.getEmployees();
        for (ContactShop es : employeeShops) {
            ArrayList<PartnerContact> shopEmployees = (ArrayList<PartnerContact>)shopEmployeeMap.get(es.getShopId());
            if (shopEmployees == null) {
                shopEmployees = new ArrayList<PartnerContact>();
                shopEmployeeMap.put(es.getShopId(), shopEmployees);
            }
            String employeeId = es.getUserId();
            e = (PartnerContact)employeeMap.get(employeeId);
            shopEmployees.add(e);
        }
        for (PartnerForExcel partner : partners) {
            partner.setCengji(1);
            partnerMap.put(partner.getId(), partner);
        }
        ImportData.initPartnerLevel(partnerMap, partners);
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        for (ShopView shop : shops) {
            ExcelRow row = new ExcelRow();
            row.setNo(shop.getShopNumber());
            row.setName(shop.getShopName());
            row.setArea(shop.getAreaId());
            row.setBigarea(shop.getBigAreaId());
            row.setProvince(shop.getProvinceId());
            row.setCity(shop.getCityId());
            row.setCounty(shop.getCountyId());
            row.setMianji(shop.getShopTotalArea());
            row.setType(shop.getShopType());
            row.setSubType(shop.getShopClassify());
            row.setIsmember(shop.getIsMenberShop());
            row.setPromotionNumber(shop.getPromotionNumber());
            row.setSaleMode(shop.getPromotionMode());
            row.setShoppeNumber(shop.getShoppeNumber());
            row.setShopTel(shop.getShopTel());
            row.setAddressDetails(shop.getAddressDetails());
            row.setStartDate(shop.getStartDate());
            row.setEndDate(shop.getEndDate());
            e = (PartnerContact)employeeMap.get(shop.getSalseManId());
            if (e != null) {
                row.setSeller(e.getContactName());
            }
            String partnerId = shop.getParentDealerId();
            ImportData.setPartner(row, partnerMap, partnerId);
            List shopEmployees = (List)shopEmployeeMap.get(shop.getId());
            if (shopEmployees != null) {
                for (PartnerContact employee : shopEmployees) {
                    if (employee == null) continue;
                    if (employee.getPartnerId().equals(OrgId)) {
                        if ("Distict Manager".equals(employee.getDutyTypeCode())) {
                            row.setBigManager(employee.getContactName());
                            continue;
                        }
                        if ("Region Manager".equals(employee.getDutyTypeCode())) {
                            row.setAreaManager(employee.getContactName());
                            continue;
                        }
                        if ("City Manager".equals(employee.getDutyTypeCode())) {
                            row.setCityManager(employee.getContactName());
                            continue;
                        }
                        if (!"Market Represent".equals(employee.getDutyTypeCode())) continue;
                        row.setMarketer(employee.getContactName());
                        continue;
                    }
                    if ("Market Represent".equals(employee.getDutyTypeCode())) {
                        row.setPartner1M(employee.getContactName());
                        continue;
                    }
                    if (!"Shopping Guide".equals(employee.getDutyTypeCode())) continue;
                    row.setPartner1D(employee.getContactName());
                }
            }
            rows.add(row);
        }
        return rows;
    }

    private static void initPartnerLevel(Map<String, PartnerForExcel> partnerMap, List<PartnerForExcel> partners) {
        for (PartnerForExcel partner : partners) {
            PartnerForExcel p2_partner;
            String pid = partner.getParentPartnerId();
            if (StringUtils.isEmpty(pid)) continue;
            if (pid.equals(OrgId)) {
                partner.setCengji(1);
                continue;
            }
            PartnerForExcel p_partner = partnerMap.get(pid);
            if (p_partner == null) continue;
            if (!StringUtils.isEmpty(p_partner.getParentPartnerId()) && p_partner.getParentPartnerId().equals(OrgId)) {
                partner.setCengji(2);
            }
            if ((p2_partner = partnerMap.get(p_partner.getParentPartnerId())) == null || StringUtils.isEmpty(p2_partner.getParentPartnerId()) || !p2_partner.getParentPartnerId().equals(OrgId)) continue;
            partner.setCengji(3);
        }
    }

    private static void setPartner(ExcelRow row, Map<String, PartnerForExcel> partnerMap, String partnerId) {
        PartnerForExcel partner = partnerMap.get(partnerId);
        if (partner == null) {
            return;
        }
        Integer centji = partner.getCengji();
        if (centji == null) {
            return;
        }
        if (centji == 3) {
            row.setPartner3(partner.getName());
            row.setPartner3F(partner.getSmName());
            row.setPartner3M(partner.getSmPhone());
            row.setPartner3No(partner.getNo());
            PartnerForExcel partner2 = partnerMap.get(partner.getParentPartnerId());
            if (partner2 != null) {
                row.setPartner2(partner2.getName());
                row.setPartner2No(partner2.getNo());
                row.setPartner2F(partner2.getSmName());
                row.setPartner2M(partner2.getSmPhone());
                PartnerForExcel partner1 = partnerMap.get(partner2.getParentPartnerId());
                if (partner1 != null) {
                    row.setPartner1(partner1.getName());
                    row.setPartner1No(partner1.getNo());
                }
            }
        } else if (centji == 2) {
            row.setPartner2(partner.getName());
            row.setPartner2F(partner.getSmName());
            row.setPartner2M(partner.getSmPhone());
            row.setPartner2No(partner.getNo());
            PartnerForExcel partner1 = partnerMap.get(partner.getParentPartnerId());
            if (partner1 != null) {
                row.setPartner1(partner1.getName());
                row.setPartner1No(partner1.getNo());
            }
        } else if (centji == 1) {
            row.setPartner1(partner.getName());
            row.setPartner1No(partner.getNo());
        }
    }

    public static void excels(List<ExcelRow> list, String path, String name, HttpServletResponse response, HttpServletRequest request) {
        int sheetSize = list.size() / 20000 + 1;
        int j = 0;
        while (j < sheetSize) {
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet sheet = wb.createSheet("0");
            Row row = sheet.createRow(0);
            String[] names = new String[]{"\u5927\u533a", "\u5927\u533a\u7ecf\u7406", "\u7701\u4efd", "\u533a\u57df", "\u533a\u57df\u7ecf\u7406", "\u57ce\u5e02", "\u53bf\u57ce\uff08\u533a\uff09", "\u57ce\u5e02\u7ecf\u7406", "\u5e02\u573a\u4ee3\u8868", "\u4e1a\u52a1\u5458", "\u4e00\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e00\u7ea7\u7ecf\u9500\u5546", "\u7ecf\u9500\u5546\u5e02\u573a\u4ee3\u8868", "\u7ecf\u9500\u5546\u5bfc\u8d2d", "\u4e8c\u6279\u5c5e\u6027", "\u8fde\u9501\u7f16\u53f7", "\u8fde\u9501/\u4e8c\u7ea7\u5206\u9500\u5546", "\u4e09\u7ea7\u8fde\u9501\u7f16\u53f7", "\u8fde\u9501/\u4e09\u7ea7\u5206\u9500\u5546", "\u8fde\u9501/\u4e09\u7ea7\u5206\u9500\u5546\u8d1f\u8d23\u4eba", "\u8d1f\u8d23\u4eba\u624b\u673a\u53f7", "\u95e8\u5e97\u7f16\u53f7", "\u662f\u5426\u4f1a\u5458\u5e97", "\u4f1a\u5458\u5e97\u7533\u8bf7\u65f6\u95f4", "\u95e8\u5e97\u540d\u79f0", "\u8be6\u7ec6\u5730\u5740", "\u5e97\u957f\u59d3\u540d", "\u5e97\u957f\u624b\u673a", "\u9500\u552e\u6a21\u5f0f", "\u95e8\u5e97\u7c7b\u578b", "\u95e8\u5e97\u5206\u7ea7", "\u4fc3\u9500\u4eba\u5458\u6570", "\u4e13\u67dc\u4e2a\u6570", "\u95e8\u5e97\u603b\u9762\u79ef(\u5e73\u65b9\u7c73\uff09", "\u4f1a\u5458\u5e97\u5e73\u53f0\u7cfb\u7edf", "\u95e8\u5e97\u53ef\u7528\u4ea7\u54c1\u79ef\u5206", "\u95e8\u5e97\u53ef\u7528\u793c\u54c1\u79ef\u5206", "\u95e8\u5e97\u9500\u552e\u79ef\u5206", "\u95e8\u5e97\u603b\u79ef\u5206", "\u5907\u6ce8", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4"};
            int i = 0;
            while (i < names.length) {
                row.createCell(i).setCellValue(names[i]);
                ++i;
            }
            int size = 20000 * (j + 1);
            if (size > list.size()) {
                size = list.size();
            }
            int k = 0;
            ExcelRow stu = null;
            int i2 = 20000 * j;
            while (i2 < size) {
                row = sheet.createRow(k + 1);
                stu = list.get(i2);
                row.createCell(0).setCellValue(stu.getBigAreaName());
                row.createCell(1).setCellValue(stu.getBigManager());
                row.createCell(2).setCellValue(stu.getProvinceName());
                row.createCell(3).setCellValue(stu.getAreaName());
                row.createCell(4).setCellValue(stu.getAreaManager());
                row.createCell(5).setCellValue(stu.getCityName());
                row.createCell(6).setCellValue(stu.getCountyName());
                row.createCell(7).setCellValue(stu.getCityManager());
                row.createCell(8).setCellValue(stu.getMarketer());
                row.createCell(9).setCellValue(stu.getSeller());
                row.createCell(10).setCellValue(stu.getPartner1No());
                row.createCell(11).setCellValue(stu.getPartner1());
                row.createCell(12).setCellValue(stu.getPartner1M());
                row.createCell(13).setCellValue(stu.getPartner1D());
                row.createCell(14).setCellValue("");
                row.createCell(15).setCellValue(stu.getPartner2No());
                row.createCell(16).setCellValue(stu.getPartner2());
                row.createCell(17).setCellValue(stu.getPartner3No());
                row.createCell(18).setCellValue(stu.getPartner3());
                row.createCell(19).setCellValue(stu.getSaleModeName());
                row.createCell(20).setCellValue("");
                row.createCell(21).setCellValue(stu.getNo());
                row.createCell(22).setCellValue(stu.getIsMemberName());
                row.createCell(23).setCellValue("");
                row.createCell(24).setCellValue(stu.getName());
                row.createCell(25).setCellValue(stu.getAddressDetails());
                row.createCell(26).setCellValue("");
                row.createCell(27).setCellValue(stu.getShopTel());
                row.createCell(28).setCellValue(stu.getSaleModeName());
                row.createCell(29).setCellValue(stu.getTypeName());
                row.createCell(30).setCellValue(stu.getSubTypeName());
                row.createCell(31).setCellValue(String.valueOf(stu.getShoppeNumber()));
                row.createCell(32).setCellValue(String.valueOf(stu.getPromotionNumber()));
                row.createCell(33).setCellValue(String.valueOf(stu.getMianji()));
                row.createCell(34).setCellValue("");
                row.createCell(35).setCellValue("");
                row.createCell(36).setCellValue("");
                row.createCell(37).setCellValue("");
                row.createCell(38).setCellValue("");
                row.createCell(39).setCellValue("");
                row.createCell(40).setCellValue(String.valueOf(stu.getStartDate()));
                row.createCell(41).setCellValue(String.valueOf(stu.getEndDate()));
                System.out.println(String.valueOf(stu.getName()) + "----------" + stu.getNo() + "--------k=" + k + "--------i=" + i2);
                ++k;
                ++i2;
            }
            try {
                File f;
                String newName = new StringBuffer(path).append("/").append(UUID.randomUUID().toString()).append(".xls").toString();
                File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!(f = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + newName)).exists()) {
                    f.createNewFile();
                }
                FileOutputStream fout = new FileOutputStream("D:\\\\" + new Date().getTime() + ".xls");
                wb.write((OutputStream)fout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
    }

    public static void print(BaseDao dao, HttpServletResponse response, HttpServletRequest request) {
        List<ExcelRow> rows = ImportData.get(dao);
        ImportData.excels(rows, "shop", String.valueOf(new Date().getTime()) + ".xls", response, request);
    }

    public static void updateInOutProductId(BaseDao dao, HttpServletResponse response) {
        List items = dao.findEntity("from OrderInOutItem", OrderInOutItem.class);
        for (OrderInOutItem item : items) {
            String pn;
            Product p;
            int pos;
            String remark = item.getRemark();
            String productId = item.getProductId();
            if (StringUtils.isNotEmpty(productId) || StringUtils.isEmpty(remark) || (pos = remark.lastIndexOf(".")) <= 0 || (p = Cache.getProductByNo(pn = remark.substring(pos + 1))) == null) continue;
            item.setProductId(p.getId());
            dao.update((Object)item);
        }
    }

    public static void ZipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            int i = 0;
            while (i < srcfile.length) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

