/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.view;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExchangeDetail {
    private String id;
    private String orderId;
    private String productName;
    private String productNo;
    private String productId;
    private String orderNo;
    private String barCode;
    private String securityCode;
    private Double quantity;
    private Double points;
    private String unit;
    private String spec;
    private String unitName;
    private String transactionSubType;
    private String no;
    private Date createDt;
    private String shopName;
    private String redeemType;
    private String state;
    private String orderType;
    private String channelType;
    private String stockFlag;
    private String remainQuantity;
    private Double totalScore;

    public String getStockFlag() {
        return this.stockFlag;
    }

    public void setStockFlag(String stockFlag) {
        this.stockFlag = stockFlag;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getOrderTypeName() {
        return Cache.getItemName("TCBJ_EXCHANGE_ORDER_TYPE", this.orderType);
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public Date getCreateDt() {
        return this.createDt;
    }

    public void setCreateDt(Date createDt) {
        this.createDt = createDt;
    }

    public String getShopName() {
        return this.shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getRedeemType() {
        return this.redeemType;
    }

    public void setRedeemType(String redeemType) {
        this.redeemType = redeemType;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ExchangeDetail() {
    }

    public ExchangeDetail(String productId, String productNo, Double quantity) {
        this.productId = productId;
        this.productNo = productNo;
        this.quantity = quantity;
    }

    public ExchangeDetail(String productId, Double quantity, Double points) {
        this.productId = productId;
        this.quantity = quantity;
        this.points = points;
    }

    public String getOrderStatusName() {
        return Cache.getItemName("TCBJ_MEM_ORD_DEL_STATUS", this.state);
    }

    public String getRedeemTypeName() {
        return Cache.getItemName("TCBJ_MEM_ORD_METHOD", this.redeemType);
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Double getTotalScore() {
        if (this.totalScore == null) {
            return 0.0;
        }
        return this.totalScore;
    }

    public void setTotalScore(Double totalScore) {
        this.totalScore = totalScore;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductNo() {
        return this.productNo;
    }

    public void setProductNo(String productNo) {
        this.productNo = productNo;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getUnitName() {
        return Cache.getItemName("TCBJ_UNIT_TYPE", this.unit);
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getSpec() {
        if (StringUtils.isNotNull(Cache.getGift(this.productId))) {
            return Cache.getGift(this.productId).getSpec();
        }
        return "";
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Double getQuantity() {
        if (this.quantity == null) {
            this.quantity = 0.0;
        }
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Double getPoints() {
        if (this.points == null) {
            this.points = 0.0;
        }
        return this.points;
    }

    public void setPoints(Double points) {
        this.points = points;
    }

    public String getTransactionSubType() {
        return this.transactionSubType;
    }

    public String getTransactionSubTypeName() {
        return Cache.getItemName("TCBJ_PRODUCT_SUB_TYPE", this.getTransactionSubType());
    }

    public String getTransactionSubTypeCode() {
        ProductGiftView gift = Cache.getGift(this.getProductId());
        if (gift != null) {
            return gift.getCategory();
        }
        return null;
    }

    public void setTransactionSubType(String transactionSubType) {
        this.transactionSubType = transactionSubType;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getRowPoints() {
        return MathUtils.mul((Double)this.getPoints(), (Double)this.getQuantity());
    }

    public String getRemainQuantity() {
        return this.remainQuantity;
    }

    public void setRemainQuantity(String remainQuantity) {
        this.remainQuantity = remainQuantity;
    }
}

