/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.ygift;

import com.tcbj.crm.view.GiftListView;
import com.tcbj.crm.ygift.GiftListViewCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="YgiftService")
public class YgiftService {
    @Autowired
    private BaseDao baseDao;

    public Page getGiftList(GiftListViewCondition con, int pageno) {
        Page page = new Page();
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("from GiftListView o where 1=1 and o.bh_gift_category = 'STOREGIFT' ");
        if (StringUtils.isNotEmpty(con.getBh_csn())) {
            HQL.append(" and o.bh_csn = ?");
            args.add(con.getBh_csn().trim());
        }
        if (StringUtils.isNotEmpty(con.getBh_storename())) {
            HQL.append(" and o.bh_storename like ?");
            args.add("%" + con.getBh_storename().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getBh_name())) {
            HQL.append(" and o.bh_name like ?");
            args.add("%" + con.getBh_name().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getBh_barcode())) {
            HQL.append(" and o.bh_barcode like ?");
            args.add("%" + con.getBh_barcode().trim() + "%");
        }
        if (con.getBh_pointsS() != null) {
            HQL.append(" and o.bh_points >= ?");
            args.add(con.getBh_pointsS());
        }
        if (con.getBh_pointsE() != null) {
            HQL.append(" and o.bh_points <= ?");
            args.add(con.getBh_pointsE());
        }
        if (StringUtils.isNotEmpty(con.getBh_statusCd())) {
            HQL.append(" and o.bh_statusCd = ?");
            args.add(con.getBh_statusCd().trim());
        }
        page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public GiftListView getGiftDetail(GiftListViewCondition condition, int pageno) {
        GiftListView giftListView = (GiftListView)this.baseDao.get(GiftListView.class, (Serializable)((Object)condition.getBh_giftid()));
        return giftListView;
    }

    public String updateGift(GiftListView view) {
        Element e = DocumentHelper.createElement((String)"GiftList");
        Element e_sub = e.addElement("Gift");
        this.getAddElement(e_sub, "Id", view.getBh_giftid());
        this.getAddElement(e_sub, "BarCode", view.getBh_barcode());
        this.getAddElement(e_sub, "GiftName", view.getBh_name());
        if ("Active".equals(view.getBh_statusCd())) {
            this.getAddElement(e_sub, "Status", "\u53ef\u7528");
            this.getAddElement(e_sub, "PosExchangeFlag", "\u4e0a\u67b6");
            this.getAddElement(e_sub, "AppExchangeFlag", "\u4e0a\u67b6");
        } else if ("unqualified".equals(view.getBh_statusCd())) {
            this.getAddElement(e_sub, "Status", "\u4e0d\u5408\u683c");
            this.getAddElement(e_sub, "PosExchangeFlag", "\u4e0b\u67b6");
            this.getAddElement(e_sub, "AppExchangeFlag", "\u4e0b\u67b6");
        } else if ("Inactive".equals(view.getBh_statusCd())) {
            this.getAddElement(e_sub, "Status", "\u505c\u7528");
            this.getAddElement(e_sub, "PosExchangeFlag", "\u4e0b\u67b6");
            this.getAddElement(e_sub, "AppExchangeFlag", "\u4e0b\u67b6");
        }
        this.getAddElement(e_sub, "OrganizationId", view.getBh_storeid());
        Document _document = DocumentHelper.createDocument();
        _document.add(e);
        String resultXml = this.getFormatXml(_document);
        return resultXml;
    }

    public Element getAddElement(Element e, String name, String value) {
        Element sub_Element = e.addElement(name);
        if (StringUtils.isEmpty(value)) {
            value = "";
        }
        sub_Element.addText(value);
        return sub_Element;
    }

    public String getFormatXml(Document doc) {
        String s = "";
        try {
            OutputFormat format = new OutputFormat("", true);
            format.setEncoding("UTF-8");
            StringWriter out = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)out, format);
            xmlWriter.write(doc);
            xmlWriter.flush();
            s = out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public List<GiftListView> getGiftListByArgs(GiftListViewCondition con) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        HQL.append("from GiftListView o where 1=1 ");
        if (StringUtils.isNotEmpty(con.getBh_csn())) {
            HQL.append(" and o.bh_csn = ?");
            params.add(con.getBh_csn().trim());
        }
        if (StringUtils.isNotEmpty(con.getBh_storename())) {
            HQL.append(" and o.bh_storename like ?");
            params.add("%" + con.getBh_storename().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getBh_name())) {
            HQL.append(" and o.bh_name like ?");
            params.add("%" + con.getBh_name().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getBh_barcode())) {
            HQL.append(" and o.bh_barcode like ?");
            params.add("%" + con.getBh_barcode().trim() + "%");
        }
        if (con.getBh_pointsS() != null) {
            HQL.append(" and o.bh_points >= ?");
            params.add(con.getBh_pointsS());
        }
        if (con.getBh_pointsE() != null) {
            HQL.append(" and o.bh_points <= ?");
            params.add(con.getBh_pointsE());
        }
        if (StringUtils.isNotEmpty(con.getBh_statusCd())) {
            HQL.append(" and o.bh_statusCd = ?");
            params.add(con.getBh_statusCd().trim());
        }
        return this.baseDao.findEntity(HQL.toString(), params.toArray(), GiftListView.class);
    }

    public String approve(String[] ids, String targetStatus) {
        if (ids.length > 0 && !"".equals(targetStatus)) {
            Element e = DocumentHelper.createElement((String)"GiftList");
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Element e_sub = e.addElement("Gift");
                GiftListView giftListView = (GiftListView)this.baseDao.get(GiftListView.class, (Serializable)((Object)id));
                this.getAddElement(e_sub, "Id", giftListView.getBh_giftid());
                if ("Active".equals(targetStatus)) {
                    this.getAddElement(e_sub, "Status", "\u53ef\u7528");
                    this.getAddElement(e_sub, "PosExchangeFlag", "\u4e0a\u67b6");
                    this.getAddElement(e_sub, "AppExchangeFlag", "\u4e0a\u67b6");
                }
                if ("unqualified".equals(targetStatus)) {
                    this.getAddElement(e_sub, "Status", "\u4e0d\u5408\u683c");
                    this.getAddElement(e_sub, "PosExchangeFlag", "\u4e0b\u67b6");
                    this.getAddElement(e_sub, "AppExchangeFlag", "\u4e0b\u67b6");
                }
                if ("Inactive".equals(targetStatus)) {
                    this.getAddElement(e_sub, "Status", "\u505c\u7528");
                    this.getAddElement(e_sub, "PosExchangeFlag", "\u4e0b\u67b6");
                    this.getAddElement(e_sub, "AppExchangeFlag", "\u4e0b\u67b6");
                }
                this.getAddElement(e_sub, "OrganizationId", giftListView.getBh_storeid());
                ++n2;
            }
            Document _document = DocumentHelper.createDocument();
            _document.add(e);
            String resultXml = this.getFormatXml(_document);
            return resultXml;
        }
        return null;
    }
}

