/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.yorder;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.CxAwkOrderView;
import com.tcbj.crm.view.CxAwkOrderXmView;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.yorder.CxAwkOrderViewCondition;
import com.tcbj.crm.yorder.YorderCxyService;
import com.tcbj.crm.yorder.YorderService;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/yorder"})
public class YorderContoller
extends BaseController {
    @Autowired
    YorderService yorderService;
    @Autowired
    YorderCxyService yorderCxyService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, CxAwkOrderViewCondition condition, Model model) {
        EmployeePartner em = this.getCurrentEmployee().getCurrentPartner();
        if (!em.getId().equals(em.getOrganizationid())) {
            throw new AppException("2020");
        }
        if (StringUtils.isEmpty(condition.getDelivery_status())) {
            condition.setDelivery_status("Submitted");
        }
        condition.setOrgId(em.getId());
        Page page = this.yorderService.getOrderList(condition, pageno);
        List list = page.getList();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                CxAwkOrderView cxAwkOrderView = (CxAwkOrderView)list.get(i);
                if (cxAwkOrderView.getCreated() != null) {
                    cxAwkOrderView.getCreated().setHours(cxAwkOrderView.getCreated().getHours() + 8);
                }
                ++i;
            }
        }
        page.setList(list);
        model.addAttribute("page", (Object)page);
        model.addAttribute("status", (Object)condition.getDelivery_status());
        model.addAttribute("condition", (Object)condition);
        return "yorder/list.ftl";
    }

    @RequestMapping(value={"/detail.do"}, method={RequestMethod.GET})
    public String detail(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, CxAwkOrderViewCondition condition, Model model) {
        Map<String, Object> map = this.yorderService.getOrderDetail(condition, pageno);
        model.addAttribute("page", map.get("page"));
        model.addAttribute("cxAwkOrderView", map.get("cxAwkOrderView"));
        Employee e = this.getCurrentEmployee();
        model.addAttribute("employee", (Object)e);
        return "yorder/detail.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody CxAwkOrderView cxAwkOrderView, BindingResult errors, Model model, HttpServletRequest request) {
        String inXml = this.yorderService.updateOrder(cxAwkOrderView);
        Map<String, String> map = this.yorderService.updateOrderNew(inXml);
        String errCode = map.get("ErrCode");
        String ErrDesc = map.get("ErrDesc");
        if (!errCode.equals("100")) {
            throw new AppException("8007", ErrDesc);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(CxAwkOrderViewCondition condition, HttpServletRequest request, HttpServletResponse response) {
        EmployeePartner em = this.getCurrentEmployee().getCurrentPartner();
        if ("All".equals(condition.getDelivery_status())) {
            condition.setDelivery_status("");
        }
        condition.setOrgId(em.getId());
        List<CxAwkOrderView> orderLists = this.yorderService.getOrderListByArgs(condition);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.exportExcel(response, orderLists, "\u4f1a\u5458\u5151\u6362\u8ba2\u5355-" + DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ".xls");
    }

    private boolean exportExcel(HttpServletResponse response, List<CxAwkOrderView> list, String fileName) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.reset();
            fileName = URLDecoder.decode(fileName, "gbk");
            fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)os);
            String tmptitle = "\u5151\u6362\u8ba2\u5355";
            WritableSheet wsheet = wbook.createSheet(tmptitle, 0);
            wsheet.addCell((WritableCell)new Label(0, 0, "\u8ba2\u5355\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(1, 0, "\u8ba2\u5355\u65f6\u95f4"));
            wsheet.addCell((WritableCell)new Label(2, 0, "\u8ba2\u5355\u72b6\u6001"));
            wsheet.addCell((WritableCell)new Label(3, 0, "\u8ba2\u5355\u7c7b\u578b"));
            wsheet.addCell((WritableCell)new Label(4, 0, "\u8ba2\u5355\u6765\u6e90"));
            wsheet.addCell((WritableCell)new Label(5, 0, "\u5151\u6362\u65b9\u5f0f"));
            wsheet.addCell((WritableCell)new Label(6, 0, "\u95e8\u5e97\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(7, 0, "\u95e8\u5e97\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(8, 0, "\u4f1a\u5458\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(9, 0, "\u4f1a\u5458\u624b\u673a\u53f7"));
            wsheet.addCell((WritableCell)new Label(10, 0, "\u6536\u8d27\u4eba"));
            wsheet.addCell((WritableCell)new Label(11, 0, "\u6536\u8d27\u8054\u7cfb\u7535\u8bdd"));
            wsheet.addCell((WritableCell)new Label(12, 0, "\u6536\u8d27\u5730\u5740"));
            wsheet.addCell((WritableCell)new Label(13, 0, "\u8ba2\u5355\u5907\u6ce8"));
            wsheet.addCell((WritableCell)new Label(14, 0, "\u914d\u9001\u5355\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(15, 0, "\u7269\u6d41\u516c\u53f8"));
            wsheet.addCell((WritableCell)new Label(16, 0, "\u53d1\u8d27\u65e5\u671f"));
            wsheet.addCell((WritableCell)new Label(17, 0, "\u7269\u6d41\u5907\u6ce8"));
            wsheet.addCell((WritableCell)new Label(18, 0, "\u793c\u54c1\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(19, 0, "\u793c\u54c1\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(20, 0, "\u5151\u6362\u6570\u91cf"));
            wsheet.addCell((WritableCell)new Label(21, 0, "\u5151\u6362\u79ef\u5206"));
            wsheet.addCell((WritableCell)new Label(22, 0, "\u5151\u6362\u603b\u6570\u91cf"));
            wsheet.addCell((WritableCell)new Label(23, 0, "\u5151\u6362\u603b\u79ef\u5206"));
            int j = 1;
            if (list != null && list.size() == 0) {
                int k = 0;
                while (k <= 21) {
                    wsheet.addCell((WritableCell)new Label(k, 1, ""));
                    ++k;
                }
            }
            int i = 0;
            while (i < list.size()) {
                List<CxAwkOrderXmView> orderItems = this.yorderService.findOrderItemByPid(list.get(i).getRow_id());
                if (orderItems.size() > 0) {
                    Calendar cd = Calendar.getInstance();
                    for (CxAwkOrderXmView item : orderItems) {
                        wsheet.addCell((WritableCell)new Label(0, j, list.get(i).getOrder_no()));
                        if (list.get(i).getCreated() == null || "".equals(list.get(i).getCreated())) {
                            wsheet.addCell((WritableCell)new Label(1, j, ""));
                        } else {
                            cd.setTime(list.get(i).getCreated());
                            cd.add(10, 8);
                            wsheet.addCell((WritableCell)new Label(1, j, DateUtils.formartDate((Date)cd.getTime(), (String)"yyyy-MM-dd HH:mm:ss")));
                        }
                        wsheet.addCell((WritableCell)new Label(2, j, list.get(i).getDeliveryStatusName()));
                        wsheet.addCell((WritableCell)new Label(3, j, list.get(i).getMem_class_cd()));
                        wsheet.addCell((WritableCell)new Label(4, j, list.get(i).getRdm_chnl()));
                        wsheet.addCell((WritableCell)new Label(5, j, list.get(i).getExchangeMethodName()));
                        wsheet.addCell((WritableCell)new Label(6, j, list.get(i).getStore_code()));
                        wsheet.addCell((WritableCell)new Label(7, j, list.get(i).getStore_name()));
                        wsheet.addCell((WritableCell)new Label(8, j, list.get(i).getName()));
                        wsheet.addCell((WritableCell)new Label(9, j, list.get(i).getX_mob_pho_no()));
                        wsheet.addCell((WritableCell)new Label(10, j, list.get(i).getReceiver_name()));
                        wsheet.addCell((WritableCell)new Label(11, j, list.get(i).getReceiver_phone()));
                        wsheet.addCell((WritableCell)new Label(12, j, list.get(i).getReceiver_address()));
                        wsheet.addCell((WritableCell)new Label(13, j, list.get(i).getComments()));
                        wsheet.addCell((WritableCell)new Label(14, j, list.get(i).getDelivery_order_no()));
                        wsheet.addCell((WritableCell)new Label(15, j, list.get(i).getDelivery_company()));
                        if (list.get(i).getDelivery_date() == null || "".equals(list.get(i).getDelivery_date())) {
                            wsheet.addCell((WritableCell)new Label(16, j, ""));
                        } else {
                            cd.setTime(list.get(i).getDelivery_date());
                            cd.add(10, 8);
                            wsheet.addCell((WritableCell)new Label(16, j, DateUtils.formartDate((Date)cd.getTime(), (String)"yyyy-MM-dd HH:mm:ss")));
                        }
                        wsheet.addCell((WritableCell)new Label(17, j, list.get(i).getDelivery_comments()));
                        wsheet.addCell((WritableCell)new Label(18, j, item.getPart_num()));
                        wsheet.addCell((WritableCell)new Label(19, j, item.getAlias_name()));
                        wsheet.addCell((WritableCell)new Label(20, j, item.getProduct_quantity().toString()));
                        wsheet.addCell((WritableCell)new Label(21, j, item.getPointsCount().toString()));
                        wsheet.addCell((WritableCell)new Label(22, j, list.get(i).getCounts()));
                        wsheet.addCell((WritableCell)new Label(23, j, list.get(i).getPointsTotal()));
                        ++j;
                    }
                }
                ++i;
            }
            wbook.write();
            wbook.close();
            os.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @RequestMapping(value={"/batch.do"}, method={RequestMethod.GET})
    public String selectBatch(Model model, @RequestParam(value="type", required=false) String type, @RequestParam(value="ids", required=false) String ids) {
        try {
            type = new String(type.getBytes("iso8859-1"), "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("type", (Object)type);
        model.addAttribute("ids", (Object)ids);
        return "yorder/batch.ftl";
    }

    @RequestMapping(value={"/editBatch.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editBatch(@Valid @RequestBody CxAwkOrderView cxAwkOrderView, BindingResult errors, Model model, HttpServletRequest request) {
        String ids = cxAwkOrderView.getRow_id();
        ArrayList<String> listId = new ArrayList<String>();
        if (ids != null) {
            int i = 0;
            while (i < ids.split(",").length) {
                cxAwkOrderView.setOrder_no(ids.split(",")[i]);
                String inXml = this.yorderService.updateBatch(cxAwkOrderView);
                Map<String, String> map = this.yorderService.updateOrderNew(inXml);
                String errCode = map.get("ErrCode");
                String ErrDesc = map.get("ErrDesc");
                if (!"100".equals(errCode)) {
                    listId.add(String.valueOf(ids.split(",")[i]) + ":" + ErrDesc);
                }
                ++i;
            }
        }
        if (listId.size() > 0) {
            return this.getSuccessResult("\u6279\u91cf\u5904\u7406\u5b58\u5728\u5931\u8d25\uff01" + listId);
        }
        return this.getSuccessResult("\u6279\u91cf\u5904\u7406\u6210\u529f");
    }

    @RequestMapping(value={"/importExcel.do"}, method={RequestMethod.GET})
    public String importExcel() {
        return "yorder/uploadOrder.ftl";
    }

    @RequestMapping(value={"/uploadOrder.do"}, method={RequestMethod.POST})
    public String uploadOrder(Model model, HttpServletRequest request) {
        List<IUploadFile> list = this.uploadFile(request, "yorder");
        this.getCurrentEmployee();
        String rtn = null;
        if (list.size() > 0) {
            IUploadFile file = list.get(0);
            List<List<Object>> datas = ExcelHandle.readExcel(file.getRealPath());
            if (datas.isEmpty()) {
                rtn = JSON.toJSONString((Object)this.getErrorResult("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a"));
                model.addAttribute("rtn", (Object)rtn);
                return "common/iframeRtn.ftl";
            }
            CxAwkOrderViewCondition condition = new CxAwkOrderViewCondition();
            ArrayList<String> listOrder = new ArrayList<String>();
            for (List<Object> rows : datas) {
                String order_no = (String)rows.get(0);
                String delivery_order_no = (String)rows.get(1);
                String delivery_company = (String)rows.get(2);
                String delivery_comments = (String)rows.get(3);
                condition.setOrder_no(order_no);
                Page page = this.yorderService.getOrderList(condition, 1);
                if (page.getList().size() == 0) {
                    listOrder.add("\u8ba2\u5355" + order_no + ":" + "\u4e0d\u5b58\u5728");
                    continue;
                }
                CxAwkOrderView cxAwkOrderView = (CxAwkOrderView)page.getList().get(0);
                if (!"Sended".equals(cxAwkOrderView.getDelivery_status())) {
                    listOrder.add("\u8ba2\u5355" + order_no + ":" + "\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u9001");
                    continue;
                }
                cxAwkOrderView.setDelivery_order_no(delivery_order_no);
                cxAwkOrderView.setDelivery_company(delivery_company);
                cxAwkOrderView.setDelivery_comments(delivery_comments);
                String inXml = this.yorderService.importUpdateOrder(cxAwkOrderView);
                Map<String, String> map = this.yorderService.updateOrderNew(inXml);
                String errCode = map.get("ErrCode");
                String ErrDesc = map.get("ErrDesc");
                if ("100".equals(errCode)) continue;
                listOrder.add("\u8ba2\u5355" + order_no + ":" + ErrDesc);
            }
            if (listOrder.size() > 0) {
                rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(listOrder)));
                model.addAttribute("rtn", (Object)rtn);
                return "common/iframeRtn.ftl";
            }
            rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        }
        model.addAttribute("rtn", rtn);
        return "common/iframeRtn.ftl";
    }
}

