/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.view.OrderInOutView;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelUtil {
    public List<List<Object>> excelUtil(String fileName) throws IOException {
        ExcelUtil xlsMain = new ExcelUtil();
        List<List<Object>> list = xlsMain.readXls(fileName);
        return list;
    }

    public List<List<Object>> readXls(String fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook((InputStream)is);
        LinkedList<List<Object>> list = new LinkedList<List<Object>>();
        int numSheet = 0;
        while (numSheet < hssfWorkbook.getNumberOfSheets()) {
            HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet != null) {
                LinkedList<String> linked = null;
                int rowNum = 0;
                while (rowNum <= hssfSheet.getLastRowNum()) {
                    linked = new LinkedList<String>();
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow != null) {
                        short cellNum = 0;
                        while (cellNum <= hssfRow.getLastCellNum()) {
                            HSSFCell hssfCell = hssfRow.getCell(cellNum);
                            if (hssfCell == null) {
                                linked.add(cellNum, null);
                            } else {
                                linked.add(cellNum, this.getValue(hssfCell));
                            }
                            cellNum = (short)(cellNum + 1);
                        }
                        list.add(linked);
                    }
                    ++rowNum;
                }
            }
            ++numSheet;
        }
        return list;
    }

    private String getValue(HSSFCell hssfCell) {
        if (hssfCell.getCellType() == 4) {
            return String.valueOf(hssfCell.getBooleanCellValue());
        }
        if (hssfCell.getCellType() == 0) {
            return String.valueOf(hssfCell.getNumericCellValue());
        }
        return String.valueOf(hssfCell.getStringCellValue());
    }

    public static boolean exportExcel(HttpServletResponse response, List<OrderProduct> list, OrderApply orderApply, String name) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + name);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)os);
            String tmptitle = "\u4ea7\u54c1\u8ba2\u5355";
            WritableSheet wsheet = wbook.createSheet(tmptitle, 0);
            wsheet.addCell((WritableCell)new Label(0, 0, "\u4ea7\u54c1\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(1, 0, "\u4ea7\u54c1\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(2, 0, "\u4ea7\u54c1\u89c4\u683c"));
            wsheet.addCell((WritableCell)new Label(3, 0, "\u5355\u4f4d"));
            wsheet.addCell((WritableCell)new Label(4, 0, "\u5305\u88c5\u6570"));
            wsheet.addCell((WritableCell)new Label(5, 0, "\u7edf\u4e00\u4ef7\u683c"));
            wsheet.addCell((WritableCell)new Label(6, 0, "\u4f9b\u8d27\u4ef7\u683c"));
            wsheet.addCell((WritableCell)new Label(7, 0, "\u8ba2\u8d2d\u6570\u91cf"));
            wsheet.addCell((WritableCell)new Label(8, 0, "\u91d1\u989d"));
            int i = 0;
            while (i < list.size()) {
                wsheet.addCell((WritableCell)new Label(0, i + 1, list.get(i).getNo()));
                wsheet.addCell((WritableCell)new Label(1, i + 1, list.get(i).getName()));
                wsheet.addCell((WritableCell)new Label(2, i + 1, list.get(i).getSpec()));
                wsheet.addCell((WritableCell)new Label(3, i + 1, list.get(i).getUnitName()));
                wsheet.addCell((WritableCell)new Label(4, i + 1, list.get(i).getMinUnit().toString()));
                wsheet.addCell((WritableCell)new Label(5, i + 1, list.get(i).getBasePrice().toString()));
                wsheet.addCell((WritableCell)new Label(6, i + 1, list.get(i).getPrice().toString()));
                wsheet.addCell((WritableCell)new Label(7, i + 1, list.get(i).getQuantity().toString()));
                wsheet.addCell((WritableCell)new Label(8, i + 1, list.get(i).getMoney().toString()));
                ++i;
            }
            wsheet.addCell((WritableCell)new Label(0, list.size() + 1, "\u6c47\u603b\u6570\u91cf"));
            wsheet.addCell((WritableCell)new Label(1, list.size() + 1, orderApply.getQuantity().toString()));
            wsheet.addCell((WritableCell)new Label(2, list.size() + 1, "\u6c47\u603b\u91d1\u989d"));
            wsheet.addCell((WritableCell)new Label(3, list.size() + 1, orderApply.getTotalMoney().toString()));
            wsheet.addCell((WritableCell)new Label(4, list.size() + 1, "\u5e94\u4ed8\u91d1\u989d"));
            wsheet.addCell((WritableCell)new Label(5, list.size() + 1, orderApply.getRemainMoney().toString()));
            wbook.write();
            wbook.close();
            os.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean exportExcel(HttpServletResponse response, OrderInOutView orderInOut, List<OrderInOutItem> list, String name) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + name);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)os);
            String tmptitle = "\u4ea7\u54c1\u8ba2\u5355";
            WritableSheet wsheet = wbook.createSheet(tmptitle, 0);
            wsheet.addCell((WritableCell)new Label(0, 0, "\u4ea7\u54c1\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(1, 0, "\u4ea7\u54c1\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(2, 0, "\u4ea7\u54c1\u89c4\u683c"));
            wsheet.addCell((WritableCell)new Label(3, 0, "\u5355\u4f4d"));
            wsheet.addCell((WritableCell)new Label(4, 0, "\u6279\u6b21\u53f7"));
            wsheet.addCell((WritableCell)new Label(5, 0, "\u4ef7\u683c"));
            wsheet.addCell((WritableCell)new Label(6, 0, "\u8ba2\u8d2d\u6570\u91cf"));
            wsheet.addCell((WritableCell)new Label(7, 0, "\u91d1\u989d"));
            wsheet.addCell((WritableCell)new Label(8, 0, "\u5907\u6ce8"));
            int i = 0;
            for (OrderInOutItem item : list) {
                if (!"PRODUCT".equals(item.getProductType()) && !"GIFT".equals(item.getProductType()) && !"MATERIAL".equals(item.getProductType())) continue;
                wsheet.addCell((WritableCell)new Label(0, i + 1, item.getNo()));
                wsheet.addCell((WritableCell)new Label(1, i + 1, item.getProductName()));
                wsheet.addCell((WritableCell)new Label(2, i + 1, item.getSpec()));
                wsheet.addCell((WritableCell)new Label(3, i + 1, item.getUnitName()));
                wsheet.addCell((WritableCell)new Label(4, i + 1, item.getBatchNum()));
                wsheet.addCell((WritableCell)new Label(5, i + 1, (item.getSalePrice() == null ? "" : item.getSalePrice()).toString()));
                wsheet.addCell((WritableCell)new Label(6, i + 1, item.getQuantity().toString()));
                wsheet.addCell((WritableCell)new Label(7, i + 1, item.getMoney().toString()));
                wsheet.addCell((WritableCell)new Label(8, i + 1, item.getRemark() == null ? "" : item.getRemark().toString()));
                ++i;
            }
            wsheet.addCell((WritableCell)new Label(0, i + 1, "\u6c47\u603b\u6570\u91cf"));
            wsheet.addCell((WritableCell)new Label(1, i + 1, orderInOut.getQuantity().toString()));
            wsheet.addCell((WritableCell)new Label(2, i + 1, "\u6c47\u603b\u91d1\u989d"));
            wsheet.addCell((WritableCell)new Label(3, i + 1, orderInOut.getTotalMoney().toString()));
            wsheet.addCell((WritableCell)new Label(4, i + 1, "\u5e94\u4ed8\u91d1\u989d"));
            wsheet.addCell((WritableCell)new Label(5, i + 1, orderInOut.getRemainMoney().toString()));
            wbook.write();
            wbook.close();
            os.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean excels(List<OrderProduct> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue("ID");
        int i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            OrderProduct stu = list.get(i);
            row.createCell(0).setCellValue(stu.getNo());
            row.createCell(1).setCellValue(stu.getName());
            row.createCell(2).setCellValue(stu.getSpec());
            row.createCell(3).setCellValue(stu.getUnitName());
            row.createCell(4).setCellValue(stu.getMinUnit().doubleValue());
            row.createCell(5).setCellValue(stu.getBasePrice().doubleValue());
            row.createCell(6).setCellValue(stu.getPrice().doubleValue());
            row.createCell(7).setCellValue(stu.getQuantity().doubleValue());
            row.createCell(8).setCellValue(stu.getMoney().doubleValue());
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void download(String path, HttpServletResponse response) {
        try {
            File file = new File(path);
            String filename = file.getName();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

