/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.ability;

import com.tcbj.crm.ability.AbilityCondition;
import com.tcbj.crm.entity.Ability;
import com.tcbj.crm.entity.AbilityRule;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abilityService")
public class AbilityService {
    @Autowired
    private BaseDao baseDao;

    public List<Ability> getAbilityList(AbilityCondition con) {
        String hql = "from Ability a where 1=1";
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(con.getPartnerId())) {
            hql = String.valueOf(hql) + "and a.partnerId = ?";
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql = String.valueOf(hql) + "and a.year = ?";
            args.add(con.getYear());
        }
        hql = String.valueOf(hql) + " order by a.year desc ";
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Ability.class);
    }

    public Page getAbilityPage(AbilityCondition con, int pageno) {
        String hql = "from Ability a where 1=1";
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(con.getPartnerId())) {
            hql = String.valueOf(hql) + " and a.partnerId = ? ";
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql = String.valueOf(hql) + " and a.year = ? ";
            args.add(con.getYear());
        }
        hql = String.valueOf(hql) + " order by a.year desc ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<Ability> getAbilitys(String partnerId, Integer year) {
        String hql = "from Ability a where a.use = 'Y' and a.partnerId = ? ";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(partnerId);
        if (StringUtils.isNotNull(year)) {
            hql = String.valueOf(hql) + "and a.year = ?";
            args.add(year);
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Ability.class);
    }

    public boolean isExist(AbilityCondition con) {
        List ats;
        boolean isExist = false;
        String hql = "from Ability a where a.use='Y' ";
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(con.getPartnerId())) {
            hql = String.valueOf(hql) + "and a.partnerId = ?";
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql = String.valueOf(hql) + "and a.year = ?";
            args.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getPrototype())) {
            hql = String.valueOf(hql) + "and a.prototype = ?";
            args.add(con.getPrototype());
        }
        if (StringUtils.isNotEmpty(con.getId())) {
            hql = String.valueOf(hql) + " and id != ? ";
            args.add(con.getId());
        }
        if ((ats = this.baseDao.findEntity(hql.toString(), args.toArray(), Ability.class)).size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public void addAndupdate(AbilityCondition con, Employee em) {
        String[] ids = con.getDelIds().split(",");
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!"".equals(id)) {
                this.delete(id);
            }
            ++n2;
        }
        Double sum = 0.0;
        List<Ability> abilitys = con.getAbilityList();
        for (Ability ab : abilitys) {
            if (!"Y".equals(ab.getUse())) continue;
            sum = MathUtils.add((Double)sum, (Double)ab.getRate());
            con.setPartnerId(em.getCurrentPartner().getId());
            con.setPrototype(ab.getPrototype());
            con.setUse(ab.getUse());
            con.setId(ab.getId());
            boolean isExist = this.isExist(con);
            if (!isExist) continue;
            throw new AppException("5117");
        }
        if (100.0 != sum) {
            throw new AppException("5118");
        }
        for (Ability ability : abilitys) {
            ability.setPartnerId(em.getCurrentPartner().getId());
            ability.setYear(con.getYear());
            if (StringUtils.isNotEmpty(ability.getId())) {
                this.baseDao.update((Object)ability);
                continue;
            }
            this.baseDao.save((Object)ability);
        }
    }

    public void update(Ability ability) {
        this.baseDao.update((Object)ability);
    }

    public Ability findById(String id) {
        return (Ability)this.baseDao.get(Ability.class, (Serializable)((Object)id));
    }

    public void delete(String id) {
        this.baseDao.deleteById(Ability.class, (Serializable)((Object)id));
    }

    public boolean isDel(String id) {
        boolean isExist = false;
        List list = this.baseDao.findEntity("from Ability where parentId = ?", new Object[]{id});
        if (list.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public String findCode(String functionCode) {
        List list = this.baseDao.findEntity("from Ability where functionCode = ?", new Object[]{functionCode}, Ability.class);
        if (list.size() > 0) {
            return "false";
        }
        return "true";
    }

    public List<AbilityRule> getRules(String abilityId) {
        String hql = "from AbilityRule a where a.abilityId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{abilityId}, AbilityRule.class);
    }

    public void save(Ability ability) {
        String[] ids;
        String[] stringArray = ids = ability.getDelIds().split(",");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!"".equals(id)) {
                this.del(id);
            }
            ++n2;
        }
        List<AbilityRule> list = ability.getAbilityRules();
        for (AbilityRule ar : list) {
            ar.setAbilityId(ability.getId());
            if (StringUtils.isNotEmpty(ar.getId())) {
                this.baseDao.update((Object)ar);
                continue;
            }
            this.baseDao.save((Object)ar);
        }
    }

    public void del(String id) {
        this.baseDao.deleteById(AbilityRule.class, (Serializable)((Object)id));
    }

    public List<AbilityRule> getAbilityRule(String partnerId, Integer year) {
        String hql = " from Ability a,AbilityRule r where a.id=r.abilityId and a.partnerId = ? and a.year = ? and r.use='Y' ";
        List obs = this.baseDao.findEntity(hql, new Object[]{partnerId, year}, Object[].class);
        ArrayList<AbilityRule> abilityRules = new ArrayList<AbilityRule>();
        for (Object[] ob : obs) {
            abilityRules.add((AbilityRule)ob[1]);
        }
        return abilityRules;
    }
}

