/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.abilitydata;

import com.tcbj.crm.ability.AbilityService;
import com.tcbj.crm.abilitydata.AbilityDataCondition;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Ability;
import com.tcbj.crm.entity.AbilityData;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abilityDataService")
public class AbilityDataService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private AbilityService abilityService;

    public AbilityData get(String id) {
        return (AbilityData)this.baseDao.get(AbilityData.class, (Serializable)((Object)id));
    }

    public void save(AbilityData obj) {
        this.baseDao.save((Object)obj);
    }

    public void save(List<AbilityData> list, Employee em) {
        for (AbilityData abilityData : list) {
            abilityData.fillInitData(em);
        }
        this.baseDao.save(list);
    }

    public Page getPage(int pageno, AbilityDataCondition condition) {
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o from AbilityData o,Customer c where o.partnerId = ? ");
        args.add(condition.getPartnerId());
        hql.append(" and o.applyerId = c.applyerId ");
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotNull(condition.getYear())) {
            hql.append(" and o.year = ? ");
            args.add(condition.getYear());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public List<AbilityData> getList(Employee e, Integer year) {
        String sb = this.personnelService.getFRegionsByUserId(e.getId());
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o from AbilityData o,Customer c where o.partnerId = ? ");
        args.add(e.getCurrentPartner().getId());
        hql.append(" and o.applyerId = c.applyerId ");
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotNull(year)) {
            hql.append(" and o.year = ? ");
            args.add(year);
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), AbilityData.class);
    }

    public void update(AbilityData obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        this.baseDao.deleteById(AbilityData.class, (Serializable)((Object)id));
    }

    public void update(List<AbilityData> abilityDatas, String delIds, Employee me) {
        try {
            String[] ids;
            String[] stringArray = ids = delIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    this.baseDao.executeHQL("delete AbilityData where id= ?", args);
                }
                ++n2;
            }
            for (AbilityData abilityData : abilityDatas) {
                abilityData.fillInitData(me);
                abilityData.setPartnerId(me.getCurrentPartner().getId());
                if (StringUtils.isEmpty(abilityData.getId())) {
                    this.baseDao.save((Object)abilityData);
                    continue;
                }
                this.baseDao.update((Object)abilityData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getCustomerMap(String parentId) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? ");
        Object[] args = new Object[]{parentId};
        List list = this.baseDao.findEntity(sb.toString(), args, Customer.class);
        for (Customer customer : list) {
            map.put(customer.getApplyerCode(), customer.getApplyerId());
        }
        return map;
    }

    public List<AdjustStockUtil> validate(Integer year, List<List<Object>> readExcelList, Employee emp, List<AbilityData> list) {
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        Map<String, String> customerMap = this.getCustomerMap(emp.getCurrentPartner().getId());
        List<Ability> abilities = this.abilityService.getAbilitys(emp.getCurrentPartner().getId(), year);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Ability ability : abilities) {
            map.put(ability.getPrototypeName(), ability.getId());
        }
        int j = 0;
        while (j < readExcelList.size()) {
            List<Object> data = readExcelList.get(j);
            String result = null;
            String message = null;
            AbilityData abilityData = new AbilityData();
            int i = 0;
            while (i < data.size()) {
                switch (i) {
                    case 0: {
                        message = ValidataUtils.validataMap((Object)data.get(i), customerMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u5ba2\u6237\u52a9\u8bb0\u7801 \uff1a" + message;
                            break;
                        }
                        abilityData.setApplyerId(customerMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 2: {
                        abilityData.setYear(year);
                        break;
                    }
                    case 3: {
                        message = ValidataUtils.validataMap((Object)data.get(i), map);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u80fd\u529b\u9879\u539f\u5f62 \uff1a" + message;
                            break;
                        }
                        abilityData.setAbilityId((String)map.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 4: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u80fd\u529b\u503c \uff1a" + message;
                            break;
                        }
                        abilityData.setValue(Double.valueOf(data.get(i).toString()));
                        break;
                    }
                }
                abilityData.setPartnerId(emp.getCurrentPartner().getId());
                ++i;
            }
            if (result != null) {
                msglist.add(new AdjustStockUtil("\u7b2c" + (j + 2) + "\u884c:" + result));
            }
            list.add(abilityData);
            ++j;
        }
        AbilityData t1 = null;
        AbilityData t2 = null;
        String s1 = null;
        String s2 = null;
        int k = 0;
        while (k < list.size()) {
            t1 = list.get(k);
            s1 = String.valueOf(t1.getAbilityId()) + (t1.getYear() == null ? "0" : t1.getYear().toString()) + t1.getApplyerId();
            int k2 = k + 1;
            while (k2 < list.size()) {
                t2 = list.get(k2);
                s2 = String.valueOf(t2.getAbilityId()) + (t2.getYear() == null ? "0" : t2.getYear().toString()) + t2.getApplyerId();
                if (s1.equals(s2)) {
                    msglist.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                }
                ++k2;
            }
            ++k;
        }
        if (msglist.size() > 0) {
            return msglist;
        }
        List<AbilityData> sqlList = this.getList(emp, year);
        int k2 = 0;
        while (k2 < sqlList.size()) {
            t1 = sqlList.get(k2);
            s1 = String.valueOf(t1.getAbilityId()) + (t1.getYear() == null ? "0" : t1.getYear().toString()) + t1.getApplyerId();
            int k22 = 0;
            while (k22 < list.size()) {
                t2 = list.get(k22);
                s2 = String.valueOf(t2.getAbilityId()) + (t2.getYear() == null ? "0" : t2.getYear().toString()) + t2.getApplyerId();
                if (s1.equals(s2)) {
                    msglist.add(new AdjustStockUtil("\u7b2c" + (k2 + 2) + "\u884c\u6570\u636e\u5728\u6570\u636e\u5e93\u91cd\u590d\u3002"));
                }
                ++k22;
            }
            ++k2;
        }
        return msglist;
    }
}

