/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.account;

import com.tcbj.crm.account.EasCustDto;
import com.tcbj.crm.view.EasCustDocSummaryV;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasCustDocSummaryDto
extends EasCustDto {
    public static Logger logger = LoggerFactory.getLogger(EasCustDocSummaryDto.class);
    public static final String DOCTYPE_INVOICE = "\u9500\u552e\u53d1\u7968";
    public static final String DOCTYPE_BILL = "\u6536\u6b3e\u5355";
    public static final String SELL_OUT = "\u9500\u552e\u51fa\u5e93\u5355";
    public static final String INIT = "\u521d\u59cb\u5316";
    public static final String OTHER = "\u5176\u4ed6\u5e94\u6536";
    private Map<Integer, List<EasCustDocSummaryV>> yearSummaryMap;
    private BigDecimal yearShouldReceiveAmt = new BigDecimal(0);
    private BigDecimal yearReceivedAmt = new BigDecimal(0);
    private BigDecimal monthShouldReceiveAmt = new BigDecimal(0);
    private BigDecimal monthReceivedAmt = new BigDecimal(0);
    private Integer year;
    private Integer month;

    public EasCustDocSummaryDto(String supplierId, String applyerId, String yearMonth, Employee employee) {
        super(supplierId, applyerId, yearMonth, employee);
        this.initYearMonth(yearMonth);
        this.initYearSummaryMap();
    }

    private void initYearMonth(String yearMonth) {
        if (Beans.isEmpty((Object)yearMonth)) {
            throw new RuntimeException("yearMonth can not be null");
        }
        String[] str = yearMonth.split("-");
        if (str.length < 2) {
            throw new RuntimeException("yearMonth format error");
        }
        this.year = Integer.valueOf(str[0]);
        this.month = Integer.valueOf(str[1]);
    }

    private void initYearSummaryMap() {
        List<EasCustDocSummaryV> all = this.accountService.getAnnualEasCustDocSummaryList(this.employee.getCurrentPartner().getOrganizationid(), this.applyerId, this.year);
        this.yearSummaryMap = new HashMap<Integer, List<EasCustDocSummaryV>>();
        BigDecimal amt = this.account.getBeginningAmt();
        for (EasCustDocSummaryV sum : all) {
            Integer m = EasCustDocSummaryDto.translateYearMonthToMonthInt(sum.getDocDate());
            List<EasCustDocSummaryV> list = this.yearSummaryMap.get(m);
            if (list == null) {
                list = new ArrayList<EasCustDocSummaryV>();
                this.yearSummaryMap.put(m, list);
            }
            list.add(sum);
            this.yearShouldReceiveAmt = this.yearShouldReceiveAmt.add(sum.getIssAmt());
            this.yearReceivedAmt = this.yearReceivedAmt.add(sum.getRecAmt());
            if (m == this.month && DOCTYPE_INVOICE.equals(sum.getDocType())) {
                this.monthShouldReceiveAmt = this.monthShouldReceiveAmt.add(sum.getIssAmt());
                amt = amt.add(sum.getIssAmt());
            } else if (m == this.month && DOCTYPE_BILL.equals(sum.getDocType())) {
                this.monthReceivedAmt = this.monthReceivedAmt.add(sum.getRecAmt());
                amt = amt.subtract(sum.getRecAmt());
            } else if (m == this.month && SELL_OUT.equals(sum.getDocType())) {
                this.monthShouldReceiveAmt = this.monthShouldReceiveAmt.add(sum.getIssAmt());
                amt = amt.add(sum.getIssAmt());
            }
            sum.setEndAmount(amt);
        }
    }

    public List<EasCustDocSummaryV> getSummaryList() {
        if (this.yearSummaryMap.get(this.month) == null) {
            return new ArrayList<EasCustDocSummaryV>();
        }
        return this.yearSummaryMap.get(this.month);
    }

    public static Integer translateYearMonthToMonthInt(String yearMonth) {
        if (Beans.isEmpty((Object)yearMonth)) {
            return null;
        }
        String[] str = yearMonth.split("-");
        if (str.length < 2) {
            return null;
        }
        try {
            Integer month = Integer.valueOf(str[1]);
            return month;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public BigDecimal getYearShouldReceiveAmt() {
        return this.yearShouldReceiveAmt;
    }

    public BigDecimal getYearReceivedAmt() {
        return this.yearReceivedAmt;
    }

    @Override
    public String getSupplierId() {
        return this.supplierId;
    }

    @Override
    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    @Override
    public String getApplyerId() {
        return this.applyerId;
    }

    @Override
    public void setApplyerId(String applyerId) {
        this.applyerId = applyerId;
    }

    public Map<Integer, List<EasCustDocSummaryV>> getYearSummaryMap() {
        return this.yearSummaryMap;
    }

    public BigDecimal getMonthShouldReceiveAmt() {
        return this.monthShouldReceiveAmt;
    }

    public BigDecimal getMonthReceivedAmt() {
        return this.monthReceivedAmt;
    }
}

