/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.accountRelevance;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.accountRelevance.AccountRelevanceCondition;
import com.tcbj.crm.accountRelevance.AccountRelevanceService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.BrandAccountRelevance;
import com.tcbj.crm.intRuleControl.IntRuleControlCondition;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.UUIDUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/accountRelevance"})
public class AccountRelevanceController
extends BaseController {
    @Autowired
    AccountRelevanceService accountRelevanceService;

    @RequestMapping(value={"/list.do"})
    public String list(AccountRelevanceCondition con, Model model) {
        Page page = this.accountRelevanceService.getPage(con);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "accountRelevance/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editPartner(String relevanceCode, Model model, HttpServletRequest request) {
        if (StringUtils.isNotBlank((String)relevanceCode)) {
            List<BrandAccountRelevance> list = this.accountRelevanceService.getByRelevanceCode(relevanceCode);
            model.addAttribute("rowGridData", (Object)JSON.toJSONString(list));
            model.addAttribute("relevanceCode", (Object)relevanceCode);
        }
        return "accountRelevance/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result itemParams(@Valid @RequestBody AccountRelevanceCondition con) throws Exception {
        List<BrandAccountRelevance> list = con.getAccountRelevances();
        Employee employee = this.getCurrentEmployee();
        String relevanceGroup = con.getRelevanceCode();
        if (StringUtils.isEmpty((String)relevanceGroup)) {
            relevanceGroup = UUIDUtils.getId();
        }
        for (BrandAccountRelevance accountRelevance : list) {
            accountRelevance.setOrgId(employee.getCurrentPartner().getOrganizationid());
            accountRelevance.setRelevanceGroup(relevanceGroup);
        }
        this.accountRelevanceService.saveOrUpdate(list);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="relevanceCode", required=false) String relevanceCode, Model model) {
        this.accountRelevanceService.del(relevanceCode);
        return "redirect:list.do";
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.GET})
    public String intoExcel() throws Exception {
        return "accountRelevance/excel.ftl";
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.POST})
    public String upload(IntRuleControlCondition condition, HttpServletRequest request, Model model) {
        IUploadFile file;
        List<List<Object>> datas;
        List<String> errorList;
        List<IUploadFile> list = this.uploadFile(request, "accountRelevance");
        Employee emp = this.getCurrentEmployee();
        condition.setEm(emp);
        String rtn = null;
        if (list.size() > 0 && (errorList = this.accountRelevanceService.saveExcel(datas = ExcelHandle.readExcel((file = list.get(0)).getRealPath()))).size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(errorList)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }
}

