/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.accountRelevance;

import com.tcbj.crm.accountRelevance.AccountRelevanceCondition;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.entity.BrandAccountRelevance;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountRelevanceService {
    @Autowired
    NewBaseDao newBaseDao;
    @Autowired
    BaseDao baseDao;

    public List<PartnerContact> findUserList(AccountRelevanceCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("from PartnerContact where login is not null and startDate<? and (endDate>? or endDate is null)");
        args.add(new Date());
        args.add(new Date());
        if (StringUtils.isNotBlank(con.getOrgId())) {
            hql.append(" and pOrgId = ? ");
            args.add(con.getOrgId());
        }
        if (StringUtils.isNotBlank(con.getPartnerId())) {
            hql.append(" and partnerId = ? ");
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotEmpty(con.getRelevanceAccount())) {
            hql.append(" and login = ? ");
            args.add(con.getRelevanceAccount());
        }
        if (StringUtils.isNotEmpty(con.getRelevanceName())) {
            hql.append(" and contactName = ? ");
            args.add(con.getRelevanceName());
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PartnerContact.class);
    }

    public List<BrandAccountRelevance> findBrandAccountRelevanceByPerson(String personId, String orgId) {
        String hql = "from BrandAccountRelevance where personId = ? and orgId = ?";
        BrandAccountRelevance brandAccountRelevance = (BrandAccountRelevance)this.baseDao.findFirstEntity(hql, new Object[]{personId, orgId}, BrandAccountRelevance.class);
        if (Beans.isEmpty((Object)brandAccountRelevance)) {
            return null;
        }
        List accountRelevances = this.baseDao.findEntity("from BrandAccountRelevance where relevanceGroup = ? and orgId = ?", new Object[]{brandAccountRelevance.getRelevanceGroup(), orgId}, BrandAccountRelevance.class);
        for (BrandAccountRelevance accountRelevance : accountRelevances) {
            PartnerContact partnerContact = (PartnerContact)this.baseDao.get(PartnerContact.class, (Serializable)((Object)accountRelevance.getPersonId()));
            if (partnerContact == null) continue;
            accountRelevance.setRelevanceName(partnerContact.getContactName());
        }
        return accountRelevances;
    }

    public void saveOrUpdate(List<BrandAccountRelevance> list) {
        if (list.size() < 1) {
            return;
        }
        this.baseDao.executeHQL("delete from BrandAccountRelevance where relevanceGroup = ?", new Object[]{list.get(0).getRelevanceGroup()});
        String error = "";
        for (BrandAccountRelevance ar : list) {
            BrandAccountRelevance accountRelevance = (BrandAccountRelevance)this.baseDao.uniqueFindByHql("from BrandAccountRelevance where relevanceAccount = ? and orgId = ?", new Object[]{ar.getRelevanceAccount(), ar.getOrgId()}, BrandAccountRelevance.class);
            if (accountRelevance == null) continue;
            error = String.valueOf(error) + "\u5173\u8054\u8d26\u53f7" + accountRelevance.getRelevanceAccount() + "\u5df2\u6709\u5173\u8054\u5173\u7cfb;<br/>";
        }
        if (StringUtils.isNotBlank(error)) {
            throw new AppException("0010", error);
        }
        this.baseDao.save(list);
    }

    public Page getPage(AccountRelevanceCondition con) {
        String sql = "SELECT RELEVANCE_GROUP FROM CX_BRAND_ACCOUNT_RELEVANCE where 1=1 ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotBlank(con.getRelevanceAccount())) {
            sql = String.valueOf(sql) + " and RELEVANCE_ACCOUNT = ?";
            args.add(con.getRelevanceAccount());
        }
        if (StringUtils.isNotBlank(con.getPartnerId())) {
            sql = String.valueOf(sql) + " and PARTNER_ID = ?";
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotBlank(con.getPersonId())) {
            sql = String.valueOf(sql) + " and PERSON_ID = ?";
            args.add(con.getPersonId());
        }
        sql = String.valueOf(sql) + " GROUP BY RELEVANCE_GROUP ORDER BY MAX(CREATED) DESC";
        Page page = this.baseDao.searchBySql(sql, args.toArray(), Constant.DEFAULT_ROWS, con.getPageno().intValue(), null);
        ArrayList<String> relevanceCodes = new ArrayList<String>();
        for (Object obj : page.getList()) {
            String code = obj instanceof Object[] ? String.valueOf(((Object[])obj)[0]) : String.valueOf(obj);
            relevanceCodes.add(code);
        }
        ArrayList<AccountRelevanceCondition> list = new ArrayList<AccountRelevanceCondition>();
        for (String relevanceGroup : relevanceCodes) {
            List accountRelevances = this.baseDao.findEntity("from BrandAccountRelevance where relevanceGroup = ?", new Object[]{relevanceGroup}, BrandAccountRelevance.class);
            for (BrandAccountRelevance accountRelevance : accountRelevances) {
                List relevanceName = this.baseDao.findBySql("select FullName from CX_AWK_USERLIST_VIEW_ALL where Login = ? and PartnerOrgId = ?", new Object[]{accountRelevance.getRelevanceAccount(), accountRelevance.getOrgId()});
                if (!Beans.isNotEmpty((Object)relevanceName)) continue;
                accountRelevance.setRelevanceName(relevanceName.get(0).toString());
            }
            AccountRelevanceCondition condition = new AccountRelevanceCondition();
            condition.setAccountRelevances(accountRelevances);
            condition.setRelevanceCode(relevanceGroup);
            list.add(condition);
        }
        page.setList(list);
        return page;
    }

    public List<BrandAccountRelevance> getByRelevanceCode(String relevanceCode) {
        String hql = "from BrandAccountRelevance where relevanceGroup = ?";
        List list = this.baseDao.findEntity(hql, new Object[]{relevanceCode}, BrandAccountRelevance.class);
        for (BrandAccountRelevance accountRelevance : list) {
            List relevanceName = this.baseDao.findBySql("select FullName from CX_AWK_USERLIST_VIEW_ALL where Login = ? and PartnerOrgId = ?", new Object[]{accountRelevance.getRelevanceAccount(), accountRelevance.getOrgId()});
            if (!Beans.isNotEmpty((Object)relevanceName)) continue;
            accountRelevance.setRelevanceName(relevanceName.get(0).toString());
        }
        return list;
    }

    public void del(String relevanceGroup) {
        this.baseDao.executeHQL("delete from BrandAccountRelevance where relevanceGroup = ?", new Object[]{relevanceGroup});
    }

    public List<BrandAccountRelevance> findAccountRelevance(AccountRelevanceCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from BrandAccountRelevance where 1=1 ");
        if (StringUtils.isNotEmpty(con.getRelevanceAccount())) {
            hql.append(" and relevanceAccount = ? ");
            args.add(con.getRelevanceAccount());
        }
        if (StringUtils.isNotEmpty(con.getOrgId())) {
            hql.append(" and orgId = ? ");
            args.add(con.getOrgId());
        }
        if (StringUtils.isNotEmpty(con.getRelevanceCode())) {
            hql.append(" and relevanceGroup = ? ");
            args.add(con.getRelevanceCode());
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), BrandAccountRelevance.class);
    }

    public List<String> saveExcel(List<List<Object>> datas) {
        AccountRelevanceCondition con = new AccountRelevanceCondition();
        con.setOrgId(StringUtils.getOrgId());
        List<PartnerContact> userList = this.findUserList(con);
        HashMap<String, PartnerContact> userMap = new HashMap<String, PartnerContact>();
        for (PartnerContact user : userList) {
            String account = user.getLogin();
            userMap.put(account, user);
        }
        ArrayList<String> errorList = new ArrayList<String>();
        HashMap<String, ArrayList<Object>> accountRelevanceMap = new HashMap<String, ArrayList<Object>>();
        ArrayList<Object> accountRelevanceList = new ArrayList<Object>();
        int line = 1;
        for (List<Object> row : datas) {
            int errorSize = errorList.size();
            BrandAccountRelevance accountRelevance = new BrandAccountRelevance();
            String relevanceCode = (String)row.get(0);
            this.validataIsEmpty("\u5206\u7ec4\u6807\u8bc6\u7801", relevanceCode, ++line, errorList);
            accountRelevance.setRelevanceGroup(String.valueOf(line));
            String relevanceAccount = (String)row.get(1);
            if (this.validataIsEmpty("\u5173\u8054\u8d26\u53f7", relevanceAccount, line, errorList)) {
                relevanceAccount = row.get(1).toString().trim().toUpperCase();
                PartnerContact partnerContact = (PartnerContact)userMap.get(relevanceAccount);
                if (Beans.isEmpty((Object)partnerContact)) {
                    errorList.add("\u7b2c" + line + "\u884c\u5173\u8054\u8d26\u53f7\u4e0d\u6b63\u786e\uff01");
                } else {
                    accountRelevance.setPersonId(partnerContact.getId());
                    accountRelevance.setPartnerId(partnerContact.getPartnerId());
                    accountRelevance.setOrgId(partnerContact.getpOrgId());
                    accountRelevance.setRelevanceAccount(relevanceAccount);
                }
            }
            if (errorList.size() == errorSize) {
                ArrayList<Object> list = (ArrayList<Object>)accountRelevanceMap.get(relevanceCode);
                if (Beans.isEmpty((Object)list)) {
                    list = new ArrayList<Object>();
                }
                list.add(accountRelevance);
                accountRelevanceMap.put(relevanceCode, list);
                accountRelevanceList.add(accountRelevance);
            }
            errorSize = errorList.size();
        }
        if (errorList.size() > 0) {
            return errorList;
        }
        List<BrandAccountRelevance> arList = this.findAccountRelevance(new AccountRelevanceCondition());
        HashMap<String, BrandAccountRelevance> arMap = new HashMap<String, BrandAccountRelevance>();
        for (BrandAccountRelevance ar : arList) {
            arMap.put(ar.getRelevanceAccount(), ar);
        }
        HashMap<String, String> account_Map = new HashMap<String, String>();
        for (String relevanceCode : accountRelevanceMap.keySet()) {
            List list = (List)accountRelevanceMap.get(relevanceCode);
            String uuid = UUIDUtils.getId();
            for (BrandAccountRelevance accountRelevance : list) {
                String _line = accountRelevance.getRelevanceGroup();
                String relevanceAccount = accountRelevance.getRelevanceAccount();
                if (Beans.isNotEmpty(account_Map.get(relevanceAccount))) {
                    errorList.add("\u7b2c" + _line + "\u884c\u7684" + accountRelevance.getRelevanceAccount() + "\u8d26\u53f7\u5728\u5176\u4ed6\u7ec4\u4e2d\u5df2\u88ab\u914d\u7f6e");
                    continue;
                }
                account_Map.put(relevanceAccount, "true");
                if (Beans.isNotEmpty(arMap.get(relevanceAccount))) {
                    errorList.add("\u7b2c" + _line + "\u884c\u7684" + accountRelevance.getRelevanceAccount() + "\u8d26\u53f7\u5df2\u6709\u5173\u8054\u5173\u7cfb");
                    continue;
                }
                accountRelevance.setRelevanceGroup(uuid);
            }
        }
        if (errorList.size() == 0) {
            this.baseDao.save(accountRelevanceList);
        }
        return errorList;
    }

    public boolean validataIsEmpty(String name, Object data, int line, List<String> errorList) {
        if (Beans.isEmpty((Object)data)) {
            errorList.add("\u7b2c" + line + "\u884c" + name + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        return true;
    }
}

