/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.activity;

import com.tcbj.crm.activity.ActivityCondition;
import com.tcbj.crm.view.CampaignAccountlistV;
import com.tcbj.crm.view.CampaignFormlistV;
import com.tcbj.crm.view.CampaignGiftlistV;
import com.tcbj.crm.view.CampaignlistV;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityService {
    @Autowired
    BaseDao baseDao;

    public Page getActivityPage(ActivityCondition condition) {
        StringBuffer hql = new StringBuffer();
        hql.append("select c from CampaignlistV c ,CampaignAccountlistV a where a.campaignId = c.id ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(condition.getPartnerId())) {
            hql.append(" and (a.accountId = ? or c.supplierId = ?)");
            args.add(condition.getPartnerId());
            args.add(condition.getPartnerId());
        }
        if (StringUtils.isNotEmpty(condition.getActivityName())) {
            hql.append(" and c.campaignName like ? ");
            args.add("%" + condition.getActivityName() + "%");
        }
        if (condition.getStartDate() != null) {
            hql.append(" and c.startDate >= ? ");
            args.add(condition.getStartDate());
        }
        if (condition.getEndDate() != null) {
            hql.append(" and c.startDate <= ? ");
            args.add(condition.getEndDate());
        }
        hql.append(" order by c.startDate desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public CampaignlistV getActivity(String id) {
        CampaignlistV activity = (CampaignlistV)this.baseDao.get(CampaignlistV.class, (Serializable)((Object)id));
        List giftList = this.baseDao.findEntity(" from CampaignGiftlistV g where g.campaignId = ? ", new Object[]{id}, CampaignGiftlistV.class);
        List formList = this.baseDao.findEntity(" from  CampaignFormlistV f where f.campaignId = ? ", new Object[]{id}, CampaignFormlistV.class);
        List accountList = this.baseDao.findEntity(" from CampaignAccountlistV a where a.campaignId = ? ", new Object[]{id}, CampaignAccountlistV.class);
        activity.setGiftList(giftList);
        activity.setFormList(formList);
        activity.setAccountList(accountList);
        return activity;
    }
}

