/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.activityPlat;

import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ActivityPartnerService")
public class ActivityPartnerService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelservice;

    public String getOrgTree(String emId, String ids) throws Exception {
        Partner p = this.personnelservice.getById(emId);
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)"1");
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u533a\u57df\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("nocheck", (Object)"false");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        this.channelTree(emId, ids, nodes, p.getId());
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public void channelTree(String emId, String ids, JSONArray nodes, String pId) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emId);
        args.add(new Date());
        args.add(new Date());
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by c.created ", args.toArray(), ChannelType.class);
        if (StringUtils.isNotEmpty(ids)) {
            ids = ids.substring(0, ids.length() - 1);
        }
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)pId);
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            node2.put("nocheck", (Object)"false");
            if (StringUtils.isNotEmpty(ids)) {
                if (ids.indexOf("'" + dt.getId() + "'") != -1) {
                    node2.put("checked", (Object)"true");
                } else {
                    this.bigAreaCodeTree(emId, ids, nodes, node2, dt.getId());
                }
            }
            nodes.put((Object)node2);
        }
    }

    public void bigAreaCodeTree(String emId, String ids, JSONArray nodes, JSONObject node2, String pId) throws Exception {
        List<String> list = StringUtils.stringToList(ids, ",");
        StringBuilder ids1 = new StringBuilder();
        StringBuilder ids2 = new StringBuilder();
        if (list.size() > 1000) {
            int i = 0;
            while (i < 1000) {
                if (i == 999) {
                    ids1.append(list.get(i));
                } else {
                    ids1.append(String.valueOf(list.get(i)) + ",");
                }
                ++i;
            }
            i = 1000;
            while (i < list.size()) {
                if (i == list.size() - 1) {
                    ids2.append(list.get(i));
                } else {
                    ids2.append(String.valueOf(list.get(i)) + ",");
                }
                ++i;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        String hql = " select CHANNEL_CODE as channelType  from CX_REGION_MAIN where ORG_ID = ?  ";
        hql = list.size() > 1000 ? String.valueOf(hql) + "  and ( PARENT_ID in (" + ids1.toString() + ") or PARENT_ID in (" + ids2.toString() + ") or row_id in (" + ids1.toString() + ") or row_id in (" + ids2.toString() + ") ) " : String.valueOf(hql) + "  and ( PARENT_ID in (" + ids + ") or row_id in (" + ids + ") ) ";
        args.add(emId);
        hql = String.valueOf(hql) + " union select PartnerChnlType as channelType from CX_AWK_PRTNR_ACCOUNTLIST_VIEW where ORGID = ?  ";
        hql = list.size() > 1000 ? String.valueOf(hql) + " and  ( PARTNERID in (" + ids1.toString() + ") or PARTNERID in (" + ids2.toString() + ") ) " : String.valueOf(hql) + " and  PARTNERID in (" + ids + ") ";
        args.add(emId);
        List pns = this.baseDao.findBySql(hql, args.toArray());
        this.setTree(pns, emId, ids, nodes, node2, pId, "b");
    }

    public void areaCodeTree(String emId, String ids, JSONArray nodes, JSONObject node2, String pId) throws Exception {
        List<String> list = StringUtils.stringToList(ids, ",");
        StringBuilder ids1 = new StringBuilder();
        StringBuilder ids2 = new StringBuilder();
        if (list.size() > 1000) {
            int i = 0;
            while (i < 1000) {
                if (i == 999) {
                    ids1.append(list.get(i));
                } else {
                    ids1.append(String.valueOf(list.get(i)) + ",");
                }
                ++i;
            }
            i = 1000;
            while (i < list.size()) {
                if (i == list.size() - 1) {
                    ids2.append(list.get(i));
                } else {
                    ids2.append(String.valueOf(list.get(i)) + ",");
                }
                ++i;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        String hql = " select PARENT_ID as areaCode  from CX_REGION_MAIN where ORG_ID = ?  ";
        hql = list.size() > 1000 ? String.valueOf(hql) + "  and ( row_id in (" + ids1.toString() + ") or row_id in (" + ids2.toString() + ") ) " : String.valueOf(hql) + "  and row_id in (" + ids + ") ";
        args.add(emId);
        hql = String.valueOf(hql) + " union select DISTRICTID as areaCode from CX_AWK_PRTNR_ACCOUNTLIST_VIEW where ORGID = ?  ";
        hql = list.size() > 1000 ? String.valueOf(hql) + " and  ( PARTNERID in (" + ids1.toString() + ") or PARTNERID in (" + ids2.toString() + ") ) " : String.valueOf(hql) + " and  PARTNERID in (" + ids + ") ";
        args.add(emId);
        List pns = this.baseDao.findBySql(hql, args.toArray());
        this.setTree(pns, emId, ids, nodes, node2, pId, "a");
    }

    public void partnerTree(String emId, String ids, JSONArray nodes, JSONObject node2, String pId) throws Exception {
        List<String> list = StringUtils.stringToList(ids, ",");
        StringBuilder ids1 = new StringBuilder();
        StringBuilder ids2 = new StringBuilder();
        if (list.size() > 1000) {
            int i = 0;
            while (i < 1000) {
                if (i == 999) {
                    ids1.append(list.get(i));
                } else {
                    ids1.append(String.valueOf(list.get(i)) + ",");
                }
                ++i;
            }
            i = 1000;
            while (i < list.size()) {
                if (i == list.size() - 1) {
                    ids2.append(list.get(i));
                } else {
                    ids2.append(String.valueOf(list.get(i)) + ",");
                }
                ++i;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        String hql = " select distinct REGIONID as areaCode from CX_AWK_PRTNR_ACCOUNTLIST_VIEW where ORGID = ?   ";
        hql = list.size() > 1000 ? String.valueOf(hql) + " and ( PARTNERID in (" + ids1.toString() + ") or PARTNERID in (" + ids2.toString() + ") ) " : String.valueOf(hql) + " and  PARTNERID in (" + ids + ") ";
        args.add(emId);
        List pns = this.baseDao.findBySql(hql, args.toArray());
        this.setTree(pns, emId, ids, nodes, node2, pId, "p");
    }

    public void setTree(List<Object[]> pns, String emId, String ids, JSONArray nodes, JSONObject node2, String pId, String type) throws Exception {
        boolean cTrue = false;
        for (Object[] object : pns) {
            String obj;
            if (object == null || !(obj = object.toString()).equals(pId)) continue;
            cTrue = true;
            ArrayList<Object> args3 = new ArrayList<Object>();
            args3.add(obj);
            args3.add(emId);
            String hql3 = "";
            if ("b".equals(type) || "a".equals(type)) {
                hql3 = "select id,regionName from Region where parentId = ? and orgId = ? and startDate < ? and nvl(endDate,?) >= ? order by regionName";
                args3.add(DateUtils.now());
                args3.add(DateUtils.getEndTime());
                args3.add(DateUtils.now());
            }
            if ("p".equals(type)) {
                hql3 = "select applyerId,applyerName from Customer where areaCode=? and supplierId = ? ";
                hql3 = String.valueOf(hql3) + " and startdate <= ? and nvl(enddate,?) >= ? ";
                args3.add(DateUtils.now());
                args3.add(DateUtils.getEndTime());
                args3.add(DateUtils.now());
                hql3 = String.valueOf(hql3) + " order by applyerCode ";
            }
            List pns3 = this.baseDao.findEntity(hql3, args3.toArray(), Object.class);
            for (Object pn : pns3) {
                Object[] p3 = (Object[])pn;
                JSONObject node3 = new JSONObject();
                node3.put("id", (Object)((String)p3[0]));
                node3.put("pId", (Object)obj);
                node3.put("name", (Object)((String)p3[1]));
                if ("p".equals(type)) {
                    node3.put("isParent", (Object)"false");
                } else {
                    node3.put("isParent", (Object)"true");
                }
                node3.put("iconSkin", (Object)"start");
                node3.put("nocheck", (Object)"false");
                if (ids.indexOf("'" + (String)p3[0] + "'") != -1) {
                    node3.put("checked", (Object)"true");
                } else {
                    if ("b".equals(type)) {
                        this.areaCodeTree(emId, ids, nodes, node3, (String)p3[0]);
                    }
                    if ("a".equals(type)) {
                        this.partnerTree(emId, ids, nodes, node3, (String)p3[0]);
                    }
                }
                nodes.put((Object)node3);
            }
        }
        if (cTrue) {
            node2.put("open", (Object)"true");
        }
    }

    public String getChildNodeTree(String parentId, String level, String check, Employee e) throws JSONException {
        JSONArray nodes = new JSONArray();
        String hql = "";
        String isParent = "true";
        ArrayList<Object> args = new ArrayList<Object>();
        if ("1".equals(level) || "2".equals(level)) {
            hql = "select id,regionName from Region where parentId = ? and orgId = ? ";
            hql = String.valueOf(hql) + " and startDate < ? and nvl(endDate,?) >= ?  order by regionName";
        } else {
            isParent = "false";
            hql = "  select applyerId,applyerName from Customer where areaCode=? and supplierId = ? ";
            hql = String.valueOf(hql) + " and startdate <= ? and nvl(enddate,?) >= ? ";
            hql = String.valueOf(hql) + " order by applyerCode ";
        }
        args.add(parentId);
        args.add(e.getCurrentPartner().getId());
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        List pns = this.baseDao.findEntity(hql, args.toArray(), Object.class);
        for (Object pn : pns) {
            Object[] p = (Object[])pn;
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)((String)p[0]));
            node2.put("pId", (Object)((String)p[0]));
            node2.put("name", (Object)((String)p[1]));
            node2.put("isParent", (Object)isParent);
            node2.put("iconSkin", (Object)"start");
            node2.put("nocheck", (Object)"false");
            if ("true".equals(check)) {
                node2.put("checked", (Object)"true");
            }
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }
}

