/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.activityPlat;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.activityPlat.ActivityCondition;
import com.tcbj.crm.activityPlat.ActivityPartnerService;
import com.tcbj.crm.activityPlat.ActivityPlatService;
import com.tcbj.crm.activityPlat.EsbActivity;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/activityPlat"})
public class ActivityPlatController
extends BaseController {
    @Autowired
    ActivityPlatService activityService;
    @Autowired
    ActivityPartnerService activityPartnerService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, HttpServletRequest request, ActivityCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        con.setOrgId(em.getCurrentPartner().getId());
        Page page = this.activityService.getActivityPage(con, pageno, request);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "activityPlat/list.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String code, Model model, HttpServletRequest request) {
        Activity activity = this.activityService.actView(code, request);
        model.addAttribute("act", (Object)activity);
        return "activityPlat/viewAct.ftl";
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String code, Model model, HttpServletRequest request) {
        this.activityService.delete(code, request);
        return "redirect:list.do";
    }

    @RequestMapping(value={"/addAct.do"}, method={RequestMethod.GET})
    public String addAct(Activity act, Model model) {
        Employee em = this.getCurrentEmployee();
        model.addAttribute("em", (Object)em);
        act.setStatus("0");
        model.addAttribute("act", (Object)act);
        return "activityPlat/addAct.ftl";
    }

    @RequestMapping(value={"/addAct.do"}, method={RequestMethod.POST})
    public String addAct(Activity act, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        act.fillInitData(em);
        this.activityService.setPartner(act);
        String rtn = "";
        HashMap<String, List<String>> productMap = new HashMap<String, List<String>>();
        this.activityService.setRule(act, productMap);
        this.activityService.checkProduct(productMap, em, act);
        List condition = (List)productMap.get("condition");
        if (condition != null && condition.size() > 0) {
            rtn = String.valueOf(rtn) + "condition:" + Jsons.toJson((Object)condition);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        List privilege = (List)productMap.get("privilege");
        if (privilege != null && privilege.size() > 0) {
            rtn = String.valueOf(rtn) + "privilege:" + Jsons.toJson((Object)privilege);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        EsbActivity newAct = new EsbActivity();
        Beans.copy((Object)newAct, (Object)act);
        newAct.setRuleList(act.getRuleList());
        newAct.setEndDate(DateUtils.formDateToDate((Date)newAct.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss", (String)"23:59:59"));
        rtn = this.activityService.saveAct(request, Jsons.toJson((Object)newAct));
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/editAct.do"}, method={RequestMethod.GET})
    public String editAct(String code, Model model, HttpServletRequest request) {
        Activity activity = this.activityService.actView(code, request);
        model.addAttribute("act", (Object)activity);
        return "activityPlat/editAct.ftl";
    }

    @RequestMapping(value={"/editAct.do"}, method={RequestMethod.POST})
    public String editAct(Activity act, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        act.fillInitData(em);
        this.activityService.setPartner(act);
        String rtn = "";
        HashMap<String, List<String>> productMap = new HashMap<String, List<String>>();
        this.activityService.setRule(act, productMap);
        this.activityService.checkProduct(productMap, em, act);
        List condition = (List)productMap.get("condition");
        if (condition != null && condition.size() > 0) {
            rtn = String.valueOf(rtn) + "condition:" + Jsons.toJson((Object)condition);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        List privilege = (List)productMap.get("privilege");
        if (privilege != null && privilege.size() > 0) {
            rtn = String.valueOf(rtn) + "privilege:" + Jsons.toJson((Object)privilege);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        EsbActivity newAct = new EsbActivity();
        Beans.copy((Object)newAct, (Object)act);
        if ("2".equals(newAct.getStatus())) {
            newAct.setStatus("3");
        }
        newAct.setRuleList(act.getRuleList());
        newAct.setEndDate(DateUtils.formDateToDate((Date)newAct.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss", (String)"23:59:59"));
        List<Map<String, Object>> list = newAct.getRuleList();
        for (Map<String, Object> map : list) {
            map.remove("ruleCondition");
            map.remove("rulePrivilege");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jsonStr", Jsons.toJson((Object)newAct));
        hashMap.put("code", newAct.getCode());
        rtn = this.activityService.editAct(hashMap);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/manageAct.do"}, method={RequestMethod.POST})
    public String manageAct(Activity act, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        String state = act.getStatus();
        Activity activity = this.activityService.actView(act.getCode(), request);
        if ("0".equals(state) || "3".equals(state)) {
            String rtn = "";
            String errorProducts = this.activityService.checkActivityRule03(activity);
            if (Beans.isNotEmpty((Object)errorProducts)) {
                rtn = "false:\u5b58\u5728\u540c\u671f\u6d3b\u52a8\u8d60\u9001\u7684\u4ea7\u54c1\u4e0d\u663e\u793a\u5728\u5e38\u89c4\u5217\u8868,\u9519\u8bef\u914d\u7f6e\u4ea7\u54c1\u7f16\u7801\u5982\u4e0b\n" + errorProducts;
                model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
                return "common/iframeRtn.ftl";
            }
            state = "1";
        } else if ("1".equals(state)) {
            state = "2";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", act.getCode());
        map.put("status", state);
        map.put("lastUpdateMan", em.getId());
        String rtn = this.activityService.manageAct(map);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/excelRtn.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excelRtn(String rtns, String type, HttpServletResponse response) throws Exception {
        String[] pop;
        String[] titles;
        HashMap<String, String> map;
        ArrayList listMap = new ArrayList();
        List<String> list = StringUtils.stringToList(rtns, ",");
        if ("order".equals(type)) {
            for (String string : list) {
                map = new HashMap<String, String>();
                map.put("no", string);
                listMap.add(map);
            }
            titles = new String[]{"\u8ba2\u5355\u7f16\u53f7"};
            pop = new String[]{"no"};
            ExcelUtils.exportExcelNew("\u66f4\u591a\u62a5\u9519\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6ca1\u6709\u5206\u914d\u4ea7\u54c1\u7684\u7ecf\u9500\u5546", ".xlsx", titles, listMap, pop, response);
        }
        if ("product".equals(type)) {
            for (String string : list) {
                map = new HashMap();
                List<String> listinfo = StringUtils.stringToList(string, "\uff1a");
                map.put("p", listinfo.get(0));
                map.put("no", listinfo.get(1));
                listMap.add(map);
            }
            titles = new String[]{"\u7ecf\u9500\u5546", "\u4ea7\u54c1\u7f16\u53f7"};
            pop = new String[]{"p", "no"};
            ExcelUtils.exportExcelNew("\u66f4\u591a\u62a5\u9519\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6ca1\u6709\u5206\u914d\u4ea7\u54c1\u7684\u7ecf\u9500\u5546", ".xlsx", titles, listMap, pop, response);
        }
    }

    @RequestMapping(value={"/addRule.do"})
    public String addRule(HttpServletRequest request, @RequestParam(value="rowId", required=false) String rowId, @RequestParam(value="type", required=false) String type, @RequestParam(value="code", required=false) String code, @RequestParam(value="status", required=false) String status, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("name", (Object)e.getName());
        model.addAttribute("rowId", (Object)rowId);
        model.addAttribute("status", (Object)status);
        String url = "";
        if ("RULE001".equals(code)) {
            url = "activityPlat/baseRuleItem.ftl";
            if ("view".equals(type)) {
                url = "activityPlat/viewRuleItem.ftl";
            }
        } else if ("RULE002".equals(code)) {
            url = "activityPlat/baseRule.ftl";
            if ("view".equals(type)) {
                url = "activityPlat/viewRule.ftl";
            }
        } else if ("RULE004".equals(code)) {
            url = "activityPlat/baseFreeMateriel.ftl";
            if ("view".equals(type)) {
                url = "activityPlat/viewFreeMateriel.ftl";
            }
        } else {
            url = "activityPlat/baseRuleOneGift.ftl";
            if ("view".equals(type)) {
                url = "activityPlat/viewRuleOneGift.ftl";
            }
        }
        return url;
    }

    @RequestMapping(value={"/partnerTree.do"})
    public String tree(HttpServletRequest request, String ids, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        String tree = this.activityPartnerService.getOrgTree(e.getCurrentPartner().getId(), ids);
        model.addAttribute("tree", (Object)tree);
        return "activityPlat/partnerTree.ftl";
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String parentId, String level, String check, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        try {
            String result = this.activityPartnerService.getChildNodeTree(parentId, level, check, em);
            response.getWriter().write(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET})
    public String editPartner(String code, Model model, HttpServletRequest request) {
        Activity activity = this.activityService.actView(code, request);
        model.addAttribute("act", (Object)activity);
        return "activityPlat/editPartner.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.POST})
    public String editPartner(Activity act, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        act.fillInitData(em);
        Activity activity = this.activityService.actView(act.getCode(), request);
        activity.updateLastData(em);
        activity.setPartnerJson(act.getPartnerJson());
        this.activityService.setPartner(activity);
        String rtn = "";
        HashMap<String, List<String>> productMap = new HashMap<String, List<String>>();
        this.activityService.setRule(activity, productMap);
        this.activityService.checkProduct(productMap, em, activity);
        List condition = (List)productMap.get("condition");
        if (condition != null && condition.size() > 0) {
            rtn = String.valueOf(rtn) + "condition:" + Jsons.toJson((Object)condition);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        List privilege = (List)productMap.get("privilege");
        if (privilege != null && privilege.size() > 0) {
            rtn = String.valueOf(rtn) + "privilege:" + Jsons.toJson((Object)privilege);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", Jsons.toJson((Object)activity));
        map.put("code", activity.getCode());
        rtn = this.activityService.editAct(map);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/partnerImport.do"}, method={RequestMethod.POST})
    public String partnerImport(Model model, HttpServletRequest request) {
        ArrayList<Partner> partners;
        block7: {
            String url;
            Employee me;
            block6: {
                try {
                    me = this.getCurrentEmployee();
                    List<IUploadFile> filelist = this.uploadFile(request, "partnerImport");
                    url = "";
                    if (filelist.size() > 0) {
                        for (IUploadFile file : filelist) {
                            if (!file.getFieldName().equals("uploadfile_2")) continue;
                            url = file.getRealPath();
                        }
                        break block6;
                    }
                    model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getErrorResult("\u8bf7\u4e0a\u4f20Excel\u6587\u4ef6")));
                    return "common/iframeRtn.ftl";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getErrorResult(" \u7cfb\u7edf\u5f02\u5e38\uff0c\u5bfc\u5165\u5931\u8d25")));
                    return "common/iframeRtn.ftl";
                }
            }
            partners = new ArrayList<Partner>();
            List<String> errorMsgs = this.activityService.readPartnersByExcel(url, partners, me);
            if (errorMsgs.size() <= 0) break block7;
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("code", "-1");
            rtn.put("data", errorMsgs);
            model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("code", "200");
        rtn.put("data", partners);
        model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }
}

