/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.activityPlat;

import com.alibaba.fastjson.JSONArray;
import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.activityPlat.ActivityCondition;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.ActivityPlatformHelper;
import com.tcbj.crm.util.ActivityRequestHelper;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ActivityPlatformService")
public class ActivityPlatService {
    @Autowired
    BaseDao baseDao;
    private String URL = StringUtils.getActicity();
    private int pageSize = Constant.ESB_PAGE_ROWS;
    private String organization = StringUtils.getPrefix();

    public Page getActivityPage(ActivityCondition con, int pageno, HttpServletRequest request) {
        String url = String.valueOf(this.URL) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", this.organization);
        if (con.getStartDate() != null) {
            map.put("beginDate_start", DateUtils.formartDate((Date)con.getStartDate(), (String)"yyyy-MM-dd"));
        }
        if (con.getsDate() != null) {
            map.put("beginDate_end", DateUtils.formartDate((Date)con.getsDate(), (String)"yyyy-MM-dd"));
        }
        if (con.getEndDate() != null) {
            map.put("endDate_start", DateUtils.formartDate((Date)con.getEndDate(), (String)"yyyy-MM-dd"));
        }
        if (con.geteDate() != null) {
            map.put("endDate_end", DateUtils.formartDate((Date)con.geteDate(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty(con.getActCode())) {
            map.put("code", con.getActCode().trim());
        }
        if (StringUtils.isNotEmpty(con.getActTheme())) {
            map.put("name", con.getActTheme().trim());
        }
        if (StringUtils.isNotEmpty(con.getStatus())) {
            map.put("status", con.getStatus());
        }
        map.put("orderBy", " last_update_date desc");
        String bodyCount = ActivityRequestHelper.getInstance().sendBody(url, map);
        int count = 0;
        if (bodyCount != null) {
            List conListCount = JSONArray.parseArray((String)EsbAnalyUtil.getResults(bodyCount, "activityInfo"), Activity.class);
            count = conListCount.size();
        }
        if (pageno > 0) {
            map.put("fromRow", String.valueOf(pageno));
            map.put("maxRows", String.valueOf(this.pageSize));
        }
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        List conList = new ArrayList();
        if (body != null) {
            conList = JSONArray.parseArray((String)EsbAnalyUtil.getResults(body, "activityInfo"), Activity.class);
        }
        return new Page(conList, pageno, this.pageSize, count);
    }

    public Activity actView(String code, HttpServletRequest request) {
        String url = String.valueOf(this.URL) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", this.organization);
        map.put("code", code);
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        Map<String, Object> activityInfo = EsbAnalyUtil.getResult(body, "activityInfo");
        Activity activity = new Activity();
        Beans.copy((Object)activity, activityInfo, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"});
        ArrayList ruleList = new ArrayList();
        Map<String, Object> variabls = EsbAnalyUtil.getResult(body, "variabls");
        HashMap<String, Object> ruleData = new HashMap<String, Object>();
        if (variabls != null) {
            activity.setPartnerJson(variabls.get("fwList").toString());
            ruleData.put("activityType", variabls.get("activityType").toString());
            ruleData.put("droolsRuleCode", variabls.get("droolsRuleCode").toString());
            ruleData.put("creatDate", variabls.get("creatDate").toString());
            ruleData.put("priceFlag", variabls.get("priceFlag").toString());
            ruleData.put("partFlag", variabls.get("partFlag").toString());
            List zpList = (List)Jsons.toBean((String)variabls.get("zpList").toString(), List.class);
            variabls.put("rulePrivilege", zpList);
            List tjList = (List)Jsons.toBean((String)variabls.get("tjList").toString(), List.class);
            variabls.put("ruleCondition", tjList);
            variabls.remove("fwList");
            variabls.remove("zpList");
            variabls.remove("tjList");
            variabls.remove("channel_id");
            variabls.remove("district_id");
            variabls.remove("region_id");
            variabls.remove("partner_id");
            ruleData.put("ruleInfo", variabls);
        }
        ruleList.add(ruleData);
        activity.setRuleJson(Jsons.toJson(ruleList));
        return activity;
    }

    public void delete(String code, HttpServletRequest request) {
        String url = String.valueOf(this.URL) + "ActivityApi/delActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", this.organization);
        map.put("code", code);
        try {
            String body = ActivityRequestHelper.getInstance().sendBody(url, map);
            EsbAnalyUtil.returnObject(body, null).toString();
        }
        catch (Exception exception) {
            throw new AppException("2021");
        }
    }

    public String saveAct(HttpServletRequest request, String jsonData) {
        String url = String.valueOf(this.URL) + "ActivityApi/addActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", this.organization);
        map.put("jsonStr", jsonData);
        String rtn = "";
        try {
            String body = ActivityRequestHelper.getInstance().sendBody(url, map);
            String message = EsbAnalyUtil.returnObject(body, null).toString();
            rtn = "true:" + message;
        }
        catch (Exception exception) {
            rtn = "false:ESB\u8c03\u7528\u5931\u8d25";
        }
        return rtn;
    }

    public String editAct(Map<String, String> map) {
        String url = String.valueOf(this.URL) + "ActivityApi/updateActivityInfo";
        map.put("organization", this.organization);
        String rtn = "";
        try {
            String body = ActivityRequestHelper.getInstance().sendBody(url, map);
            String message = EsbAnalyUtil.returnObject(body, null).toString();
            rtn = "true:" + message;
        }
        catch (Exception exception) {
            rtn = "false:ESB\u8c03\u7528\u5931\u8d25";
        }
        return rtn;
    }

    public String manageAct(Map<String, String> map) {
        String url = String.valueOf(this.URL) + "ActivityApi/updateActivityStatus";
        map.put("organization", this.organization);
        String rtn = "";
        if ("2".equals(map.get("status"))) {
            StringBuffer hql = new StringBuffer();
            hql.append(" select o.no from OrderApply o,OrderActivityInfo c ");
            hql.append(" where o.state='2' and o.id=c.orderApplyId and c.activityId=? ");
            List list = this.baseDao.findEntity(hql.toString(), new Object[]{map.get("code")}, Object.class);
            if (list.size() > 0) {
                return "list:" + Jsons.toJson((Object)list);
            }
        }
        try {
            String body = ActivityRequestHelper.getInstance().sendBody(url, map);
            String message = EsbAnalyUtil.returnObject(body, null).toString();
            rtn = "true:" + message;
        }
        catch (Exception exception) {
            rtn = "false:ESB\u8c03\u7528\u5931\u8d25";
        }
        return rtn;
    }

    public void setPartner(Activity act) {
        List list = (List)Jsons.toBean((String)act.getPartnerJson(), List.class);
        act.setPartnerList(list);
        String channel = "";
        String bigAreaCode = "";
        String areaCode = "";
        String partner = "";
        for (Map map : list) {
            String level = map.get("level").toString();
            String regionId = map.get("regionId").toString();
            if ("1".equals(level)) {
                channel = String.valueOf(channel) + regionId + ",";
                continue;
            }
            if ("2".equals(level)) {
                bigAreaCode = String.valueOf(bigAreaCode) + regionId + ",";
                continue;
            }
            if ("3".equals(level)) {
                areaCode = String.valueOf(areaCode) + regionId + ",";
                continue;
            }
            if (!"4".equals(level)) continue;
            partner = String.valueOf(partner) + regionId + ",";
        }
        channel = this.clIds(channel);
        bigAreaCode = this.clIds(bigAreaCode);
        areaCode = this.clIds(areaCode);
        partner = this.clIds(partner);
        act.setChannel(channel);
        act.setBigAreaCode(bigAreaCode);
        act.setAreaCode(areaCode);
        act.setPartner(partner);
    }

    public void setRule(Activity act, Map<String, List<String>> productMap) {
        ArrayList<String> listCondition = new ArrayList<String>();
        ArrayList<String> listPrivilege = new ArrayList<String>();
        List list = (List)Jsons.toBean((String)act.getRuleJson(), List.class);
        ArrayList<Map<String, Object>> ruleList = new ArrayList<Map<String, Object>>();
        for (Map map : list) {
            Map ruleInfo = new HashMap();
            ruleInfo = map.get("ruleInfo") instanceof Map ? (Map)map.get("ruleInfo") : (Map)Jsons.toBean((String)map.get("ruleInfo").toString(), Map.class);
            List ruleCondition = (List)ruleInfo.get("ruleCondition");
            HashMap<String, List> tjMap = new HashMap<String, List>();
            tjMap.put("tjList", ruleCondition);
            ArrayList<HashMap<String, List>> tjParam = new ArrayList<HashMap<String, List>>();
            tjParam.add(tjMap);
            ruleInfo.put("tjParam", tjParam);
            List rulePrivilege = (List)ruleInfo.get("rulePrivilege");
            HashMap<String, List> zpMap = new HashMap<String, List>();
            zpMap.put("zpList", rulePrivilege);
            ArrayList<HashMap<String, List>> zpParam = new ArrayList<HashMap<String, List>>();
            zpParam.add(zpMap);
            ruleInfo.put("zpParam", zpParam);
            HashMap<String, Object> fwMap = new HashMap<String, Object>();
            fwMap.put("fwList", act.getPartnerList());
            fwMap.put("channel_id", act.getChannel());
            fwMap.put("district_id", act.getBigAreaCode());
            fwMap.put("region_id", act.getAreaCode());
            fwMap.put("partner_id", act.getPartner());
            ArrayList<HashMap<String, Object>> fwParams = new ArrayList<HashMap<String, Object>>();
            fwParams.add(fwMap);
            ruleInfo.put("fwParam", fwParams);
            for (Map map2 : ruleCondition) {
                if (!"product".equals(map2.get("rule_conditionType").toString())) continue;
                listCondition.add(map2.get("rule_productCode").toString());
            }
            for (Map map2 : rulePrivilege) {
                listPrivilege.add(map2.get("rule_productCode").toString());
            }
            ruleInfo.remove("ruleCondition");
            ruleInfo.remove("rulePrivilege");
            ruleList.add(ruleInfo);
        }
        act.setRuleList(ruleList);
        productMap.put("listCondition", listCondition);
        productMap.put("listPrivilege", listPrivilege);
    }

    public void checkProduct(Map<String, List<String>> productMap, Employee em, Activity act) {
        List<String> listPrivilege;
        List<String> listCondition = this.productAndpartner(productMap, "listCondition", em, act);
        if (listCondition.size() > 0) {
            productMap.put("condition", listCondition);
        }
        if ((listPrivilege = this.productAndpartner(productMap, "listPrivilege", em, act)).size() > 0) {
            productMap.put("privilege", listPrivilege);
        }
    }

    public List<String> productAndpartner(Map<String, List<String>> productMap, String listKey, Employee em, Activity act) {
        ArrayList<String> listNo = new ArrayList<String>();
        List<String> list = productMap.get(listKey);
        if (list.size() > 0) {
            List<String> areaList;
            List<String> bigList;
            StringBuffer HQL = new StringBuffer();
            HQL.append("select partner_id,partner_name from CX_PARTNERLIST_V ");
            HQL.append(" where StartDate <= ? and nvl(EndDate,?) >= ? ");
            HQL.append(" and (1=0 ");
            List<String> chList = StringUtils.stringToList(act.getChannel(), ",");
            if (chList.size() > 0) {
                HQL.append(" or channel_id in ('").append(StringUtils.listToString(chList, "','")).append("') ");
            }
            if ((bigList = StringUtils.stringToList(act.getBigAreaCode(), ",")).size() > 0) {
                HQL.append(" or district_id in ('").append(StringUtils.listToString(bigList, "','")).append("') ");
            }
            if ((areaList = StringUtils.stringToList(act.getAreaCode(), ",")).size() > 0) {
                HQL.append(" or region_id in ('").append(StringUtils.listToString(areaList, "','")).append("') ");
            }
            List<String> partnerList = StringUtils.stringToList(act.getPartner(), ",");
            ArrayList<String> partnerList1 = new ArrayList<String>();
            ArrayList<String> partnerList2 = new ArrayList<String>();
            if (partnerList.size() > 1000) {
                int i = 0;
                while (i < partnerList.size()) {
                    if (i < 1000) {
                        partnerList1.add(partnerList.get(i));
                    } else {
                        partnerList2.add(partnerList.get(i));
                    }
                    ++i;
                }
            }
            if (partnerList.size() > 1000) {
                HQL.append(" or partner_id in ('").append(StringUtils.listToString(partnerList1, "','")).append("') or partner_id in ('").append(StringUtils.listToString(partnerList2, "','")).append("') ");
            } else if (partnerList.size() > 0) {
                HQL.append(" or partner_id in ('").append(StringUtils.listToString(partnerList, "','")).append("') ");
            }
            HQL.append(" )");
            List dts = this.baseDao.findBySql(HQL.toString(), new Object[]{DateUtils.now(), DateUtils.getEndTime(), DateUtils.now()});
            StringBuffer hql = new StringBuffer();
            ArrayList<String> args = new ArrayList<String>();
            hql.append(" select c.partnerId,a.no from Product a,PartnerProductREL c where a.id=c.productId and c.supplierId=? and a.orgId=? ");
            hql.append(" and nvl(c.invalidDt,sysdate + 1) > sysdate ");
            args.add(em.getCurrentPartner().getId());
            args.add(em.getCurrentPartner().getOrganizationid());
            hql.append(" and a.no in('").append(StringUtils.listToString(list, "','")).append("')");
            List obj = this.baseDao.findEntity(hql.toString(), args.toArray(), Object.class);
            HashMap<String, String> mapList = new HashMap<String, String>();
            for (Object object : obj) {
                Object[] product = (Object[])object;
                String partnerId = String.valueOf((String)product[0]) + "@" + (String)product[1];
                String productNo = (String)product[1];
                mapList.put(partnerId, productNo);
            }
            for (String string : list) {
                for (Object object : dts) {
                    Object[] customer = (Object[])object;
                    String partnerName = (String)customer[1];
                    String partnerId = String.valueOf((String)customer[0]) + "@" + string;
                    if (mapList.get(partnerId) != null) continue;
                    listNo.add(String.valueOf(partnerName) + "\uff1a" + string);
                }
            }
        }
        return listNo;
    }

    public String clIds(String ids) {
        if (ids.length() > 0) {
            return ids.substring(0, ids.length() - 1);
        }
        return "";
    }

    public String checkActivityRule03(Activity act) {
        String url = String.valueOf(this.URL) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", this.organization);
        map.put("status", "1");
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        List conList = new ArrayList();
        if (body != null) {
            conList = (List)Jsons.toListBean((String)EsbAnalyUtil.getResults(body, "activityInfo"), Activity.class);
        }
        StringBuilder aids = new StringBuilder();
        StringBuilder errorProduct = new StringBuilder("");
        if (Beans.isNotEmpty(conList)) {
            for (Activity a : conList) {
                aids.append(a.getCode()).append(",");
            }
            aids.deleteCharAt(aids.length() - 1);
            List<Map<String, Object>> items = ActivityPlatformHelper.getActivityItem(aids.toString());
            if (Beans.isNotEmpty(items)) {
                ArrayList<String> notShowInNormalProds = new ArrayList<String>();
                for (Map<String, Object> item : items) {
                    if (!Beans.isEmpty((Object)item.get("showInNormal")) && !"0".equals(item.get("showInNormal").toString())) continue;
                    notShowInNormalProds.add(item.get("rule_productCode").toString());
                }
                List ruleList = (List)Jsons.toBean((String)act.getRuleJson(), List.class);
                for (Map rule : ruleList) {
                    Map ruleInfo = (Map)rule.get("ruleInfo");
                    String droolsRuleCode = rule.get("droolsRuleCode").toString();
                    if (!"RULE003".equals(droolsRuleCode)) continue;
                    List rulePrivilege = (List)ruleInfo.get("rulePrivilege");
                    for (Map rp : rulePrivilege) {
                        if (!Beans.isNotEmpty(rp.get("showInNormal")) || !"1".equals(rp.get("showInNormal").toString()) || !notShowInNormalProds.contains(rp.get("rule_productCode"))) continue;
                        errorProduct.append(rp.get("rule_productCode").toString()).append("\n");
                    }
                }
            }
        }
        return errorProduct.toString();
    }

    public List<String> readPartnersByExcel(String url, List<Partner> partners, Employee me) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(me.getCurrentPartner().getId());
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        List partnerList = this.baseDao.findEntity("from Partner where parentPartnerId = ? and startDt <= ? and nvl(endDt,?) >= ? ", args.toArray(), Partner.class);
        HashMap<String, Partner> partnerMap = new HashMap<String, Partner>();
        for (Partner partner : partnerList) {
            partnerMap.put(partner.getNo(), partner);
        }
        ArrayList<String> errorMsgs = new ArrayList<String>();
        try {
            String[] headers = new String[]{"partnerNo"};
            List datas = Excels.readExcel((String)url, (InputStream)new FileInputStream(url), (String[])headers);
            if (Beans.isEmpty((Object)datas)) {
                errorMsgs.add("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u5bfc\u5165\u7684\u8868\u4e2d\u6ca1\u6709\u6570\u636e\u3002\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01");
                return errorMsgs;
            }
            int j = 1;
            HashMap<String, Integer> partnerNo = new HashMap<String, Integer>();
            for (Map data : datas) {
                ++j;
                if (Beans.isEmpty(data.get("partnerNo"))) {
                    errorMsgs.add("\u7b2c" + j + "\u884c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    continue;
                }
                if (partnerNo.containsKey(data.get("partnerNo"))) {
                    errorMsgs.add("\u7b2c" + j + "\u884c\u7ecf\u9500\u5546\u7f16\u7801\u91cd\u590d\u5b58\u5728\uff01");
                    continue;
                }
                partnerNo.put(data.get("partnerNo").toString(), j);
                Partner p = (Partner)partnerMap.get(String.valueOf(data.get("partnerNo")));
                if (Beans.isEmpty((Object)p)) {
                    errorMsgs.add("\u7b2c" + j + "\u884c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u627e\u4e0d\u5230\u76f8\u5173\u7ecf\u9500\u5546\uff01");
                    continue;
                }
                partners.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorMsgs;
    }
}

