/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.adjustStockNew;

import com.alibaba.fastjson.JSON;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.adjuststock.AdjustStockCondition;
import com.tcbj.crm.adjuststock.AdjustStockRowCondition;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.AdjustStock;
import com.tcbj.crm.entity.AdjustStockDetails;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.stock.UpdateStockItem;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adjustStockNewService")
public class AdjustStockNewService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    StockService stockService;
    @Autowired
    ProductService productService;
    @Autowired
    StorageService storageService;

    public void del(String id) {
        Object[] args = new Object[]{id};
        String hql = "delete AdjustStockDetails where adjustStockId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete AdjustStock where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public void deleteRow(String id) {
        this.baseDao.deleteById(AdjustStockDetails.class, (Serializable)((Object)id));
    }

    public Page findAdjustStocks(AdjustStockCondition con) {
        HashMap<String, String> sendData = new HashMap<String, String>();
        sendData.put("fromRow", con.getPageno().toString());
        sendData.put("maxRows", String.valueOf(Constant.DEFAULT_ROWS));
        sendData.put("organization", ConfigFactory.get().get("prefix"));
        sendData.put("adjustType", "2");
        if (StringUtils.isNotEmpty(con.getAdjustNumber())) {
            sendData.put("inventoryCode", con.getAdjustNumber());
        }
        Map<String, Object> result = EasRequestHelper.getInstance().sendBodyToESB(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/queryInventoryBase", sendData);
        Map returnObject = (Map)result.get("returnObject");
        List list = (List)returnObject.get("resultQuery");
        ArrayList<AdjustStock> checkVouchList = new ArrayList<AdjustStock>();
        for (Map map : list) {
            AdjustStock adjustStock = new AdjustStock();
            adjustStock.setRemark((String)map.get("comment"));
            if (Beans.isNotEmpty(map.get("createDate"))) {
                adjustStock.setCreateDt(DateUtils.autoFormatDate((String)((String)map.get("createDate")), null));
            }
            adjustStock.setId(String.valueOf(map.get("id")));
            adjustStock.setAdjustNumber((String)map.get("inventoryCode"));
            checkVouchList.add(adjustStock);
        }
        int count = Integer.valueOf(returnObject.get("count").toString());
        Page page = new Page(checkVouchList, con.getPageno().intValue(), Constant.DEFAULT_ROWS, count);
        return page;
    }

    public Page getPageAdjustStockDetailss(AdjustStockRowCondition condition) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from AdjustStockDetails a where a.adjustStockId= ? ";
        args.add(condition.getId());
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql = String.valueOf(hql) + " and a.shopId = ? ";
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            hql = String.valueOf(hql) + " and a.productId = ? ";
            args.add(condition.getProductId());
        }
        return this.baseDao.search(hql, args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue());
    }

    public void update(AdjustStock adjustStock, Employee me) {
        if (StringUtils.isNotEmpty(adjustStock.getDelIds())) {
            String[] stringArray = adjustStock.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.deleteRow(id);
                ++n2;
            }
        }
        adjustStock.fillInitData(me);
        adjustStock.setPartnerId(me.getCurrentPartner().getId());
        adjustStock.setState("0");
        this.baseDao.update((Object)adjustStock);
        List<AdjustStockDetails> list = adjustStock.getAdjustStockDetailss();
        for (AdjustStockDetails adjustStockDetails : list) {
            adjustStockDetails.setAdjustStockId(adjustStock.getId());
            adjustStockDetails.fillInitData(me);
            if (StringUtils.isNotEmpty(adjustStockDetails.getId())) {
                this.baseDao.update((Object)adjustStockDetails);
                continue;
            }
            this.baseDao.save((Object)adjustStockDetails);
        }
    }

    public List<AdjustStockDetails> getAdjustStockDetailss(String id) {
        String hql = "from AdjustStockDetails where adjustStockId = ?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, AdjustStockDetails.class);
    }

    public AdjustStock getAdjustStock(String adjustNumber) {
        AdjustStockCondition con = new AdjustStockCondition();
        con.setAdjustNumber(adjustNumber);
        List adjustStocks = this.findAdjustStocks(con).getList();
        if (adjustStocks.size() == 0) {
            throw new AppException("0010", "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u76d8\u70b9\u5355!");
        }
        AdjustStock adjustStock = (AdjustStock)adjustStocks.get(0);
        HashMap<String, String> sendData = new HashMap<String, String>();
        sendData.put("organization", ConfigFactory.get().get("prefix"));
        sendData.put("inventoryCode", adjustNumber);
        sendData.put("fromRow", con.getPageno().toString());
        sendData.put("maxRows", String.valueOf(Integer.MAX_VALUE));
        Map result = (Map)EasRequestHelper.getInstance().sendBodyToESBResult(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/queryInventorySaleOffsetDetail", sendData);
        List items = (List)result.get("resultQuery");
        ArrayList<AdjustStockDetails> checkVouchItems = new ArrayList<AdjustStockDetails>();
        for (Map map : items) {
            AdjustStockDetails item = new AdjustStockDetails();
            Product product = Cache.getProduct((String)map.get("productId"));
            if (Beans.isNotEmpty((Object)product)) {
                item.setProductId(product.getId());
            }
            item.setStorageId((String)map.get("warehouseId"));
            item.setStockType(((String)map.get("stockType")).equals("tzd_add") ? "5" : "9");
            item.setAdjustQuantity(Double.parseDouble((String)map.get("quantity")));
            checkVouchItems.add(item);
        }
        adjustStock.setAdjustStockDetailss(checkVouchItems);
        return adjustStock;
    }

    public void save(AdjustStock adjustStock, Employee me) {
        this.baseDao.save((Object)adjustStock);
        for (AdjustStockDetails adjustStockDetails : adjustStock.getAdjustStockDetailss()) {
            adjustStockDetails.fillInitData(me);
            adjustStockDetails.setAdjustStockId(adjustStock.getId());
        }
        this.baseDao.save(adjustStock.getAdjustStockDetailss());
    }

    public void updateState(String id, String state) {
        String hql = "update AdjustStock set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }

    public void saveOrStock(AdjustStock adjustStock, Employee me, String save) {
        this.save(adjustStock, me);
        if ("save".equals(save)) {
            this.updateQuantity(adjustStock, me);
            this.updateState(adjustStock.getId(), "1");
        }
    }

    public void updateStock(Employee me, AdjustStock adjustStock) {
        List<AdjustStockDetails> list = this.getAdjustStockDetailss(adjustStock.getId());
        adjustStock.setAdjustStockDetailss(list);
        this.updateQuantity(adjustStock, me);
        this.updateState(adjustStock.getId(), "1");
    }

    private void updateQuantity(AdjustStock adjustStock, Employee me) {
        List<AdjustStockDetails> list = adjustStock.getAdjustStockDetailss();
        for (AdjustStockDetails adjustStockDetails : list) {
            ArrayList<UpdateStockItem> slist = new ArrayList<UpdateStockItem>();
            UpdateStockItem item = new UpdateStockItem(adjustStockDetails.getId(), adjustStockDetails.getProductId(), 0.0 - adjustStockDetails.getAdjustQuantity());
            item.setSupplierId(me.getCurrentPartner().getId());
            item.setApplyerId(me.getCurrentPartner().getId());
            slist.add(item);
            this.stockService.updateQuantity(me, adjustStockDetails.getShopId(), adjustStockDetails.getStorageId(), adjustStock.getAdjustNumber(), "\u95e8\u5e97\u9500\u552e\u51b2\u51cf", slist);
        }
    }

    public void saveAndUpdateStock(AdjustStock adjustStock, String userId) {
        this.baseDao.save((Object)adjustStock);
        List<AdjustStockDetails> list = adjustStock.getAdjustStockDetailss();
        int i = 0;
        while (i < list.size()) {
            list.get(i).setAdjustStockId(adjustStock.getId());
            this.baseDao.save((Object)list.get(i));
            ++i;
        }
        for (AdjustStockDetails adjustStockDetails : list) {
            this.stockService.updateQuantity(userId, adjustStock.getAdjustNumber(), adjustStock.getAdjustName(), adjustStockDetails);
        }
    }

    private Map<String, ShopView> getShopMap(String parentId) {
        HashMap<String, ShopView> map = new HashMap<String, ShopView>();
        StringBuffer hql = new StringBuffer("from ShopView where parentDealerId=?");
        List list = this.baseDao.findEntity(hql.toString(), new Object[]{parentId}, ShopView.class);
        for (ShopView shop : list) {
            map.put(shop.getShopNumber(), shop);
        }
        return map;
    }

    private Map<String, Customer> getCustomerMap(String parentId) {
        HashMap<String, Customer> map = new HashMap<String, Customer>();
        StringBuffer sb = new StringBuffer("from Customer where supplierId = ? ");
        List list = this.baseDao.findEntity(sb.toString(), new Object[]{parentId}, Customer.class);
        for (Customer customer : list) {
            map.put(customer.getApplyerCode(), customer);
        }
        return map;
    }

    private Map<String, Storage> getStorageMap() {
        HashMap<String, Storage> storageMap = new HashMap<String, Storage>();
        StringBuffer hql = new StringBuffer("from Storage s");
        List list = this.baseDao.findEntity(hql.toString(), Storage.class);
        for (Storage storage : list) {
            storageMap.put(String.valueOf(storage.getSupplierNo()) + "_" + storage.getStorageCode(), storage);
        }
        return storageMap;
    }

    private Map<String, Product> getProductMap(String partnerId) {
        StringBuffer hql = new StringBuffer("from Product a ,PartnerProductREL c where a.id=c.productId and c.supplierId=? ");
        HashMap<String, Product> map = new HashMap<String, Product>();
        List list = this.baseDao.findEntity(hql.toString(), new Object[]{partnerId}, Object[].class);
        for (Object[] objs : list) {
            Product product = (Product)objs[0];
            PartnerProductREL pprel = (PartnerProductREL)objs[1];
            map.put(String.valueOf(pprel.getPartnerNo()) + "_" + product.getNo(), product);
        }
        return map;
    }

    public List<AdjustStockUtil> validate(List<List<Object>> readExcelList, Employee emp, List<AdjustStockDetails> list) {
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        Map<String, ShopView> shopMap = this.getShopMap(emp.getCurrentPartner().getId());
        Map<String, Customer> customerMap = this.getCustomerMap(emp.getCurrentPartner().getId());
        Map<String, Storage> storageMap = this.getStorageMap();
        Map<String, Product> productMap = this.getProductMap(emp.getCurrentPartner().getId());
        int j = 0;
        while (j < readExcelList.size()) {
            List<Object> data = readExcelList.get(j);
            String result = null;
            String message = null;
            AdjustStockDetails adjustStockDetails = new AdjustStockDetails();
            int i = 0;
            while (i < data.size()) {
                switch (i) {
                    case 0: {
                        message = this.validateShop(data.get(i), shopMap, customerMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97/\u5ba2\u6237\u7f16\u53f7 \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setShopId(customerMap.get(data.get(i).toString()).getApplyerId());
                        break;
                    }
                    case 1: {
                        message = this.validateStore(data.get(i), (String)data.get(0), storageMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ed3\u5e93\u7f16\u53f7 \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setStorageId(storageMap.get(String.valueOf((String)data.get(0)) + "_" + (String)data.get(i)).getId());
                        break;
                    }
                    case 2: {
                        message = this.validateProduct(data.get(i), (String)data.get(0), productMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ea7\u54c1\u7f16\u7801 \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setProductId(productMap.get(String.valueOf((String)data.get(0)) + "_" + (String)data.get(i)).getId());
                        break;
                    }
                    case 3: {
                        adjustStockDetails.setProductBatch((String)data.get(i));
                        break;
                    }
                    case 4: {
                        message = ValidataUtils.validataDoubleOrNull((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ef7\u683c \uff1a" + message;
                            break;
                        }
                        if (data.get(i) == null || "".equals(String.valueOf(data.get(i)).trim())) {
                            adjustStockDetails.setPrice(0.0);
                            break;
                        }
                        adjustStockDetails.setPrice(Double.parseDouble(String.valueOf(data.get(i)).trim()));
                        break;
                    }
                    case 5: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u6570\u91cf \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setAdjustQuantity(Double.valueOf(String.valueOf(data.get(i)).trim()));
                        break;
                    }
                }
                ++i;
            }
            if (result != null) {
                msglist.add(new AdjustStockUtil("\u7b2c" + (j + 2) + "\u884c:" + result));
            }
            list.add(adjustStockDetails);
            ++j;
        }
        return msglist;
    }

    private String validateProduct(Object object, String id, Map<String, Product> productMap) {
        if (object == null || "".equals(String.valueOf(object).trim())) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String code = (String)object;
        if (productMap.get(String.valueOf(id) + "_" + code) == null) {
            return "\u975e\u6cd5\u7684\u6570\u636e" + code;
        }
        return null;
    }

    private String validateStore(Object object, String id, Map<String, Storage> storageMap) {
        if (object == null || "".equals(String.valueOf(object).trim())) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String code = (String)object;
        if (storageMap.get(String.valueOf(id) + "_" + code) == null) {
            return "\u975e\u6cd5\u7684\u6570\u636e" + code;
        }
        return null;
    }

    private String validateShop(Object object, Map<String, ShopView> shopMap, Map<String, Customer> customerMap) {
        if (object == null || "".equals(String.valueOf(object).trim())) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String code = (String)object;
        if (shopMap.get(code) == null && customerMap.get(code) == null) {
            return "\u975e\u6cd5\u7684\u6570\u636e" + code;
        }
        return null;
    }

    public boolean validateFileName(String partnerId, String fileName) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from AdjustStock where adjustType = 'STORE_ADJUST' and partnerId =? and fileName =? ");
        AdjustStock adjustStock = (AdjustStock)this.baseDao.findFirstEntity(hql.toString(), new Object[]{partnerId, fileName}, AdjustStock.class);
        return StringUtils.isNotNull(adjustStock);
    }

    public void saveAdjustStock(AdjustStock adjustStock, Employee me) {
        HashMap<String, String> sendData = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2017, 7, 1);
        String currentDateStr = DateUtils.formartDate((Date)calendar.getTime(), (String)"yyyy-MM-dd hh:mm:ss");
        String orgId = ConfigFactory.get().get("prefix");
        sendData.put("organization", orgId);
        sendData.put("inventoryTime", currentDateStr);
        HashMap<String, Cloneable> jsonStr = new HashMap<String, Cloneable>();
        HashMap<String, String> headData = new HashMap<String, String>();
        jsonStr.put("headData", headData);
        headData.put("comment", adjustStock.getRemark());
        headData.put("inventoryCode", adjustStock.getAdjustNumber());
        headData.put("adjustType", "2");
        ArrayList itemList = new ArrayList();
        jsonStr.put("listData", itemList);
        for (AdjustStockDetails item : adjustStock.getAdjustStockDetailss()) {
            Product product = Cache.getProduct(item.getProductId());
            Cache.getPartner(me.getCurrentPartner().getId());
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("partnerCode", ConfigFactory.get().get("auto_partnerShortCode"));
            itemMap.put("partnerOtherNum", ConfigFactory.get().get("auto_partnerLongCode"));
            itemMap.put("stockType", "5".equals(item.getStockType()) ? "tzd_add" : "tzd_sub");
            itemMap.put("warehouseId", item.getStorageId());
            itemMap.put("organization", orgId);
            itemMap.put("orgId", orgId);
            itemMap.put("brandId", product.getBrand());
            itemMap.put("productId", item.getProductId());
            itemMap.put("productCode", product.getNo());
            itemMap.put("productOtherNum", product.getEasNo());
            itemMap.put("quantity", new BigDecimal(item.getAdjustQuantity()).toPlainString());
            itemMap.put("createMan", me.getId());
            itemMap.put("lastUpdateMan", me.getId());
            itemList.add(itemMap);
        }
        sendData.put("jsonStr", JSON.toJSONString(jsonStr));
        EasRequestHelper.getInstance().sendBodyToESB(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/saleOffset", sendData);
    }

    public List<Map> readSheetByExcel(String filePath, List<AdjustStockUtil> megs, Employee me) throws FileNotFoundException {
        String[] headers = new String[]{"productName", "productNo", "storageName", "storageCode", "stockTypeName", "adjustQuantity"};
        List excelDatas = Excels.readExcel((String)filePath, (InputStream)new FileInputStream(filePath), (String[])headers);
        HashMap<String, String> productMap = new HashMap<String, String>();
        HashMap<String, Product> productMap_ = new HashMap<String, Product>();
        ProductCondition con = new ProductCondition();
        con.setEm(me);
        List<Product> products = this.productService.getProducts(con);
        for (Product product : products) {
            productMap.put(product.getNo(), product.getName());
            productMap_.put(product.getNo(), product);
        }
        HashMap<String, String> storageMap = new HashMap<String, String>();
        HashMap<String, Storage> _storageMap = new HashMap<String, Storage>();
        List<Storage> storages = this.storageService.getList(me.getCurrentPartner().getId());
        for (Storage storage : storages) {
            storageMap.put(storage.getStorageCode(), storage.getStorageName());
            _storageMap.put(storage.getStorageCode(), storage);
        }
        HashMap<String, String> stockTypeMap = new HashMap<String, String>();
        stockTypeMap.put("\u5165\u5e93", "5");
        stockTypeMap.put("\u51fa\u5e93", "9");
        String message = null;
        int j = 2;
        for (Map data : excelDatas) {
            message = ValidataUtils.validataString(data.get("productNo"));
            if (message != null) {
                megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u4ea7\u54c1\u7f16\u53f7 \uff1a" + message + ";"));
            } else {
                message = ValidataUtils.validataMap(data.get("productNo"), productMap);
                if (message != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u4ea7\u54c1\u7f16\u53f7 \uff1a" + message + ";"));
                } else {
                    data.put("productId", ((Product)productMap_.get(data.get("productNo"))).getId());
                    data.put("productName", productMap.get(data.get("productNo")));
                }
            }
            message = ValidataUtils.validataString(data.get("storageCode"));
            if (message != null) {
                megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u4ed3\u5e93\u4ee3\u7801 \uff1a" + message + ";"));
            } else {
                message = ValidataUtils.validataMap(data.get("storageCode"), storageMap);
                if (message != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u4ed3\u5e93\u4ee3\u7801 \uff1a" + message + ";"));
                } else {
                    data.put("storageName", storageMap.get(data.get("storageCode")));
                    data.put("storageId", ((Storage)_storageMap.get(data.get("storageCode"))).getId());
                }
            }
            message = ValidataUtils.validataString(data.get("stockTypeName"));
            if (message != null) {
                megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u64cd\u4f5c\u7c7b\u578b \uff1a" + message + ";"));
            } else {
                message = ValidataUtils.validataMap(data.get("stockTypeName"), stockTypeMap);
                if (message != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u64cd\u4f5c\u7c7b\u578b \uff1a" + message + ";"));
                } else {
                    data.put("stockType", stockTypeMap.get(data.get("stockTypeName")));
                }
            }
            message = ValidataUtils.validataDouble(data.get("adjustQuantity"));
            if (message != null) {
                megs.add(new AdjustStockUtil("\u7b2c" + j + "\u884c \u8c03\u6574\u6570\u91cf \uff1a" + message + ";"));
            }
            ++j;
        }
        return excelDatas;
    }
}

