/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.adjuststock;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockCondition;
import com.tcbj.crm.adjuststock.AdjustStockRowCondition;
import com.tcbj.crm.adjuststock.AdjustStockService;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.AdjustStock;
import com.tcbj.crm.entity.AdjustStockDetails;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/adjuststock"})
public class AdjustStockController
extends BaseController {
    @Autowired
    AdjustStockService service;
    @Autowired
    StockService stockService;
    @Autowired
    OrderNoService orderNoService;

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(Model model) {
        Employee em = this.getCurrentEmployee();
        AdjustStock adjustStock = new AdjustStock();
        adjustStock.setAdjustNumber(this.orderNoService.maxNo(em.getCurrentPartner().getNo(), "07"));
        model.addAttribute("adjustStock", (Object)adjustStock);
        return "adjuststock/apply.ftl";
    }

    @RequestMapping(value={"/batch.do"}, method={RequestMethod.GET})
    public String batch(Model model) {
        Employee em = this.getCurrentEmployee();
        AdjustStock adjustStock = new AdjustStock();
        adjustStock.setAdjustNumber(this.orderNoService.maxNo(em.getCurrentPartner().getNo(), "07"));
        model.addAttribute("adjustStock", (Object)adjustStock);
        return "adjuststock/batch.ftl";
    }

    @RequestMapping(value={"/batch.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result batchPost(@Valid @RequestBody AdjustStock adjustStock, String save, Model model) {
        Employee me = this.getCurrentEmployee();
        adjustStock.fillInitData(me);
        adjustStock.setPartnerId(me.getCurrentPartner().getId());
        adjustStock.setState("0");
        this.service.saveOrStock(adjustStock, me, save);
        return this.getSuccessResult(adjustStock.getId());
    }

    private List<AdjustStockUtil> getFileReadyExcel(List<AdjustStockDetails> list, String url) {
        Employee emp = this.getCurrentEmployee();
        LinkedList<List<Object>> readExcelList = new LinkedList();
        readExcelList = ExcelHandle.readExcel(url);
        List<AdjustStockUtil> msglist = this.service.validate(readExcelList, emp, list);
        return msglist;
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    public String applyDo(@ModelAttribute(value="adjustStock") AdjustStock adjustStock, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "adjuststock");
        String filePath = "";
        String fileName = "";
        String url = "";
        String rtn = null;
        if (filelist.size() > 0) {
            boolean isFileName = this.service.validateFileName(me.getCurrentPartner().getId(), filelist.get(0).getName());
            if (isFileName) {
                rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u5df2\u7ecf\u4e0a\u4f20\u8fc7\u6216\u8005\u6587\u4ef6\u540d\u91cd\u590d\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6587\u4ef6"));
                model.addAttribute("rtn", (Object)rtn);
                return "common/iframeRtn.ftl";
            }
            filePath = filelist.get(0).getWebPath();
            fileName = filelist.get(0).getName();
            url = filelist.get(0).getRealPath();
        }
        adjustStock.fillInitData(me);
        ArrayList<AdjustStockDetails> list = new ArrayList<AdjustStockDetails>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcel(list, url);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        adjustStock.setAdjustStockDetailss(list);
        adjustStock.setPartnerId(me.getCurrentPartner().getId());
        adjustStock.setState("0");
        adjustStock.setFilePath(filePath);
        adjustStock.setFileName(fileName);
        this.service.save(adjustStock, me);
        String id = adjustStock.getId();
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:" + id));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/applys.do"})
    public String applys(@ModelAttribute(value="condition") AdjustStockCondition condition, Model model) {
        if (StringUtils.isNotEmpty(condition.getState())) {
            condition.getStates().add(condition.getState());
        }
        condition = (AdjustStockCondition)this.wrapCondition(condition, "AdjustStock");
        Employee me = this.getCurrentEmployee();
        condition.setPartnerId(me.getCurrentPartner().getId());
        Page page = this.service.findAdjustStocks(condition);
        model.addAttribute("me", (Object)me);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        return "adjuststock/applys.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    public Result edit(@Valid @RequestBody AdjustStock adjustStock, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        this.service.update(adjustStock, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String auditGet(String id, HttpServletRequest request, Model model) {
        AdjustStock adjustStock = this.service.getAdjustStock(id);
        model.addAttribute("adjustStock", (Object)adjustStock);
        return "adjuststock/audit.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    public Result auditDo(@Valid @RequestBody AdjustStock adjustStock, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        this.service.updateStock(me, adjustStock);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        this.service.del(id);
        return "redirect:applys.do?conscope=session";
    }

    private AdjustStock loadAdjustStock(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        AdjustStock adjustStock = null;
        if (StringUtils.isEmpty(id)) {
            adjustStock = new AdjustStock();
            adjustStock.fillInitData(me);
        } else {
            adjustStock = this.service.getAdjustStock(id);
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("adjustStock", (Object)adjustStock);
        return adjustStock;
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadAdjustStock(id, model);
        return "adjuststock/view.ftl";
    }

    @RequestMapping(value={"/getAdjustStockDetails.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getAdjustStockDetails(AdjustStockRowCondition condition, Model model) {
        return this.service.getPageAdjustStockDetailss(condition);
    }

    private void validateFileName(String partnerId, String fileName) {
        boolean isFileName = this.service.validateFileName(partnerId, fileName);
        if (isFileName) {
            throw new AppException("0010", "\u8be5\u6587\u4ef6\u5df2\u7ecf\u4e0a\u4f20\u8fc7\u6216\u8005\u6587\u4ef6\u540d\u91cd\u590d\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6587\u4ef6");
        }
    }
}

