/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.allot;

import com.alibaba.fastjson.JSON;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.allot.QyAllotCondition;
import com.tcbj.crm.allot.QyAllotRowCondition;
import com.tcbj.crm.allot.QyAllotService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.entity.QyAllot;
import com.tcbj.crm.entity.QyAllotRecord;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/allot"})
public class QyAllotController
extends BaseController {
    @Autowired
    QyAllotService service;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ClientService clientService;
    @Autowired
    RegionService regionService;
    @Autowired
    ProductService productService;
    @Autowired
    Cache cache;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) {
        QyAllot allot = new QyAllot();
        model.addAttribute("master", (Object)allot);
        return "allot/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String addPost(@ModelAttribute(value="cxqyallot") QyAllot cxqyallot, @RequestParam(value="mediaFile", required=false) MultipartFile file, BindingResult errors, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Employee e = this.getCurrentEmployee();
        String rtn = null;
        boolean isName = this.service.validateName(cxqyallot.getAllotName(), null, e.getCurrentPartner().getId());
        if (isName) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u5b9a\u91cf\u914d\u8d27\u540d\u79f0 (" + cxqyallot.getAllotName() + ") \u5728\u672c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6362\u5176\u4ed6\u540d\u79f0"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        ArrayList<QyAllotRow> list = new ArrayList<QyAllotRow>();
        List<AdjustStockUtil> msglist = this.getFileReadExcel(list, request, cxqyallot.getAllotType());
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        cxqyallot.setSupplierId(e.getCurrentPartner().getId());
        cxqyallot.fillInitData(e);
        cxqyallot.setCxQyAllotRowList(list);
        try {
            this.validateOnly(cxqyallot, e.getCurrentPartner().getId());
        }
        catch (AppException e1) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(e1.getArgs()[0].toString()));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        List<QyAllotCondition> listCondition = this.service.save(cxqyallot, e);
        if (listCondition.size() > 0) {
            for (QyAllotCondition qyc : listCondition) {
                String type = "";
                String dataName = "";
                if (StringUtils.isNotEmpty(qyc.getApplyerId())) {
                    type = "\u7ecf\u9500\u5546";
                    dataName = qyc.getApplyerName();
                } else if (StringUtils.isNotEmpty(qyc.getAreaId())) {
                    type = "\u533a\u57df";
                    dataName = qyc.getAreaName();
                } else if (StringUtils.isNotEmpty(qyc.getBigAreaId())) {
                    type = "\u5927\u533a";
                    dataName = qyc.getBigAreaName();
                }
                msglist.add(new AdjustStockUtil("\u4ea7\u54c1\u7f16\u53f7(" + qyc.getProductNo() + ")\u4e0e\u5b9a\u91cf\u914d\u8d27(" + qyc.getAllotName() + ") \u4e2d" + type + "(" + dataName + ")\u5b58\u5728\u51b2\u7a81"));
            }
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
        } else {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        }
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.GET})
    public String savePet(Model model, HttpServletRequest request) {
        QyAllot allot = new QyAllot();
        model.addAttribute("master", (Object)allot);
        return "allot/save.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result savePost(@Valid @RequestBody QyAllot cxqyallot, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        this.validateName(cxqyallot.getAllotName(), null, me.getCurrentPartner().getId());
        this.validateFormOnly(cxqyallot);
        this.validateOnly(cxqyallot, me.getCurrentPartner().getId());
        List<QyAllotCondition> listCondition = this.service.save(cxqyallot, me);
        if (listCondition.size() > 0) {
            return this.getSuccessResult(listCondition);
        }
        this.saveOrUpdateRecord(cxqyallot, null);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/excelRtn.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excelRtn(String rtns, String type, HttpServletResponse response) throws Exception {
        List<String> listinfo;
        String[] pop;
        String[] titles;
        HashMap<String, String> map;
        ArrayList listMap = new ArrayList();
        List<String> list = StringUtils.stringToList(rtns, ",");
        if ("applyer".equals(type)) {
            for (String string : list) {
                map = new HashMap<String, String>();
                map.put("no", string);
                listMap.add(map);
            }
            titles = new String[]{"\u5b9a\u91cf\u914d\u8d27"};
            pop = new String[]{"no"};
            ExcelUtils.exportExcelNew("\u66f4\u591a\u62a5\u9519\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6ca1\u6709\u5206\u914d\u4ea7\u54c1\u7684\u7ecf\u9500\u5546", ".xlsx", titles, listMap, pop, response);
        }
        if ("area".equals(type)) {
            for (String string : list) {
                map = new HashMap();
                listinfo = StringUtils.stringToList(string, "\uff1a");
                map.put("p", listinfo.get(0));
                map.put("no", listinfo.get(1));
                listMap.add(map);
            }
            titles = new String[]{"\u7ecf\u9500\u5546", "\u4ea7\u54c1\u7f16\u53f7"};
            pop = new String[]{"p", "no"};
            ExcelUtils.exportExcelNew("\u66f4\u591a\u62a5\u9519\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6ca1\u6709\u5206\u914d\u4ea7\u54c1\u7684\u7ecf\u9500\u5546", ".xlsx", titles, listMap, pop, response);
        }
        if ("bigArea".equals(type)) {
            for (String string : list) {
                map = new HashMap();
                listinfo = StringUtils.stringToList(string, "\uff1a");
                map.put("p", listinfo.get(0));
                map.put("no", listinfo.get(1));
                listMap.add(map);
            }
            titles = new String[]{"\u7ecf\u9500\u5546", "\u4ea7\u54c1\u7f16\u53f7"};
            pop = new String[]{"p", "no"};
            ExcelUtils.exportExcelNew("\u66f4\u591a\u62a5\u9519\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6ca1\u6709\u5206\u914d\u4ea7\u54c1\u7684\u7ecf\u9500\u5546", ".xlsx", titles, listMap, pop, response);
        }
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, HttpServletRequest request, QyAllotCondition condition) {
        Employee e = this.getCurrentEmployee();
        condition.setSupplierId(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        model.addAttribute("page", (Object)this.service.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "allot/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        QyAllot cxqyallot = this.service.get(id);
        model.addAttribute("master", (Object)cxqyallot);
        model.addAttribute("id", (Object)id);
        return "allot/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody QyAllot cxqyallot) throws Exception {
        Employee me = this.getCurrentEmployee();
        QyAllot beforeCxqyallot = this.service.get(cxqyallot.getId());
        if (StringUtils.isNotEmpty(cxqyallot.getDelIds())) {
            String[] stringArray = cxqyallot.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.deleteRow(id);
                ++n2;
            }
        }
        this.validateName(cxqyallot.getAllotName(), cxqyallot.getId(), me.getCurrentPartner().getId());
        this.validateFormOnly(cxqyallot);
        this.validateOnly(cxqyallot, me.getCurrentPartner().getId());
        this.validate(this.getCompleteQyAllotRow(cxqyallot, cxqyallot.getCxQyAllotRowList()));
        List<QyAllotCondition> listCondition = this.service.update(cxqyallot, me);
        if (listCondition.size() > 0) {
            return this.getSuccessResult(listCondition);
        }
        this.saveOrUpdateRecord(cxqyallot, beforeCxqyallot);
        if (beforeCxqyallot.getEndDate() != null && DateUtils.compareNew((Date)beforeCxqyallot.getEndDate(), (Date)DateUtils.now()) && (cxqyallot.getEndDate() == null || DateUtils.compareNew((Date)DateUtils.now(), (Date)beforeCxqyallot.getEndDate()))) {
            this.saveOrUpdateRecord(me, cxqyallot.getId(), null, QyAllotRecord.UPDATE_TYPE_START, null);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id) {
        this.service.delete(id);
        this.saveOrUpdateRecord(this.getCurrentEmployee(), id, null, QyAllotRecord.UPDATE_TYPE_OBSOLETE, null);
        return "redirect:/allot/list.do";
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        QyAllot cxqyallot = this.service.get(id);
        model.addAttribute("master", (Object)cxqyallot);
        model.addAttribute("JSONString", (Object)JSON.toJSONString(cxqyallot.getCxQyAllotRowList()));
        return "allot/look.ftl";
    }

    private List<AdjustStockUtil> getFileReadExcel(List<QyAllotRow> list, HttpServletRequest request, String allotType) {
        List<IUploadFile> filelist = this.uploadFile(request, "allot");
        List<List<Object>> readExcelList = new LinkedList<List<Object>>();
        String fileUrl = "";
        if (filelist.size() > 0) {
            fileUrl = filelist.get(0).getRealPath();
            readExcelList = ExcelHandle.readExcel(fileUrl);
        }
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        this.validateExcel(readExcelList, list, msglist, allotType);
        return msglist;
    }

    public void validateEmpty(List<List<Object>> readExcelList, List<AdjustStockUtil> msglist) {
        int j = 1;
        for (List<Object> objectslist : readExcelList) {
            String message = "\u5728\u7b2c" + ++j + "\u884c\uff0c";
            boolean is = false;
            if ("".equals(objectslist.get(0).toString()) || objectslist.get(0).toString() == null) {
                message = String.valueOf(message) + "\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if ("".equals(objectslist.get(1).toString()) || objectslist.get(1).toString() == null) {
                message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if ("".equals(objectslist.get(2).toString()) || objectslist.get(2).toString() == null) {
                message = String.valueOf(message) + "\u9650\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else if (!StringUtils.match(objectslist.get(2).toString())) {
                message = String.valueOf(message) + "\u9650\u8d2d\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57;";
                is = true;
            }
            if (!is) continue;
            AdjustStockUtil asu = new AdjustStockUtil();
            asu.setMessage(message);
            msglist.add(asu);
        }
    }

    public void validateExcel(List<List<Object>> readExcelList, List<QyAllotRow> list, List<AdjustStockUtil> msglist, String allotType) {
        Employee em = this.getCurrentEmployee();
        this.validateEmpty(readExcelList, msglist);
        if (msglist.size() > 0) {
            return;
        }
        int j = 2;
        String message = "";
        for (List<Object> objectslist : readExcelList) {
            Region region;
            Product product;
            message = "\u5728\u7b2c" + j++ + "\u884c\uff0c";
            QyAllotRow adju = new QyAllotRow();
            boolean is = false;
            if ("applyer".equals(allotType)) {
                Customer customer = this.clientService.getCodeAndSupplier(objectslist.get(0).toString(), em.getCurrentPartner().getId());
                if (customer == null) {
                    message = String.valueOf(message) + "\u7ecf\u9500\u5546\u7f16\u53f7 [" + objectslist.get(0).toString() + "] \u4e0d\u5c5e\u4e8e [" + em.getCurrentPartner().getOrganization() + "] \u7ec4\u7ec7;";
                    is = true;
                } else {
                    adju.setApplyerId(customer.getApplyerId());
                    product = this.productService.getCodeAndProduct(objectslist.get(1).toString(), customer.getApplyerId());
                    if (product != null) {
                        adju.setProductId(product.getId());
                        adju.setUnits(product.getUnitName());
                        adju.setNorms(product.getSpec());
                    } else {
                        message = String.valueOf(message) + "\u5bfc\u5165\u7c7b\u578b\u4e0d\u5339\u914d,\u6216\u8005\u4ea7\u54c1\u7f16\u53f7 [" + objectslist.get(1).toString() + "] \u672a\u5206\u914d\u7ed9\u7f16\u53f7\u4e3a [" + objectslist.get(0).toString() + "] \u7684\u7ecf\u9500\u5546;";
                        is = true;
                    }
                }
            }
            if ("area".equals(allotType)) {
                region = this.regionService.getAreaByName(objectslist.get(0).toString(), em.getCurrentPartner().getId());
                if (Beans.isEmpty((Object)region) || region.getParentId().equals(region.getChannelCode())) {
                    message = String.valueOf(message) + "\u533a\u57df [" + objectslist.get(0).toString() + "] \u4e0d\u5b58\u5728,\u6216\u8005\u5bfc\u5165\u7c7b\u578b\u4e0d\u5339\u914d;";
                    is = true;
                } else {
                    adju.setChannelId(region.getChannelCode());
                    adju.setBigAreaId(region.getParentId());
                    adju.setAreaId(region.getId());
                }
                product = Cache.getProductByNo(objectslist.get(1).toString());
                if (product != null) {
                    adju.setProductId(product.getId());
                    adju.setUnits(product.getUnitName());
                    adju.setNorms(product.getSpec());
                } else {
                    message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7 [" + objectslist.get(1).toString() + "] \u4e0d\u5b58\u5728;";
                    is = true;
                }
            }
            if ("bigArea".equals(allotType)) {
                region = this.regionService.getAreaByName(objectslist.get(0).toString(), em.getCurrentPartner().getId());
                if (Beans.isEmpty((Object)region) || !region.getParentId().equals(region.getChannelCode())) {
                    message = String.valueOf(message) + "\u5927\u533a [" + objectslist.get(0).toString() + "] \u4e0d\u5b58\u5728,\u6216\u8005\u5bfc\u5165\u7c7b\u578b\u4e0d\u5339\u914d;";
                    is = true;
                } else {
                    adju.setChannelId(region.getChannelCode());
                    adju.setBigAreaId(region.getId());
                }
                product = Cache.getProductByNo(objectslist.get(1).toString());
                if (product != null) {
                    adju.setProductId(product.getId());
                    adju.setUnits(product.getUnitName());
                    adju.setNorms(product.getSpec());
                } else {
                    message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7 [" + objectslist.get(1).toString() + "] \u4e0d\u5b58\u5728;";
                    is = true;
                }
            }
            if ("".equals(objectslist.get(2).toString())) {
                adju.setQuotaNumber(0.0);
            } else {
                adju.setQuotaNumber(Double.valueOf(objectslist.get(2).toString()));
            }
            if (is) {
                AdjustStockUtil asu = new AdjustStockUtil();
                asu.setMessage(message);
                msglist.add(asu);
            }
            list.add(adju);
        }
        if (msglist.size() > 0) {
            return;
        }
        Map<String, QyAllot> map = this.service.getQyAllotRows(em.getCurrentPartner().getId());
        for (List<Object> qyAllotRow : readExcelList) {
            if (map.get(String.valueOf(qyAllotRow.get(0).toString()) + "_" + qyAllotRow.get(1).toString()) == null) continue;
            message = String.valueOf(qyAllotRow.get(0).toString()) + "\u7684" + qyAllotRow.get(1).toString() + "\u4ea7\u54c1\u5728\u672c\u7ec4\u7ec7\u6709\u91cd\u590d\u6570\u636e\uff01";
            AdjustStockUtil asu = new AdjustStockUtil();
            asu.setMessage(message);
            msglist.add(asu);
        }
        if (msglist.size() > 0) {
            return;
        }
        List<Object[]> products = this.productService.getPartnerProducts(em.getCurrentPartner().getId());
        HashMap<String, Double> productsMap = new HashMap<String, Double>();
        for (Object[] objects : products) {
            if (StringUtils.isNotNull(em.getCurrentPartner().getParPartnerId())) {
                productsMap.put(((Product)objects[0]).getId(), ((PartnerProduct)objects[1]).getDivideQuantity());
                continue;
            }
            productsMap.put(((Product)objects[0]).getId(), ((Product)objects[0]).getMinUnit());
        }
        j = 1;
        for (QyAllotRow allotRow : list) {
            ++j;
            allotRow.setMinUnit((Double)productsMap.get(allotRow.getProductId()));
        }
        if (msglist.size() > 0) {
            return;
        }
    }

    public void validateOnly(QyAllot qyAllot, String partnerId) {
        Date endDate = qyAllot.getEndDate();
        if (endDate != null && DateUtils.compareNew((Date)endDate, (Date)DateUtils.now())) {
            return;
        }
        Map<String, QyAllot> map = this.service.getQyAllotRows(partnerId);
        for (QyAllotRow qyAllotRow : qyAllot.getCxQyAllotRowList()) {
            Set<String> keySet = map.keySet();
            int count = 0;
            for (String key : keySet) {
                QyAllot qya = map.get(key);
                String vName = "";
                String vId = "";
                if ("area".equals(qyAllot.getAllotType())) {
                    vName = qyAllotRow.getAreaName();
                    vId = qyAllotRow.getAreaId();
                } else if ("bigArea".equals(qyAllot.getAllotType())) {
                    vName = qyAllotRow.getBigAreaName();
                    vId = qyAllotRow.getBigAreaId();
                } else {
                    vName = qyAllotRow.getApplyerName();
                    vId = qyAllotRow.getApplyerId();
                }
                if (!Beans.isNotEmpty((Object)qya) || !(String.valueOf(vId) + "_" + qyAllotRow.getProductId()).equals(key) || qya.getId().equals(qyAllot.getId()) && ++count < 2) continue;
                throw new AppException("0010", String.valueOf(vName) + "\u7684" + qyAllotRow.getProductName() + "\u4ea7\u54c1\u5728(" + qya.getAllotName() + ")\u5b9a\u91cf\u914d\u8d27\u4e2d\uff0c\u6709\u5b58\u5728\u91cd\u590d\u6570\u636e\uff01");
            }
        }
    }

    public void validateFormOnly(QyAllot qyAllot) {
        List<QyAllotRow> rowList = qyAllot.getCxQyAllotRowList();
        String error_msg = "";
        HashMap<String, Integer> count_map = new HashMap<String, Integer>();
        HashMap<String, String> msg_map = new HashMap<String, String>();
        for (QyAllotRow data : rowList) {
            String msg;
            String key;
            String productId = data.getProductId();
            String productName = data.getProductName();
            if ("area".equals(qyAllot.getAllotType())) {
                key = String.valueOf(data.getAreaId()) + "_" + productId;
                msg = String.valueOf(data.getAreaName()) + "_" + productName;
            } else if ("bigArea".equals(qyAllot.getAllotType())) {
                key = String.valueOf(data.getBigAreaId()) + "_" + productId;
                msg = String.valueOf(data.getBigAreaName()) + "_" + productName;
            } else {
                key = String.valueOf(data.getApplyerId()) + "_" + productId;
                msg = String.valueOf(data.getApplyerName()) + "_" + productName;
            }
            if (count_map.get(key) != null) {
                count_map.put(key, (Integer)count_map.get(key) + 1);
                msg_map.put(key, msg);
            } else {
                count_map.put(key, 1);
            }
            if (msg_map.size() <= 0) continue;
            for (Map.Entry entry : msg_map.entrySet()) {
                String key_str = (String)entry.getKey();
                int ct_str = (Integer)count_map.get(key_str);
                String msg_str = (String)entry.getValue();
                error_msg = String.valueOf(error_msg) + msg_str + "\uff1a\u91cd\u590d\u6b21\u6570\uff1a" + ct_str + " ";
            }
            throw new AppException("0010", error_msg);
        }
    }

    public void checkShopNumber(List<AdjustStockUtil> msglist, Object ages, String str) {
        AdjustStockUtil util = new AdjustStockUtil();
        if ("".equals(ages) || ages == null) {
            util.setMessage(str);
            msglist.add(util);
        }
    }

    public void setMessage(List<AdjustStockUtil> msglist, String str) {
        AdjustStockUtil util = new AdjustStockUtil();
        util.setMessage(str);
        msglist.add(util);
    }

    public void packageMap(Map<String, List<QyAllotRow>> map, List<QyAllotRow> allotRows) {
        for (QyAllotRow qyAllotRow : allotRows) {
            List<QyAllotRow> nslist = map.get(qyAllotRow.getApplyerId());
            if (nslist == null) {
                nslist = new ArrayList<QyAllotRow>();
                map.put(qyAllotRow.getApplyerId(), nslist);
            }
            nslist.add(qyAllotRow);
        }
    }

    public void validateName(String name, String id, String partnerId) {
        boolean isName = this.service.validateName(name, id, partnerId);
        if (isName) {
            throw new AppException("0010", "\u5b9a\u91cf\u914d\u8d27(" + name + ")\u5df2\u7ecf\u5b58\u5728");
        }
    }

    @RequestMapping(value={"/getQyAllotRows.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getQyAllotRows(QyAllotRowCondition condition) {
        Employee em = this.getCurrentEmployee();
        condition.setUserId(em.getId());
        condition.setSupplierId(em.getCurrentPartner().getId());
        Page page = this.service.getPageQyAllotRows(condition);
        QyAllot qyAllot = this.service.getQyAllotById(condition.getId());
        List<QyAllotRow> list = this.getCompleteQyAllotRow(qyAllot, page.getList());
        page.setList(list);
        return page;
    }

    @RequestMapping(value={"/batchEdit.do"}, method={RequestMethod.GET})
    public String batchEdit(String id, String allotType, Model model) {
        model.addAttribute("id", (Object)id);
        String xls = "allot.xls";
        if ("applyer".equals(allotType)) {
            xls = "allot.xls";
        }
        if ("area".equals(allotType)) {
            xls = "allotArea.xls";
        }
        if ("bigArea".equals(allotType)) {
            xls = "allotBigArea.xls";
        }
        model.addAttribute("xls", (Object)xls);
        return "allot/batchEdit.ftl";
    }

    @RequestMapping(value={"/batchEdit.do"}, method={RequestMethod.POST})
    public String batchEdit(String id, Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee e = this.getCurrentEmployee();
        String rtn = null;
        QyAllot qyAllot = this.service.get(id);
        if (qyAllot == null) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u8be5\u6279\u91cf\u4fee\u6539\uff0c\u6ca1\u6709\u9488\u5bf9\u7684\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\uff01"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        List<QyAllotRow> qyAllotRows = this.getCompleteQyAllotRow(qyAllot, qyAllot.getCxQyAllotRowList());
        ArrayList<QyAllotRow> updateList = new ArrayList<QyAllotRow>();
        List<AdjustStockUtil> msglist = this.getReadEditExcel(qyAllot.getAllotType(), qyAllotRows, updateList, request);
        if (updateList.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        qyAllot.setCxQyAllotRowList(updateList);
        List<QyAllotCondition> listCondition = this.service.checkQyAllot(qyAllot, "update");
        if (listCondition.size() > 0) {
            for (QyAllotCondition qyc : listCondition) {
                String type = "";
                String dataName = "";
                if (StringUtils.isNotEmpty(qyc.getApplyerId())) {
                    type = "\u7ecf\u9500\u5546";
                    dataName = qyc.getApplyerName();
                } else if (StringUtils.isNotEmpty(qyc.getAreaId())) {
                    type = "\u533a\u57df";
                    dataName = qyc.getAreaName();
                } else if (StringUtils.isNotEmpty(qyc.getBigAreaId())) {
                    type = "\u5927\u533a";
                    dataName = qyc.getBigAreaName();
                }
                msglist.add(new AdjustStockUtil("\u4ea7\u54c1\u7f16\u53f7(" + qyc.getProductNo() + ")\u4e0e\u5b9a\u91cf\u914d\u8d27(" + qyc.getAllotName() + ") \u4e2d" + type + "(" + dataName + ")\u5b58\u5728\u51b2\u7a81"));
            }
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
        } else {
            this.service.updateAll(updateList);
            String fileUrl = (String)request.getAttribute("fileUrl");
            this.saveOrUpdateRecord(e, id, null, QyAllotRecord.UPDATE_TYPE_BATCH, fileUrl);
            rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        }
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    private List<AdjustStockUtil> getReadEditExcel(String allotType, List<QyAllotRow> qyAllotRows, List<QyAllotRow> updateList, HttpServletRequest request) {
        List<IUploadFile> filelist = this.uploadFile(request, "allot_batchEdit");
        List<List<Object>> readExcelList = new LinkedList<List<Object>>();
        String fileUrl = "";
        if (filelist.size() > 0) {
            fileUrl = filelist.get(0).getRealPath();
            request.setAttribute("fileUrl", (Object)fileUrl);
            readExcelList = ExcelHandle.readExcel(fileUrl);
        }
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        this.validateExcelByBatchEdit(allotType, readExcelList, qyAllotRows, updateList, msglist);
        return msglist;
    }

    public void validateExcelByBatchEdit(String allotType, List<List<Object>> readExcelList, List<QyAllotRow> qyAllotRows, List<QyAllotRow> updateList, List<AdjustStockUtil> msglist) {
        Employee em = this.getCurrentEmployee();
        this.validateEmpty(readExcelList, msglist);
        if (msglist.size() > 0) {
            return;
        }
        new ArrayList();
        int j = 1;
        for (List<Object> objectslist : readExcelList) {
            Region region;
            Product product;
            String message = "\u5728\u7b2c" + ++j + "\u884c\uff0c";
            QyAllotRow adju = null;
            boolean is = false;
            boolean isExistId = false;
            if ("applyer".equals(allotType)) {
                Customer customer = this.clientService.getCodeAndSupplier(objectslist.get(0).toString(), em.getCurrentPartner().getId());
                if (customer == null) {
                    message = String.valueOf(message) + "\u5ba2\u6237\u7f16\u53f7\u4e0d\u5c5e\u4e8e\u672c\u7ec4\u7ec7;";
                    is = true;
                }
                product = null;
                if (!is && (product = this.productService.getCodeAndProduct(objectslist.get(1).toString(), customer.getApplyerId())) == null) {
                    message = String.valueOf(message) + "\u8be5\u4ea7\u54c1\u7f16\u53f7\u4e0d\u5c5e\u4e8e" + objectslist.get(0).toString() + "\u7f16\u53f7\u7684\u5ba2\u6237,\u6216\u8005\u5bfc\u5165\u7c7b\u578b\u4e0d\u5339\u914d;";
                    is = true;
                }
                if (!is) {
                    for (QyAllotRow qyAllotRow : qyAllotRows) {
                        if (!Beans.isNotEmpty((Object)customer) || !customer.getApplyerId().equals(qyAllotRow.getApplyerId())) continue;
                        isExistId = true;
                        if (!Beans.isNotEmpty((Object)product) || !product.getId().equals(qyAllotRow.getProductId())) continue;
                        adju = qyAllotRow;
                    }
                    if (!isExistId) {
                        message = String.valueOf(message) + "\u8be5\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7ecf\u9500\u5546;";
                        is = true;
                    } else if (adju == null) {
                        message = String.valueOf(message) + "\u8be5\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\u4e2d\u6ca1\u6709\u5b58\u5728\u5bf9\u5e94\u7684\u4ea7\u54c1\u7f16\u7801;";
                        is = true;
                    }
                }
            }
            if ("area".equals(allotType)) {
                region = this.regionService.getAreaByName(objectslist.get(0).toString(), em.getCurrentPartner().getId());
                product = Cache.getProductByNo(objectslist.get(1).toString());
                if (!is) {
                    for (QyAllotRow qyAllotRow : qyAllotRows) {
                        if (!Beans.isNotEmpty((Object)region) || !region.getId().equals(qyAllotRow.getAreaId())) continue;
                        isExistId = true;
                        if (!Beans.isNotEmpty((Object)product) || !product.getId().equals(qyAllotRow.getProductId())) continue;
                        adju = qyAllotRow;
                    }
                    if (!isExistId) {
                        message = String.valueOf(message) + "\u8be5\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u533a\u57df;";
                        is = true;
                    } else if (adju == null) {
                        message = String.valueOf(message) + "\u8be5\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\u4e2d\u6ca1\u6709\u5b58\u5728\u5bf9\u5e94\u7684\u4ea7\u54c1\u7f16\u7801;";
                        is = true;
                    }
                }
                if (!is) {
                    if (Beans.isEmpty((Object)region)) {
                        message = String.valueOf(message) + "\u533a\u57df [" + objectslist.get(0).toString() + "] \u4e0d\u5b58\u5728,\u6216\u8005\u5bfc\u5165\u7c7b\u578b\u4e0d\u5339\u914d;";
                        is = true;
                    } else {
                        adju.setChannelId(region.getChannelCode());
                        adju.setBigAreaId(region.getParentId());
                        adju.setAreaId(region.getId());
                    }
                    if (product != null) {
                        adju.setProductId(product.getId());
                        adju.setUnits(product.getUnitName());
                        adju.setNorms(product.getSpec());
                    } else {
                        message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7 [" + objectslist.get(1).toString() + "] \u4e0d\u5b58\u5728;";
                        is = true;
                    }
                }
            }
            if ("bigArea".equals(allotType)) {
                region = this.regionService.getAreaByName(objectslist.get(0).toString(), em.getCurrentPartner().getId());
                product = Cache.getProductByNo(objectslist.get(1).toString());
                if (!is) {
                    for (QyAllotRow qyAllotRow : qyAllotRows) {
                        if (!Beans.isNotEmpty((Object)region) || !region.getId().equals(qyAllotRow.getBigAreaId())) continue;
                        isExistId = true;
                        if (!Beans.isNotEmpty((Object)product) || !product.getId().equals(qyAllotRow.getProductId())) continue;
                        adju = qyAllotRow;
                    }
                    if (!isExistId) {
                        message = String.valueOf(message) + "\u8be5\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5927\u533a;";
                        is = true;
                    } else if (adju == null) {
                        message = String.valueOf(message) + "\u8be5\u5b9a\u91cf\u914d\u8d27\u540d\u79f0\u4e2d\u6ca1\u6709\u5b58\u5728\u5bf9\u5e94\u7684\u4ea7\u54c1\u7f16\u7801;";
                        is = true;
                    }
                }
                if (!is) {
                    if (Beans.isEmpty((Object)region)) {
                        message = String.valueOf(message) + "\u5927\u533a [" + objectslist.get(0).toString() + "] \u4e0d\u5b58\u5728,\u6216\u8005\u5bfc\u5165\u7c7b\u578b\u4e0d\u5339\u914d;";
                        is = true;
                    } else {
                        adju.setChannelId(region.getChannelCode());
                        adju.setBigAreaId(region.getId());
                    }
                    if (product != null) {
                        adju.setProductId(product.getId());
                        adju.setUnits(product.getUnitName());
                        adju.setNorms(product.getSpec());
                    } else {
                        message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7 [" + objectslist.get(1).toString() + "] \u4e0d\u5b58\u5728;";
                        is = true;
                    }
                }
            }
            if (!is && adju != null) {
                Double quotaNumber = Double.parseDouble(objectslist.get(2).toString());
                if (quotaNumber < adju.getPassProduct() + adju.getNotPassProduct()) {
                    message = String.valueOf(message) + "\u9650\u8d2d\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u8d2d\u6570\u91cf";
                    is = true;
                } else if (Beans.isNotEmpty((Object)adju.getMinUnit()) && quotaNumber % adju.getMinUnit() != 0.0) {
                    message = String.valueOf(message) + "\u9650\u8d2d\u6570\u91cf\u5fc5\u987b\u662f\u6700\u5c0f\u5305\u88c5\u6570\u7684\u500d\u6570";
                    is = true;
                } else {
                    adju.setQuotaNumber(quotaNumber);
                    updateList.add(adju);
                }
            }
            if (!is) continue;
            AdjustStockUtil asu = new AdjustStockUtil();
            asu.setMessage(message);
            msglist.add(asu);
        }
    }

    public void saveOrUpdateRecord(Employee emp, String quantifyAllotId, QyAllotRecord qyAllotRecord, String updateType, String filePath) {
        if (Beans.isEmpty((Object)qyAllotRecord)) {
            qyAllotRecord = new QyAllotRecord();
            qyAllotRecord.setCreated(new Date());
            qyAllotRecord.setCreatedBy(emp.getId());
            qyAllotRecord.setQuantifyAllotId(quantifyAllotId);
            qyAllotRecord.setUpdateData(filePath);
            qyAllotRecord.setUpdateType(updateType);
        } else {
            qyAllotRecord.setCreated(new Date());
            qyAllotRecord.setCreatedBy(emp.getId());
        }
        this.service.saveOrUpdateRecord(qyAllotRecord);
    }

    @RequestMapping(value={"/viewHistory.do"}, method={RequestMethod.GET})
    public String viewHistory(String id, Model model) {
        List<QyAllotRecord> history = this.service.getHistoryByQuantifyAllotId(id);
        model.addAttribute("list", history);
        return "allot/viewHistory.ftl";
    }

    @RequestMapping(value={"/downloadHistory.do"}, method={RequestMethod.GET})
    public void viewHistory(String id, HttpServletResponse response) throws Exception {
        QyAllotRecord allotRecord = this.service.getHistoryById(id);
        File file = new File(allotRecord.getUpdateData());
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = URLDecoder.decode(file.getName(), "gbk");
            fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
            response.reset();
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setHeader("Content-Length", String.valueOf(file.length()));
            response.setContentType("application/octet-stream; charset=utf-8");
            os.write(FileUtils.readFileToByteArray((File)file));
            os.flush();
        }
    }

    public void saveOrUpdateRecord(QyAllot updateCxqyallot, QyAllot beforeCxqyallot) throws Exception {
        int j;
        String[] vals;
        List<QyAllotRow> updateQyAllotRow = updateCxqyallot.getCxQyAllotRowList();
        List<QyAllotRow> beforeQyAllotRow = null;
        if (beforeCxqyallot != null) {
            beforeQyAllotRow = beforeCxqyallot.getCxQyAllotRowList();
        }
        ArrayList<QyAllotRow> deleteQyAllotRow = new ArrayList<QyAllotRow>();
        if (beforeQyAllotRow != null) {
            String delIds = updateCxqyallot.getDelIds();
            if (StringUtils.isNotEmpty(delIds)) {
                String[] ids;
                String[] stringArray = ids = delIds.split(",");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    for (QyAllotRow q : beforeQyAllotRow) {
                        if (!q.getId().equals(id)) continue;
                        deleteQyAllotRow.add(q);
                    }
                    ++n2;
                }
            }
            Iterator<QyAllotRow> iterator = updateQyAllotRow.iterator();
            while (iterator.hasNext()) {
                QyAllotRow q = iterator.next();
                for (QyAllotRow qa : beforeQyAllotRow) {
                    if (!q.getApplyerId().equals(qa.getApplyerId()) || !q.getProductId().equals(qa.getProductId()) || !q.getQuotaNumber().equals(qa.getQuotaNumber())) continue;
                    iterator.remove();
                }
            }
            if (updateQyAllotRow.size() == 0 && deleteQyAllotRow.size() == 0) {
                return;
            }
        }
        QyAllotRecord qyAllotRecord = this.service.getHistoryManual(updateCxqyallot.getId());
        int index = 0;
        HSSFWorkbook wb = new HSSFWorkbook();
        String name = String.valueOf(this.getCurrentEmployee().getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls";
        HSSFSheet sheet = wb.createSheet(name);
        if (qyAllotRecord != null) {
            FileInputStream fs = new FileInputStream(qyAllotRecord.getUpdateData());
            POIFSFileSystem ps = new POIFSFileSystem((InputStream)fs);
            wb = new HSSFWorkbook(ps);
            sheet = wb.getSheetAt(0);
            index = sheet.getLastRowNum() + 1;
            fs.close();
        }
        String allotType = updateCxqyallot.getAllotType();
        HSSFRow row = null;
        if (qyAllotRecord == null) {
            row = sheet.createRow(0);
            String[] names = new String[]{"\u5ba2\u6237\u540d\u79f0", "\u5ba2\u6237\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u5355\u4f4d", "\u89c4\u683c", "\u9650\u8d2d\u6570\u91cf", "\u4fee\u6539\u65f6\u95f4", "\u4fee\u6539\u8005", "\u64cd\u4f5c\u7c7b\u578b"};
            if ("area".equals(allotType)) {
                names = new String[]{"\u5927\u533a\u540d\u79f0", "\u5927\u533a\u7f16\u53f7", "\u533a\u57df\u540d\u79f0", "\u533a\u57df\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u5355\u4f4d", "\u89c4\u683c", "\u9650\u8d2d\u6570\u91cf", "\u4fee\u6539\u65f6\u95f4", "\u4fee\u6539\u8005", "\u64cd\u4f5c\u7c7b\u578b"};
            }
            if ("bigArea".equals(allotType)) {
                names = new String[]{"\u5927\u533a\u540d\u79f0", "\u5927\u533a\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u5355\u4f4d", "\u89c4\u683c", "\u9650\u8d2d\u6570\u91cf", "\u4fee\u6539\u65f6\u95f4", "\u4fee\u6539\u8005", "\u64cd\u4f5c\u7c7b\u578b"};
            }
            int i = 0;
            while (i < names.length) {
                row.createCell(i).setCellValue(names[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < updateQyAllotRow.size()) {
            row = sheet.createRow(index + i + 1);
            QyAllotRow q = updateQyAllotRow.get(i);
            String[] stringArray = new String[10];
            stringArray[0] = q.getApplyerName();
            stringArray[1] = q.getApplyerNo();
            stringArray[2] = q.getProductName();
            stringArray[3] = q.getProductNo();
            stringArray[4] = q.getUnits();
            stringArray[5] = q.getNorms();
            stringArray[6] = q.getQuotaNumber().toString();
            new DateUtils();
            stringArray[7] = DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            stringArray[8] = this.getCurrentEmployee().getName();
            stringArray[9] = beforeQyAllotRow == null ? "\u65b0\u589e" : "\u65b0\u589e\u6216\u4fee\u6539";
            vals = stringArray;
            if ("area".equals(allotType)) {
                String[] stringArray2 = new String[12];
                stringArray2[0] = q.getBigAreaName();
                stringArray2[1] = q.getBigAreaCode();
                stringArray2[2] = q.getAreaName();
                stringArray2[3] = q.getAreaCode();
                stringArray2[4] = q.getProductName();
                stringArray2[5] = q.getProductName();
                stringArray2[6] = q.getUnits();
                stringArray2[7] = q.getNorms();
                stringArray2[8] = q.getQuotaNumber().toString();
                new DateUtils();
                stringArray2[9] = DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                stringArray2[10] = this.getCurrentEmployee().getName();
                stringArray2[11] = beforeQyAllotRow == null ? "\u65b0\u589e" : "\u65b0\u589e\u6216\u4fee\u6539";
                vals = stringArray2;
            }
            if ("bigArea".equals(allotType)) {
                String[] stringArray3 = new String[10];
                stringArray3[0] = q.getBigAreaName();
                stringArray3[1] = q.getBigAreaCode();
                stringArray3[2] = q.getProductName();
                stringArray3[3] = q.getProductName();
                stringArray3[4] = q.getUnits();
                stringArray3[5] = q.getNorms();
                stringArray3[6] = q.getQuotaNumber().toString();
                new DateUtils();
                stringArray3[7] = DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                stringArray3[8] = this.getCurrentEmployee().getName();
                stringArray3[9] = beforeQyAllotRow == null ? "\u65b0\u589e" : "\u65b0\u589e\u6216\u4fee\u6539";
                vals = stringArray3;
            }
            j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        index += updateQyAllotRow.size();
        i = 0;
        while (i < deleteQyAllotRow.size()) {
            row = sheet.createRow(index + i + 1);
            QyAllotRow q = (QyAllotRow)deleteQyAllotRow.get(i);
            String[] stringArray = new String[10];
            stringArray[0] = q.getApplyerName();
            stringArray[1] = q.getApplyerId();
            stringArray[2] = q.getProductName();
            stringArray[3] = q.getProductName();
            stringArray[4] = q.getUnits();
            stringArray[5] = q.getNorms();
            stringArray[6] = q.getQuotaNumber().toString();
            new DateUtils();
            stringArray[7] = DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            stringArray[8] = this.getCurrentEmployee().getName();
            stringArray[9] = "\u5220\u9664";
            vals = stringArray;
            if ("area".equals(allotType)) {
                String[] stringArray4 = new String[12];
                stringArray4[0] = q.getBigAreaName();
                stringArray4[1] = q.getBigAreaCode();
                stringArray4[2] = q.getAreaName();
                stringArray4[3] = q.getAreaCode();
                stringArray4[4] = q.getProductName();
                stringArray4[5] = q.getProductName();
                stringArray4[6] = q.getUnits();
                stringArray4[7] = q.getNorms();
                stringArray4[8] = q.getQuotaNumber().toString();
                new DateUtils();
                stringArray4[9] = DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                stringArray4[10] = this.getCurrentEmployee().getName();
                stringArray4[11] = "\u5220\u9664";
                vals = stringArray4;
            }
            if ("bigArea".equals(allotType)) {
                String[] stringArray5 = new String[10];
                stringArray5[0] = q.getBigAreaName();
                stringArray5[1] = q.getBigAreaCode();
                stringArray5[2] = q.getProductName();
                stringArray5[3] = q.getProductName();
                stringArray5[4] = q.getUnits();
                stringArray5[5] = q.getNorms();
                stringArray5[6] = q.getQuotaNumber().toString();
                new DateUtils();
                stringArray5[7] = DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                stringArray5[8] = this.getCurrentEmployee().getName();
                stringArray5[9] = "\u5220\u9664";
                vals = stringArray5;
            }
            j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        String dir = String.valueOf(ConfigFactory.get().get("upload_base_path")) + "allot_edit";
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fout = null;
        fout = qyAllotRecord != null ? new FileOutputStream(qyAllotRecord.getUpdateData()) : new FileOutputStream(String.valueOf(dir) + "\\" + name);
        wb.write((OutputStream)fout);
        this.saveOrUpdateRecord(this.getCurrentEmployee(), updateCxqyallot.getId(), qyAllotRecord, QyAllotRecord.UPDATE_TYPE_MANUAL, String.valueOf(dir) + "\\" + name);
    }

    public List<QyAllotRow> getCompleteQyAllotRow(QyAllot qyAllot, List<QyAllotRow> qyAllotRow) {
        ArrayList<QyAllotRow> qyAllotRows = new ArrayList<QyAllotRow>();
        for (QyAllotRow q : qyAllotRow) {
            PartnerProduct p = this.productService.getPartnerProduct(qyAllot.getSupplierId(), q.getProductId());
            QyAllotCondition qyAllotCondition = new QyAllotCondition();
            qyAllotCondition.setApplyerId(q.getApplyerId());
            qyAllotCondition.setStartDate(qyAllot.getStartDate());
            qyAllotCondition.setEndDate(qyAllot.getEndDate());
            qyAllotCondition.setAllotType(qyAllot.getAllotType());
            qyAllotCondition.setAreaId(q.getAreaId());
            qyAllotCondition.setBigAreaId(q.getBigAreaId());
            List<OrderProduct> products = this.service.getProducts(qyAllotCondition, true);
            double passProduct = this.service.getProductsCount(q.getProductId(), products);
            q.setPassProduct(passProduct);
            List<OrderProduct> products2 = this.service.getProducts(qyAllotCondition, false);
            double notPassProduct = this.service.getProductsCount(q.getProductId(), products2);
            q.setNotPassProduct(notPassProduct);
            double residueNumber = q.getQuotaNumber() - (passProduct + notPassProduct);
            q.setResidueNumber(residueNumber);
            if (StringUtils.isNotNull(p)) {
                q.setMinUnit(p.getDivideQuantity());
            } else {
                q.setMinUnit(1.0);
            }
            qyAllotRows.add(q);
        }
        return qyAllotRows;
    }

    private void validate(List<QyAllotRow> completeQyAllotRow) {
        for (QyAllotRow q : completeQyAllotRow) {
            if (!(q.getQuotaNumber() < q.getPassProduct() + q.getNotPassProduct())) continue;
            String name = "";
            if (StringUtils.isNotEmpty(q.getApplyerId())) {
                name = q.getApplyerName();
            } else if (StringUtils.isNotEmpty(q.getAreaId())) {
                name = q.getAreaName();
            } else if (StringUtils.isNotEmpty(q.getBigAreaId())) {
                name = q.getBigAreaName();
            }
            throw new AppException("0010", String.valueOf(name) + "\u7684" + q.getProductName() + "\u4ea7\u54c1\u9650\u8d2d\u6570\u91cf\uff0c\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u8d2d\u6570\u91cf\uff01");
        }
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(QyAllotRowCondition condition, String allotType, HttpServletResponse response) {
        condition.setRowsize(Integer.MAX_VALUE);
        List list = this.getQyAllotRows(condition).getList();
        File dir = new File(String.valueOf(ConfigFactory.get().get("upload_base_path")) + "qyallotrow_excel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        QyAllotController.excels(allotType, list, dir.getPath(), String.valueOf(this.getCurrentEmployee().getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    public static boolean excels(String allotType, List<QyAllotRow> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u5ba2\u6237\u540d\u79f0", "\u5ba2\u6237\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u5355\u4f4d", "\u89c4\u683c", "\u6700\u5c0f\u5305\u88c5\u6570", "\u9650\u8d2d\u6570\u91cf", "\u5df2\u8d2d\u6570\u91cf", "\u5f85\u5ba1\u6838\u6570\u91cf", "\u53ef\u8d2d\u6570\u91cf"};
        if ("area".equals(allotType)) {
            names = new String[]{"\u5927\u533a\u540d\u79f0", "\u5927\u533a\u7f16\u53f7", "\u533a\u57df\u540d\u79f0", "\u533a\u57df\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u5355\u4f4d", "\u89c4\u683c", "\u6700\u5c0f\u5305\u88c5\u6570", "\u9650\u8d2d\u6570\u91cf", "\u5df2\u8d2d\u6570\u91cf", "\u5f85\u5ba1\u6838\u6570\u91cf", "\u53ef\u8d2d\u6570\u91cf"};
        }
        if ("bigArea".equals(allotType)) {
            names = new String[]{"\u5927\u533a\u540d\u79f0", "\u5927\u533a\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u5355\u4f4d", "\u89c4\u683c", "\u6700\u5c0f\u5305\u88c5\u6570", "\u9650\u8d2d\u6570\u91cf", "\u5df2\u8d2d\u6570\u91cf", "\u5f85\u5ba1\u6838\u6570\u91cf", "\u53ef\u8d2d\u6570\u91cf"};
        }
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            QyAllotRow q = list.get(i);
            String[] vals = new String[]{q.getApplyerName(), q.getApplyerNo(), q.getProductName(), q.getProductNo(), q.getUnits(), q.getNorms(), StringUtils.objToStr(q.getMinUnit()), StringUtils.objToStr(q.getQuotaNumber()), StringUtils.objToStr(q.getPassProduct()), StringUtils.objToStr(q.getNotPassProduct()), StringUtils.objToStr(q.getResidueNumber())};
            if ("area".equals(allotType)) {
                vals = new String[]{q.getBigAreaName(), q.getBigAreaCode(), q.getAreaName(), q.getAreaCode(), q.getProductName(), q.getProductNo(), q.getUnits(), q.getNorms(), StringUtils.objToStr(q.getMinUnit()), StringUtils.objToStr(q.getQuotaNumber()), StringUtils.objToStr(q.getPassProduct()), StringUtils.objToStr(q.getNotPassProduct()), StringUtils.objToStr(q.getResidueNumber())};
            }
            if ("bigArea".equals(allotType)) {
                vals = new String[]{q.getBigAreaName(), q.getBigAreaCode(), q.getProductName(), q.getProductNo(), q.getUnits(), q.getNorms(), StringUtils.objToStr(q.getMinUnit()), StringUtils.objToStr(q.getQuotaNumber()), StringUtils.objToStr(q.getPassProduct()), StringUtils.objToStr(q.getNotPassProduct()), StringUtils.objToStr(q.getResidueNumber())};
            }
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

