/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.allot;

import com.tcbj.crm.allot.QyAllotCondition;
import com.tcbj.crm.allot.QyAllotRowCondition;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.QyAllot;
import com.tcbj.crm.entity.QyAllotRecord;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerArea;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="qyAllotService")
public class QyAllotService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    Cache cache;
    @Autowired
    RegionService regionService;

    public QyAllot get(String id) {
        QyAllot q = (QyAllot)this.baseDao.get(QyAllot.class, (Serializable)((Object)id));
        Object[] args = new Object[]{q.getId()};
        List list = this.baseDao.findEntity("from QyAllotRow where allotId = ?", args, QyAllotRow.class);
        q.setCxQyAllotRowList(list);
        if (Beans.isEmpty((Object)q.getAllotType())) {
            q.setAllotType("applyer");
        }
        return q;
    }

    public QyAllot getQyAllotById(String id) {
        return (QyAllot)this.baseDao.get(QyAllot.class, (Serializable)((Object)id));
    }

    @Transactional
    public List<QyAllotCondition> save(QyAllot obj, Employee me) {
        List<QyAllotCondition> listCondition = this.checkQyAllot(obj, "add");
        if (listCondition.size() <= 0) {
            obj.fillInitData(me);
            obj.setSupplierId(me.getCurrentPartner().getId());
            this.baseDao.save((Object)obj);
            try {
                List<QyAllotRow> list = obj.getCxQyAllotRowList();
                for (QyAllotRow cxQyAllotRow : list) {
                    cxQyAllotRow.fillInitData(me);
                    cxQyAllotRow.setAllotId(obj.getId());
                }
                this.baseDao.save(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listCondition;
    }

    public List<QyAllotCondition> checkQyAllot(QyAllot qyAllot, String type) {
        ArrayList<QyAllotCondition> listResult = new ArrayList<QyAllotCondition>();
        String allotType = qyAllot.getAllotType();
        for (QyAllotRow qyAllotRow : qyAllot.getCxQyAllotRowList()) {
            PartnerArea partnerArea;
            StringBuffer hql = new StringBuffer();
            ArrayList<Object> args = new ArrayList<Object>();
            hql.append("from QyAllot o,QyAllotRow r where o.id=r.allotId and (o.endDate is null or o.endDate >= ?) and r.productId = ? ");
            args.add(new Date());
            args.add(qyAllotRow.getProductId());
            if ("update".equals(type)) {
                hql.append(" and o.id !=? ");
                args.add(qyAllot.getId());
            }
            if ("applyer".equals(allotType) && Beans.isNotEmpty((Object)(partnerArea = Cache.getPartnerAreaById(qyAllotRow.getApplyerId())))) {
                hql.append(" and (r.applyerId = ? or r.areaId = ? or r.bigAreaId = ?)");
                args.add(qyAllotRow.getApplyerId());
                args.add(partnerArea.getRegionId());
                args.add(partnerArea.getDistrictId());
            }
            if ("area".equals(allotType)) {
                hql.append("   and ((r.areaId = ? and o.allotType = ? ) or (r.bigAreaId = ? and o.allotType = ? )");
                args.add(qyAllotRow.getAreaId());
                args.add(allotType);
                args.add(qyAllotRow.getBigAreaId());
                args.add("bigArea");
                hql.append(" or r.applyerId in(select partnerId from PartnerArea where regionId = ?)");
                args.add(qyAllotRow.getAreaId());
                hql.append(" )");
            }
            if ("bigArea".equals(allotType)) {
                hql.append(" and (r.bigAreaId = ?  ");
                args.add(qyAllotRow.getBigAreaId());
                ArrayList<String> aList = new ArrayList<String>();
                List<Region> listRegion = this.regionService.getParentAreas(qyAllotRow.getBigAreaId(), null);
                for (Region region : listRegion) {
                    aList.add(region.getId());
                }
                if (aList.size() > 0) {
                    hql.append(" or r.areaId in( '").append(StringUtils.listToString2(aList, "','")).append("')");
                }
                hql.append(" or r.applyerId in(select partnerId from PartnerArea where districtId = ?)");
                args.add(qyAllotRow.getBigAreaId());
                hql.append(" )");
            }
            List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
            for (Object[] ps : list) {
                QyAllotCondition qyAllotCondition = new QyAllotCondition();
                QyAllot o = (QyAllot)ps[0];
                QyAllotRow r = (QyAllotRow)ps[1];
                qyAllotCondition.setProductId(r.getProductId());
                qyAllotCondition.setApplyerId(r.getApplyerId());
                qyAllotCondition.setAreaId(r.getAreaId());
                qyAllotCondition.setBigAreaId(r.getBigAreaId());
                qyAllotCondition.setAllotName(o.getAllotName());
                qyAllotCondition.setAllotType(Beans.isEmpty((Object)o.getAllotType()) ? "applyer" : o.getAllotType());
                listResult.add(qyAllotCondition);
            }
        }
        return (List)StringUtils.disList(listResult);
    }

    public Page getList(int pageno, QyAllotCondition con) {
        PartnerArea partnerArea;
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String applyerId = con.getApplyerId();
        String productId = con.getProductId();
        hql.append("select o.id from QyAllot o");
        if (StringUtils.isNotEmpty(applyerId) || StringUtils.isNotEmpty(productId)) {
            hql.append(" ,QyAllotRow r ");
            hql.append(" where  o.id = r.allotId ");
        } else {
            hql.append(" where 1=1");
        }
        hql.append(" and o.supplierId = ? ");
        args.add(con.getSupplierId());
        if (StringUtils.isNotEmpty(con.getAllotName())) {
            hql.append(" and o.allotName like ? ");
            args.add("%" + con.getAllotName() + "%");
        }
        if (StringUtils.isNotNull(con.getStartDate())) {
            hql.append(" and o.startDate >= ?");
            args.add(con.getStartDate());
        }
        if (StringUtils.isNotNull(con.getEndDateHQL())) {
            hql.append(" and o.startDate < ?");
            args.add(con.getEndDateHQL());
        }
        if (StringUtils.isNotEmpty(applyerId) && Beans.isNotEmpty((Object)(partnerArea = Cache.getPartnerAreaById(applyerId)))) {
            hql.append(" and (r.applyerId = ? or r.areaId = ? or r.bigAreaId = ?)");
            args.add(applyerId);
            args.add(partnerArea.getRegionId());
            args.add(partnerArea.getDistrictId());
        }
        if (StringUtils.isNotEmpty(productId)) {
            hql.append(" and r.productId = ? ");
            args.add(productId);
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            if ("0".equals(con.getState())) {
                hql.append(" and (o.endDate is not null and o.endDate < sysdate)");
            } else {
                hql.append(" and (o.endDate is null or o.endDate >= sysdate) ");
            }
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object obj : list) {
            set.add((String)obj);
        }
        if (set.size() > 0) {
            String pf = " ";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql2 = " from QyAllot p where p.id in ( " + pf + ")";
            hql2 = String.valueOf(hql2) + " order by createDt desc ";
            Page page = this.baseDao.search(hql2, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    public List<QyAllotCondition> update(QyAllot obj, Employee me) {
        List<QyAllotCondition> listCondition = this.checkQyAllot(obj, "update");
        if (listCondition.size() > 0) {
            return listCondition;
        }
        obj.fillInitData(me);
        obj.setSupplierId(me.getCurrentPartner().getId());
        this.baseDao.update((Object)obj);
        try {
            List<QyAllotRow> list = obj.getCxQyAllotRowList();
            for (QyAllotRow cxQyAllotRow : list) {
                cxQyAllotRow.setAllotId(obj.getId());
                cxQyAllotRow.fillInitData(me);
                if (StringUtils.isNotEmpty(cxQyAllotRow.getId())) {
                    this.baseDao.update((Object)cxQyAllotRow);
                    continue;
                }
                this.baseDao.save((Object)cxQyAllotRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listCondition;
    }

    public void delete(String id) {
        QyAllot qyAllot = (QyAllot)this.baseDao.get(QyAllot.class, (Serializable)((Object)id));
        qyAllot.setEndDate(DateUtils.now());
    }

    public void deleteRow(String id) {
        this.baseDao.deleteById(QyAllotRow.class, (Serializable)((Object)id));
    }

    public List<QyAllotRow> getList(String applyerId, String supplierId, Date findDate) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer hql = new StringBuffer();
        hql.append("from QyAllot p,QyAllotRow a where a.allotId = p.id ");
        if (StringUtils.isNotEmpty(supplierId)) {
            hql.append(" and p.supplierId = ?");
            args.add(supplierId);
        }
        if (StringUtils.isNotEmpty(applyerId)) {
            PartnerArea partnerArea = Cache.getPartnerAreaById(applyerId);
            if (Beans.isNotEmpty((Object)partnerArea)) {
                hql.append(" and (a.applyerId = ? or a.areaId = ? or a.bigAreaId = ?)");
                args.add(applyerId);
                args.add(partnerArea.getRegionId());
                args.add(partnerArea.getDistrictId());
            } else {
                hql.append(" and a.applyerId = ?");
                args.add(applyerId);
            }
        }
        hql.append(" and p.startDate <= ? and nvl(p.endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        hql.append(" order by p.startDate asc ");
        List objects = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<QyAllotRow> list = new ArrayList<QyAllotRow>();
        for (Object[] obj : objects) {
            QyAllotRow qyrow = (QyAllotRow)obj[1];
            QyAllot qy = (QyAllot)obj[0];
            qyrow.setApplyerId(applyerId);
            qyrow.setStartDate(qy.getStartDate());
            qyrow.setEndDate(qy.getEndDate());
            qyrow.setQyAllotType(qy.getAllotType());
            list.add(qyrow);
        }
        return list;
    }

    public Page getPageQyAllotRows(QyAllotRowCondition condition) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        this.personnelService.getFRegionsByUserId(condition.getUserId());
        sb.append("from QyAllotRow q where q.allotId=? ");
        args.add(condition.getId());
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            sb.append(" and q.applyerId=? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            sb.append(" and q.productId=? ");
            args.add(condition.getProductId());
        }
        Page page = this.baseDao.search(sb.toString(), args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue());
        return page;
    }

    public Map<String, QyAllot> getQyAllotRows(String partnerId) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer hql = new StringBuffer();
        hql.append("from QyAllot p,QyAllotRow a where a.allotId = p.id ");
        if (StringUtils.isNotEmpty(partnerId)) {
            hql.append(" and p.supplierId = ?");
            args.add(partnerId);
        }
        hql.append(" and p.startDate <= ? and nvl(p.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        List objects = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        HashMap<String, QyAllot> map = new HashMap<String, QyAllot>();
        for (Object[] obj : objects) {
            QyAllotRow row = (QyAllotRow)obj[1];
            QyAllot allot = (QyAllot)obj[0];
            if ("area".equals(allot.getAllotType())) {
                map.put(String.valueOf(row.getAreaId()) + "_" + row.getProductId(), allot);
                continue;
            }
            if ("bigArea".equals(allot.getAllotType())) {
                map.put(String.valueOf(row.getBigAreaId()) + "_" + row.getProductId(), allot);
                continue;
            }
            map.put(String.valueOf(row.getApplyerId()) + "_" + row.getProductId(), allot);
        }
        return map;
    }

    public boolean validateName(String name, String id, String partnerId) {
        QyAllot qyAllot;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append("from QyAllot where supplierId = ? and allotName = ? ");
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            sb.append(" and id != ? ");
            args.add(id);
        }
        return StringUtils.isNotNull(qyAllot = (QyAllot)this.baseDao.findFirstEntity(sb.toString(), args.toArray(), QyAllot.class));
    }

    public Map<String, String> getAllotRowDates(String applyId) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> map_temp = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select t2.PRODUCT_NUMBER prodId,to_char(max(t1.START_DATE),'yyyymmdd') ksrq ").append(" from CX_QY_ALLOT  t1, ").append("        CX_QY_ALLOT_ROW  t2 ").append("   where t2.QUANTIFY_ALLOT_ID=t1.row_id ").append("         and (t1.END_DATE is null  or to_char(t1.END_DATE,'yyyy-MM-dd')>'").append(DateUtils.formartDate((Date)DateUtils.now(), (String)"yyyy-MM-dd")).append(" ')   ").append("         and          t2.DEALER_NAME='").append(applyId).append("'").append("  group by t2.PRODUCT_NUMBER ");
        List list = this.baseDao.findBySql(sb.toString());
        for (Object[] objectArray : list) {
            map_temp.put(objectArray[0].toString(), objectArray[1].toString());
        }
        for (Map.Entry entry : map_temp.entrySet()) {
            String value = (String)entry.getValue();
            String key = (String)entry.getKey();
            for (Map.Entry entry2 : map_temp.entrySet()) {
                if (!((String)entry2.getValue()).equals(value)) continue;
                if (map.get(value) == null) {
                    map.put(value, "'" + key + "'");
                    continue;
                }
                if (((String)map.get(value)).contains((CharSequence)entry2.getKey())) continue;
                map.put(value, String.valueOf((String)map.get(value)) + ",'" + (String)entry2.getKey() + "'");
            }
        }
        return map;
    }

    public List<OrderProduct> getProducts(QyAllotCondition condition, boolean state) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        sb.append("from OrderApply oa where 1=1 ");
        if ("area".equals(condition.getAllotType())) {
            sb.append(" and exists (select 1 from PartnerArea ca where oa.applyerId=ca.partnerId and ca.regionId=?) ");
            args.add(condition.getAreaId());
        } else if ("bigArea".equals(condition.getAllotType())) {
            sb.append(" and exists (select 1 from PartnerArea ca where oa.applyerId=ca.partnerId and ca.districtId=?) ");
            args.add(condition.getBigAreaId());
        } else {
            sb.append(" and oa.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (state) {
            sb.append(" and oa.state in ('3','4','5','6','4-1') ");
        } else {
            sb.append(" and oa.state in ('2') ");
        }
        if (Beans.isNotEmpty((Object)condition.getStartDate())) {
            sb.append(" and oa.dt >= ? ");
            args.add(condition.getStartDate());
        }
        if (Beans.isNotEmpty((Object)condition.getEndDate())) {
            sb.append(" and oa.dt <= ? ");
            args.add(condition.getEndDate());
        }
        List orderApplys = this.baseDao.findEntity(sb.toString(), args.toArray(), OrderApply.class);
        ArrayList<OrderProduct> orderProducts = new ArrayList<OrderProduct>();
        for (OrderApply orderApply : orderApplys) {
            List<OrderApplyItem> orderApplyItems = this.orderApplyService.getOrderApplyItems(orderApply.getId());
            for (OrderApplyItem item : orderApplyItems) {
                OrderProduct product = new OrderProduct(orderApply.getApplyerId(), item);
                orderProducts.add(product);
            }
        }
        return orderProducts;
    }

    public double getProductsCount(String productId, List<OrderProduct> products) {
        double productsCount = 0.0;
        for (OrderProduct orderProduct : products) {
            if (!productId.equals(orderProduct.getId())) continue;
            productsCount += orderProduct.getActQuantity().doubleValue();
        }
        return productsCount;
    }

    public void updateAll(List<QyAllotRow> updateList) {
        this.baseDao.update(updateList);
    }

    public void saveOrUpdateRecord(QyAllotRecord qyAllotRecord) {
        this.baseDao.saveOrUpdate((Object)qyAllotRecord);
    }

    public List<QyAllotRecord> getHistoryByQuantifyAllotId(String id) {
        return this.baseDao.findEntity("from QyAllotRecord where quantifyAllotId = ? order by created DESC", new Object[]{id}, QyAllotRecord.class);
    }

    public QyAllotRecord getHistoryManual(String id) {
        return (QyAllotRecord)this.baseDao.findFirstEntity("from QyAllotRecord where quantifyAllotId = ? and updateType = ?", new Object[]{id, QyAllotRecord.UPDATE_TYPE_MANUAL}, QyAllotRecord.class);
    }

    public QyAllotRecord getHistoryById(String id) {
        return (QyAllotRecord)this.baseDao.get(QyAllotRecord.class, (Serializable)((Object)id));
    }
}

