/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.allotorder;

import com.tcbj.crm.allotorder.AllotMainCondition;
import com.tcbj.crm.entity.AllotDetails;
import com.tcbj.crm.entity.AllotMain;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotmainService")
public class AllotMainService {
    @Autowired
    BaseDao baseDao;

    public void del(String id) {
        Object[] args = new Object[]{id};
        String hql = "delete AllotDetails where allotDetailsId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete AllotMain where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public Page findAllotMains(AllotMainCondition condition) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from AllotMain o where 1=1 ");
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(condition.getAllotOrderId())) {
            HQL.append(" and o.allotOrderId = ? ");
            args.add(condition.getAllotOrderId());
        }
        if (condition.getStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : condition.getStates()) {
                HQL.append(" state = ?");
                if (++i < condition.getStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public List<AllotDetails> getAllotDetailss(String id) {
        String hql = "from AllotDetails where allotMainId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, AllotDetails.class);
    }

    public AllotMain get(String id) {
        AllotMain obj = (AllotMain)this.baseDao.get(AllotMain.class, (Serializable)((Object)id));
        obj.setAllotDetailss(this.getAllotDetailss(id));
        return obj;
    }

    public AllotMain getSimpleAllotMain(String id) {
        return (AllotMain)this.baseDao.get(AllotMain.class, (Serializable)((Object)id));
    }

    public void saveOrUpdate(AllotMain allotMain) {
        if (StringUtils.isEmpty(allotMain.getId())) {
            this.baseDao.save((Object)allotMain);
            for (AllotDetails allotDetails : allotMain.getAllotDetailss()) {
                allotDetails.setAllotMainId(allotMain.getId());
            }
            this.baseDao.save(allotMain.getAllotDetailss());
        } else {
            this.baseDao.update((Object)allotMain);
            List<AllotDetails> newItemsAllotDetails = allotMain.getAllotDetailss();
            List<AllotDetails> itemsAllotDetails = this.getAllotDetailss(allotMain.getId());
            ArrayList updateItemsAllotDetails = new ArrayList();
            ArrayList<AllotDetails> appendItemsAllotDetails = new ArrayList<AllotDetails>();
            ArrayList<AllotDetails> delItemsAllotDetails = new ArrayList<AllotDetails>();
            for (AllotDetails ni : newItemsAllotDetails) {
                boolean isnew = true;
                for (AllotDetails i : itemsAllotDetails) {
                    if (!ni.getId().equals(i.getId())) continue;
                    isnew = false;
                    break;
                }
                if (!isnew) continue;
                ni.setId(UUIDUtils.getId());
                ni.setAllotMainId(allotMain.getId());
                appendItemsAllotDetails.add(ni);
            }
            for (AllotDetails i : itemsAllotDetails) {
                boolean isdel = true;
                for (AllotDetails ni : newItemsAllotDetails) {
                    if (!ni.getId().equals(i.getId())) continue;
                    isdel = false;
                    break;
                }
                if (!isdel) continue;
                delItemsAllotDetails.add(i);
            }
            if (appendItemsAllotDetails.size() > 0) {
                this.baseDao.save(appendItemsAllotDetails);
            }
            if (updateItemsAllotDetails.size() > 0) {
                this.baseDao.update(updateItemsAllotDetails);
            }
            if (delItemsAllotDetails.size() > 0) {
                this.baseDao.deleteAll(delItemsAllotDetails);
            }
        }
    }

    public void updateState(String id, String state) {
        String hql = "update AllotMain set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }

    public List<Storage> getAllotStorage(String partnerId) {
        String hql = " from Storage where dealerId =?";
        List list = this.baseDao.findEntity(hql, new Object[]{partnerId}, Storage.class);
        if (list != null) {
            return list;
        }
        return null;
    }

    public List<ShopView> getShopList(EmployeePartner partner, int type) {
        StringBuilder hql = new StringBuilder();
        hql.append(" from ShopView where  parentDealerId=?");
        if (type == 1) {
            hql.append(" and orgtype='Store' ");
        }
        Object[] args = new Object[]{partner.getId()};
        return this.baseDao.findEntity(hql.toString(), args, ShopView.class);
    }
}

