/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.aplfine;

import com.tcbj.crm.aplfine.AplfineCondition;
import com.tcbj.crm.aplfine.AplfineService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Aplfine;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.view.Employee;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/aplfine"})
public class AplfineController
extends BaseController {
    @Autowired
    AplfineService aplfineservice;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    OrderNoService orderNoService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        Aplfine aplfine = new Aplfine();
        aplfine.setFineNumber(this.orderNoService.maxNo(e.getCurrentPartner().getNo(), "06"));
        model.addAttribute("master", (Object)aplfine);
        return "aplfine/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody Aplfine aplfine, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        aplfine.fillInitData(e);
        aplfine.setPartnerId(e.getCurrentPartner().getId());
        this.aplfineservice.save(aplfine);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AplfineCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        condition.setEm(e);
        model.addAttribute("page", (Object)this.aplfineservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "aplfine/list.ftl";
    }

    @RequestMapping(value={"/seriallist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String seriallist(AplfineCondition condition, Model model) {
        model.addAttribute("list", this.aplfineservice.getserialList(condition));
        return "aplfine/seriallist.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee e = this.getCurrentEmployee();
        Aplfine aplfine = this.aplfineservice.get(id);
        model.addAttribute("master", (Object)aplfine);
        model.addAttribute("perList", this.personnelService.getPTS(e.getCurrentPartner().getId()));
        return "aplfine/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody Aplfine aplfine, BindingResult errors, Model model, HttpServletRequest request) {
        if (aplfine.getWithheldMoney() - aplfine.getFineMoney() > 0.0) {
            throw new AppException("7020");
        }
        Employee e = this.getCurrentEmployee();
        aplfine.fillInitData(e);
        this.aplfineservice.update(aplfine);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Aplfine aplfine = this.aplfineservice.get(id);
        model.addAttribute("master", (Object)aplfine);
        return "aplfine/look.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.aplfineservice.delete(id);
        return "redirect:/aplfine/list.do";
    }
}

