/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.backParam;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.backParam.BackParamCondition;
import com.tcbj.crm.backParam.BackParamService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.entity.BackParam;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/backParam"})
public class BackParamController
extends BaseController {
    @Autowired
    BackParamService backParamService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(BackParamCondition condition, Model model) {
        Page page = this.backParamService.getBackParamPage(condition);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        return "backParam/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String edit(String id, Model model) {
        BackParam backParam = this.backParamService.getBackParam(id);
        model.addAttribute("backParam", (Object)backParam);
        return "backParam/edit.ftl";
    }

    @RequestMapping(value={"/editPicture.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String editPicture(BackParam backParam, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> uploadFilelist = this.uploadFile(request, Constant.BACK_PARAM);
        IUploadFile file = null;
        if (uploadFilelist.size() > 0) {
            file = uploadFilelist.get(0);
        }
        this.backParamService.saveUpload(file, backParam, me, request);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/upload.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String upload() {
        return "/backParam/upload.ftl";
    }

    @RequestMapping(value={"/uploadPicture.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String UploadPicture(BackParam backParam, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        String url = Constant.BACK_PARAM;
        List<IUploadFile> uploadFilelist = this.uploadFile(request, "backParam");
        IUploadFile file = uploadFilelist.get(0);
        backParam.setFlag("0");
        backParam.setUrl(url);
        this.backParamService.saveUpload(file, backParam, me);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/start.do"})
    public String start(String id) throws UnsupportedEncodingException {
        this.backParamService.start(id);
        return "redirect:list.do";
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String id, String newCode, HttpServletRequest request) throws UnsupportedEncodingException {
        this.backParamService.delete(id, newCode, request);
        return "redirect:list.do";
    }
}

