/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.backParam;

import com.tcbj.crm.backParam.BackParamCondition;
import com.tcbj.crm.entity.BackParam;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="BackParamService")
public class BackParamService {
    @Autowired
    BaseDao baseDao;

    public Page getBackParamPage(BackParamCondition condition) {
        StringBuffer hql = new StringBuffer();
        hql.append("from BackParam where orgId = '").append(StringUtils.getPrefix()).append("'");
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and name like '%").append(condition.getName()).append("%'");
        }
        if (StringUtils.isNotEmpty(condition.getCode())) {
            hql.append(" and code like '%").append(condition.getCode()).append("%'");
        }
        hql.append(" order by created desc ");
        return this.baseDao.search(hql.toString(), new Object[0], Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public void saveUpload(IUploadFile file, BackParam backParam, Employee me) {
        backParam.setCode(file.getName().trim());
        backParam.setCreated(new Date());
        backParam.setPerson(me.getId());
        backParam.setNewCode(file.getWebPath());
        backParam.setOrgId(StringUtils.getPrefix());
        this.baseDao.save((Object)backParam);
    }

    public BackParam getBackParam(String id) {
        return (BackParam)this.baseDao.get(BackParam.class, (Serializable)((Object)id));
    }

    public void saveUpload(IUploadFile file, BackParam backParam, Employee me, HttpServletRequest request) {
        BackParam back = (BackParam)this.baseDao.get(BackParam.class, (Serializable)((Object)backParam.getId()));
        back.setName(backParam.getName());
        back.setColor(backParam.getColor());
        if (file != null) {
            back.setCode(file.getName().trim());
            back.setCreated(new Date());
            back.setPerson(me.getId());
            back.setNewCode(file.getWebPath());
            File f = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + backParam.getNewCode());
            if (f.exists()) {
                f.delete();
            }
        }
    }

    @Transactional
    public void start(String id) {
        this.baseDao.executeHQL("update BackParam set flag=0 where orgId = '" + StringUtils.getPrefix() + "' ");
        this.baseDao.executeHQL("update BackParam set flag=1 where id='" + id + "' ");
    }

    @Transactional
    public void delete(String id, String newCode, HttpServletRequest request) {
        this.baseDao.deleteById(BackParam.class, (Serializable)((Object)id));
        File f = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + newCode);
        if (f.exists()) {
            f.delete();
        }
    }

    public BackParam getFirstParam() {
        BackParam param = (BackParam)this.baseDao.findFirstEntity("from BackParam where flag=1 and  orgId = '" + StringUtils.getPrefix() + "' order by created desc ", BackParam.class);
        if (param == null) {
            param = new BackParam();
        }
        return param;
    }
}

