/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.budget;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.budget.BudgetCondition;
import com.tcbj.crm.budget.BudgetItemCondition;
import com.tcbj.crm.budget.BudgetService;
import com.tcbj.crm.budget.BudgetVaildateService;
import com.tcbj.crm.entity.Budget;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/budget"})
public class BudgetController
extends BaseController {
    @Autowired
    private BudgetService service;
    @Autowired
    BudgetVaildateService budgetVaildateService;

    @RequestMapping(value={"/list.do"})
    public String myapplys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") BudgetCondition con, Model model) {
        return this.findAllBudgets(pageno, con, model);
    }

    private String findAllBudgets(int pageno, BudgetCondition condition, Model model) {
        Employee e = this.getCurrentEmployee();
        Page budgets = this.service.findAllBudgets(condition, e, pageno);
        model.addAttribute("startDate", (Object)DateUtils.now());
        model.addAttribute("me", (Object)e);
        model.addAttribute("budgets", (Object)budgets);
        model.addAttribute("condition", (Object)condition);
        return "budget/list.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Budget budget = null;
        budget = StringUtils.isEmpty(id) ? new Budget() : this.service.getBudgetById(id);
        budget.fillInitData(me);
        model.addAttribute("id", (Object)id);
        model.addAttribute("curentYear", (Object)DateUtils.formartDate((Date)new Date(), (String)"yyyy"));
        model.addAttribute("me", (Object)me);
        model.addAttribute("budget", (Object)budget);
        return "budget/apply.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody Budget budget, String type, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        boolean flag = this.service.validateBudget(budget, me);
        if (!flag) {
            throw new AppException("9230", String.valueOf(budget.getTargetName()) + " " + budget.getYear());
        }
        budget.fillInitData(me);
        budget.setState(type);
        if (StringUtils.isEmpty(budget.getId())) {
            this.service.addBudget(budget, me);
        } else {
            this.service.updateBudget(budget, me);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del"})
    @ResponseBody
    public Result del(String id, Model model) {
        this.service.del(id);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/audits.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String audits(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") BudgetCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        Page audits = this.service.findBudgetAudits(con, pageno, me);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("me", (Object)me);
        model.addAttribute("budgets", (Object)audits);
        return "budget/audits.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Budget budget = this.service.getBudgetById(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("budget", (Object)budget);
        return "budget/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(String id, String state, String remark, Model model) {
        if (!state.equals(ShopEnum.ApproveState.pass.getValue()) && !state.equals(ShopEnum.ApproveState.notpass.getValue())) {
            state = ShopEnum.ApproveState.notpass.getValue();
        }
        Employee me = this.getCurrentEmployee();
        this.service.saveAudit(id, state, me, remark);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String viewBudget(String id, Model model) {
        Budget budget = this.service.getBudgetById(id);
        model.addAttribute("budget", (Object)budget);
        model.addAttribute("hideaudit", (Object)true);
        return "budget/view.ftl";
    }

    @RequestMapping(value={"orgList.do"})
    public String get_orgList(BudgetItemCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        Page page = this.service.getOrgPage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/orgList.ftl";
    }

    @RequestMapping(value={"orgEdit.do"}, method={RequestMethod.GET})
    public String get_orgAdd(BudgetItemCondition con, Model model) throws Exception {
        List<BudgetItem> Items = this.service.getItems(con);
        model.addAttribute("items", (Object)JSON.toJSONString(Items));
        model.addAttribute("con", (Object)con);
        return "budget/orgEdit.ftl";
    }

    @RequestMapping(value={"orgEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result get_postEdit(@Valid @RequestBody Budget budget, BindingResult errors, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(budget.getDelIds())) {
            String[] stringArray = budget.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.delete(id);
                ++n2;
            }
        }
        BudgetItemCondition con = new BudgetItemCondition();
        Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 1);
        Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 1);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            if (dbMap.get(entry.getKey()) == null || !(entry.getValue() < dbMap.get(entry.getKey()))) continue;
            throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u7ec4\u7ec7\u5b9a\u4e49\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6e20\u9053\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
        }
        this.service.addAndupdate(budget, me);
        return this.getSuccessResult(budget.getId());
    }

    @RequestMapping(value={"channelList.do"})
    public String channel_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, BudgetItemCondition con, Model model) {
        Page page = this.service.getChannelPage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/channelList.ftl";
    }

    @RequestMapping(value={"channelEdit.do"}, method={RequestMethod.GET})
    public String get_cahnnelAdd(BudgetItemCondition con, Model model) throws Exception {
        List<BudgetItem> Items = this.service.getChannels(con);
        model.addAttribute("items", (Object)JSON.toJSONString(Items));
        model.addAttribute("con", (Object)con);
        return "budget/channelEdit.ftl";
    }

    @RequestMapping(value={"channelEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_ChannelEdit(@Valid @RequestBody Budget budget, BindingResult errors, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(budget.getDelIds())) {
            String[] stringArray = budget.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.delete(id);
                ++n2;
            }
        }
        BudgetItemCondition con = new BudgetItemCondition();
        con.setBudgetId(budget.getId());
        Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 1);
        Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 1);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            if (dbMap.get(entry.getKey()) != null) {
                if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u5b9a\u4e49\u91d1\u989d,\u8d85\u51fa\u7ec4\u7ec7\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
            }
            throw new AppException("0010", String.valueOf(entry.getKey()) + "\u5728\u7ec4\u7ec7\u672a\u5b9a\u4e49\u3002");
        }
        Map<String, Double> dbMap2 = this.budgetVaildateService.getOrgMapDB2(con, 2);
        Map<String, Double> map2 = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 2);
        for (Map.Entry<String, Double> entry : map2.entrySet()) {
            if (dbMap2.get(entry.getKey()) == null || !(entry.getValue() < dbMap2.get(entry.getKey()))) continue;
            throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u6e20\u9053\u5b9a\u4e49\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5927\u533a\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
        }
        this.service.addAndupdate(budget, me);
        return this.getSuccessResult(budget.getId());
    }

    @RequestMapping(value={"bigAreaList.do"})
    public String bigArea_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, BudgetItemCondition con, Model model) {
        Page page = this.service.getBigAreaPage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/bigAreaList.ftl";
    }

    @RequestMapping(value={"bigAreaEdit.do"}, method={RequestMethod.GET})
    public String get_bigArea(BudgetItemCondition con, Model model) throws Exception {
        List<BudgetItem> Items = this.service.getBigAreas(con);
        model.addAttribute("items", (Object)JSON.toJSONString(Items));
        model.addAttribute("con", (Object)con);
        return "budget/bigAreaEdit.ftl";
    }

    @RequestMapping(value={"bigAreaEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_bigAreaEdit(@Valid @RequestBody Budget budget, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(budget.getDelIds())) {
            String[] stringArray = budget.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.delete(id);
                ++n2;
            }
        }
        BudgetItemCondition con = new BudgetItemCondition();
        con.setBudgetId(budget.getId());
        Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 2);
        Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 2);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            if (dbMap.get(entry.getKey()) != null) {
                if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u5b9a\u4e49\u91d1\u989d,\u8d85\u51fa\u6e20\u9053\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
            }
            throw new AppException("0010", String.valueOf(entry.getKey()) + "\u5728\u6e20\u9053\u672a\u5b9a\u4e49\u3002");
        }
        Map<String, Double> dbMap2 = this.budgetVaildateService.getOrgMapDB2(con, 3);
        Map<String, Double> map2 = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 3);
        for (Map.Entry<String, Double> entry : map2.entrySet()) {
            if (dbMap2.get(entry.getKey()) == null || !(entry.getValue() < dbMap2.get(entry.getKey()))) continue;
            throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u5927\u533a\u5b9a\u4e49\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u533a\u57df\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
        }
        this.service.addAndupdate(budget, me);
        return this.getSuccessResult(budget.getId());
    }

    @RequestMapping(value={"areaList.do"})
    public String area_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, BudgetItemCondition con, Model model) {
        Page page = this.service.getAreaPage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/areaList.ftl";
    }

    @RequestMapping(value={"areaEdit.do"}, method={RequestMethod.GET})
    public String get_area(BudgetItemCondition con, Model model) throws Exception {
        List<BudgetItem> Items = this.service.getAreas(con);
        model.addAttribute("items", (Object)JSON.toJSONString(Items));
        model.addAttribute("con", (Object)con);
        return "budget/areaEdit.ftl";
    }

    @RequestMapping(value={"areaEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_areaEdit(@Valid @RequestBody Budget budget, BindingResult errors, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(budget.getDelIds())) {
            String[] stringArray = budget.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.delete(id);
                ++n2;
            }
        }
        BudgetItemCondition con = new BudgetItemCondition();
        con.setBudgetId(budget.getId());
        Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 3);
        Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 3);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            if (dbMap.get(entry.getKey()) != null) {
                if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u5b9a\u4e49\u91d1\u989d,\u8d85\u51fa\u5927\u533a\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
            }
            throw new AppException("0010", String.valueOf(entry.getKey()) + "\u5728\u5927\u533a\u672a\u5b9a\u4e49\u3002");
        }
        Map<String, Double> dbMap2 = this.budgetVaildateService.getOrgMapDB2(con, 4);
        Map<String, Double> map2 = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 4);
        for (Map.Entry<String, Double> entry : map2.entrySet()) {
            if (dbMap2.get(entry.getKey()) == null || !(entry.getValue() < dbMap2.get(entry.getKey()))) continue;
            throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u533a\u57df\u5b9a\u4e49\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u4eba\u5458\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
        }
        this.service.addAndupdate(budget, me);
        return this.getSuccessResult(budget.getId());
    }

    @RequestMapping(value={"customerList.do"})
    public String customer_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, BudgetItemCondition con, Model model) {
        Page page = this.service.getCustomerPage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/customerList.ftl";
    }

    @RequestMapping(value={"customerEdit.do"}, method={RequestMethod.GET})
    public String get_customer(BudgetItemCondition con, Model model) throws Exception {
        List<BudgetItem> Items = this.service.getCustomers(con);
        model.addAttribute("items", (Object)JSON.toJSONString(Items));
        model.addAttribute("con", (Object)con);
        return "budget/customerEdit.ftl";
    }

    @RequestMapping(value={"customerEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_customerEdit(@Valid @RequestBody Budget budget, BindingResult errors, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(budget.getDelIds())) {
            String[] stringArray = budget.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.delete(id);
                ++n2;
            }
        }
        BudgetItemCondition con = new BudgetItemCondition();
        con.setBudgetId(budget.getId());
        List<BudgetItem> Items = this.service.getEmployees(con);
        budget.getList().addAll(Items);
        Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 4);
        Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 4);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            if (dbMap.get(entry.getKey()) != null) {
                if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u5b9a\u4e49\u91d1\u989d,\u8d85\u51fa\u533a\u57df\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
            }
            throw new AppException("0010", String.valueOf(entry.getKey()) + "\u5728\u533a\u57df\u672a\u5b9a\u4e49\u3002");
        }
        this.service.addAndupdate(budget, me);
        return this.getSuccessResult(budget.getId());
    }

    @RequestMapping(value={"employeeList.do"})
    public String employee_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, BudgetItemCondition con, Model model) {
        Page page = this.service.getEmployeePage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/employeeList.ftl";
    }

    @RequestMapping(value={"employeeEdit.do"}, method={RequestMethod.GET})
    public String get_employees(BudgetItemCondition con, Model model) throws Exception {
        List<BudgetItem> Items = this.service.getEmployees(con);
        model.addAttribute("items", (Object)JSON.toJSONString(Items));
        model.addAttribute("con", (Object)con);
        return "budget/employeeEdit.ftl";
    }

    @RequestMapping(value={"employeeEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_employeeEdit(@Valid @RequestBody Budget budget, BindingResult errors, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(budget.getDelIds())) {
            String[] stringArray = budget.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.delete(id);
                ++n2;
            }
        }
        BudgetItemCondition con = new BudgetItemCondition();
        con.setBudgetId(budget.getId());
        List<BudgetItem> Items = this.service.getCustomers(con);
        budget.getList().addAll(Items);
        Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 4);
        Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(budget.getList(), 4);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            if (dbMap.get(entry.getKey()) != null) {
                if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                throw new AppException("0010", String.valueOf(entry.getKey()) + ",\u8be5\u884c\u5b9a\u4e49\u91d1\u989d,\u8d85\u51fa\u533a\u57df\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002");
            }
            throw new AppException("0010", String.valueOf(entry.getKey()) + "\u5728\u533a\u57df\u672a\u5b9a\u4e49\u3002");
        }
        this.service.addAndupdate(budget, me);
        return this.getSuccessResult(budget.getId());
    }

    @RequestMapping(value={"orgDel.do"})
    public String delete(BudgetItemCondition con, Model model) {
        BudgetItem item = this.service.getItem(con.getId());
        item.setState("-1");
        this.service.updateItem(item);
        if (StringUtils.isNotEmpty(con.getDelState())) {
            if (con.getDelState().equals("1")) {
                return "redirect:channelList.do?budgetId=" + con.getBudgetId() + "&budgetState=" + con.getBudgetState();
            }
            if (con.getDelState().equals("2")) {
                return "redirect:bigAreaList.do?budgetId=" + con.getBudgetId() + "&budgetState=" + con.getBudgetState();
            }
            if (con.getDelState().equals("3")) {
                return "redirect:areaList.do?budgetId=" + con.getBudgetId() + "&budgetState=" + con.getBudgetState();
            }
            if (con.getDelState().equals("4")) {
                return "redirect:employeeList.do?budgetId=" + con.getBudgetId() + "&budgetState=" + con.getBudgetState();
            }
            if (con.getDelState().equals("5")) {
                return "redirect:customerList.do?budgetId=" + con.getBudgetId() + "&budgetState=" + con.getBudgetState();
            }
        }
        return "redirect:orgList.do?budgetId=" + con.getBudgetId() + "&budgetState=" + con.getBudgetState();
    }

    @RequestMapping(value={"allList.do"})
    public String get_allList(BudgetItemCondition con, Model model, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        Page page = this.service.getAllPage(con, pageno);
        List list = page.getList();
        ArrayList allList = new ArrayList();
        ArrayList<BudgetItem> chanList = new ArrayList<BudgetItem>();
        ArrayList<BudgetItem> bigList = new ArrayList<BudgetItem>();
        ArrayList<BudgetItem> areaList = new ArrayList<BudgetItem>();
        ArrayList<BudgetItem> cusList = new ArrayList<BudgetItem>();
        String subType = "";
        if (list.size() > 0) {
            subType = ((BudgetItem)list.get(0)).getSubType();
        }
        for (BudgetItem budgetItem : list) {
            if (!subType.equals(budgetItem.getSubType())) {
                allList.addAll(chanList);
                allList.addAll(bigList);
                allList.addAll(areaList);
                allList.addAll(cusList);
                chanList = new ArrayList();
                bigList = new ArrayList();
                areaList = new ArrayList();
                cusList = new ArrayList();
                subType = budgetItem.getSubType();
            }
            if (budgetItem.getChannelId() == null || "".equals(budgetItem.getChannelId())) {
                allList.add(budgetItem);
                continue;
            }
            if (budgetItem.getBigareaId() == null || "".equals(budgetItem.getBigareaId())) {
                chanList.add(budgetItem);
                continue;
            }
            if (budgetItem.getAreaId() == null || "".equals(budgetItem.getAreaId())) {
                bigList.add(budgetItem);
                continue;
            }
            if (budgetItem.getCustomerId() == null || "".equals(budgetItem.getCustomerId())) {
                areaList.add(budgetItem);
                continue;
            }
            cusList.add(budgetItem);
        }
        allList.addAll(chanList);
        allList.addAll(bigList);
        allList.addAll(areaList);
        allList.addAll(cusList);
        page.setList(allList);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "budget/allList.ftl";
    }
}

