/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.budget;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.budget.BudgetItemCondition;
import com.tcbj.crm.budget.BudgetService;
import com.tcbj.crm.budget.BudgetVaildateService;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excelVaildateService")
public class ExcelVaildateService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ClientService clientService;
    @Autowired
    Cache cache;
    @Autowired
    BudgetService budgetService;
    @Autowired
    BudgetVaildateService budgetVaildateService;
    private final Logger LOG = LoggerFactory.getLogger(ExcelVaildateService.class);

    public List<AdjustStockUtil> readOrgByExcel(String filePath, Employee em, List<BudgetItem> list, BudgetItemCondition con) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block21: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block21;
            return null;
        }
        try {
            Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_EXPENSE_TYPE");
            Map<String, String> expenseSubTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
            String message = null;
            String result = null;
            BudgetItem budgetItem = null;
            int j = 1;
            while (j < myR) {
                budgetItem = new BudgetItem();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(1, j).getContents(), expenseTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setType(expenseTypeMap.get(ExcelVaildateService.str(st.getCell(1, j).getContents())));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(2, j).getContents(), expenseSubTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u9879\u76ee \uff1a" + message;
                } else {
                    budgetItem.setSubType(expenseSubTypeMap.get(ExcelVaildateService.str(st.getCell(2, j).getContents())));
                }
                message = ValidataUtils.validataDouble((Object)st.getCell(3, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u91d1\u989d \uff1a" + message;
                } else {
                    budgetItem.setAmount(Double.valueOf(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                    budgetItem.setAmountUpt(Double.valueOf(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                this.init(con.getBudgetId(), budgetItem, em);
                list.add(budgetItem);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            BudgetItem t1 = null;
            BudgetItem t2 = null;
            String s1 = null;
            String s2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getType()) + t1.getSubType();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getType()) + t2.getSubType();
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            List<BudgetItem> sqlList = this.budgetService.getItems(con);
            int k2 = 0;
            while (k2 < sqlList.size()) {
                t1 = sqlList.get(k2);
                s1 = String.valueOf(t1.getType()) + t1.getSubType();
                int k22 = 0;
                while (k22 < list.size()) {
                    t2 = list.get(k22);
                    s2 = String.valueOf(t2.getType()) + t2.getSubType();
                    if (s1.equals(s2)) {
                        t2.setId(t1.getId());
                    }
                    ++k22;
                }
                ++k2;
            }
            Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB2(con, 1);
            Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(list, 1);
            for (Map.Entry<String, Double> entry : dbMap.entrySet()) {
                if (map.get(entry.getKey()) == null || !(entry.getValue() > map.get(entry.getKey()))) continue;
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u4e0d\u80fd\u4f4e\u4e8e\u6e20\u9053\u603b\u91d1\u989d\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> readChannelByExcel(String filePath, Employee em, List<BudgetItem> list, BudgetItemCondition con) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block28: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block28;
            return null;
        }
        try {
            Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_EXPENSE_TYPE");
            Map<String, String> expenseSubTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
            Map<String, String> channeiMap = this.budgetVaildateService.getChannelTypeMap(em.getCurrentPartner().getId());
            String message = null;
            String result = null;
            BudgetItem budgetItem = null;
            int j = 1;
            while (j < myR) {
                budgetItem = new BudgetItem();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(1, j).getContents(), channeiMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u6e20\u9053 \uff1a" + message;
                } else {
                    budgetItem.setChannelId(channeiMap.get(ExcelVaildateService.str(st.getCell(1, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(2, j).getContents(), expenseTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setType(expenseTypeMap.get(ExcelVaildateService.str(st.getCell(2, j).getContents())));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(3, j).getContents(), expenseSubTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u5b50\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setSubType(expenseSubTypeMap.get(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                }
                message = ValidataUtils.validataDouble((Object)st.getCell(4, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u91d1\u989d \uff1a" + message;
                } else {
                    budgetItem.setAmount(Double.valueOf(ExcelVaildateService.str(st.getCell(4, j).getContents())));
                    budgetItem.setAmountUpt(Double.valueOf(ExcelVaildateService.str(st.getCell(4, j).getContents())));
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                this.init(con.getBudgetId(), budgetItem, em);
                list.add(budgetItem);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            BudgetItem t1 = null;
            BudgetItem t2 = null;
            String s1 = null;
            String s2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getChannelId()) + t1.getType() + t1.getSubType();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 1);
            List<BudgetItem> sqlList = this.budgetService.getChannels(con);
            ArrayList<BudgetItem> allList = new ArrayList<BudgetItem>();
            allList.addAll(list);
            HashMap<String, BudgetItem> listMap = new HashMap<String, BudgetItem>();
            for (BudgetItem budgetItem2 : list) {
                listMap.put(String.valueOf(budgetItem2.getTypeName()) + "," + budgetItem2.getSubTypeName(), budgetItem2);
            }
            for (BudgetItem budgetItem2 : sqlList) {
                if (listMap.get(String.valueOf(budgetItem2.getTypeName()) + "," + budgetItem2.getSubTypeName()) != null) continue;
                allList.add(budgetItem2);
            }
            Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(allList, 1);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (dbMap.get(entry.getKey()) != null) {
                    if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                    megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u8d85\u51fa\u7ec4\u7ec7\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002"));
                    continue;
                }
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u5728\u7ec4\u7ec7\u672a\u5b9a\u4e49\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap2 = this.budgetVaildateService.getOrgMapDB2(con, 2);
            Map<String, Double> map2 = this.budgetVaildateService.getChannelCountAmount(allList, 2);
            for (Map.Entry<String, Double> entry : dbMap2.entrySet()) {
                if (map2.get(entry.getKey()) == null || !(entry.getValue() > map2.get(entry.getKey()))) continue;
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u4e0d\u80fd\u4f4e\u4e8e\u5927\u533a\u603b\u91d1\u989d\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            int k2 = 0;
            while (k2 < sqlList.size()) {
                t1 = sqlList.get(k2);
                s1 = String.valueOf(t1.getChannelId()) + t1.getType() + t1.getSubType();
                int k22 = 0;
                while (k22 < list.size()) {
                    t2 = list.get(k22);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        t2.setId(t1.getId());
                    }
                    ++k22;
                }
                ++k2;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> readBigAreaByExcel(String filePath, Employee em, List<BudgetItem> list, BudgetItemCondition con) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block30: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block30;
            return null;
        }
        try {
            Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_EXPENSE_TYPE");
            Map<String, String> expenseSubTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
            Map<String, String> channeiMap = this.budgetVaildateService.getChannelTypeMap(em.getCurrentPartner().getId());
            Map<String, String> bigAreaMap = this.budgetVaildateService.getBigAreaMap(em.getCurrentPartner().getId());
            String message = null;
            String result = null;
            BudgetItem budgetItem = null;
            int j = 1;
            while (j < myR) {
                budgetItem = new BudgetItem();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(1, j).getContents(), channeiMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u6e20\u9053 \uff1a" + message;
                } else {
                    budgetItem.setChannelId(channeiMap.get(ExcelVaildateService.str(st.getCell(1, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(2, j).getContents(), bigAreaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message;
                } else {
                    budgetItem.setBigareaId(bigAreaMap.get(ExcelVaildateService.str(st.getCell(2, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(3, j).getContents(), expenseTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setType(expenseTypeMap.get(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(4, j).getContents(), expenseSubTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u5b50\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setSubType(expenseSubTypeMap.get(ExcelVaildateService.str(st.getCell(4, j).getContents())));
                }
                message = ValidataUtils.validataDouble((Object)st.getCell(5, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u91d1\u989d \uff1a" + message;
                } else {
                    budgetItem.setAmount(Double.valueOf(ExcelVaildateService.str(st.getCell(5, j).getContents())));
                    budgetItem.setAmountUpt(Double.valueOf(ExcelVaildateService.str(st.getCell(5, j).getContents())));
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                this.init(con.getBudgetId(), budgetItem, em);
                budgetItem.fillInitData(em);
                list.add(budgetItem);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            BudgetItem t1 = null;
            BudgetItem t2 = null;
            String s1 = null;
            String s2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getType() + t1.getSubType();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 2);
            List<BudgetItem> sqlList = this.budgetService.getBigAreas(con);
            ArrayList<BudgetItem> allList = new ArrayList<BudgetItem>();
            allList.addAll(list);
            HashMap<String, BudgetItem> listMap = new HashMap<String, BudgetItem>();
            for (BudgetItem budgetItem2 : list) {
                listMap.put(String.valueOf(budgetItem2.getChannelName()) + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName(), budgetItem2);
            }
            for (BudgetItem budgetItem2 : sqlList) {
                if (listMap.get(String.valueOf(budgetItem2.getChannelName()) + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName()) != null) continue;
                allList.add(budgetItem2);
            }
            Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(allList, 2);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (dbMap.get(entry.getKey()) != null) {
                    if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                    megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u8d85\u51fa\u6e20\u9053\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002"));
                    continue;
                }
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u5728\u6e20\u9053\u672a\u5b9a\u4e49\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap2 = this.budgetVaildateService.getOrgMapDB2(con, 3);
            Map<String, Double> map2 = this.budgetVaildateService.getChannelCountAmount(allList, 3);
            for (Map.Entry<String, Double> entry : dbMap2.entrySet()) {
                if (map2.get(entry.getKey()) == null || !(entry.getValue() > map2.get(entry.getKey()))) continue;
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u4e0d\u80fd\u4f4e\u4e8e\u533a\u57df\u603b\u91d1\u989d\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            int k2 = 0;
            while (k2 < sqlList.size()) {
                t1 = sqlList.get(k2);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getType() + t1.getSubType();
                int k22 = 0;
                while (k22 < list.size()) {
                    t2 = list.get(k22);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        t2.setId(t1.getId());
                    }
                    ++k22;
                }
                ++k2;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> readAreaByExcel(String filePath, Employee em, List<BudgetItem> list, BudgetItemCondition con) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block32: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block32;
            return null;
        }
        try {
            Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_EXPENSE_TYPE");
            Map<String, String> expenseSubTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
            Map<String, String> channeiMap = this.budgetVaildateService.getChannelTypeMap(em.getCurrentPartner().getId());
            Map<String, String> bigAreaMap = this.budgetVaildateService.getBigAreaMap(em.getCurrentPartner().getId());
            Map<String, String> areaMap = this.budgetVaildateService.getAreaMap(em.getCurrentPartner().getId());
            String message = null;
            String result = null;
            BudgetItem budgetItem = null;
            int j = 1;
            while (j < myR) {
                budgetItem = new BudgetItem();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(1, j).getContents(), channeiMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u6e20\u9053 \uff1a" + message;
                } else {
                    budgetItem.setChannelId(channeiMap.get(ExcelVaildateService.str(st.getCell(1, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(2, j).getContents(), bigAreaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message;
                } else {
                    budgetItem.setBigareaId(bigAreaMap.get(ExcelVaildateService.str(st.getCell(2, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(3, j).getContents(), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message;
                } else {
                    budgetItem.setAreaId(areaMap.get(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(4, j).getContents(), expenseTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setType(expenseTypeMap.get(ExcelVaildateService.str(st.getCell(4, j).getContents())));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(5, j).getContents(), expenseSubTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u5b50\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setSubType(expenseSubTypeMap.get(ExcelVaildateService.str(st.getCell(5, j).getContents())));
                }
                message = ValidataUtils.validataDouble((Object)st.getCell(6, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u91d1\u989d \uff1a" + message;
                } else {
                    budgetItem.setAmount(Double.valueOf(ExcelVaildateService.str(st.getCell(6, j).getContents())));
                    budgetItem.setAmountUpt(Double.valueOf(ExcelVaildateService.str(st.getCell(6, j).getContents())));
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                this.init(con.getBudgetId(), budgetItem, em);
                list.add(budgetItem);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            BudgetItem t1 = null;
            BudgetItem t2 = null;
            String s1 = null;
            String s2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getAreaId() + t1.getType() + t1.getSubType();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getAreaId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 3);
            List<BudgetItem> sqlList = this.budgetService.getAreas(con);
            ArrayList<BudgetItem> allList = new ArrayList<BudgetItem>();
            allList.addAll(list);
            HashMap<String, BudgetItem> listMap = new HashMap<String, BudgetItem>();
            for (BudgetItem budgetItem2 : list) {
                listMap.put(String.valueOf(budgetItem2.getBigAreaName()) + "," + budgetItem2.getChannelName() + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName(), budgetItem2);
            }
            for (BudgetItem budgetItem2 : sqlList) {
                if (listMap.get(String.valueOf(budgetItem2.getBigAreaName()) + "," + budgetItem2.getChannelName() + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName()) != null) continue;
                allList.add(budgetItem2);
            }
            Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(allList, 3);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (dbMap.get(entry.getKey()) != null) {
                    if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                    megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u8d85\u51fa\u5927\u533a\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002"));
                    continue;
                }
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u5728\u5927\u533a\u672a\u5b9a\u4e49\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap2 = this.budgetVaildateService.getOrgMapDB2(con, 4);
            Map<String, Double> map2 = this.budgetVaildateService.getChannelCountAmount(allList, 4);
            for (Map.Entry<String, Double> entry : dbMap2.entrySet()) {
                if (map2.get(entry.getKey()) == null || !(entry.getValue() > map2.get(entry.getKey()))) continue;
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u4e0d\u80fd\u4f4e\u4e8e\u4eba\u5458 \u603b\u91d1\u989d\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            int k2 = 0;
            while (k2 < sqlList.size()) {
                t1 = sqlList.get(k2);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getAreaId() + t1.getType() + t1.getSubType();
                int k22 = 0;
                while (k22 < list.size()) {
                    t2 = list.get(k22);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getAreaId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        t2.setId(t1.getId());
                    }
                    ++k22;
                }
                ++k2;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> readEmployeeByExcel(String filePath, Employee em, List<BudgetItem> list, BudgetItemCondition con) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block32: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block32;
            return null;
        }
        try {
            Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_EXPENSE_TYPE");
            Map<String, String> expenseSubTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
            Map<String, String> channeiMap = this.budgetVaildateService.getChannelTypeMap(em.getCurrentPartner().getId());
            Map<String, String> bigAreaMap = this.budgetVaildateService.getBigAreaMap(em.getCurrentPartner().getId());
            Map<String, String> areaMap = this.budgetVaildateService.getAreaMap(em.getCurrentPartner().getId());
            Map<String, String> employeeMap = this.budgetVaildateService.getEmployeeMap(em.getCurrentPartner().getId());
            String message = null;
            String result = null;
            BudgetItem budgetItem = null;
            int j = 1;
            while (j < myR) {
                budgetItem = new BudgetItem();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(1, j).getContents(), channeiMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u6e20\u9053 \uff1a" + message;
                } else {
                    budgetItem.setChannelId(channeiMap.get(ExcelVaildateService.str(st.getCell(1, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(2, j).getContents(), bigAreaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message;
                } else {
                    budgetItem.setBigareaId(bigAreaMap.get(ExcelVaildateService.str(st.getCell(2, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(3, j).getContents(), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message;
                } else {
                    budgetItem.setAreaId(areaMap.get(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(4, j).getContents(), employeeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4eba\u5458 \uff1a" + message;
                } else {
                    budgetItem.setSellerId(employeeMap.get(ExcelVaildateService.str(st.getCell(4, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(5, j).getContents(), expenseTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setType(expenseTypeMap.get(ExcelVaildateService.str(st.getCell(5, j).getContents())));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(6, j).getContents(), expenseSubTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u5b50\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setSubType(expenseSubTypeMap.get(ExcelVaildateService.str(st.getCell(6, j).getContents())));
                }
                message = ValidataUtils.validataDouble((Object)st.getCell(7, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u91d1\u989d \uff1a" + message;
                } else {
                    budgetItem.setAmount(Double.valueOf(ExcelVaildateService.str(st.getCell(7, j).getContents())));
                    budgetItem.setAmountUpt(Double.valueOf(ExcelVaildateService.str(st.getCell(7, j).getContents())));
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                this.init(con.getBudgetId(), budgetItem, em);
                list.add(budgetItem);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            BudgetItem t1 = null;
            BudgetItem t2 = null;
            String s1 = null;
            String s2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getAreaId() + t1.getSellerId() + t1.getType() + t1.getSubType();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getAreaId() + t2.getSellerId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 4);
            List<BudgetItem> sqlList = this.budgetService.getEmployees(con);
            List<BudgetItem> sqlList2 = this.budgetService.getCustomers(con);
            ArrayList<BudgetItem> allList = new ArrayList<BudgetItem>();
            allList.addAll(list);
            allList.addAll(sqlList2);
            HashMap<String, BudgetItem> listMap = new HashMap<String, BudgetItem>();
            for (BudgetItem budgetItem2 : list) {
                listMap.put(String.valueOf(budgetItem2.getBigAreaName()) + "," + budgetItem2.getChannelName() + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName(), budgetItem2);
            }
            for (BudgetItem budgetItem2 : sqlList) {
                if (listMap.get(String.valueOf(budgetItem2.getBigAreaName()) + "," + budgetItem2.getChannelName() + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName()) != null) continue;
                allList.add(budgetItem2);
            }
            Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(allList, 4);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (dbMap.get(entry.getKey()) != null) {
                    if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                    megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u8d85\u51fa\u5927\u533a\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002"));
                    continue;
                }
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u5728\u5927\u533a\u672a\u5b9a\u4e49\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            int k2 = 0;
            while (k2 < sqlList.size()) {
                t1 = sqlList.get(k2);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getAreaId() + t1.getSellerId() + t1.getType() + t1.getSubType();
                int k22 = 0;
                while (k22 < list.size()) {
                    t2 = list.get(k22);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getAreaId() + t2.getSellerId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        t2.setId(t1.getId());
                    }
                    ++k22;
                }
                ++k2;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> readCustomerByExcel(String filePath, Employee em, List<BudgetItem> list, BudgetItemCondition con) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block32: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block32;
            return null;
        }
        try {
            Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_EXPENSE_TYPE");
            Map<String, String> expenseSubTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
            Map<String, String> channeiMap = this.budgetVaildateService.getChannelTypeMap(em.getCurrentPartner().getId());
            Map<String, String> bigAreaMap = this.budgetVaildateService.getBigAreaMap(em.getCurrentPartner().getId());
            Map<String, String> areaMap = this.budgetVaildateService.getAreaMap(em.getCurrentPartner().getId());
            Map<String, String> customerMap = this.budgetVaildateService.getCustomerMap(em.getCurrentPartner().getId());
            String message = null;
            String result = null;
            BudgetItem budgetItem = null;
            int j = 1;
            while (j < myR) {
                budgetItem = new BudgetItem();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(1, j).getContents(), channeiMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u6e20\u9053 \uff1a" + message;
                } else {
                    budgetItem.setChannelId(channeiMap.get(ExcelVaildateService.str(st.getCell(1, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(2, j).getContents(), bigAreaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message;
                } else {
                    budgetItem.setBigareaId(bigAreaMap.get(ExcelVaildateService.str(st.getCell(2, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(3, j).getContents(), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message;
                } else {
                    budgetItem.setAreaId(areaMap.get(ExcelVaildateService.str(st.getCell(3, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(4, j).getContents(), customerMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5ba2\u6237 \uff1a" + message;
                } else {
                    budgetItem.setCustomerId(customerMap.get(ExcelVaildateService.str(st.getCell(4, j).getContents())));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(5, j).getContents(), expenseTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setType(expenseTypeMap.get(ExcelVaildateService.str(st.getCell(5, j).getContents())));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(6, j).getContents(), expenseSubTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u8d39\u7528\u5b50\u7c7b\u578b \uff1a" + message;
                } else {
                    budgetItem.setSubType(expenseSubTypeMap.get(ExcelVaildateService.str(st.getCell(6, j).getContents())));
                }
                message = ValidataUtils.validataDouble((Object)st.getCell(7, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u91d1\u989d \uff1a" + message;
                } else {
                    budgetItem.setAmount(Double.valueOf(ExcelVaildateService.str(st.getCell(7, j).getContents())));
                    budgetItem.setAmountUpt(Double.valueOf(ExcelVaildateService.str(st.getCell(7, j).getContents())));
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                this.init(con.getBudgetId(), budgetItem, em);
                list.add(budgetItem);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            BudgetItem t1 = null;
            BudgetItem t2 = null;
            String s1 = null;
            String s2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getAreaId() + t1.getCustomerId() + t1.getType() + t1.getSubType();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getAreaId() + t2.getCustomerId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Map<String, Double> dbMap = this.budgetVaildateService.getOrgMapDB(con, 4);
            List<BudgetItem> sqlList = this.budgetService.getCustomers(con);
            List<BudgetItem> sqlList2 = this.budgetService.getEmployees(con);
            ArrayList<BudgetItem> allList = new ArrayList<BudgetItem>();
            allList.addAll(list);
            allList.addAll(sqlList2);
            HashMap<String, BudgetItem> listMap = new HashMap<String, BudgetItem>();
            for (BudgetItem budgetItem2 : list) {
                listMap.put(String.valueOf(budgetItem2.getBigAreaName()) + "," + budgetItem2.getChannelName() + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName(), budgetItem2);
            }
            for (BudgetItem budgetItem2 : sqlList) {
                if (listMap.get(String.valueOf(budgetItem2.getBigAreaName()) + "," + budgetItem2.getChannelName() + "," + budgetItem2.getTypeName() + "," + budgetItem2.getSubTypeName()) != null) continue;
                allList.add(budgetItem2);
            }
            Map<String, Double> map = this.budgetVaildateService.getChannelCountAmount(allList, 4);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (dbMap.get(entry.getKey()) != null) {
                    if (!(entry.getValue() > dbMap.get(entry.getKey()))) continue;
                    megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u8d85\u51fa\u5927\u533a\u5b9a\u4e49\u91d1\u989d\u4e0a\u9650\u3002"));
                    continue;
                }
                megs.add(new AdjustStockUtil(String.valueOf(entry.getKey()) + "\u5728\u5927\u533a\u672a\u5b9a\u4e49\u3002"));
            }
            if (megs.size() > 0) {
                return megs;
            }
            int k2 = 0;
            while (k2 < sqlList.size()) {
                t1 = sqlList.get(k2);
                s1 = String.valueOf(t1.getChannelId()) + t1.getBigareaId() + t1.getAreaId() + t1.getCustomerId() + t1.getType() + t1.getSubType();
                int k22 = 0;
                while (k22 < list.size()) {
                    t2 = list.get(k22);
                    s2 = String.valueOf(t2.getChannelId()) + t2.getBigareaId() + t2.getAreaId() + t2.getCustomerId() + t2.getType() + t2.getSubType();
                    if (s1.equals(s2)) {
                        t2.setId(t1.getId());
                    }
                    ++k22;
                }
                ++k2;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    private void init(String pid, BudgetItem budgetItem, Employee em) {
        budgetItem.setPartnerId(em.getCurrentPartner().getId());
        budgetItem.setBudgetId(pid);
        budgetItem.setState("0");
        budgetItem.setUsedAmount(0.0);
        budgetItem.setTempAmount(0.0);
        budgetItem.setUsingAmount(0.0);
        budgetItem.fillInitData(em);
    }

    private Map<String, String> getItenMap(String type) {
        List<DictionaryItem> items = Cache.getItems(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : items) {
            map.put(dictionaryItem.getVal(), dictionaryItem.getName());
        }
        return map;
    }

    public static String str(String str) {
        if (str == null || "".equals(str.trim()) || "NULL".equals(str.toUpperCase())) {
            str = "";
        }
        return str.trim();
    }

    public void initMap(Map<String, String> cusMap, String partnerId, String userId) {
        List<Customer> list = this.clientService.findRegionApplys(partnerId, userId);
        for (Customer customer : list) {
            cusMap.put(customer.getApplyerCode(), customer.getApplyerId());
        }
    }
}

