/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.cache;

import com.alibaba.fastjson.JSON;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Disposition;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.entity.SystemFunction;
import com.tcbj.crm.view.CampaignlistV;
import com.tcbj.crm.view.CurrencyType;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerArea;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ProductCategory;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tcbjcache")
public class Cache {
    public static Logger logger = LoggerFactory.getLogger(Cache.class);
    @Autowired
    private static BaseDao baseDao;
    @Autowired
    private NewBaseDao newBaseDao;
    private static List<CurrencyType> currencyTypes;
    private static Map<String, String> types;
    private static Map<String, List<DictionaryItem>> dictionarys;
    private static Map<String, Partner> partners;
    private static Map<String, Partner> partnersByNo;
    private static Map<String, List<Partner>> partnerByShortExtCode;
    private static Map<String, PartnerContact> employees;
    private static Map<String, String> persons;
    private static Map<String, OrderActivityInfo> orderActivityInfos;
    private static Map<String, PredictConfig> predictConfigs;
    private static Map<String, Product> products;
    private static Map<String, Product> product;
    private static Map<String, Storage> storages;
    private static Map<String, Customer> customers;
    private static Map<String, Customer> customerByExtCode;
    private static Map<String, Customer> customerByExtCode_long;
    private static Map<String, Customer> customerByIdMap;
    private static Map<String, Customer> customersMap;
    private static Map<String, Region> region;
    private static Map<String, Position> positions;
    private static Map<String, ChannelType> channelType;
    private static Map<String, ProductCategory> productCategorys;
    private static Map<String, CampaignlistV> campaigns;
    private static Map<String, PartnerContact> employeeMap;
    private static List<Map<String, Object>> description;
    private static Map<String, String> interfaceConfigs;
    private static Map<String, ProductGiftView> giftMap;
    private static Map<String, PartnerShop> partnerShopMap;
    private static Map<String, SystemFunction> systemFunctionMap;
    private static List<Disposition> dispositions;
    private static List<PartnerArea> partnerAreaList;
    private static Map<String, SystemFunction> systemFunctionIDMap;
    private static String siebelUser;
    private static String siebelPwd;
    private static String siebelUrl;
    private static String cacheJSON;

    static {
        currencyTypes = new ArrayList<CurrencyType>();
        types = new HashMap<String, String>();
        dictionarys = new HashMap<String, List<DictionaryItem>>();
        partners = new HashMap<String, Partner>();
        partnersByNo = new HashMap<String, Partner>();
        partnerByShortExtCode = new HashMap<String, List<Partner>>();
        employees = new HashMap<String, PartnerContact>();
        persons = new HashMap<String, String>();
        orderActivityInfos = new HashMap<String, OrderActivityInfo>();
        predictConfigs = new HashMap<String, PredictConfig>();
        products = new HashMap<String, Product>();
        product = new HashMap<String, Product>();
        storages = new HashMap<String, Storage>();
        customers = new HashMap<String, Customer>();
        customerByExtCode = new HashMap<String, Customer>();
        customerByExtCode_long = new HashMap<String, Customer>();
        customerByIdMap = new HashMap<String, Customer>();
        customersMap = new HashMap<String, Customer>();
        region = new HashMap<String, Region>();
        positions = new HashMap<String, Position>();
        channelType = new HashMap<String, ChannelType>();
        productCategorys = new HashMap<String, ProductCategory>();
        campaigns = new HashMap<String, CampaignlistV>();
        employeeMap = new HashMap<String, PartnerContact>();
        description = new ArrayList<Map<String, Object>>();
        interfaceConfigs = new HashMap<String, String>();
        giftMap = new HashMap<String, ProductGiftView>();
        partnerShopMap = new HashMap<String, PartnerShop>();
        systemFunctionMap = new HashMap<String, SystemFunction>();
        dispositions = new ArrayList<Disposition>();
        partnerAreaList = new ArrayList<PartnerArea>();
        systemFunctionIDMap = new HashMap<String, SystemFunction>();
        siebelUser = null;
        siebelPwd = null;
        siebelUrl = null;
        cacheJSON = null;
        logger.info("======================testing logger======================");
        types.put("CONTACT_TYPE", "\u804c\u4f4d\u5206\u7c7b");
        types.put("TCBJ_ABILITY_TYPE", "\u80fd\u529b\u9879\u539f\u5f62");
        types.put("TCBJ_PERSON_TYPE_CD", "\u7c7b\u578b");
        types.put("TCBJ_PURCHASE_MODE", "\u8d2d\u9500\u6a21\u5f0f");
        types.put("TCBJ_SETTLEMENT_MODE", "\u7ed3\u7b97\u65b9\u5f0f");
        types.put("TCBJ_CREDIT_LEVEL", "\u4fe1\u7528\u7b49\u7ea7");
        types.put("TCBJ_ORDER_TYPE", "\u9ed8\u8ba4\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_RETURN_ORDER_TYPE", "\u9ed8\u8ba4\u9000\u8d27\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_SHIPMENT_PRIORITY", "\u53d1\u8d27\u4f18\u5148\u7ea7");
        types.put("TCBJ_SALES_TAX_CODE", "\u9500\u552e\u7a0e\u7801");
        types.put("TCBJ_BILL_TYPE", "\u5f00\u7968\u7c7b\u578b");
        types.put("TCBJ_STORE_TYPE", "\u95e8\u5e97\u7c7b\u578b");
        types.put("TCBJ_STORE_SUBTYPE", "\u95e8\u5e97\u5206\u7c7b");
        types.put("COUNTRY", "\u56fd\u5bb6");
        types.put("STATE_ABBREV", "\u7701");
        types.put("TCBJ_CITY", "\u57ce\u5e02");
        types.put("COUNTY", "\u53bf");
        types.put("TCBJ_RECEIVE_DATE_TYPE", "\u6536\u8d27\u65f6\u95f4");
        types.put("LOY_PART_CATEGORY_TYPE", "\u7ec4\u7ec7\u5206\u7c7b");
        types.put("TCBJ_PARTNER_LEVEL", "\u7ecf\u9500\u5546\u7b49\u7ea7");
        types.put("TCBJ_RECEIVE_TYPE", "\u5e93\u5b58\u63a5\u6536\u65b9\u5f0f ");
        types.put("BIG_REGION", "\u5927\u533a");
        types.put("REGION", "\u533a\u57df");
        types.put("YON", "\u662f\u5426");
        types.put("ADDR_TYPE", "\u5730\u5740\u7c7b\u578b");
        types.put("SEX_MF", "\u6027\u522b");
        types.put("TCBJ_NOTICE_SYS", "\u53d1\u5e03\u7cfb\u7edf");
        types.put("TCBJ_EAS_ORDER_TYPE", "\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_SHIPMENT_TYPE", "\u4ea4\u8d27\u65b9\u5f0f");
        types.put("TCBJ_UNIT_TYPE", "\u8ba1\u91cf\u5355\u4f4d");
        types.put("TCBJ_NOTICE_TYPE", "\u516c\u544a\u7c7b\u578b");
        types.put("TCBJ_STORE_TYPE", "\u95e8\u5e97\u7c7b\u578b");
        types.put("TCBJ_STORE_SUBTYPE", "\u95e8\u5e97\u5206\u7c7b");
        types.put("TCBJ_BUS_MODE", "\u95e8\u5e97\u4e1a\u52a1\u6a21\u5f0f");
        types.put("TCBJ_PROMOTION_MODE", "\u4fc3\u9500\u6a21\u5f0f");
        types.put("TCBJ_ROLE_CTL_VALUE", "\u63a7\u5236\u8303\u56f4");
        types.put("TCBJ_FINE_TYPE", "\u91d1\u989d\u7c7b\u578b");
        types.put("TCBJ_ACTION_TYPE", "\u63d0\u9192\u7c7b\u578b");
        types.put("TCBJ_CONTROL_SOURCE_TYPE", "\u63a7\u5236\u6e90");
        types.put("TCBJ_PRODUCT_TYPE", "\u4ea7\u54c1\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_SUB_TYPE", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_USE_TYPE", "\u4ea7\u54c1\u5242\u578b");
        types.put("TCBJ_CONTROL_CONTENT", "\u63a7\u5236\u5185\u5bb9");
        types.put("TCBJ_GIFT_SOURCE_TYPE", "\u8d60\u54c1\u6765\u6e90");
        types.put("TCBJ_CHECK_TYPE", "\u68c0\u67e5\u7c7b\u578b");
        types.put("TCBJ_CHECK_METHOD", "\u68c0\u67e5\u65b9\u5f0f");
        types.put("TCBJ_TERMIMAL_LEVEL", "\u7ec8\u7aef\u7b49\u7ea7");
        types.put("TCBJ_SUBINV_OWNER_TYPE", "\u4ed3\u5e93\u5f52\u5c5e");
        types.put("TCBJ_SUBINV_TYPE", "\u4ed3\u5e93\u7c7b\u578b");
        types.put("TCBJ_STORE_RULE_STATUS", "\u4ed3\u5e93\u72b6\u6001");
        types.put("TCBJ_MOVE_ORDER_TYPE", "\u8c03\u62e8\u7c7b\u578b");
        types.put("TCBJ_SURVEY_TYPE", "\u8c03\u7814\u95ee\u5377\u7c7b\u578b");
        types.put("TCBJ_DUE_DAYS", "\u5230\u671f\u5929\u6570");
        types.put("TCBJ_SHIPMENT_TYPE", "\u4ea4\u8d27\u65b9\u5f0f");
        types.put("TCBJ_MODIFY_TYPE", "\u8c03\u6574\u7c7b\u578b");
        types.put("TCBJ_COEFFICIENT_TYPE", "\u7cfb\u6570\u7c7b\u578b");
        types.put("TCBJ_MODIFY_METHOD", "\u8c03\u6574\u65b9\u5f0f");
        types.put("TCBJ_PARTNER_LEVEL", "\u7ecf\u9500\u5546\u7b49\u7ea7");
        types.put("TCBJ_FREEGIFT_CTRL_MODE", "\u8d60\u54c1\u63a7\u5236\u65b9\u5f0f");
        types.put("TCBJ_DISCOUNT_PRODUCT_TYPE", "\u6298\u6263\u4ea7\u54c1\u7c7b\u578b");
        types.put("TCBJ_PRICE_DECIMAL_DIGITS", "\u4ef7\u683c\u5c0f\u6570\u4f4d");
        types.put("TCBJ_MISC_ORDER_TYPE", "\u8c03\u5e93\u5355\u7c7b\u578b");
        types.put("TCBJ_PACT_TARGET_TYPE", "\u5408\u540c\u76ee\u6807\u7c7b\u578b");
        types.put("TCBJ_PACT_TARGET_SUB_TYPE", "\u5408\u540c\u76ee\u6807\u5b50\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_TYPE", "\u4ea7\u54c1\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_SUB_TYPE", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        types.put("TCBJ_PACT_SOURCE_TYPE", "\u8d44\u6e90\u7c7b\u578b");
        types.put("TCBJ_PACT_SOURCE_SUB_TYPE", "\u8d44\u6e90\u5b50\u7c7b\u578b");
        types.put("TCBJ_PACT_ACTIVE_TYPE", "\u6d3b\u52a8\u7c7b\u578b");
        types.put("TCBJ_PACT_ACTIVE_SUB_TYPE", "\u6d3b\u52a8\u5b50\u7c7b\u578b");
        types.put("TCBJ_PACT_PLAN_SHAPE", "\u8ba1\u5212\u6295\u5165\u5f62\u5f0f");
        types.put("TCBJ_EXPENSE_TYPE", "\u8d39\u7528\u7c7b\u578b");
        types.put("TCBJ_PACT_EXPENSE_TYPE", "\u8d39\u7528\u5b50\u7c7b\u578b");
        types.put("APPLY_SCOPE", "\u7533\u8bf7\u8303\u56f4\u63a7\u5236");
        types.put("STORE_TYPE", "\u4e13\u67dc\u7533\u8bf7\u7c7b\u578b");
        types.put("TRAIN_TYPE", "\u57f9\u8bad\u7c7b\u522b");
        types.put("BUDGET_TARGET", "\u8d39\u7528\u5bf9\u8c61");
        types.put("BUDGET_TYPE", "\u8d39\u7528\u7c7b\u578b");
        types.put("TCBJ_MEM_ORD_STATUS", "\u8ba2\u5355\u72b6\u6001");
        types.put("TCBJ_EXCHANGE_ORDER_TYPE", "\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_MEM_ORD_DEL_STATUS", "\u53d1\u9001\u72b6\u6001");
        types.put("TCBJ_MEM_ORD_METHOD", "\u5151\u6362\u65b9\u5f0f ");
        types.put("TCBJ_MEM_RDM_STATUS", "\u5151\u6362\u72b6\u6001");
        types.put("IMPL_PHASE", "\u4ea7\u54c1\u72b6\u6001");
        types.put("YOW", "\u6709\u65e0");
        types.put("TCBJ_ORDER_SHIP_TYPE", "\u53d1\u8d27\u72b6\u6001");
        types.put("TCBJ_PRODUCT_BRAND", "\u54c1\u724c");
    }

    @PostConstruct
    public void init() {
        this.initEnums();
        this.initCurrencyTypes();
        this.initPartners();
        this.initEmployees();
        this.initPersons();
        this.initOrderActivityInfo();
        this.initProduct();
        this.initPredictConfigs();
        this.initStorages();
        this.initCampaigns();
        this.initCustomers();
        this.initRegion();
        this.initPositions();
        this.initChannelType();
        this.initProductCategorys();
        this.initProductGift();
        this.initPartnerShop();
        this.initDescription();
        this.initSystemFunction();
        this.initDisposition();
        this.initInterfaceConfigs();
        this.initPartnerArea();
        cacheJSON = null;
    }

    public void initPredictConfigs() {
        HashMap<String, PredictConfig> tmp = new HashMap<String, PredictConfig>();
        List predicts = baseDao.findEntity("from PredictConfig ", PredictConfig.class);
        for (PredictConfig pc : predicts) {
            tmp.put(pc.getId(), pc);
        }
        predictConfigs.clear();
        predictConfigs = tmp;
    }

    private void initOrderActivityInfo() {
        orderActivityInfos.clear();
        HashMap<String, OrderActivityInfo> tmp = new HashMap<String, OrderActivityInfo>();
        List orders = baseDao.findEntity("from OrderActivityInfo", OrderActivityInfo.class);
        for (OrderActivityInfo e : orders) {
            tmp.put(e.getActivityId(), e);
        }
        orderActivityInfos = tmp;
    }

    public void initProductGift() {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ProductGiftView");
        List gifts = baseDao.findEntity(hql.toString(), ProductGiftView.class);
        for (ProductGiftView gift : gifts) {
            giftMap.put(gift.getId(), gift);
        }
    }

    public static ProductGiftView getGift(String productId) {
        return giftMap.get(productId);
    }

    public void initRegionData() {
        this.initChannelType();
        this.initRegion();
        this.initStorages();
    }

    public static Map<String, Region> getRegion() {
        return region;
    }

    public static Map<String, Storage> getStorages() {
        return storages;
    }

    public static Map<String, PartnerContact> getEmployees() {
        return employees;
    }

    public void initCustomers() {
        customersMap.clear();
        customerByIdMap.clear();
        customerByExtCode.clear();
        customerByExtCode_long.clear();
        HashMap<String, Customer> tmp = new HashMap<String, Customer>();
        List _customers = baseDao.findEntity("from Customer where supplierId = '" + ConfigFactory.get().get("auto_orgId") + "'", Customer.class);
        for (Customer c : _customers) {
            customerByIdMap.put(c.getId(), c);
            tmp.put(c.getApplyerId(), c);
            customersMap.put(c.getUnionId(), c);
            if (!StringUtils.isNotEmpty(c.getExtCode())) continue;
            if (c.getExtCode().lastIndexOf(".") > -1) {
                customerByExtCode.put(c.getExtCode().substring(c.getExtCode().lastIndexOf(".") + 1), c);
            }
            customerByExtCode_long.put(c.getExtCode(), c);
        }
        customers = tmp;
    }

    public static Customer getCustomer(String unionId) {
        return customersMap.get(unionId);
    }

    public static Customer getCustomerById(String id) {
        return customerByIdMap.get(id);
    }

    public void initPartnerShop() {
        partnerShopMap.clear();
        HashMap<String, PartnerShop> tmp = new HashMap<String, PartnerShop>();
        List _PartnerShop = baseDao.findEntity("from PartnerShop ", PartnerShop.class);
        for (PartnerShop c : _PartnerShop) {
            tmp.put(c.getId(), c);
        }
        partnerShopMap = tmp;
    }

    public static PartnerShop getPartnerShop(String no) {
        return partnerShopMap.get(no);
    }

    public static PartnerShop getPartnerShopByNo(String no) {
        Set<String> keySet = partnerShopMap.keySet();
        for (String key : keySet) {
            if (!no.equals(partnerShopMap.get(key).getNo())) continue;
            return partnerShopMap.get(key);
        }
        return null;
    }

    public void initCampaigns() {
        HashMap<String, CampaignlistV> tmp = new HashMap<String, CampaignlistV>();
        List _campaign = baseDao.findEntity("from CampaignlistV ", CampaignlistV.class);
        for (CampaignlistV c : _campaign) {
            tmp.put(c.getId(), c);
        }
        campaigns.clear();
        campaigns = tmp;
    }

    public static String getCampaignName(String id) {
        CampaignlistV campaign = campaigns.get(id);
        if (campaign == null) {
            return null;
        }
        return campaign.getCampaignName();
    }

    public static Product getNo(String id) {
        Product p = product.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    private void initDisposition() {
        List tmp = baseDao.findEntity("from Disposition", Disposition.class);
        dispositions.clear();
        dispositions = tmp;
    }

    public void initStorages() {
        HashMap<String, Storage> tmp = new HashMap<String, Storage>();
        List _storages = baseDao.findEntity("from Storage ", Storage.class);
        for (Storage s : _storages) {
            tmp.put(s.getId(), s);
        }
        storages.clear();
        storages = tmp;
    }

    public void initProduct() {
        HashMap<String, Product> tmp = new HashMap<String, Product>();
        HashMap<String, Product> tmps = new HashMap<String, Product>();
        List _product = baseDao.findEntity("from Product where orgId = '" + StringUtils.getOrgId() + "'", Product.class);
        for (Product p : _product) {
            tmps.put(p.getId(), p);
            tmp.put(p.getNo(), p);
        }
        product.clear();
        product = tmp;
        products.clear();
        products = tmps;
    }

    public void initPositions() {
        HashMap<String, Position> tmp = new HashMap<String, Position>();
        List _positions = baseDao.findEntity("from Position", Position.class);
        for (Position p : _positions) {
            tmp.put(p.getId(), p);
        }
        positions.clear();
        positions = tmp;
    }

    public void initEmployees() {
        employeeMap.clear();
        HashMap<String, PartnerContact> tmp = new HashMap<String, PartnerContact>();
        List _employees = baseDao.findEntity("from PartnerContact", PartnerContact.class);
        for (PartnerContact e : _employees) {
            tmp.put(e.getId(), e);
            if (!StringUtils.getOrgId().equals(e.getPartnerId())) continue;
            employeeMap.put(e.getContactName(), e);
        }
        employees.clear();
        employees = tmp;
    }

    public void initPersons() {
        HashMap<String, String> tmp = new HashMap<String, String>();
        String hql = " select c.personNo,c.personName from CustomerMatchPerson c where orgId = ? group by c.personNo,c.personName ";
        List list = baseDao.findEntity(hql, new Object[]{StringUtils.getOrgId()});
        for (Object obj : list) {
            Object[] object = (Object[])obj;
            tmp.put((String)object[0], (String)object[1]);
        }
        persons.clear();
        persons = tmp;
    }

    public static String getEmployeeId(String name) {
        if (employeeMap.get(name) != null) {
            return employeeMap.get(name).getId();
        }
        return null;
    }

    public void initChannelType() {
        HashMap<String, ChannelType> tmp = new HashMap<String, ChannelType>();
        List _channelType = baseDao.findEntity("from ChannelType", ChannelType.class);
        for (ChannelType e : _channelType) {
            tmp.put(e.getId(), e);
        }
        channelType.clear();
        channelType = tmp;
    }

    public void initProductCategorys() {
        HashMap<String, ProductCategory> tmp = new HashMap<String, ProductCategory>();
        List pcs = baseDao.findEntity("from ProductCategory", ProductCategory.class);
        for (ProductCategory pc : pcs) {
            tmp.put(pc.getId(), pc);
        }
        productCategorys.clear();
        productCategorys = tmp;
    }

    public void initRegion() {
        HashMap<String, Region> tmp = new HashMap<String, Region>();
        List list = baseDao.findEntity("from Region", Region.class);
        for (Region region2 : list) {
            tmp.put(region2.getId(), region2);
        }
        region.clear();
        region = tmp;
        for (Region partner : region.values()) {
            Region parent = region.get(partner.getParentId());
            if (parent == null) continue;
            parent.getChildList().add(partner);
        }
    }

    public void initPartners() {
        partnersByNo.clear();
        HashMap<String, Partner> tmp = new HashMap<String, Partner>();
        List _partners = baseDao.findEntity("from Partner p where p.masterOuId = ? ", new Object[]{StringUtils.getOrgId()}, Partner.class);
        for (Partner p : _partners) {
            tmp.put(p.getId(), p);
            partnersByNo.put(p.getNo(), p);
            if (!Beans.isNotEmpty((Object)p.getClientAppNo())) continue;
            List<Partner> partners = partnerByShortExtCode.get(p.getClientNo());
            if (Beans.isEmpty(partners)) {
                partners = new ArrayList<Partner>();
                partnerByShortExtCode.put(p.getClientNo(), partners);
            }
            partners.add(p);
        }
        partners.clear();
        partners = tmp;
        for (Partner partner : partners.values()) {
            Partner parent = partners.get(partner.getParentPartnerId());
            if (parent == null) continue;
            parent.getChildPartner().add(partner);
        }
    }

    public void initInterfaceConfigs() {
        HashMap<String, String> tmp = new HashMap<String, String>();
        List<Map<String, Object>> list = this.newBaseDao.findBySql(" select * from CX_CALL_INTERFACE_CONFIG where flag = '1' and org_Id = '" + ConfigFactory.get().get("auto_orgId") + "' ");
        for (Map<String, Object> map : list) {
            tmp.put((String)map.get("TYPE"), (String)map.get("ADDRESS"));
        }
        interfaceConfigs.clear();
        interfaceConfigs = tmp;
    }

    public static String getInterfaceConfig(String type) {
        if (Beans.isNotEmpty(interfaceConfigs) && Beans.isNotEmpty((Object)interfaceConfigs.get(type))) {
            return interfaceConfigs.get(type);
        }
        return null;
    }

    public void initDescription() {
        description = this.newBaseDao.findBySql("select * from CX_AWK_DISPOSITION s where flag=1 order by s.order_by ");
    }

    public static List<Map<String, Object>> getDescriptions(String type) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : description) {
            if (!type.equals(map.get("TYPE"))) continue;
            list.add(map);
        }
        return list;
    }

    public static List<Disposition> getDispositionValid(String type) {
        ArrayList<Disposition> dislist = new ArrayList<Disposition>();
        for (Disposition dis : dispositions) {
            if (!type.equals(dis.getType()) || !dis.getFlag().equals("1")) continue;
            dislist.add(dis);
        }
        return dislist;
    }

    public static Disposition getDispositionFirst(String type) {
        for (Disposition dis : dispositions) {
            if (!type.equals(dis.getType()) || !dis.getFlag().equals("1")) continue;
            return dis;
        }
        return null;
    }

    public static List<Disposition> getDispositionValidForList(String type) {
        ArrayList<Disposition> dislist = new ArrayList<Disposition>();
        for (Disposition dis : dispositions) {
            if (!type.equals(dis.getType()) || !dis.getFlag().equals("1") && !dis.getFlag().equals("0")) continue;
            dislist.add(dis);
        }
        return dislist;
    }

    public static List<Disposition> getDispositionAll(String type) {
        ArrayList<Disposition> dislist = new ArrayList<Disposition>();
        for (Disposition dis : dispositions) {
            if (!type.equals(dis.getType())) continue;
            dislist.add(dis);
        }
        return dislist;
    }

    public static Map<String, String> getMapByType(String type, String orgId) {
        List<Disposition> list = Cache.getDispositionValidForList(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Disposition mapdes : list) {
            if (!orgId.equals(mapdes.getOrderBy())) continue;
            map.put(StringUtils.objToStr(mapdes.getVal()), StringUtils.objToStr(mapdes.getDisposition()));
        }
        return map;
    }

    public static Map<String, String> getMapByType2(String type, String orgId) {
        List<DictionaryItem> list = Cache.getItems(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DictionaryItem mapdes : list) {
            if (!orgId.equals(mapdes.getBusinessId()) || !"1".equals(mapdes.getLow()) && !"0".equals(mapdes.getLow())) continue;
            map.put(StringUtils.objToStr(mapdes.getName()), StringUtils.objToStr(mapdes.getVal()));
        }
        return map;
    }

    public static Map<String, String> getMapByTypeForList(String type) {
        List<Disposition> list = Cache.getDispositionAll(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Disposition mapdes : list) {
            map.put(StringUtils.objToStr(mapdes.getVal()), StringUtils.objToStr(mapdes.getDisposition()));
        }
        return map;
    }

    public static String getDesByParms(String type, String parms) {
        List<Map<String, Object>> list = Cache.getDescriptions(type);
        String parm = "";
        for (Map<String, Object> map : list) {
            parm = String.valueOf(parm) + map.get(parms) + ",";
        }
        if (parm.length() > 0) {
            parm = parm.substring(0, parm.length() - 1);
        }
        return parm;
    }

    public static String getDesByVal(String type, String val) {
        List<Map<String, Object>> list = Cache.getDescriptions(type);
        String value = "";
        for (Map<String, Object> map : list) {
            String vals = StringUtils.objToStr(map.get("VAL"));
            if (!val.equals(vals)) continue;
            value = StringUtils.objToStr(map.get("DESCRIPTION"));
            break;
        }
        return value;
    }

    public static String getValByParms(String type, String parms) {
        List<Map<String, Object>> list = Cache.getDescriptions(type);
        String value = "";
        for (Map<String, Object> map : list) {
            String parm = StringUtils.objToStr(map.get("DESCRIPTION"));
            if (!parms.equals(parm)) continue;
            value = StringUtils.objToStr(map.get("VAL"));
            break;
        }
        return value;
    }

    public static LinkedHashMap<String, String> getMapByParms(String type, String key, String value) {
        List<Map<String, Object>> list = Cache.getDescriptions(type);
        LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>();
        for (Map<String, Object> map : list) {
            String key1 = StringUtils.objToStr(map.get(key));
            String value1 = StringUtils.objToStr(map.get(value));
            linkMap.put(key1, value1);
        }
        return linkMap;
    }

    public static String getDesByTypeAndVal(String type, String val) {
        List<Disposition> list = Cache.getDispositionAll(type);
        String value = "";
        for (Disposition dis : list) {
            String vals = StringUtils.objToStr(dis.getVal());
            if (!val.equals(vals)) continue;
            value = StringUtils.objToStr(dis.getDisposition());
            break;
        }
        return value;
    }

    public static String getDesByTypeAndDisposition(String type, String disposition) {
        List<Disposition> list = Cache.getDispositionAll(type);
        String value = "";
        for (Disposition dis : list) {
            String dispositions = StringUtils.objToStr(dis.getDisposition());
            if (!disposition.equals(dispositions)) continue;
            value = StringUtils.objToStr(dis.getVal());
            break;
        }
        return value;
    }

    public static List<Partner> getPartnersBySupplierId(String supplierId) {
        ArrayList<Partner> _partners = new ArrayList<Partner>();
        for (String key : partners.keySet()) {
            Partner partner = partners.get(key);
            if (StringUtils.isEmpty(partner.getParentPartnerId()) || !partner.getParentPartnerId().equals(supplierId)) continue;
            _partners.add(partner);
        }
        return _partners;
    }

    public static Partner getPartnerByNo(String no) {
        return partnersByNo.get(no);
    }

    public static Region getRegionById(String id) {
        return region.get(id);
    }

    public static String getPositionName(String id) {
        Position p = positions.get(id);
        if (p == null) {
            return "";
        }
        return p.getPostName();
    }

    public static String getChannelTypeName(String id) {
        ChannelType p = channelType.get(id);
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    public static String getChannelTypeId(String id) {
        ChannelType p = channelType.get(id);
        if (p == null) {
            return "";
        }
        return p.getId();
    }

    public static String getApplyerName(String id) {
        Customer p = customers.get(id);
        if (p == null) {
            return "";
        }
        return p.getApplyerName();
    }

    public static Customer getApplyer(String id) {
        Customer p = customers.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public static String getApplyerCode(String id) {
        Customer p = customers.get(id);
        if (p == null) {
            return "";
        }
        return p.getApplyerCode();
    }

    public static String getStorageName(String storageId) {
        Storage storage = storages.get(storageId);
        if (storage == null) {
            return null;
        }
        return storage.getStorageName();
    }

    public static String getStorageCode(String storageId) {
        Storage storage = storages.get(storageId);
        if (storage == null) {
            return null;
        }
        return storage.getStorageCode();
    }

    private void initCurrencyTypes() {
        List tmp = baseDao.findEntity("from CurrencyType", CurrencyType.class);
        currencyTypes.clear();
        currencyTypes = tmp;
    }

    public static Customer getCustomerByExtCode(String extCode) {
        return customerByExtCode.get(extCode);
    }

    public static Customer getCustomerByExtCode_long(String extCode) {
        return customerByExtCode_long.get(extCode);
    }

    private void initEnums() {
        StringBuffer hql = new StringBuffer();
        hql.append("from DictionaryItem where activeFlg='Y' and ");
        hql.append(" type in ( ");
        int count = 1;
        for (String key : types.keySet()) {
            hql.append("'");
            hql.append(key);
            hql.append("'");
            if (count++ >= types.size()) continue;
            hql.append(",");
        }
        hql.append(" ) ");
        hql.append(" order by orderBy ");
        List items = baseDao.findEntity(hql.toString(), DictionaryItem.class);
        DictionaryItem item_15 = new DictionaryItem("item_15", "1", "\u4e13\u67dc\u4e00", "STORE_TYPE", "");
        DictionaryItem item_16 = new DictionaryItem("item_16", "2", "\u4e13\u67dc\u4e8c", "STORE_TYPE", "");
        DictionaryItem item_17 = new DictionaryItem("item_17", "3", "\u67dc\u4e09", "STORE_TYPE", "");
        items.add(item_15);
        items.add(item_16);
        items.add(item_17);
        DictionaryItem item_11 = new DictionaryItem("item_11", "1", "\u5ba2\u6237", "APPLY_SCOPE", "");
        DictionaryItem item_12 = new DictionaryItem("item_12", "2", "\u7ec4\u7ec7", "APPLY_SCOPE", "");
        DictionaryItem item_13 = new DictionaryItem("item_13", "3", "\u5ba2\u6237\u53ca\u7ec4\u7ec7", "APPLY_SCOPE", "");
        DictionaryItem item_14 = new DictionaryItem("item_14", "4", "\u65e0", "APPLY_SCOPE", "");
        items.add(item_14);
        items.add(item_13);
        items.add(item_12);
        items.add(item_11);
        DictionaryItem item_6 = new DictionaryItem("item_6", "Y", "\u662f", "YON", "");
        DictionaryItem item_7 = new DictionaryItem("item_7", "N", "\u5426", "YON", "");
        items.add(item_6);
        items.add(item_7);
        DictionaryItem item_20 = new DictionaryItem("item_20", "1", "\u8425\u517b\u57f9\u8bad", "TRAIN_TYPE", "");
        DictionaryItem item_21 = new DictionaryItem("item_21", "2", "\u8679\u819c\u57f9\u8bad", "TRAIN_TYPE", "");
        items.add(item_20);
        items.add(item_21);
        DictionaryItem item_22 = new DictionaryItem("item_22", "1", "\u6709", "YOW", "");
        DictionaryItem item_23 = new DictionaryItem("item_23", "2", "\u65e0", "YOW", "");
        items.add(item_22);
        items.add(item_23);
        DictionaryItem item_24 = new DictionaryItem("item_24", "0", "\u7ec4\u7ec7", "BUDGET_TYPE", "");
        DictionaryItem item_25 = new DictionaryItem("item_25", "1", "\u6e20\u9053", "BUDGET_TYPE", "");
        DictionaryItem item_26 = new DictionaryItem("item_26", "2", "\u5927\u533a", "BUDGET_TYPE", "");
        DictionaryItem item_27 = new DictionaryItem("item_27", "3", "\u533a\u57df", "BUDGET_TYPE", "");
        items.add(item_24);
        items.add(item_25);
        items.add(item_26);
        items.add(item_27);
        DictionaryItem item_28 = new DictionaryItem("item_28", "0", "\u5408\u540c\u5185", "BUDGET_TARGET", "");
        DictionaryItem item_29 = new DictionaryItem("item_29", "1", "OTC", "BUDGET_TARGET", "");
        DictionaryItem item_30 = new DictionaryItem("item_30", "2", "\u5927\u533a", "BUDGET_TARGET", "");
        DictionaryItem item_31 = new DictionaryItem("item_31", "3", "\u5546\u8d85", "BUDGET_TARGET", "");
        DictionaryItem item_32 = new DictionaryItem("item_32", "4", "\u7535\u5546", "BUDGET_TARGET", "");
        DictionaryItem item_33 = new DictionaryItem("item_33", "5", "\u76f4\u8425", "BUDGET_TARGET", "");
        items.add(item_28);
        items.add(item_29);
        items.add(item_30);
        items.add(item_31);
        items.add(item_32);
        items.add(item_33);
        DictionaryItem item_9 = new DictionaryItem("PRODUCT", "PRODUCT", "\u4ea7\u54c1", "TCBJ_DISCOUNT_PRODUCT_TYPE", "");
        DictionaryItem item_10 = new DictionaryItem("GIFT", "GIFT", "\u8d60\u54c1", "TCBJ_DISCOUNT_PRODUCT_TYPE", "");
        items.add(item_9);
        items.add(item_10);
        HashMap<String, List<DictionaryItem>> tmp = new HashMap<String, List<DictionaryItem>>();
        for (String type : types.keySet()) {
            ArrayList<DictionaryItem> dis = (ArrayList<DictionaryItem>)tmp.get(type);
            if (dis == null) {
                dis = new ArrayList<DictionaryItem>();
            }
            tmp.put(type, dis);
            for (DictionaryItem item : items) {
                if (item.getType() == null || !item.getType().equals(type)) continue;
                dis.add(item);
            }
        }
        dictionarys.clear();
        dictionarys = tmp;
    }

    public void initSystemFunction() {
        systemFunctionMap.clear();
        systemFunctionIDMap.clear();
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from SystemFunction");
        hql.append(" where futureState = ?");
        args.add("0");
        List funcs = baseDao.findEntity(hql.toString(), args.toArray(), SystemFunction.class);
        for (SystemFunction func : funcs) {
            systemFunctionMap.put(String.valueOf(func.getFutureType()) + ":" + func.getFunctionInvoking(), func);
            systemFunctionIDMap.put(func.getRowId(), func);
        }
    }

    public static PartnerArea getPartnerAreaByCode(String code) {
        PartnerArea partnerArea = new PartnerArea();
        if (Beans.isNotEmpty((Object)code) && partnerAreaList.size() > 0) {
            for (PartnerArea p : partnerAreaList) {
                if (!p.getPartnerCode().equals(code)) continue;
                partnerArea = p;
                break;
            }
        }
        return partnerArea;
    }

    public static List<PartnerArea> getAreaPartnerById(String id, String type) {
        ArrayList<PartnerArea> list = new ArrayList<PartnerArea>();
        if (Beans.isNotEmpty((Object)id) && Beans.isNotEmpty((Object)type) && partnerAreaList.size() > 0) {
            for (PartnerArea p : partnerAreaList) {
                if ("region".equals(type) && id.equals(p.getRegionId())) {
                    list.add(p);
                    continue;
                }
                if (!"district".equals(type) || !id.equals(p.getDistrictId())) continue;
                list.add(p);
            }
        }
        return list;
    }

    public static void addSystemFunction(SystemFunction systemFunction) {
        if (systemFunction != null) {
            systemFunctionMap.put(String.valueOf(systemFunction.getFutureType()) + ":" + systemFunction.getFunctionInvoking(), systemFunction);
            systemFunctionIDMap.put(systemFunction.getRowId(), systemFunction);
        }
    }

    public static void updateSystemFunction(SystemFunction systemFunction) {
        if (systemFunction != null) {
            SystemFunction function = systemFunctionIDMap.remove(systemFunction.getRowId());
            if (function != null) {
                systemFunctionMap.remove(String.valueOf(function.getFutureType()) + ":" + function.getFunctionInvoking());
            }
            if ("0".equals(systemFunction.getFutureState())) {
                systemFunctionMap.put(String.valueOf(systemFunction.getFutureType()) + ":" + systemFunction.getFunctionInvoking(), systemFunction);
                systemFunctionIDMap.put(systemFunction.getRowId(), systemFunction);
            }
        }
    }

    public static void deleteSystemFunction(List<SystemFunction> sysFunctions) {
        for (SystemFunction systemFunction : sysFunctions) {
            SystemFunction function = systemFunctionIDMap.remove(systemFunction.getRowId());
            if (function == null) continue;
            systemFunctionMap.remove(String.valueOf(function.getFutureType()) + ":" + function.getFunctionInvoking());
        }
    }

    public static SystemFunction getSysFunc(String URL2, String method) {
        SystemFunction systemFunction = systemFunctionMap.get(String.valueOf(method) + ":" + URL2);
        if (systemFunction == null) {
            systemFunction = systemFunctionMap.get("GET_POST:" + URL2);
        }
        return systemFunction;
    }

    public static SystemFunction getRootSysFunc(SystemFunction fun) {
        SystemFunction temp = fun;
        while (StringUtils.isNotEmpty(temp.getParentId())) {
            temp = systemFunctionIDMap.get(temp.getParentId());
        }
        return temp;
    }

    public static Map<String, ProductCategory> getProductCategorys() {
        return productCategorys;
    }

    public static ProductCategory getProductCategory(String id) {
        if (Cache.getProductCategorys() == null) {
            return null;
        }
        return Cache.getProductCategorys().get(id);
    }

    public static List<CurrencyType> getCurrencyTypes() {
        return currencyTypes;
    }

    public static String getCurrencyTypeName(String code) {
        for (CurrencyType type : currencyTypes) {
            if (!type.getCurcyCd().equals(code)) continue;
            return type.getName();
        }
        return "";
    }

    public static List<DictionaryItem> getItems(String type) {
        return dictionarys.get(type);
    }

    public static String getItemName(String type, String itemCode) {
        List<DictionaryItem> items = Cache.getItems(type);
        if (items == null) {
            return "";
        }
        for (DictionaryItem item : items) {
            if (!item.getName().equals(itemCode)) continue;
            return item.getVal();
        }
        return "";
    }

    public static String getItemType(String type, String val) {
        List<DictionaryItem> items = Cache.getItems(type);
        if (items == null) {
            return "";
        }
        for (DictionaryItem item : items) {
            if (!item.getVal().equals(val)) continue;
            return item.getName();
        }
        return "";
    }

    public static DictionaryItem getItem(String type, String itemCode) {
        List<DictionaryItem> items = Cache.getItems(type);
        if (items == null) {
            return null;
        }
        for (DictionaryItem item : items) {
            if (!item.getName().equals(itemCode)) continue;
            return item;
        }
        return null;
    }

    public static String getPartnerName(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    public static Map<String, Partner> getPartners() {
        return partners;
    }

    public static Partner getPartner(String id) {
        return partners.get(id);
    }

    public static String getPartnerNo(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getNo();
    }

    public static String getPartnerSaleChannelTypeCode(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getSaleChannelTypeName();
    }

    public static String getPartnerCSN(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getClientAppNo();
    }

    public static String getEmployeeName(String id) {
        PartnerContact e = employees.get(id);
        if (e == null) {
            return "";
        }
        return e.getContactName();
    }

    public static String getPersonName(String id) {
        String s = persons.get(id);
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String getPersonNoAndName(String id) {
        String s = persons.get(id);
        if (s == null) {
            return "";
        }
        return String.valueOf(s) + " " + id;
    }

    public static String getEmployeeNo(String id) {
        PartnerContact e = employees.get(id);
        if (e == null) {
            return "";
        }
        return e.getNo();
    }

    public static String getRegionsName(String id) {
        Region p = region.get(id);
        if (p == null) {
            return "";
        }
        return p.getRegionName();
    }

    public static String getRegionsCode(String id) {
        Region p = region.get(id);
        if (p == null) {
            return "";
        }
        return p.getRegionCode();
    }

    public static Region getRegions(String id) {
        Region p = region.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public static String getProductName(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    public static String getProductType(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getType();
    }

    public static String getProductUnit(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getUnitName();
    }

    public static String getProductNo(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getNo();
    }

    public static Product getProduct(String id) {
        Product p = products.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public static Product getProductByNo(String no) {
        for (String key : products.keySet()) {
            Product p = products.get(key);
            if (!StringUtils.isNotEmpty(p.getNo()) || !p.getNo().equals(no)) continue;
            return p;
        }
        return null;
    }

    public String getEnumJSON() {
        if (cacheJSON != null) {
            return cacheJSON;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ___dictionarys = ");
        HashMap<String, List<DictionaryItem>> tmp = new HashMap<String, List<DictionaryItem>>();
        for (String key : dictionarys.keySet()) {
            List<DictionaryItem> items = dictionarys.get(key);
            if ("COUNTRY".equals(key) || "STATE_ABBREV".equals(key) || "TCBJ_CITY".equals(key) || "COUNTY".equals(key)) continue;
            tmp.put(key, items);
        }
        sb.append(JSON.toJSONString(tmp));
        sb.append(";");
        sb.append("var ___currencytype = ");
        sb.append(JSON.toJSONString(currencyTypes));
        sb.append(";");
        cacheJSON = sb.toString();
        return cacheJSON;
    }

    public String getEmployeeJSON(String partnerId) {
        if (StringUtils.isEmpty(partnerId)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ___employees = ");
        List cs = baseDao.findEntity("from PartnerContact where partnerId='" + partnerId + "'", PartnerContact.class);
        sb.append(JSON.toJSONString((Object)cs));
        sb.append(";");
        return sb.toString();
    }

    public static String getSiebelUrl() {
        return siebelUrl;
    }

    static void setSiebelUrl(String siebelUrl) {
        if (StringUtils.isNotEmpty(Cache.siebelUrl)) {
            return;
        }
        Cache.siebelUrl = siebelUrl;
    }

    public static String getSiebelUser() {
        return siebelUser;
    }

    static void setSiebelUser(String siebelUser) {
        if (StringUtils.isNotEmpty(Cache.siebelUser)) {
            return;
        }
        Cache.siebelUser = siebelUser;
    }

    public static String getSiebelPwd() {
        return siebelPwd;
    }

    static void setSiebelPwd(String siebelPwd) {
        if (StringUtils.isNotEmpty(Cache.siebelPwd)) {
            return;
        }
        Cache.siebelPwd = siebelPwd;
    }

    public static Partner getPartnerByNoAndOrgCode(String no) {
        String orgCode = StringUtils.getOrgId();
        for (String key : partnersByNo.keySet()) {
            Partner p;
            if (!key.equals(no) || !Beans.isNotEmpty((Object)(p = partnersByNo.get(key))) || !orgCode.equals(p.getMasterOuId())) continue;
            return p;
        }
        return null;
    }

    public String getRelatedIds(String partnerId) {
        Customer customer = Cache.getApplyer(partnerId);
        String par_partnerId = partnerId;
        StringBuilder ids = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        if (customer.getRelatedDelearId() != null) {
            par_partnerId = customer.getRelatedDelearId();
        }
        ids.append("'").append(par_partnerId).append("'").append(",");
        sql.append(" SELECT * FROM CX_AWK_PRTNR_ACCOUNTLIST_VIEW WHERE RELATED_DELEAR_ID = '").append(par_partnerId).append("'");
        List list2 = baseDao.findBySql(sql.toString());
        int size = list2.size();
        int i = 0;
        while (i < size) {
            Object[] objs = (Object[])list2.get(i);
            if (objs != null && objs.length > 0) {
                ids.append("'").append(objs[1].toString()).append("'").append(",");
            }
            ++i;
        }
        ids = ids.deleteCharAt(ids.length() - 1);
        return ids.toString();
    }

    public void initPartnerArea() {
        logger.info("loading partner area cache................");
        partnerAreaList.clear();
        StringBuffer hql = new StringBuffer();
        hql.append(" from PartnerArea ");
        partnerAreaList = baseDao.findEntity(hql.toString(), PartnerArea.class);
        logger.info("loading partner area cache finished................");
    }

    public static PartnerArea getPartnerAreaById(String id) {
        PartnerArea partnerArea = new PartnerArea();
        if (Beans.isNotEmpty((Object)id) && partnerAreaList.size() > 0) {
            for (PartnerArea p : partnerAreaList) {
                if (!p.getPartnerId().equals(id)) continue;
                partnerArea = p;
                break;
            }
        }
        return partnerArea;
    }

    public String getExtCodeS(String partnerId) {
        Customer customer = Cache.getApplyer(partnerId);
        String code = customer.getExtCode();
        if (Beans.isEmpty((Object)code)) {
            return "";
        }
        StringBuilder extCodes = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT * FROM CX_AWK_PRTNR_ACCOUNTLIST_VIEW WHERE EXTCODE = '").append(code).append("'");
        List list2 = baseDao.findBySql(sql.toString());
        int size = list2.size();
        int i = 0;
        while (i < size) {
            Object[] objs = (Object[])list2.get(i);
            if (objs != null && objs.length > 0) {
                extCodes.append("'").append(objs[1].toString()).append("'").append(",");
            }
            ++i;
        }
        extCodes = extCodes.deleteCharAt(extCodes.length() - 1);
        return extCodes.toString();
    }

    public static OrderActivityInfo getActivityById(String activityId) {
        OrderActivityInfo o = orderActivityInfos.get(activityId);
        if (o == null) {
            return null;
        }
        return o;
    }

    public static List<Partner> getPartnerByShortExtCode(String extCode) {
        List partners = partnerByShortExtCode.get(extCode);
        if (Beans.isEmpty(partners)) {
            List pts;
            String hql = " from Partner where SUBSTR(clientAppNo, INSTR(clientAppNo, '.', -1) + 1) = '" + extCode + "'";
            partners = pts = baseDao.findEntity(hql, Partner.class);
            partnerByShortExtCode.put(extCode, pts);
        }
        return partners;
    }

    public static PredictConfig getPredictConfig(String id) {
        return Cache.getPredictConfigById(id);
    }

    public static PredictConfig getPredictConfigById(String id) {
        PredictConfig pc = predictConfigs.get(id);
        if (Beans.isEmpty((Object)pc)) {
            PredictConfig ptemp = (PredictConfig)baseDao.get(PredictConfig.class, (Serializable)((Object)id));
            if (Beans.isNotEmpty((Object)ptemp)) {
                predictConfigs.put(ptemp.getId(), ptemp);
            }
            return ptemp;
        }
        return pc;
    }

    public static Partner getPartnerById(String id) {
        if (Beans.isEmpty((Object)id)) {
            return null;
        }
        Partner p = partners.get(id);
        if (Beans.isEmpty((Object)p)) {
            Partner ptemp = (Partner)baseDao.get(Partner.class, (Serializable)((Object)id));
            if (Beans.isNotEmpty((Object)ptemp)) {
                partners.put(ptemp.getId(), ptemp);
            }
            return ptemp;
        }
        return p;
    }

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        Cache.baseDao = baseDao;
    }
}

