/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.check;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.check.CheckVouchCondition;
import com.tcbj.crm.check.CheckVouchService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.CheckVouch;
import com.tcbj.crm.entity.CheckVouchItem;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.stock.UpdateStockItem;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/check"})
public class CheckVouchController
extends BaseController {
    @Autowired
    CheckVouchService service;
    @Autowired
    StockService stockService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    StorageService storageService;

    @RequestMapping(value={"/check.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) throws Exception {
        this.loadCheckVouch(id, model);
        return "check/check.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/check.do"}, method={RequestMethod.POST})
    public Result apply_do(@Valid @RequestBody CheckVouch checkVouch, BindingResult errors, HttpServletRequest request) throws Exception {
        String storageId;
        String result = null;
        if (StringUtils.isEmpty(checkVouch.getId()) && StringUtils.isEmpty(checkVouch.getStorageId())) {
            throw new AppException("9200");
        }
        if (checkVouch.getCheckVouchItems().size() == 0) {
            throw new AppException("9201");
        }
        Employee me = this.getCurrentEmployee();
        checkVouch.fillInitData(me);
        for (CheckVouchItem item : checkVouch.getCheckVouchItems()) {
            item.fillInitData(me);
        }
        String type = checkVouch.getSubmitType();
        if (type != null && type.equals("save")) {
            checkVouch.setCheckvouchFlag("1");
            String no = this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "05");
            checkVouch.setCheckvouchId(no);
        } else if (type != null && type.equals("second")) {
            checkVouch.setCheckvouchFlag("3");
            checkVouch.setSecondSnapshoot(new Date());
            checkVouch.setSecondSnapshootPerson(me.getId());
            storageId = checkVouch.getStorageId();
            Map<String, Double> map = this.stockService.getQuantityByStorage(storageId);
            for (CheckVouchItem item : checkVouch.getCheckVouchItems()) {
                String productId = item.getProductId();
                double quantity = map.get(productId) == null ? 0.0 : map.get(productId);
                item.setSecondSnapshootQuantity(quantity);
            }
        } else if (type != null && type.equals("ok")) {
            checkVouch.setCheckvouchFlag("4");
            for (CheckVouchItem item : checkVouch.getCheckVouchItems()) {
                if (item.getDifferenceQuantity() != null && item.getRealityQuantity() != null) continue;
                item.setDifferenceQuantity(MathUtils.sub((Double)item.getSecondSnapshootQuantity(), (Double)item.getRealityQuantity()));
            }
            ArrayList<UpdateStockItem> list = new ArrayList<UpdateStockItem>();
            for (CheckVouchItem item : checkVouch.getCheckVouchItems()) {
                UpdateStockItem sitem = new UpdateStockItem(item.getId(), item.getProductId(), item.getDifferenceQuantity());
                sitem.setSupplierId(me.getCurrentPartner().getId());
                sitem.setApplyerId(me.getCurrentPartner().getId());
                list.add(sitem);
            }
            String storageId2 = checkVouch.getStorageId();
            this.stockService.updateQuantity(me, me.getCurrentPartner().getId(), storageId2, checkVouch.getId(), "\u76d8\u70b9", list);
        } else if (type != null && type.equals("close")) {
            checkVouch.setCheckvouchFlag("9");
            checkVouch.setCloseDate(new Date());
            checkVouch.setClosePerson(me.getId());
        } else if (type != null && type.equals("first")) {
            checkVouch.setCheckvouchFlag("2");
            checkVouch.setFirstSnapshoot(new Date());
            checkVouch.setFirstSnapshootPerson(me.getId());
            storageId = checkVouch.getStorageId();
            Map<String, Double> map = this.stockService.getQuantityByStorage(storageId);
            for (CheckVouchItem item : checkVouch.getCheckVouchItems()) {
                String productId = item.getProductId();
                double quantity = map.get(productId) == null ? 0.0 : map.get(productId);
                item.setFirstSnapshootQuantity(quantity);
            }
        }
        checkVouch.setOrgId(me.getCurrentPartner().getId());
        this.service.saveOrUpdate(checkVouch);
        result = checkVouch.getId();
        return this.getSuccessResult(result);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String applys(@ModelAttribute(value="condition") CheckVouchCondition condition, Model model) {
        if (StringUtils.isNotEmpty(condition.getState())) {
            condition.getStates().add(condition.getState());
        }
        this.findCheckVouchs(condition, "order by lastUpdateDt ", model);
        return "check/list.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        try {
            this.service.del(id);
        }
        catch (Exception exception) {}
        return "redirect:list.do?conscope=session";
    }

    private void findCheckVouchs(CheckVouchCondition condition, String orderby, Model model) {
        condition = (CheckVouchCondition)this.wrapCondition(condition, "CheckVouch");
        Employee me = this.getCurrentEmployee();
        condition.setPartnerId(me.getCurrentPartner().getId());
        Page page = this.service.findCheckVouchs(condition);
        model.addAttribute("me", (Object)me);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
    }

    private CheckVouch loadCheckVouch(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        CheckVouch checkVouch = null;
        if (StringUtils.isEmpty(id)) {
            checkVouch = new CheckVouch();
            checkVouch.fillInitData(me);
        } else {
            checkVouch = this.service.get(id);
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("checkVouch", (Object)checkVouch);
        model.addAttribute("partnerName", (Object)Cache.getPartnerName(checkVouch.getOrgId()));
        model.addAttribute("checkVouchItemItems", (Object)JSON.toJSONString(checkVouch.getCheckVouchItems()));
        return checkVouch;
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadCheckVouch(id, model);
        return "check/view.ftl";
    }

    @RequestMapping(value={"/test.do"}, method={RequestMethod.GET})
    public String test() {
        return "check/index.jsp";
    }
}

