/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.checkVouch;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.check.CheckVouchCondition;
import com.tcbj.crm.checkVouch.CheckVouchNewService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.CheckVouch;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/checkVouch"})
public class CheckVouchNewController
extends BaseController {
    @Autowired
    CheckVouchNewService service;
    @Autowired
    StockService stockService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    StorageService storageService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String applys(@ModelAttribute(value="condition") CheckVouchCondition condition, Model model) {
        if (StringUtils.isNotEmpty(condition.getState())) {
            condition.getStates().add(condition.getState());
        }
        Page page = this.service.findCheckVouchs(condition);
        model.addAttribute("page", (Object)page);
        return "checkVouch/list.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        CheckVouch checkVouch = new CheckVouch();
        checkVouch.fillInitData(me);
        String no = this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "05");
        checkVouch.setCheckvouchId(no);
        model.addAttribute("me", (Object)me);
        model.addAttribute("checkVouch", (Object)checkVouch);
        model.addAttribute("partnerName", (Object)Cache.getPartnerName(checkVouch.getOrgId()));
        model.addAttribute("checkVouchItemItems", (Object)JSON.toJSONString(checkVouch.getCheckVouchItems()));
        return "checkVouch/check.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    public Result apply_do(@Valid @RequestBody CheckVouch checkVouch, BindingResult errors, HttpServletRequest request) throws Exception {
        Object result = null;
        if (StringUtils.isEmpty(checkVouch.getId()) && StringUtils.isEmpty(checkVouch.getStorageId())) {
            throw new AppException("9200");
        }
        if (checkVouch.getCheckVouchItems().size() == 0) {
            throw new AppException("9201");
        }
        this.service.save(checkVouch, this.getCurrentEmployee());
        return this.getSuccessResult(result);
    }

    private void findCheckVouchs(CheckVouchCondition condition, String orderby, Model model) {
        condition = (CheckVouchCondition)this.wrapCondition(condition, "CheckVouch");
        Employee me = this.getCurrentEmployee();
        condition.setPartnerId(me.getCurrentPartner().getId());
        Page page = this.service.findCheckVouchs(condition);
        model.addAttribute("me", (Object)me);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="checkvouchId", required=false) String checkvouchId, Model model) {
        CheckVouch checkVouch = this.service.queryCheckVouchDetail(checkvouchId);
        model.addAttribute("me", (Object)this.getCurrentEmployee());
        model.addAttribute("checkVouch", (Object)checkVouch);
        model.addAttribute("checkVouchItemItems", (Object)JSON.toJSONString(checkVouch.getCheckVouchItems()));
        return "checkVouch/view.ftl";
    }

    @RequestMapping(value={"/importExcel.do"}, method={RequestMethod.GET})
    public String importExcel(Model model) throws Exception {
        return "checkVouch/importExcel.ftl";
    }

    @RequestMapping(value={"/importExcel.do"}, method={RequestMethod.POST})
    public String importExcel(CheckVouch checkVouch, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<AdjustStockUtil> msglist;
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "checkVouch");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        if ((msglist = this.service.readExpBalanceByExcel(url, me, checkVouch)).size() > 0) {
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist))));
            return "common/iframeRtn.ftl";
        }
        if (Beans.isEmpty(checkVouch.getCheckVouchItems())) {
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6")));
            return "common/iframeRtn.ftl";
        }
        try {
            checkVouch.setCheckvouchId(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "05"));
            this.service.save(checkVouch, this.getCurrentEmployee());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(ex)));
            return "common/iframeRtn.ftl";
        }
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }
}

