/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.checkVouch;

import com.alibaba.fastjson.JSON;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.check.CheckVouchCondition;
import com.tcbj.crm.entity.CheckVouch;
import com.tcbj.crm.entity.CheckVouchItem;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.Log;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkVouchNewService")
public class CheckVouchNewService {
    @Autowired
    BaseDao baseDao;

    public void del(String id) throws Exception {
        CheckVouch cv = (CheckVouch)this.baseDao.get(CheckVouch.class, (Serializable)((Object)id));
        if (!cv.getCheckvouchFlag().equals("1")) {
            throw new Exception("\u4e0d\u80fd\u5220\u9664\u8be5\u6570\u636e");
        }
        Object[] args = new Object[]{id};
        String hql = "delete CheckVouchItem where checkVouchId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete CheckVouch where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public List<CheckVouchItem> getCheckVouchItems(String id) {
        String hql = "from CheckVouchItem where checkVouchId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, CheckVouchItem.class);
    }

    public CheckVouch get(String id) {
        CheckVouch obj = (CheckVouch)this.baseDao.get(CheckVouch.class, (Serializable)((Object)id));
        obj.setCheckVouchItems(this.getCheckVouchItems(id));
        return obj;
    }

    public CheckVouch getSimpleCheckVouch(String id) {
        return (CheckVouch)this.baseDao.get(CheckVouch.class, (Serializable)((Object)id));
    }

    public void saveOrUpdate(CheckVouch checkVouch) {
        if (StringUtils.isEmpty(checkVouch.getId())) {
            this.baseDao.save((Object)checkVouch);
            for (CheckVouchItem checkVouchItem : checkVouch.getCheckVouchItems()) {
                checkVouchItem.setCheckVouchId(checkVouch.getId());
            }
            this.baseDao.save(checkVouch.getCheckVouchItems());
        } else {
            this.baseDao.update((Object)checkVouch);
            List<CheckVouchItem> newItemsCheckVouchItem = checkVouch.getCheckVouchItems();
            List<CheckVouchItem> itemsCheckVouchItem = this.getCheckVouchItems(checkVouch.getId());
            ArrayList<CheckVouchItem> updateItemsCheckVouchItem = new ArrayList<CheckVouchItem>();
            ArrayList<CheckVouchItem> appendItemsCheckVouchItem = new ArrayList<CheckVouchItem>();
            ArrayList<CheckVouchItem> delItemsCheckVouchItem = new ArrayList<CheckVouchItem>();
            for (CheckVouchItem ni : newItemsCheckVouchItem) {
                boolean isnew = true;
                for (CheckVouchItem i : itemsCheckVouchItem) {
                    if (!ni.getId().equals(i.getId())) continue;
                    i.update(ni);
                    isnew = false;
                    updateItemsCheckVouchItem.add(i);
                    break;
                }
                if (!isnew) continue;
                ni.setId(UUIDUtils.getId());
                ni.setCheckVouchId(checkVouch.getId());
                appendItemsCheckVouchItem.add(ni);
            }
            for (CheckVouchItem i : itemsCheckVouchItem) {
                boolean isdel = true;
                for (CheckVouchItem ni : newItemsCheckVouchItem) {
                    if (!ni.getId().equals(i.getId())) continue;
                    isdel = false;
                    break;
                }
                if (!isdel) continue;
                delItemsCheckVouchItem.add(i);
            }
            if (appendItemsCheckVouchItem.size() > 0) {
                this.baseDao.save(appendItemsCheckVouchItem);
            }
            if (updateItemsCheckVouchItem.size() > 0) {
                this.baseDao.update(updateItemsCheckVouchItem);
            }
            if (delItemsCheckVouchItem.size() > 0) {
                this.baseDao.deleteAll(delItemsCheckVouchItem);
            }
        }
    }

    public void updateState(String id, String state) {
        String hql = "update CheckVouch set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }

    public void save(CheckVouch checkVouch, Employee emp) {
        HashMap<String, String> sendData = new HashMap<String, String>();
        String currentDateStr = DateUtils.formartDate((Date)checkVouch.getCheckVouchDate(), (String)"yyyy-MM-dd HH:mm:ss");
        String orgId = ConfigFactory.get().get("prefix");
        Storage storage = Cache.getStorages().get(checkVouch.getStorageId());
        sendData.put("organization", orgId);
        sendData.put("inventoryTime", currentDateStr);
        if (Beans.isNotEmpty((Object)checkVouch.getOnWayTime())) {
            sendData.put("onWayTime", DateUtils.formartDate((Date)checkVouch.getOnWayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            sendData.put("onWayTime", currentDateStr);
        }
        HashMap<String, Cloneable> jsonStr = new HashMap<String, Cloneable>();
        HashMap<String, String> headData = new HashMap<String, String>();
        jsonStr.put("headData", headData);
        headData.put("comment", checkVouch.getRemark());
        headData.put("inventoryCode", checkVouch.getCheckvouchId());
        headData.put("warehouseId", storage.getId());
        headData.put("adjustType", "1");
        ArrayList itemList = new ArrayList();
        jsonStr.put("listData", itemList);
        for (CheckVouchItem item : checkVouch.getCheckVouchItems()) {
            Product product = Cache.getProduct(item.getProductId());
            Cache.getPartner(emp.getCurrentPartner().getId());
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("partnerCode", ConfigFactory.get().get("auto_partnerShortCode"));
            itemMap.put("partnerOtherNum", ConfigFactory.get().get("auto_partnerLongCode"));
            itemMap.put("productId", product.getId());
            itemMap.put("productCode", product.getNo());
            itemMap.put("productOtherNum", product.getEasNo());
            itemMap.put("quantity", new BigDecimal(item.getRealityQuantity()).toPlainString());
            itemMap.put("warehouseId", storage.getId());
            itemMap.put("warehouseCode", storage.getStorageCode());
            itemMap.put("orgId", orgId);
            itemMap.put("brandId", product.getBrand());
            itemMap.put("statusFromTime", currentDateStr);
            itemMap.put("lastUpdateMan", emp.getId());
            itemMap.put("createMan", emp.getId());
            itemMap.put("lastUpdateDate", currentDateStr);
            itemMap.put("createDate", currentDateStr);
            itemList.add(itemMap);
        }
        sendData.put("jsonStr", JSON.toJSONString(jsonStr));
        EasRequestHelper.getInstance().sendBodyToESB(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/addInventoryBase", sendData);
    }

    public Page findCheckVouchs(CheckVouchCondition con) {
        HashMap<String, String> sendData = new HashMap<String, String>();
        sendData.put("fromRow", con.getPageno().toString());
        sendData.put("maxRows", String.valueOf(Constant.DEFAULT_ROWS));
        sendData.put("organization", ConfigFactory.get().get("prefix"));
        sendData.put("adjustType", "1");
        if (StringUtils.isNotEmpty(con.getCheckvouchId())) {
            sendData.put("inventoryCode", con.getCheckvouchId());
        }
        Map<String, Object> result = EasRequestHelper.getInstance().sendBodyToESB(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/queryInventoryBase", sendData);
        Map returnObject = (Map)result.get("returnObject");
        List list = (List)returnObject.get("resultQuery");
        ArrayList<CheckVouch> checkVouchList = new ArrayList<CheckVouch>();
        for (Map map : list) {
            CheckVouch checkVouch = new CheckVouch();
            checkVouch.setRemark((String)map.get("comment"));
            checkVouch.setCreateDt(DateUtils.autoFormatDate((String)((String)map.get("inventoryDate")), null));
            checkVouch.setStorageId((String)map.get("warehouseId"));
            checkVouch.setId(String.valueOf(map.get("id")));
            checkVouch.setCheckvouchId((String)map.get("inventoryCode"));
            if (Beans.isNotEmpty(map.get("onWayDate"))) {
                checkVouch.setOnWayTime(DateUtils.autoFormatDate((String)((String)map.get("onWayDate")), null));
            }
            checkVouchList.add(checkVouch);
        }
        int count = Integer.valueOf(returnObject.get("count").toString());
        Page page = new Page(checkVouchList, con.getPageno().intValue(), Constant.DEFAULT_ROWS, count);
        return page;
    }

    public CheckVouch queryCheckVouchDetail(String checkvouchId) {
        CheckVouchCondition con = new CheckVouchCondition();
        con.setCheckvouchId(checkvouchId);
        List checkVouchs = this.findCheckVouchs(con).getList();
        if (checkVouchs.size() == 0) {
            throw new AppException("0010", "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u76d8\u70b9\u5355!");
        }
        CheckVouch checkVouch = (CheckVouch)checkVouchs.get(0);
        HashMap<String, String> sendData = new HashMap<String, String>();
        sendData.put("organization", ConfigFactory.get().get("prefix"));
        sendData.put("inventoryCode", checkvouchId);
        sendData.put("fromRow", con.getPageno().toString());
        sendData.put("maxRows", String.valueOf(Integer.MAX_VALUE));
        Map result = (Map)EasRequestHelper.getInstance().sendBodyToESBResult(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/queryInventoryBaseDetail", sendData);
        List items = (List)result.get("resultQuery");
        ArrayList<CheckVouchItem> checkVouchItems = new ArrayList<CheckVouchItem>();
        for (Map map : items) {
            CheckVouchItem item = new CheckVouchItem();
            Product product = Cache.getProductByNo((String)map.get("productCode"));
            if (Beans.isNotEmpty((Object)product)) {
                item.setProductId(product.getId());
                item.setProductName(product.getName());
            }
            item.setRealityQuantity(Double.parseDouble((String)map.get("quantity")));
            checkVouchItems.add(item);
        }
        checkVouch.setCheckVouchItems(checkVouchItems);
        return checkVouch;
    }

    public List<AdjustStockUtil> readExpBalanceByExcel(String filePath, Employee me, CheckVouch checkVouch) {
        ArrayList<AdjustStockUtil> megs = new ArrayList<AdjustStockUtil>();
        List datas = null;
        String[] headers = new String[]{"productCode", "realityQuantity"};
        try {
            datas = Excels.readExcel((String)filePath, (InputStream)new FileInputStream(filePath), (String[])headers);
        }
        catch (FileNotFoundException e) {
            Log.error((String)"upload error", (Throwable)e);
        }
        List<CheckVouchItem> checkVouchItems = checkVouch.getCheckVouchItems();
        int line = 2;
        for (Map data : datas) {
            CheckVouchItem checkVouchItem = new CheckVouchItem();
            if (this.handleMsg(line, "\u4ea7\u54c1\u7f16\u53f7", ValidataUtils.validataString(data.get("productCode")), megs)) {
                Product product = Cache.getProductByNo((String)data.get("productCode"));
                if (Beans.isEmpty((Object)product)) {
                    this.handleMsg(line, "\u4ea7\u54c1\u7f16\u53f7", "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4ea7\u54c1", megs);
                } else {
                    checkVouchItem.setProductId(product.getId());
                }
            }
            if (this.handleMsg(line, "\u76d8\u70b9\u6570\u91cf", ValidataUtils.validataDouble(data.get("realityQuantity")), megs)) {
                checkVouchItem.setRealityQuantity(Double.valueOf((String)data.get("realityQuantity")));
            }
            checkVouchItems.add(checkVouchItem);
            ++line;
        }
        return megs;
    }

    private boolean handleMsg(int line, String fieldName, String msg, List<AdjustStockUtil> megs) {
        if (StringUtils.isNotEmpty(msg)) {
            String result = "Excel\u4e2d\u7b2c" + line + "\u884c:" + "(" + fieldName + ")" + msg;
            megs.add(new AdjustStockUtil(result));
            return false;
        }
        return true;
    }
}

