/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.ShopView;
import com.tcbj.crm.view.ShopViewAddress;
import com.tcbj.crm.view.ShopViewContats;
import com.tcbj.framework.util.Page;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/client"})
public class ClientController
extends BaseController {
    @Autowired
    ClientService service;
    @Autowired
    PartnerService partnerService;
    @Autowired
    Cache cache;
    @Autowired
    ShopService shopService;
    @Autowired
    PartnerShopService partnerShopService;

    @RequestMapping(value={"/applys.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ClientCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        if (con == null) {
            con = new ClientCondition();
        }
        con.setPartnerId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        con.setArea(true);
        Page customerList = this.service.findPartnerApplys(con, pageno);
        model.addAttribute("customerList", (Object)customerList);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "client/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        List<PartnerShop> list = this.service.getPartner(me.getCurrentPartner().getId());
        if (list.size() > 0) {
            PartnerShop partnerShop = this.partnerShopService.get(list.get(0).getId());
            model.addAttribute("partnerShop", (Object)partnerShop);
            ArrayList<PartnerAddress> addresslist = new ArrayList<PartnerAddress>();
            List<PartnerContact> contactlist = new ArrayList<PartnerContact>();
            Customer customer = new Customer();
            if ("Partner".equals(list.get(0).getOrgtype())) {
                customer = this.service.getCustomerAddresses(list.get(0).getParentPartnerId(), list.get(0).getId());
                if (customer != null) {
                    addresslist.addAll(customer.getAddresses());
                }
                contactlist = this.partnerService.getPartnerContacts(list.get(0).getId());
            } else {
                ShopView shopView = this.shopService.getShopView(list.get(0).getId());
                this.changeAddressBean(addresslist, shopView.getAddresses());
                this.changeContactBean(contactlist, shopView.getContacts());
            }
            model.addAttribute("customer", (Object)customer);
            model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(addresslist, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
            model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(contactlist, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("add", (Object)"add");
        return "client/apply.ftl";
    }

    @RequestMapping(value={"/AJAXPartner.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result ajaxPartner(String id, HttpServletResponse response) {
        PartnerShop partnerShop = this.partnerShopService.get(id);
        ArrayList<PartnerAddress> addresslist = new ArrayList<PartnerAddress>();
        List<PartnerContact> contactlist = new ArrayList<PartnerContact>();
        Customer customer = new Customer();
        if ("Partner".equals(partnerShop.getOrgtype())) {
            customer = this.service.getCustomerAddresses(partnerShop.getParentPartnerId(), partnerShop.getId());
            if (customer != null) {
                addresslist.addAll(customer.getAddresses());
            }
            contactlist = this.partnerService.getPartnerContacts(partnerShop.getId());
        } else {
            ShopView shopView = this.shopService.getShopView(partnerShop.getId());
            this.changeAddressBean(addresslist, shopView.getAddresses());
            this.changeContactBean(contactlist, shopView.getContacts());
        }
        if (customer == null) {
            customer = new Customer();
        }
        customer.setAddresses(addresslist);
        customer.setContacts(contactlist);
        String json = "[" + JSON.toJSONStringWithDateFormat((Object)customer, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]) + "," + JSON.toJSONStringWithDateFormat((Object)partnerShop, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]) + "]";
        return this.getSuccessResult(json);
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        partner.fillInitData(me);
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.fillInitData(me);
        }
        this.service.add(partner, me);
        this.cache.initCustomers();
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        Customer customer = this.service.get(id);
        PartnerShop partnerShop = this.partnerShopService.get(customer.getApplyerId());
        model.addAttribute("partnerShop", (Object)partnerShop);
        List<PartnerAddress> addresslist = this.service.getPartnerAddresses(customer.getId());
        List<PartnerContact> contactlist = new ArrayList<PartnerContact>();
        if ("Partner".equals(customer.getOrgtype())) {
            customer = this.service.getCustomerAddresses(customer.getSupplierId(), customer.getApplyerId());
            contactlist = this.partnerService.getPartnerContacts(customer.getApplyerId());
        } else {
            ShopView shopView = this.shopService.getShopView(customer.getApplyerId());
            this.changeContactBean(contactlist, shopView.getContacts());
        }
        String orgId = this.getCurrentEmployee().getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(addresslist, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(contactlist, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "client/view.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        Customer customer = this.service.get(id);
        PartnerShop partnerShop = this.partnerShopService.get(customer.getApplyerId());
        model.addAttribute("partnerShop", (Object)partnerShop);
        List<PartnerAddress> addresslist = this.service.getPartnerAddresses(customer.getId());
        List<PartnerContact> contactlist = new ArrayList<PartnerContact>();
        if ("Partner".equals(customer.getOrgtype())) {
            customer = this.service.getCustomerAddresses(customer.getSupplierId(), customer.getApplyerId());
            contactlist = this.partnerService.getPartnerContacts(customer.getApplyerId());
        } else {
            ShopView shopView = this.shopService.getShopView(customer.getApplyerId());
            this.changeContactBean(contactlist, shopView.getContacts());
        }
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(addresslist, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(contactlist, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "client/edit.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        partner.fillInitData(me);
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setSiebelId(address.getId());
            address.fillInitData(me);
        }
        this.service.updatePartner(partner, me);
        return this.getSuccessResult(null);
    }

    public void changeAddressBean(List<PartnerAddress> partnerAddressList, List<ShopViewAddress> shopAddressList) {
        PartnerAddress partnerAddress = null;
        for (ShopViewAddress shopAddress : shopAddressList) {
            partnerAddress = new PartnerAddress();
            partnerAddress.setAddressTypeCode(shopAddress.getAddressType());
            partnerAddress.setAddress(shopAddress.getAdressDetail());
            partnerAddress.setCityCode(shopAddress.getCityId());
            partnerAddress.setCountyCode(shopAddress.getCountyId());
            partnerAddress.setCountryCode(shopAddress.getContryId());
            partnerAddress.setProvinceCode(shopAddress.getProvinceId());
            partnerAddress.setReceiveTimeCode(shopAddress.getReceiptTime());
            partnerAddress.setStartDt(shopAddress.getStartDate());
            partnerAddress.setEndDt(shopAddress.getEndDate());
            partnerAddress.setContactCode(shopAddress.getDefaultContacts());
            partnerAddress.setContactPhone(shopAddress.getContatsPhone());
            partnerAddress.setZip(shopAddress.getZipCode());
            partnerAddress.setCityManagerId(shopAddress.getCityManagerId());
            partnerAddressList.add(partnerAddress);
        }
    }

    public void changeContactBean(List<PartnerContact> partnerContactlist, List<ShopViewContats> shopContatsList) {
        PartnerContact partnerContact = null;
        for (ShopViewContats shopViewContats : shopContatsList) {
            partnerContact = new PartnerContact();
            partnerContact.setContactName(shopViewContats.getContactsName());
            partnerContact.setDutyTypeCode(shopViewContats.getDutyType());
            partnerContact.setMobile(shopViewContats.getMobilePhone());
            partnerContact.setStartDate(shopViewContats.getStartDate());
            partnerContact.setEndDate(shopViewContats.getEndDate());
            partnerContact.setAddress(shopViewContats.getAddress());
            partnerContact.setEmail(shopViewContats.getEmail());
            partnerContact.setFax(shopViewContats.getFax());
            partnerContact.setQq(shopViewContats.getQq());
            partnerContact.setTel(shopViewContats.getOfficePhone());
            partnerContact.setZip(shopViewContats.getZipCode());
            partnerContact.setIsContact(shopViewContats.getIsContact());
            partnerContactlist.add(partnerContact);
        }
    }
}

