/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.common;

import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.framework.exception.DatabaseException;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.classic.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class NewBaseDaoImpl
implements NewBaseDao {
    private HibernateTemplate hibernateTemplate;

    public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    private DatabaseException runtimeException(Exception e) {
        return new DatabaseException(e.getMessage(), (Throwable)e);
    }

    @Override
    public Page findPageBySql(String sql, List<Object> args, int pageNo, int pageSize) {
        int count = this.queryBySqlForInt(sql, args);
        List<Map<String, Object>> list = this.findBySql(sql, args, pageNo, pageSize);
        Page page = new Page(list, pageNo, pageSize, count);
        return page;
    }

    @Override
    public List<Map<String, Object>> findBySql(final String sql, final List<Object> args, final int pageNo, final int pageSize) {
        try {
            return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Map<String, Object>>>(){

                public List<Map<String, Object>> doInHibernate(org.hibernate.Session paramSession) throws HibernateException, SQLException {
                    Query query = paramSession.createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                    if (args != null) {
                        int i = 0;
                        while (i < args.size()) {
                            query.setParameter(i, args.get(i));
                            ++i;
                        }
                    }
                    if (pageNo > 0 && pageSize > 0) {
                        query.setFirstResult((pageNo - 1) * pageSize);
                        query.setMaxResults(pageSize);
                    }
                    List list = query.list();
                    return list;
                }
            });
        }
        catch (Exception e) {
            this.runtimeException(e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> findBySql(String sql, List<Object> args) {
        return this.findBySql(sql, args, 0, 0);
    }

    @Override
    public List<Map<String, Object>> findBySql(String sql) {
        return this.findBySql(sql, null);
    }

    @Override
    public <T> boolean save(T object) {
        try {
            this.getHibernateTemplate().save(object);
            return true;
        }
        catch (Exception e) {
            this.runtimeException(e);
            return false;
        }
    }

    @Override
    public <T> boolean update(T object) {
        try {
            this.getHibernateTemplate().update(object);
            return true;
        }
        catch (Exception e) {
            this.runtimeException(e);
            return false;
        }
    }

    @Override
    public <T> boolean delete(T object) {
        try {
            this.getHibernateTemplate().delete(object);
            return true;
        }
        catch (Exception e) {
            this.runtimeException(e);
            return false;
        }
    }

    @Override
    public <T> boolean saveAll(List<T> object) {
        try {
            for (T o : object) {
                this.save(o);
            }
            return true;
        }
        catch (Exception e) {
            this.runtimeException(e);
            return false;
        }
    }

    @Override
    public <T> boolean updateAll(List<T> object) {
        try {
            for (T o : object) {
                this.update(o);
            }
            return true;
        }
        catch (Exception e) {
            this.runtimeException(e);
            return false;
        }
    }

    @Override
    public <T> boolean deleteAll(List<T> object) {
        try {
            for (T o : object) {
                this.delete(o);
            }
            return true;
        }
        catch (Exception e) {
            this.runtimeException(e);
            return false;
        }
    }

    @Override
    public <T> boolean deleteById(Serializable id, Class<T> clazz) {
        Object o = this.getHibernateTemplate().get(clazz, id);
        return this.delete(o);
    }

    @Override
    public <T> Page findPageByHql(String hql, List<Object> args, int pageNo, int pageSize) {
        int total = this.queryByHqlForInt(hql, args);
        List<T> list = this.findByHql(hql, args, pageNo, pageSize);
        Page page = new Page(list, pageNo, pageSize, total);
        return page;
    }

    @Override
    public <T> List<T> findByHql(final String sql, final List<Object> args, final int pageNo, final int pageSize) {
        try {
            return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

                public List<T> doInHibernate(org.hibernate.Session paramSession) throws HibernateException, SQLException {
                    Query query = paramSession.createQuery(sql);
                    if (args != null) {
                        int i = 0;
                        while (i < args.size()) {
                            query.setParameter(i, args.get(i));
                            ++i;
                        }
                    }
                    if (pageSize > 0 && pageNo > 0) {
                        query.setFirstResult((pageNo - 1) * pageSize);
                        query.setMaxResults(pageSize);
                    }
                    List list = query.list();
                    return list;
                }
            });
        }
        catch (Exception e) {
            this.runtimeException(e);
            return null;
        }
    }

    @Override
    public <T> T findByHqlUnique(String sql, List<Object> args) {
        List<T> list = this.findByHql(sql, args, 1, 1);
        if (Beans.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> findByHql(String hql, List<Object> args) {
        return this.findByHql(hql, args, 0, 0);
    }

    @Override
    public <T> List<T> findByHql(String hql) {
        return this.getHibernateTemplate().find(hql, null);
    }

    @Override
    public <T> int queryByHqlForInt(String hql, List<Object> args) {
        return this.commconQuery(hql, args, true);
    }

    @Override
    public <T> int queryByHqlForInt(String hql) {
        return this.queryByHqlForInt(hql, null);
    }

    @Override
    public int queryBySqlForInt(String sql, List<Object> args) {
        return this.commconQuery(sql, args, false);
    }

    @Override
    public int queryBySqlForInt(String sql) {
        return this.queryBySqlForInt(sql, null);
    }

    private int commconQuery(final String sql, final List<Object> args, final boolean isHql) {
        try {
            return (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                public Integer doInHibernate(org.hibernate.Session paramSession) throws HibernateException, SQLException {
                    Object obj;
                    Query query = null;
                    if (isHql) {
                        String countHql = NewBaseDaoImpl.this.getTotalCountHql(sql);
                        query = paramSession.createQuery(countHql);
                    } else {
                        String countSql = "select count(*) from (" + sql + ") t";
                        query = paramSession.createSQLQuery(countSql);
                    }
                    if (Beans.isNotEmpty((Object)args)) {
                        int i = 0;
                        while (i < args.size()) {
                            query.setParameter(i, args.get(i));
                            ++i;
                        }
                    }
                    if (Beans.isNotEmpty((Object)(obj = query.uniqueResult()))) {
                        return Integer.valueOf(obj.toString());
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            this.runtimeException(e);
            return 0;
        }
    }

    private String getTotalCountHql(String hql) {
        int sql_from = hql.indexOf("from");
        int sql_orderby = hql.indexOf("order by");
        String countStr = "";
        countStr = sql_orderby > 0 ? "select count(*) " + hql.substring(sql_from, sql_orderby) : "select count(*) " + hql.substring(sql_from);
        return countStr;
    }

    @Override
    public <T> Integer updateByHql(final String hql, final List<Object> args) {
        try {
            return (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                public Integer doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query query = session.createQuery(hql);
                    if (Beans.isNotEmpty((Object)args)) {
                        int i = 0;
                        while (i < args.size()) {
                            query.setParameter(i, args.get(i));
                            ++i;
                        }
                    }
                    return query.executeUpdate();
                }
            });
        }
        catch (Exception e) {
            this.runtimeException(e);
            return 0;
        }
    }

    @Override
    public <T> Map<String, Object> executeProcedure(String procedureName, Object ... args) {
        Session session = this.hibernateTemplate.getSessionFactory().getCurrentSession();
        boolean result = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PreparedStatement st = session.connection().prepareStatement("{call cx_sale_order_iface_pvt.DSS_RETURN_IFACE_TO_CRM('T')}");
            result = st.execute();
            result = true;
        }
        catch (SQLException | HibernateException e) {
            result = false;
            e.printStackTrace();
        }
        map.put("flag", result);
        return map;
    }

    private <T> List<T> findBySql(final String sql, final List<Object> args, final int pageNo, final int pageSize, final Class<T> clazz) {
        try {
            return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

                public List<T> doInHibernate(org.hibernate.Session paramSession) throws HibernateException, SQLException {
                    SQLQuery query = paramSession.createSQLQuery(sql);
                    if (args != null) {
                        int i = 0;
                        while (i < args.size()) {
                            query.setParameter(i, args.get(i));
                            ++i;
                        }
                    }
                    if (pageNo > 0 && pageSize > 0) {
                        query.setFirstResult((pageNo - 1) * pageSize);
                        query.setMaxResults(pageSize);
                    }
                    return query.addEntity(clazz).list();
                }
            });
        }
        catch (Exception e) {
            this.runtimeException(e);
            return null;
        }
    }

    @Override
    public Page findPageBySql(String sql, List<Object> args, int pageNo, int pageSize, Class clazz) {
        int count = this.queryBySqlForInt(sql, args);
        List list = this.findBySql(sql, args, pageNo, pageSize, clazz);
        return new Page(list, pageNo, pageSize, count);
    }

    @Override
    public <T> List<T> findBySql(String sql, List<Object> args, Class<T> clazz) {
        return this.findBySql(sql, args, 0, 0, clazz);
    }
}

