/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.common;

import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.entity.OrderNo;
import com.tcbj.crm.exception.AppException;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="orderNoService")
public class OrderNoService {
    public static final String ORDER_APPLY = "01";
    public static final String ORDER_RTN = "02";
    public static final String ORDER_OUT = "03";
    public static final String ORDER_IN = "04";
    public static final String ORDER_CHECK = "05";
    public static final String ORDER_APLFINE = "06";
    public static final String ORDER_ADJUST = "07";
    public static final String ORDER_INTRE = "08";
    public static final String ORDER_STORAGE = "09";
    public static final String DESIGN_CODE = "pmsj";
    public static final String DIMENSION_CODE = "swsj";
    public static final String PARTNER_CODE = "10001";
    public static final String ORDER_APPLY_EXCEL_NO = "order_excel_fph";
    @Autowired
    private BaseDao baseDao;
    @Autowired
    @Qualifier(value="idDao")
    private NewBaseDao idDao;

    public String maxNo(String partnerNo, String type) {
        if (partnerNo == null || type == null) {
            return null;
        }
        String id = String.valueOf(partnerNo) + "_" + type;
        OrderNo no = (OrderNo)this.baseDao.get(OrderNo.class, (Serializable)((Object)id));
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        Date now = new Date();
        if (no == null) {
            no = new OrderNo(id, now, 1);
            this.baseDao.save((Object)no);
        } else {
            Date dt = no.getDt();
            if (sdf.format(now).equals(sdf.format(dt))) {
                no.setCount(no.getCount() + 1);
            } else {
                no.setCount(1);
                no.setDt(now);
            }
            this.baseDao.update((Object)no);
        }
        int count = no.getCount();
        String strCount = null;
        strCount = count < 10 ? "0" + String.valueOf(count) : String.valueOf(count);
        return String.valueOf(partnerNo) + type + sdf.format(no.getDt()) + strCount;
    }

    public String updateNo(String id, boolean state) {
        OrderNo no = (OrderNo)this.baseDao.get(OrderNo.class, (Serializable)((Object)id));
        Date now = new Date();
        Integer countI = 0;
        if (no == null) {
            no = new OrderNo(id, now, 100001);
            this.baseDao.save((Object)no);
        } else {
            countI = no.getCount() + 1;
            if (state) {
                no.setCount(no.getCount() + 1);
                no.setDt(now);
                this.baseDao.update((Object)no);
            }
        }
        String count = countI.toString();
        return count;
    }

    public String updatePartnerNo(String type, boolean state) {
        String prefix = StringUtils.getPrefix();
        OrderNo no = (OrderNo)this.baseDao.get(OrderNo.class, (Serializable)((Object)(PARTNER_CODE + prefix)));
        Date now = new Date();
        Integer countI = Integer.parseInt(PARTNER_CODE);
        if (no == null) {
            no = new OrderNo(PARTNER_CODE, now, countI);
            this.baseDao.save((Object)no);
        } else {
            countI = no.getCount() + 1;
            if (state) {
                no.setCount(no.getCount() + 1);
                no.setDt(now);
                this.baseDao.update((Object)no);
            }
        }
        String count = countI.toString();
        return String.valueOf(type) + count;
    }

    public String updateShopNo(String id, boolean state) {
        OrderNo no = (OrderNo)this.baseDao.get(OrderNo.class, (Serializable)((Object)id));
        Date now = new Date();
        Integer countI = 0;
        if (no == null) {
            no = new OrderNo(id, now, 200001);
            this.baseDao.save((Object)no);
        } else {
            countI = no.getCount() + 1;
            if (state) {
                no.setCount(no.getCount() + 1);
                no.setDt(now);
                this.baseDao.update((Object)no);
            }
        }
        String count = countI.toString();
        return count;
    }

    public String saveBalanceShopNo(String id, boolean state) {
        List<Map<String, Object>> list = this.idDao.findBySql(" select cx_shop_record_s.nextval as \"id\" from dual ");
        String no = StringUtils.objToStr(list.get(0).get("id"));
        if (StringUtils.isEmpty(no)) {
            throw new AppException("\u95e8\u5e97\u5e8f\u5217\u751f\u6210\u5668\u5f02\u5e38,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458");
        }
        return no;
    }

    public String updateOrderApplyExcelNo(String partnerNo) {
        if (partnerNo == null) {
            return null;
        }
        String id = String.valueOf(partnerNo) + "_" + ORDER_APPLY_EXCEL_NO;
        OrderNo no = (OrderNo)this.baseDao.get(OrderNo.class, (Serializable)((Object)id));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        if (no == null) {
            no = new OrderNo(id, now, 10000);
            this.baseDao.save((Object)no);
        } else {
            Date dt = no.getDt();
            if (sdf.format(now).equals(sdf.format(dt))) {
                no.setCount(no.getCount() + 1);
            } else {
                no.setCount(10000);
                no.setDt(now);
            }
            this.baseDao.update((Object)no);
        }
        return String.valueOf(sdf.format(no.getDt())) + no.getCount();
    }

    public String maxNoPredictConfig(String type) {
        if (type == null) {
            return null;
        }
        String id = type;
        OrderNo no = (OrderNo)this.baseDao.get(OrderNo.class, (Serializable)((Object)id));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        if (no == null) {
            no = new OrderNo(id, now, 1);
            this.baseDao.save((Object)no);
        } else {
            Date dt = no.getDt();
            if (sdf.format(now).equals(sdf.format(dt))) {
                no.setCount(no.getCount() + 1);
            } else {
                no.setCount(1);
                no.setDt(now);
            }
            this.baseDao.update((Object)no);
        }
        int count = no.getCount();
        String strCount = null;
        strCount = count < 10 ? "000" + String.valueOf(count) : (count < 100 ? "00" + String.valueOf(count) : (count < 1000 ? "0" + String.valueOf(count) : String.valueOf(count)));
        return String.valueOf(type) + sdf.format(no.getDt()) + strCount;
    }
}

