/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.common;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.common.CustomerCondition;
import com.tcbj.crm.common.ProductCondition;
import com.tcbj.crm.common.SelectService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/select"})
public class SelectController
extends BaseController {
    @Autowired
    SelectService service;
    @Autowired
    ProductService productService;
    @Autowired
    PersonnelService personnelService;

    @RequestMapping(value={"/selectProduct.do"}, method={RequestMethod.GET})
    public String selectProductView(Model model) {
        return "common/selectProducts.ftl";
    }

    @RequestMapping(value={"/selectProductDatas.do"}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<Product> selectProductDatas(@ModelAttribute(value="prductCondition") ProductCondition con, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        Contact contact = this.personnelService.get(me.getId());
        return this.service.findProducts(con, contact);
    }

    @RequestMapping(value={"/findCustomerProducts.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<Product> findCustomerProducts(String applyerId, Model model) {
        Employee me = this.getCurrentEmployee();
        ArrayList<Product> products = new ArrayList<Product>();
        List<Object> _products = this.productService.getPartnerProducts(applyerId, me.getCurrentPartner().getId());
        for (Object ps : _products) {
            Product p = (Product)((Object[])ps)[0];
            products.add(p);
        }
        return products;
    }

    @RequestMapping(value={"/findProducts.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<Product> findProducts(com.tcbj.crm.product.ProductCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        ArrayList<Product> products = new ArrayList<Product>();
        con.setEm(me);
        List<Product> _products = this.productService.getProducts(con);
        for (Product ps : _products) {
            ps.setDb(null);
            ps.setPl(null);
            ps.setPpREL(null);
            products.add(ps);
        }
        return products;
    }

    @RequestMapping(value={"/selectCustomer.do"}, method={RequestMethod.GET})
    public String selectCustomerView(Model model) {
        return "common/selectCustomers.ftl";
    }

    @RequestMapping(value={"/selectCustomerDatas.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<Customer> selectCustomerDatas(@ModelAttribute(value="customerCondition") CustomerCondition con, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        return this.service.findCustomers(con);
    }
}

