/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.common;

import com.tcbj.crm.common.CustomerCondition;
import com.tcbj.crm.common.ProductCondition;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ProductAttachment;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectService")
public class SelectService {
    @Autowired
    private BaseDao baseDao;

    public List<Product> findProducts(ProductCondition con, Contact contact) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("select p from Product p where 1=1 ");
        if (contact != null && StringUtils.isNotEmpty(contact.getPartnerOrgId())) {
            HQL.append(" and p.orgId=? ");
            args.add(StringUtils.getOrgId());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        HQL.append(" order by p.no ");
        List list = this.baseDao.findEntity(HQL.toString(), args.toArray(), Product.class);
        for (Product p : list) {
            p.setDb(new HashSet<PartnerProduct>());
            p.setPl(new HashSet<ProductAttachment>());
            p.setPpREL(new HashSet<PartnerProductREL>());
        }
        return list;
    }

    public List<Customer> findCustomers(CustomerCondition con) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Customer where supplierId=?");
        args.add(con.getPartnerId());
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and supplierName like ? ");
            args.add("%" + con.getName().trim() + "%");
        }
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), Customer.class);
    }
}

