/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.dataSynchro;

import com.tcbj.crm.dataSynchro.DataSynchroErroeService;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ThreadPools;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataSynchroHandle")
public class DataSynchroHandleService {
    @Autowired
    DataSynchroErroeService dataSynchroErroeService;
    private String orgId = StringUtils.getPrefix();

    public void saveThread(Object dataParam, String cspDataSynchro, Employee me) {
        HashMap<String, Object> cspDataParam = new HashMap<String, Object>();
        cspDataParam.put("url", String.valueOf(StringUtils.getConfigure("parent_url")) + cspDataSynchro);
        cspDataParam.put("postParam", dataParam);
        HashMap<String, String> baseInfo = new HashMap<String, String>();
        baseInfo.put("orgId", this.orgId);
        baseInfo.put("currentPartner", me.getCurrentPartner().getId());
        baseInfo.put("userId", me.getId());
        cspDataParam.put("baseInfo", baseInfo);
        this.handleThread(cspDataParam, null, me);
    }

    public void sendThread(String siebelId, String siebelDataSynchro, Employee me) {
        HashMap<String, String> interfaceParam = new HashMap<String, String>();
        interfaceParam.put("orgID", this.orgId);
        interfaceParam.put("identityType", "ROWID");
        interfaceParam.put("interfaceName", siebelDataSynchro);
        interfaceParam.put("identityId", siebelId);
        interfaceParam.put("jsonStr", "");
        this.handleThread(null, interfaceParam, me);
    }

    public void handleThread(Map<String, Object> cspDataParam, Map<String, String> interfaceParam, Employee me) {
        String dataSynchro = StringUtils.getConfigure("dataSynchro");
        if ("1".equals(dataSynchro)) {
            ExecutorService executor = ThreadPools.newExecutorService((int)20, (int)30, (int)20, (int)10, (String)"tg_cspDataBase");
            try {
                Task task = new Task(me, cspDataParam, interfaceParam);
                executor.execute(task);
                executor.shutdown();
                while (!executor.isTerminated()) {
                    ThreadPools.sleep((long)2000L);
                }
            }
            finally {
                if (!executor.isShutdown()) {
                    executor.shutdownNow();
                }
            }
        }
    }

    private void dataUpdat(Map<String, Object> postParam, Employee me) {
        Map rMap;
        String body = EasRequestHelper.getInstance().sendCspBody(StringUtils.getConfigure("csp_data_synchro"), postParam);
        Map<String, Object> result = EsbAnalyUtil.returnErrorCode(body, "returnObject");
        Object returnObject = result.get("success");
        Object error = result.get("error");
        if (Beans.isNotEmpty((Object)returnObject) && !"200".equals(((String)(rMap = (Map)Jsons.toBean((String)returnObject.toString(), Map.class)).get("status")).toString())) {
            error = "\u63a5\u53e3\u4e2d\u8f6c\u8bf7\u6c42\u5f02\u5e38\uff1a" + (String)rMap.get("data");
        }
        if (Beans.isNotEmpty((Object)error)) {
            this.dataSynchroErroeService.saveDataSynchroError(postParam, me, error.toString(), "1");
        }
    }

    private void interfaceName(Map<String, String> interfaceParam, Employee me) {
        String url = StringUtils.getConfigure("siebel_data_synchro");
        String body = EasRequestHelper.getInstance().sendBody(url, interfaceParam);
        Map<String, Object> result = EsbAnalyUtil.returnErrorCode(body, "returnObject");
        Object error = result.get("error");
        if (Beans.isNotEmpty((Object)error)) {
            interfaceParam.put("url", url);
            this.dataSynchroErroeService.saveDataSynchroError(new HashMap<String, Object>(interfaceParam), me, error.toString(), "2");
        }
    }

    class Task
    implements Runnable {
        private Employee me;
        private Map<String, Object> cspDataParam;
        private Map<String, String> interfaceParam;

        public Task(Employee me, Map<String, Object> cspDataParam, Map<String, String> interfaceParam) {
            this.me = me;
            this.cspDataParam = cspDataParam;
            this.interfaceParam = interfaceParam;
        }

        @Override
        public void run() {
            if (Beans.isNotEmpty(this.interfaceParam)) {
                try {
                    DataSynchroHandleService.this.interfaceName(this.interfaceParam, this.me);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Beans.isNotEmpty(this.cspDataParam)) {
                try {
                    DataSynchroHandleService.this.dataUpdat(this.cspDataParam, this.me);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

