/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.design;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tcbj.crm.design.DesignCondition;
import com.tcbj.crm.entity.Design;
import com.tcbj.crm.entity.DesignItem;
import com.tcbj.crm.entity.DesignPhoto;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="designService")
public class DesignService {
    @Autowired
    BaseDao baseDao;

    public Design getById(String id) {
        Design design = (Design)this.baseDao.get(Design.class, (Serializable)((Object)id));
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from DesignItem t where t.designId = ? ";
        args.add(id);
        List item = this.baseDao.findEntity(hql.toString(), args.toArray(), DesignItem.class);
        ArrayList<DesignPhoto> photo = new ArrayList<DesignPhoto>();
        int i = 0;
        while (i < item.size()) {
            DesignItem dItem = (DesignItem)item.get(i);
            ArrayList<String> args2 = new ArrayList<String>();
            String hql2 = "from DesignPhoto t where t.itemsId = ? ";
            args2.add(dItem.getId());
            List item2 = this.baseDao.findEntity(hql2.toString(), args2.toArray(), DesignPhoto.class);
            int j = 0;
            while (j < item2.size()) {
                photo.add((DesignPhoto)item2.get(j));
                ++j;
            }
            ++i;
        }
        String items = JSON.toJSONString((Object)item);
        String photos = null;
        if (photo.size() > 0) {
            photos = JSON.toJSONString(photo);
        }
        design.setPjson(photos);
        design.setJson(items);
        return design;
    }

    public Page getPage(DesignCondition con, int pageno) {
        String hql = "from Design t where t.creatorId = ? and t.state !='9'";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getApplyerId());
        if (StringUtils.isNotEmpty(con.getState())) {
            hql = String.valueOf(hql) + "and t.state = ? ";
            args.add(con.getState());
        }
        if (StringUtils.isNotEmpty(con.getArea())) {
            hql = String.valueOf(hql) + "and t.area like ? ";
            args.add("%" + con.getArea() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCompany())) {
            hql = String.valueOf(hql) + "and t.company like ? ";
            args.add("%" + con.getCompany() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCodeNo())) {
            hql = String.valueOf(hql) + "and upper(t.codeNo) like upper(?)";
            args.add("%" + con.getCodeNo() + "%");
        }
        hql = String.valueOf(hql) + "order by t.created desc ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    @Transactional
    public void save(Design design, List<IUploadFile> filelist, Employee me) {
        this.baseDao.save((Object)design);
        List designItem = JSONArray.parseArray((String)design.getJson(), DesignItem.class);
        if (designItem.size() > 0) {
            for (DesignItem items : designItem) {
                List pItems;
                items.setDesignId(design.getId());
                this.baseDao.save((Object)items);
                if ("".equals(items.getItem()) || items.getItem() == null || (pItems = JSONArray.parseArray((String)items.getItem(), DesignPhoto.class)).size() <= 0) continue;
                for (DesignPhoto designPhoto : pItems) {
                    designPhoto.setItemsId(items.getId());
                    this.baseDao.save((Object)designPhoto);
                }
            }
        }
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(design.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        if (files.size() > 0) {
            this.baseDao.save(files);
        }
    }

    @Transactional
    public void update(Design design, List<IUploadFile> filelist, Employee me) {
        List designItem;
        this.baseDao.update((Object)design);
        String ids = design.getIds();
        if (ids != null && !"".equals(ids)) {
            int i = 0;
            while (i < ids.split(",").length) {
                this.baseDao.deleteById(DesignPhoto.class, (Serializable)((Object)ids.split(",")[i]));
                ++i;
            }
        }
        if ((designItem = JSONArray.parseArray((String)design.getJson(), DesignItem.class)).size() > 0) {
            for (DesignItem items : designItem) {
                List pItems;
                this.baseDao.update((Object)items);
                if ("".equals(items.getItem()) || items.getItem() == null || (pItems = JSONArray.parseArray((String)items.getItem(), DesignPhoto.class)).size() <= 0) continue;
                for (DesignPhoto designPhoto : pItems) {
                    String id = designPhoto.getId();
                    if (id == null || "".equals(id)) {
                        designPhoto.setItemsId(items.getId());
                        this.baseDao.save((Object)designPhoto);
                        continue;
                    }
                    this.baseDao.update((Object)designPhoto);
                }
            }
        }
        String[] fileids = design.getFileId().split(",");
        String[] stringArray = fileids;
        int n = fileids.length;
        int pItems = 0;
        while (pItems < n) {
            String id = stringArray[pItems];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete ShoppeApplyFile where id= ?", args);
            }
            ++pItems;
        }
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(design.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        this.baseDao.save(files);
    }

    public void updateState(Design design) {
        this.baseDao.update((Object)design);
    }

    @Transactional
    public void delete(String id) {
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete ShoppeApplyFile where applyId= ?", args);
        this.baseDao.deleteById(Design.class, (Serializable)((Object)id));
        ArrayList<String> itemArgs = new ArrayList<String>();
        String hql = "from DesignItem t where t.designId = ? ";
        itemArgs.add(id);
        List item = this.baseDao.findEntity(hql.toString(), itemArgs.toArray(), DesignItem.class);
        int i = 0;
        while (i < item.size()) {
            Object[] args2 = new Object[]{((DesignItem)item.get(i)).getId()};
            this.baseDao.executeHQL("delete DesignPhoto where itemsId= ?", args2);
            ++i;
        }
        this.baseDao.executeHQL("delete DesignItem where designId= ?", args);
    }
}

