/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.desktop;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.desktop.DesktopService;
import com.tcbj.crm.entity.DataUpload;
import com.tcbj.crm.entity.Notice;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.product.HintNumber;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.reply.ReplyService;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/desktop"})
public class DesktopController
extends BaseController {
    @Autowired
    private DesktopService service;
    @Autowired
    private OrderApplyService orderService;
    @Autowired
    ProductService productService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    private ShopService shopService;
    @Autowired
    private ReplyService replyService;
    @Autowired
    private RightService rightService;

    @RequestMapping(value={"/desktop.do"}, method={RequestMethod.GET})
    public String index(Model model) {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("currentEmployee", (Object)e);
        return "desktop/desktop.ftl";
    }

    @RequestMapping(value={"/work.do"}, method={RequestMethod.GET})
    public String work(Model model) {
        Employee me = this.getCurrentEmployee();
        int[] stats = this.orderService.getOrderStats(me.getId(), me.getCurrentPartner().getId());
        model.addAttribute("stats", (Object)stats);
        List<Notice> newsNList = this.service.getNoticeByType(me, "NEWS", "2", null);
        List<Notice> sysNList = this.service.getNoticeByType(me, "NOTICE", "2", null);
        List<Notice> proNList = this.service.getNoticeByType(me, "PRODUCT_INF", "2", null);
        List<Notice> proDataNList = this.service.getNoticeByType(me, "PRODUCT_DATA", "2", null);
        List<Notice> dynList = this.service.getNoticeByType(me, "PRODUCT_DYNAMIC", "2", null);
        model.addAttribute("newsNList", newsNList);
        model.addAttribute("sysNList", sysNList);
        model.addAttribute("proNList", proNList);
        model.addAttribute("proDataNList", proDataNList);
        model.addAttribute("dynList", dynList);
        List<DataUpload> licenseList = this.service.getDataUploadByType(me, "license");
        List<DataUpload> criterionList = this.service.getDataUploadByType(me, "criterion");
        model.addAttribute("licenseList", licenseList);
        model.addAttribute("criterionList", criterionList);
        HintNumber hit = this.productService.getStatProduct(me.getCurrentPartner().getId());
        model.addAttribute("hit", (Object)hit);
        Long draftCount = this.shopService.getDraftShopList(me);
        model.addAttribute("drafCount", (Object)draftCount);
        Long auditCount = this.shopService.getAuditShopCount(me);
        model.addAttribute("auditCount", (Object)auditCount);
        int[] counts = this.partnerService.getSketchCount(me.getId(), me.getCurrentPartner().getId());
        model.addAttribute("counts", (Object)counts);
        Long[] replayCount = this.replyService.replayCount(me.getCurrentPartner().getId());
        model.addAttribute("replayCount", (Object)replayCount);
        if (me.getCurrentPartner().isOrg()) {
            if (this.rightService.hasRightByUser(me.getId(), "/orderapply/approves.do")) {
                OrderApplyCondition con = new OrderApplyCondition();
                con.setSupplierId(me.getCurrentPartner().getId());
                con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
                con.setEmployeeId(me.getId());
                con.setRegionFilter(true);
                con.setCurrentPartnerId(me.getCurrentPartner().getId());
                List orderApplys = this.orderService.findOrderApplys(con, "order by T1.create_Dt desc").getList();
                model.addAttribute("approveOrders", (Object)orderApplys);
            }
        } else if (this.rightService.hasRightByUser(me.getId(), "/orderapply/applys.do")) {
            OrderApplyCondition con = new OrderApplyCondition();
            con.setApplyerId(me.getCurrentPartner().getId());
            con.setEmployeeId(me.getId());
            List orderApplys = this.orderService.findOrderApplys(con, "order by o.createDt desc").getList();
            model.addAttribute("applyOrders", (Object)orderApplys);
        }
        model.addAttribute("bottom", (Object)StringUtils.getBottom());
        model.addAttribute("phone", (Object)StringUtils.getPhone());
        return "desktop/work.ftl";
    }

    @RequestMapping(value={"/changePartner.do"}, method={RequestMethod.GET})
    public String change(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        for (EmployeePartner p : me.getPartners()) {
            if (!p.getId().equals(p.getId())) continue;
            me.setCurrentPartner(p);
        }
        return this.index(model);
    }
}

