/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.desktop;

import com.tcbj.crm.entity.DataUpload;
import com.tcbj.crm.entity.Notice;
import com.tcbj.crm.entity.NoticeE;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="desktopService")
public class DesktopService {
    @Autowired
    BaseDao baseDao;

    public NoticeE findById(String id) {
        return (NoticeE)this.baseDao.get(NoticeE.class, (Serializable)((Object)id));
    }

    public void delete(String id) {
        this.baseDao.deleteById(NoticeE.class, (Serializable)((Object)id));
    }

    public List<Notice> getNoticeByType(Employee me, String type, String noticeFlag, String sysFlag) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sql.append(" select * from (");
        sql.append(" SELECT * FROM (");
        sql.append(" SELECT nn.row_id ,nn.NOTICE_TITLE,nn.publish_date , nn.NOTICE_PICTURE,nn.ORDER_ID  FROM CX_AWK_NOTICE nn ,CX_AWK_NOTICE_S ns   ");
        sql.append(" WHERE nn.row_id=ns.notice_id   and  nn.NOTICE_FLAG='2'  ");
        sql.append(" and ns.system_flag ='CRM'  ");
        sql.append(" and sysdate between nvl(nn.start_date,sysdate-1) and  nvl(nn.end_date, sysdate + 1)");
        sql.append(" and nn.PUBLISH_ORG_ID = ?");
        sql.append("  and nn.notice_type=?  ");
        args.add(me.getCurrentPartner().getOrganizationid());
        args.add(type);
        sql.append("  union  ");
        sql.append(" SELECT nn.row_id ,nn.NOTICE_TITLE,nn.publish_date , nn.NOTICE_PICTURE ,nn.ORDER_ID FROM CX_AWK_NOTICE nn ,CX_AWK_NOTICE_U  nu ");
        sql.append(" WHERE nn.row_id = nu.notice_id  and  nn.NOTICE_FLAG='2'  ");
        sql.append(" and sysdate between nvl(nn.start_date,sysdate-1) and  nvl(nn.end_date, sysdate + 1)");
        sql.append("  and nn.notice_type=?  and nu.user_id=? ");
        sql.append(" and nn.PUBLISH_ORG_ID = ?");
        args.add(type);
        args.add(me.getId());
        args.add(me.getCurrentPartner().getOrganizationid());
        sql.append(") t  ");
        sql.append(" order by  t.publish_date desc,t.ORDER_ID  asc ) ");
        if ("PRODUCT_INF".equals(type)) {
            sql.append(" WHERE rownum <=4  ");
        } else {
            sql.append(" WHERE rownum <=7  ");
        }
        List noticeList = this.baseDao.findBySql(sql.toString(), args.toArray());
        ArrayList<Notice> voList = new ArrayList<Notice>();
        for (Object obj : noticeList) {
            Notice vo = new Notice();
            Object[] tempObj = new Object[10];
            tempObj = (Object[])obj;
            vo.setId((String)tempObj[0]);
            vo.setNoticeTitle((String)tempObj[1]);
            vo.setPublishDate((Date)tempObj[2]);
            vo.setNoticePicture((String)tempObj[3]);
            boolean flag = DateUtils.timeCompare((Date)new Date(), (Date)vo.getPublishDate()) <= 3L;
            vo.setFlag(flag);
            voList.add(vo);
        }
        return voList;
    }

    public List<DataUpload> getDataUploadByType(Employee me, String type) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from DataUpload where  enclosureType=? and (paramsId=? or enclosureValue =? ) ");
        hql.append(" and ROWNUM <= 7 ");
        hql.append(" order by createDt desc ,lastUpdateDt desc ");
        args.add(type);
        args.add(me.getCurrentPartner().getId());
        args.add(me.getCurrentPartner().getParPartnerId());
        return this.baseDao.findEntity(hql.toString(), args.toArray(), DataUpload.class);
    }
}

