/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.employee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.MD5.MD5;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.common.SystemOrgService;
import com.tcbj.crm.dataSynchro.DataSynchroHandleService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.employee.SaveRole;
import com.tcbj.crm.entity.ContactPartner;
import com.tcbj.crm.entity.ContactPosition;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.RoleC;
import com.tcbj.crm.entity.RoleUse;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.role.RoleService;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.siebel.service.ContactsSiebelService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.Excels;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/employee"})
public class PersonnelController
extends BaseController {
    @Autowired
    PersonnelService service;
    @Autowired
    RegionService cxregionmainservice;
    @Autowired
    ClientService clientService;
    @Autowired
    RoleService roleService;
    @Autowired
    ContactsSiebelService contactsSiebelService;
    @Autowired
    ShopService shopService;
    @Autowired
    PartnerShopService partnerShopService;
    @Autowired
    Cache tcbjcache;
    @Autowired
    DataSynchroHandleService dataSynchroHandle;
    @Autowired
    SystemOrgService systemOrgService;
    static Map<String, String> errorMapEmp = new LinkedHashMap<String, String>();

    @RequestMapping(value={"/list.do"})
    public String List(@RequestParam(value="orgId", required=false) String orgId, String no, @RequestParam(value="contactName", required=false) String contactName, @RequestParam(value="mobile", required=false) String mobile, @RequestParam(value="pageno", required=false) Integer pageno, Model model, String partnerId) throws Exception {
        if (pageno == null || pageno == 0) {
            pageno = 1;
        }
        Employee e = this.getCurrentEmployee();
        Employee employee = this.systemOrgService.getSuperMan(e.getCurrentPartner().getOrganizationid());
        String account = e.getAccount().equals(employee.getAccount()) ? null : employee.getAccount();
        Page page = this.service.getPts(orgId, contactName, mobile, no, account, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("contactName", (Object)contactName);
        model.addAttribute("mobile", (Object)mobile);
        model.addAttribute("no", (Object)no);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/list.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String get(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id", required=false) String id, Model model) throws Exception {
        Contact emp = this.service.get(id);
        Employee ep = this.service.getEP(id);
        model.addAttribute("ep", (Object)ep);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("emp", (Object)emp);
        model.addAttribute("region", (Object)JSON.toJSONStringWithDateFormat(emp.getRegion(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("position", (Object)JSON.toJSONStringWithDateFormat(emp.getPosition(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "employee/view.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(@RequestParam(value="orgId", required=false) String orgId, Model model, String partnerId) throws Exception {
        Contact ep = new Contact();
        Employee e = this.getCurrentEmployee();
        String ee = e.getCurrentPartner().getOrganizationid();
        model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        model.addAttribute("ep", (Object)ep);
        model.addAttribute("ee", (Object)ee);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("date", (Object)DateUtils.now());
        model.addAttribute("region", (Object)JSON.toJSONString(ep.getRegion()));
        model.addAttribute("position", (Object)JSON.toJSONString(ep.getPosition()));
        model.addAttribute("partner", (Object)JSON.toJSONStringWithDateFormat(ep.getPartner(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("shopJSON", (Object)JSON.toJSONStringWithDateFormat(ep.getShop(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "employee/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getAdd(@Valid @RequestBody Contact epNew, BindingResult errors, HttpServletRequest request, Model model) throws Exception {
        epNew.setEmpno(StringUtils.addPrefix(epNew.getEmpno()));
        Employee em = this.getCurrentEmployee();
        epNew.setPartnerOrgId(em.getCurrentPartner().getOrganizationid());
        this.service.findContactByEmpNo(epNew);
        Contact ep = this.service.setContacts(epNew, em);
        if (ep.getPersontype().equals("\u5916\u90e8")) {
            ep.setPersontype("External");
        }
        ep.setMf(ep.getMfName());
        ep.setPersontype(ep.getPersontypeName());
        ep.setRoletype(ep.getRoletypeName());
        ep.setState("insert");
        String siebelId = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        PartnerShop pt = this.partnerShopService.get(ep.getOrgId());
        if ("Partner".equals(pt.getOrgtype()) && StringUtils.isNotEmpty(ep.getPartnerId())) {
            ArrayList<PartnerShop> pts = new ArrayList<PartnerShop>();
            pts.add(pt);
            paramMap.put("pst", pts);
            siebelId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, pts, null, ep.getPartnerId());
        } else {
            ArrayList<ShopView> sps = new ArrayList<ShopView>();
            ShopView sp = this.shopService.getShopView(pt.getId());
            sps.add(sp);
            paramMap.put("sps", sps);
            siebelId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, null);
        }
        for (ContactRegion region : ep.getRegion()) {
            region.setUserId(siebelId);
            region.fillInitData(em);
        }
        for (ContactPosition position : ep.getPosition()) {
            position.setUserId(siebelId);
            position.fillInitData(em);
        }
        for (ContactShop shop : ep.getShop()) {
            shop.setUserId(siebelId);
            shop.fillInitData(em);
        }
        for (ContactPartner partner : ep.getPartner()) {
            partner.setUserId(siebelId);
            partner.fillInitData(em);
        }
        this.service.addRegion(ep.getRegion(), ep.getPartner(), ep.getShop(), ep.getPosition());
        if (StringUtils.isNotEmpty(siebelId)) {
            ep.setSiebelId(siebelId);
            paramMap.put("ep", ep);
            this.dataSynchroHandle.saveThread(paramMap, Constant.CspDataSynchro.personnel_apply.value, em);
        }
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="id") String id, String partnerId, Model model) throws Exception {
        Employee em = this.getCurrentEmployee();
        Contact ep = this.service.get(id);
        Employee emp = this.service.getEP(ep.getId());
        String ee = em.getCurrentPartner().getOrganizationid();
        ep.setEmpno(StringUtils.delPrefix(ep.getEmpno()));
        model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        model.addAttribute("emp", (Object)emp);
        model.addAttribute("ep", (Object)ep);
        model.addAttribute("ee", (Object)ee);
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("region", (Object)JSON.toJSONStringWithDateFormat(ep.getRegion(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("position", (Object)JSON.toJSONStringWithDateFormat(ep.getPosition(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "employee/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result update(@Valid @RequestBody Contact ep, Employee emp, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        this.service.setContacts(ep, e);
        ep.setPartnerOrgId(e.getCurrentPartner().getOrganizationid());
        ep.setEmpno(StringUtils.addPrefix(ep.getEmpno()));
        this.service.findContactByEmpNo(ep);
        if (ep.getPersontype() == null) {
            ep.setPersontype("External");
        }
        ep.setPersontype(ep.getPersontypeName());
        ep.setRoletype(ep.getRoletypeName());
        ep.setState("update");
        String siebelId = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        PartnerShop pt = this.partnerShopService.get(ep.getOrgId());
        if ("Partner".equals(pt.getOrgtype()) && StringUtils.isNotEmpty(ep.getPartnerId())) {
            ArrayList<PartnerShop> pts = new ArrayList<PartnerShop>();
            pts.add(pt);
            paramMap.put("pst", pts);
            siebelId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, pts, null, ep.getPartnerId());
        } else {
            ArrayList<ShopView> sps = new ArrayList<ShopView>();
            ShopView sp = this.shopService.getShopView(pt.getId());
            sps.add(sp);
            paramMap.put("sps", sps);
            siebelId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, null);
        }
        if (ep.getAccount() != null) {
            emp.setId(ep.getId());
            emp.setAccount(ep.getAccount());
            emp.setPassword(ep.getPassword());
            this.contactsSiebelService.updateUserToSiebel(emp);
        }
        for (ContactRegion region : ep.getRegion()) {
            region.setUserId(siebelId);
            region.fillInitData(e);
        }
        for (ContactPosition position : ep.getPosition()) {
            position.setUserId(siebelId);
            position.fillInitData(e);
        }
        for (ContactShop shop : ep.getShop()) {
            shop.setUserId(siebelId);
            shop.fillInitData(e);
        }
        for (ContactPartner partner : ep.getPartner()) {
            partner.setUserId(siebelId);
            partner.fillInitData(e);
        }
        this.service.updateRegionAndPosition(ep);
        if (StringUtils.isNotEmpty(siebelId)) {
            ep.setSiebelId(siebelId);
            paramMap.put("ep", ep);
            this.dataSynchroHandle.saveThread(paramMap, Constant.CspDataSynchro.personnel_apply.value, e);
        }
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET})
    public String del(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        if (e.getId().equals(id)) {
            throw new AppException("8582");
        }
        Contact ep = this.service.get(id);
        ep.setPartnerOrgId(e.getCurrentPartner().getOrganizationid());
        ep.setState("update");
        ep.fillInitData(ep, e);
        this.contactsSiebelService.delContactsToSiebel(ep);
        this.dataSynchroHandle.saveThread(ep, Constant.CspDataSynchro.personnel_del.value, e);
        return "redirect:list.do?orgId=" + orgId + "&partnerId=" + partnerId;
    }

    private void refreshOnThread() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PersonnelController.this.tcbjcache.initEmployees();
            }
        };
        thread.start();
    }

    @RequestMapping(value={"upPassword.do"}, method={RequestMethod.GET})
    public String get_ps(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id, Employee ep, Model model) throws Exception {
        Contact c = this.service.get(id);
        Employee em = this.service.getEP(id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("c", (Object)c);
        model.addAttribute("id", (Object)id);
        model.addAttribute("em", (Object)em);
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/upPassword.ftl";
    }

    @RequestMapping(value={"/upPassword.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_ps(@RequestBody Employee ep, Model model) throws Exception {
        ep.setContactId(MD5.GetMD5Code(ep.getContactId()));
        Employee em = this.service.getEP(ep.getId());
        if (!ep.getPassword().equals(ep.getRepeatPwd())) {
            throw new AppException("0010", "\u786e\u8ba4\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u4e0d\u76f8\u540c,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (!em.getPassword().equals(ep.getContactId())) {
            throw new AppException("0010", "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ep.setPassword(MD5.GetMD5Code(ep.getPassword()));
        this.contactsSiebelService.updateUserToSiebel(ep);
        this.refreshOnThread();
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/openAccount.do"})
    public String create(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id, Employee ep, Model model) throws Exception {
        Contact c = this.service.get(id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("c", (Object)c);
        model.addAttribute("id", (Object)id);
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/openAccount.ftl";
    }

    @RequestMapping(value={"/saveAccount.do"})
    @ResponseBody
    public Result saveCreate(@RequestBody Employee ep, Model model) throws Exception {
        this.validateAccount(ep.getAccount());
        Contact ct = this.service.get(ep.getContactId());
        ep.setId(ct.getId());
        ep.setPassword(MD5.GetMD5Code(ep.getPassword()));
        this.contactsSiebelService.addUserToSiebel(ep);
        this.refreshOnThread();
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/reset.do"})
    @ResponseBody
    public Result reset(@RequestBody PartnerContact pc, Model model) throws Exception {
        Employee em = this.service.getEP(pc.getId());
        if (Beans.isEmpty((Object)em)) {
            throw new AppException("0010", "\u8bf7\u5148\u521b\u5efa\u8d26\u53f7\uff01");
        }
        em.setPassword(MD5.GetMD5Code(Constant.DEFAULT_PASSWORD));
        this.contactsSiebelService.updateUserToSiebel(em);
        this.refreshOnThread();
        return this.getSuccessResult(pc.getOrgId());
    }

    @RequestMapping(value={"/openRole.do"}, method={RequestMethod.GET})
    public String addRole(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id", required=false) String id, Model model) throws Exception {
        List<RoleUse> rus;
        Employee e = this.getCurrentEmployee();
        String organizationid = e.getCurrentPartner().getOrganizationid();
        if (organizationid.equals(orgId)) {
            rus = this.roleService.getRole(organizationid);
            model.addAttribute("rus", rus);
        } else {
            rus = this.roleService.getByOrgId(organizationid);
            model.addAttribute("rus", rus);
        }
        List<RoleC> rcs = this.service.getRCS(id);
        HashMap<String, RoleC> roleMap = new HashMap<String, RoleC>();
        int i = 0;
        while (i < rcs.size()) {
            roleMap.put(rcs.get(i).getRoleId(), rcs.get(i));
            ++i;
        }
        model.addAttribute("roleMap", roleMap);
        model.addAttribute("id", (Object)id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/openRole.ftl";
    }

    @RequestMapping(value={"/saveRole.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save(@RequestBody SaveRole a, Model model) throws Exception {
        this.service.delete(a.getId());
        String[] ruIds = a.getRuId().split(",");
        int i = 0;
        while (i < ruIds.length) {
            String ruId = ruIds[i];
            if (!StringUtils.isEmpty(ruId)) {
                Employee e = this.getCurrentEmployee();
                RoleC rc = new RoleC();
                rc.setRoleId(ruId);
                rc.setUserId(a.getId());
                rc.setEndDate(DateUtils.now());
                rc.setStartDate(DateUtils.now());
                rc.fillInitData(e);
                this.service.save(rc);
            }
            ++i;
        }
        return this.getSuccessResult(a.getOrgId());
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.service.getChildNodeTree(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"orgTree.do"}, method={RequestMethod.GET})
    public String tree(Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner pt = this.service.getById(e.getCurrentPartner().getId());
        String tree = this.service.getOrgTree(pt);
        String orgId = e.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        return "employee/orgTree.ftl";
    }

    public void validateAccount(String account) throws Exception {
        boolean isExist = this.service.isAccount(account);
        if (isExist) {
            throw new AppException("5101");
        }
    }

    @RequestMapping(value={"updateEP.do"}, method={RequestMethod.GET})
    public String edit(Model model) throws Exception {
        Employee ep = this.getCurrentEmployee();
        Employee em = this.service.getEP(ep.getId());
        Contact cv = this.service.get(ep.getId());
        model.addAttribute("cv", (Object)cv);
        model.addAttribute("em", (Object)em);
        return "employee/updateEP.ftl";
    }

    @RequestMapping(value={"updateEP.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add(@RequestBody Contact cv, String result, Model model) throws Exception {
        cv.setState("update");
        Employee ep = this.getCurrentEmployee();
        Contact ct = this.service.get(ep.getId());
        cv.setFullname(ct.getFullname());
        cv.setHiredate(cv.getHiredate());
        cv.setPartnerOrgId(ct.getPartnerOrgId());
        cv.setStartdate(ct.getStartdate());
        cv.setPersontype(ct.getPersontypeName());
        cv.setRoletype(ct.getRoletypeName());
        this.contactsSiebelService.addOrUpdateContactsToSiebel(cv, null, null, null);
        if (StringUtils.isNotEmpty(cv.getPassword()) && StringUtils.isNotEmpty(cv.getNewPassword()) && StringUtils.isNotEmpty(cv.getIsPassword())) {
            if (!ep.getPassword().equals(MD5.GetMD5Code(cv.getPassword()))) {
                throw new AppException("0010", "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            }
            if (!cv.getNewPassword().equals(cv.getIsPassword())) {
                throw new AppException("0010", "\u65b0\u5bc6\u7801\u548c\u786e\u8ba4\u5bc6\u7801\u4e0d\u76f8\u540c,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            }
            ep.setPassword(MD5.GetMD5Code(cv.getNewPassword()));
            this.contactsSiebelService.updateUserToSiebel(ep);
        }
        model.addAttribute("result", (Object)result);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/ajaxGetChild.do"})
    public void ajaxGetChildNode1(String id, String orgId, String check, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            String result = this.service.getChildTree(id, orgId, check);
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"areaTree.do"})
    public String artree(@RequestParam(value="isMultipleChoice", required=false) String isMultipleChoice, String orgId, String ids, String partnerId, Model model) throws Exception {
        Partner p = null;
        if (partnerId.equals("")) {
            Employee e = this.getCurrentEmployee();
            p = this.service.getById(e.getCurrentPartner().getId());
        } else {
            p = this.service.getById(orgId);
        }
        String tree = this.service.areaTree(p, ids, orgId);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        return "employee/areaTree.ftl";
    }

    @RequestMapping(value={"logout.do"})
    @ResponseBody
    public String logout(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id) throws Exception {
        Employee e = this.getCurrentEmployee();
        if (e.getId().equals(id)) {
            throw new AppException("8582");
        }
        Contact ct = this.service.get(id);
        this.service.deleteRegionAndPosition(id);
        PartnerShop pt = this.partnerShopService.get(orgId);
        ct.fillInitData(ct, e);
        if ("Partner".equals(pt.getOrgtype())) {
            ct.setPartnerId(partnerId);
            ct.setState("update");
            this.contactsSiebelService.loginOut(ct);
        } else {
            ct.setState("update");
            this.contactsSiebelService.loginOut(ct);
        }
        this.dataSynchroHandle.saveThread(ct, Constant.CspDataSynchro.personnel_logout.value, e);
        return "true";
    }

    @RequestMapping(value={"/selectPartner.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page get_page(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ClientCondition con) {
        try {
            if (StringUtils.isNotEmpty(con.getName())) {
                con.setName(new String(con.getName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Page page = this.clientService.findPartnerApplyers(con, pageno);
        return page;
    }

    @RequestMapping(value={"/getPartners.do"})
    public String get_partner(String partnerId, String userId, Model model) {
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("userId", (Object)userId);
        return "employee/selectPartner.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editPartner(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        Page page = this.service.getPagePartner(condition, pageno);
        return page;
    }

    @RequestMapping(value={"/upload.do"}, method={RequestMethod.GET})
    public String myapplys(Model model) {
        return "employee/upload.ftl";
    }

    @RequestMapping(value={"/upload.do"}, method={RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String upload(@RequestParam(value="file", required=true) MultipartFile file, Model model) throws IOException {
        final Employee emp = this.getCurrentEmployee();
        String orgId = emp.getCurrentPartner().getId();
        Map<Object, Object> errorMsg = new HashMap();
        ArrayList<Map> sheet1 = new ArrayList();
        if (Beans.isNotEmpty((Object)file)) {
            try {
                sheet1 = Excels.readExcel((String)file.getOriginalFilename(), (InputStream)file.getInputStream(), (String[])new String[]{"channelnamae", "districtname", "regionname", "empno", "fullname", "roletype", "phonenumber", "belong", "endDt", "applyerId", "partnername"}, (int)0);
                errorMsg = this.service.validateExcelsheet(sheet1, orgId);
            }
            catch (IOException iOException) {
                throw new AppException("\u89e3\u6790excel\u51fa\u9519");
            }
        }
        if (Beans.isEmpty(errorMsg)) {
            final HashMap<String, Object> gmap = new HashMap<String, Object>();
            for (Map map1 : sheet1) {
                if (gmap.containsKey(map1.get("empno"))) {
                    List temmap = (List)gmap.get(map1.get("empno"));
                    temmap.add(map1);
                    gmap.put((String)map1.get("empno"), temmap);
                    continue;
                }
                ArrayList temmap1 = new ArrayList();
                temmap1.add(map1);
                gmap.put((String)map1.get("empno"), temmap1);
            }
            Set<String> keys = errorMapEmp.keySet();
            for (String key : keys) {
                errorMapEmp.remove(key);
            }
            final String id = String.valueOf(System.currentTimeMillis());
            Thread t = new Thread(){

                @Override
                public void run() {
                    String rtnStr = PersonnelController.this.handleContact(gmap, emp);
                    if (rtnStr != null && "".equals(rtnStr)) {
                        errorMapEmp.put(id, "\u6267\u884c\u5b8c\u6210");
                    } else {
                        errorMapEmp.put(id, rtnStr);
                    }
                }
            };
            int time = gmap.size() * 2 / 60 + 1;
            errorMapEmp.put(id, "\u6267\u884c\u4e2d\uff0c\u5927\u6982" + String.valueOf(time) + "\u5206\u949f\u5de6\u53f3\u80fd\u67e5\u770b\u7ed3\u679c");
            t.start();
            model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getSuccessResult(errorMsg)));
            return "common/iframeRtn.ftl";
        }
        model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getSuccessResult(errorMsg)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/intoselectshop.do"}, method={RequestMethod.GET})
    public String selectProductView(String userId, Model model) {
        model.addAttribute("userId", (Object)userId);
        return "employee/shopList.ftl";
    }

    @RequestMapping(value={"/selectshop.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getSelectShop(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) throws Exception {
        if (StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(new String(condition.getName().getBytes("iso8859-1"), "UTF-8"));
        }
        Page page = this.shopService.getSelectShop(condition, pageno);
        return page;
    }

    @RequestMapping(value={"/editShop.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editShop(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        try {
            if (StringUtils.isNotEmpty(condition.getShopName())) {
                condition.setShopName(new String(condition.getShopName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Page page = this.service.getShop(condition, pageno);
        return page;
    }

    public String handleContact(Map<String, List<Map>> gmap, Employee emp) {
        StringBuffer sf = new StringBuffer("");
        for (Map.Entry<String, List<Map>> entry : gmap.entrySet()) {
            String userId;
            Contact ep;
            block16: {
                ep = this.service.getByEpno(entry.getKey(), emp.getCurrentPartner().getOrganizationid());
                ArrayList<ContactPartner> lp = new ArrayList<ContactPartner>();
                ArrayList<ContactRegion> lr = new ArrayList<ContactRegion>();
                ArrayList<String> tempdis = new ArrayList<String>();
                ArrayList<String> tempreg = new ArrayList<String>();
                ArrayList<String> tempcha = new ArrayList<String>();
                ArrayList<String> temppar = new ArrayList<String>();
                for (Map map1 : entry.getValue()) {
                    ContactRegion cr;
                    ep.setEmpno((String)map1.get("empno"));
                    ep.setFullname((String)map1.get("fullname"));
                    ep.setRoletype((String)map1.get("roletype"));
                    ep.setPhonenumber((String)map1.get("phonenumber"));
                    ep.setOrgId((String)map1.get("orgId"));
                    ep.setEnddate(DateUtils.autoFormatDate((String)((String)map1.get("endDt")), (String[])new String[0]));
                    if (Beans.isNotEmpty(map1.get("applyerId")) && !temppar.contains(((String)map1.get("applyerId")).toString())) {
                        temppar.add(((String)map1.get("applyerId")).toString());
                        ContactPartner cp = new ContactPartner();
                        cp.setApplyerId(this.service.getByApplyid((String)map1.get("applyerId")).getApplyerId());
                        cp.setStartdate(DateUtils.now());
                        lp.add(cp);
                    }
                    if (Beans.isNotEmpty(map1.get("regionname")) && !tempreg.contains(((String)map1.get("regionname")).toString())) {
                        tempreg.add(((String)map1.get("regionname")).toString());
                        cr = new ContactRegion();
                        cr.setRegionId(this.service.getRegoinIdByName((String)map1.get("regionname")));
                        cr.setStartDate(DateUtils.now());
                        lr.add(cr);
                    }
                    if (Beans.isNotEmpty(map1.get("districtname")) && Beans.isEmpty(map1.get("regionname")) && !tempdis.contains(((String)map1.get("districtname")).toString())) {
                        tempdis.add(((String)map1.get("districtname")).toString());
                        cr = new ContactRegion();
                        cr.setRegionId(this.service.getRegoinIdByName((String)map1.get("districtname")));
                        cr.setStartDate(DateUtils.now());
                        lr.add(cr);
                    }
                    if (!Beans.isNotEmpty(map1.get("channelnamae")) || !Beans.isEmpty(map1.get("districtname")) || !Beans.isEmpty(map1.get("regionname")) || tempcha.contains(((String)map1.get("channelnamae")).toString())) continue;
                    tempcha.add(((String)map1.get("channelnamae")).toString());
                    String regoinIds = this.service.getFRegionsByName((String)map1.get("channelnamae"), emp.getCurrentPartner().getId());
                    List<String> chList = StringUtils.stringToList(regoinIds, ",");
                    for (String regionid : chList) {
                        ContactRegion cr2 = new ContactRegion();
                        cr2.setRegionId(regionid);
                        cr2.setStartDate(DateUtils.now());
                        lr.add(cr2);
                    }
                }
                ep.setRegion(lr);
                ep.setPartner(lp);
                ep.fillInitData(emp);
                ep.setPartnerId("partnerId");
                System.out.println(ep.toString());
                ep.setPartnerOrgId(emp.getCurrentPartner().getOrganizationid());
                userId = null;
                if (StringUtils.isNotEmpty(ep.getPartnerId())) {
                    ArrayList<PartnerShop> pts = new ArrayList<PartnerShop>();
                    PartnerShop pt = this.partnerShopService.get(ep.getOrgId());
                    if ("Partner".equals(pt.getOrgtype())) {
                        pt.setName(pt.getName());
                        pt.setId(pt.getId());
                        pts.add(pt);
                        try {
                            userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, pts, null, ep.getPartnerId());
                            break block16;
                        }
                        catch (AppException e1) {
                            System.out.println(e1.getArgs()[0].toString());
                            sf.append(e1.getArgs()[0].toString()).append("\t");
                            continue;
                        }
                    }
                    ArrayList<ShopView> sps = new ArrayList<ShopView>();
                    ShopView sp = this.shopService.getShopView(pt.getId());
                    sps.add(sp);
                    userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, null);
                } else {
                    ArrayList<ShopView> sps = new ArrayList<ShopView>();
                    ShopView sp = this.shopService.getShopView(ep.getOrgId());
                    sps.add(sp);
                    userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, ep.getPartnerId());
                }
            }
            if (Beans.isNotEmpty(ep.getRegion())) {
                for (ContactRegion region : ep.getRegion()) {
                    region.setUserId(userId);
                    region.fillInitData(emp);
                }
            }
            if (Beans.isNotEmpty(ep.getPartner())) {
                for (ContactPartner partner : ep.getPartner()) {
                    partner.setUserId(userId);
                    partner.fillInitData(emp);
                }
            }
            if ("insert".equals(ep.getState())) {
                this.service.addFromExcel(ep);
            }
            if (!"update".equals(ep.getState())) continue;
            this.service.updateFromExcel(ep);
        }
        return sf.toString();
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(@RequestParam(value="orgId", required=false) String orgId, String no, @RequestParam(value="contactName", required=false) String contactName, @RequestParam(value="mobile", required=false) String mobile, String partnerId, HttpServletResponse response, String nodeType) {
        List<Contact> contacts = this.service.getExportExcelData(orgId, contactName, mobile, no, nodeType);
        Employee employee = this.getCurrentEmployee();
        File dir = new File(String.valueOf(StringUtils.getUploadPath()) + "contactsexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PersonnelController.excels(contacts, dir.getPath(), String.valueOf(employee.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response, nodeType);
    }

    public static boolean excels(List<Contact> contacts, String path, String name, HttpServletResponse response, String nodeType) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u59d3\u540d", "\u804c\u52a1\u5206\u7c7b", "\u7c7b\u578b", "\u79fb\u52a8\u7535\u8bdd", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u51fa\u751f\u5e74\u6708", "\u5de5\u53f7", "\u6027\u522b", "\u4e3b\u8981\u7535\u8bdd", "\u5b66\u5386", "\u5bb6\u5ead\u7535\u8bdd", "\u7535\u5b50\u90ae\u4ef6", "\u5206\u673a\u53f7", "QQ\u53f7\u7801", "\u4f20\u771f", "\u8054\u7cfb\u5730\u5740", "\u5165\u804c\u65f6\u95f4", "\u79bb\u804c\u65f6\u95f4", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4"};
        ArrayList<String> nameList = new ArrayList<String>();
        Collections.addAll(nameList, names);
        nameList.add("\u5206\u914d\u533a\u57df");
        nameList.add("\u5206\u914d\u7ecf\u9500\u5546");
        int i = 0;
        while (i < nameList.size()) {
            row.createCell(i).setCellValue((String)nameList.get(i));
            ++i;
        }
        int rowIndex = 1;
        int i2 = 0;
        while (i2 < contacts.size()) {
            int j;
            Contact c = contacts.get(i2);
            String[] vals = new String[]{c.getFullname(), c.getRoletypeName(), c.getPersontypeName(), c.getPhonenumber(), c.getIdnumber(), DateUtils.formartDate2((Date)c.getBirthdate(), (String)"yyyy-MM-dd"), c.getEmpno(), c.getMf(), c.getPrimaryphone(), c.getEducationalbg(), c.getFamilyphone(), c.getEmail(), c.getExtphone(), c.getQq(), c.getFaxphone(), c.getAddress(), DateUtils.formartDate2((Date)c.getHiredate(), (String)"yyyy-MM-dd"), DateUtils.formartDate2((Date)c.getDimissiondate(), (String)"yyyy-MM-dd"), DateUtils.formartDate2((Date)c.getStartdate(), (String)"yyyy-MM-dd"), DateUtils.formartDate2((Date)c.getEnddate(), (String)"yyyy-MM-dd")};
            ArrayList valList = new ArrayList();
            Collections.addAll(valList, vals);
            for (ContactRegion r : c.getRegion()) {
                row = sheet.createRow(rowIndex++);
                j = 0;
                while (j < valList.size()) {
                    row.createCell(j).setCellValue((String)valList.get(j));
                    ++j;
                }
                row.createCell(valList.size()).setCellValue(r.getRegionName());
                row.createCell(valList.size() + 1).setCellValue("");
            }
            for (ContactPartner p : c.getPartner()) {
                row = sheet.createRow(rowIndex++);
                j = 0;
                while (j < valList.size()) {
                    row.createCell(j).setCellValue((String)valList.get(j));
                    ++j;
                }
                row.createCell(valList.size()).setCellValue("");
                row.createCell(valList.size() + 1).setCellValue(p.getApplyerName());
            }
            if (Beans.isEmpty(c.getRegion()) && Beans.isEmpty(c.getPartner())) {
                row = sheet.createRow(rowIndex++);
                int j2 = 0;
                while (j2 < valList.size()) {
                    row.createCell(j2).setCellValue((String)valList.get(j2));
                    ++j2;
                }
            }
            ++i2;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @RequestMapping(value={"/showError.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result showError(Model model) throws Exception {
        model.addAttribute("errorMap", errorMapEmp);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer("");
        Set<String> keys = errorMapEmp.keySet();
        for (String key : keys) {
            sb.append("\u4e0a\u4f20\u65f6\u95f4\uff1a");
            sb.append(sdf.format(new Date(Long.valueOf(key))));
            sb.append("\u6267\u884c\u7ed3\u679c\uff1a");
            sb.append(errorMapEmp.get(key));
        }
        return this.getSuccessResult(sb.toString());
    }

    @RequestMapping(value={"belongTree.do"})
    public String belongTree(@RequestParam(value="isMultipleChoice", required=false) String isMultipleChoice, String ids, String orgId, String nodeType, String jsonStrParam, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner pt = this.service.getById(e.getCurrentPartner().getId());
        Map<String, Object> paramMap = new HashMap<String, Partner>();
        if (StringUtils.isNotEmpty(jsonStrParam)) {
            paramMap = (Map)Jsons.toBean((String)jsonStrParam, Map.class);
        }
        paramMap.put("pt", pt);
        paramMap.put("nodeType", nodeType);
        paramMap.put("ids", ids);
        String tree = this.service.belongTree(paramMap);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("nodeType", (Object)nodeType);
        return "employee/belongTree.ftl";
    }

    @RequestMapping(value={"/ajaxGetBelongChildNode.do"})
    public void ajaxGetBelongChildNode(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.service.ajaxGetBelongChildNode(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }
}

