/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.employee;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.ContactPartner;
import com.tcbj.crm.entity.ContactPosition;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.RoleC;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.notice.NoticeCondition;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="personnelService")
public class PersonnelService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private NewBaseDao newBaseDao;

    public Page getPts(String partnerId, String contactName, String mobile, String no, String account, int pageno) throws Exception {
        String hql = "from PartnerContact p where p.partnerId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        if (StringUtils.isNotBlank(contactName)) {
            hql = String.valueOf(hql) + " and p.contactName like ? ";
            args.add("%" + contactName.trim() + "%");
        }
        if (StringUtils.isNotEmpty(no)) {
            hql = String.valueOf(hql) + " and p.no like ? ";
            args.add("%" + no.trim() + "%");
        }
        if (StringUtils.isNotEmpty(mobile)) {
            hql = String.valueOf(hql) + "and p.mobile = ?";
            args.add(mobile);
        }
        if (Beans.isNotEmpty((Object)account)) {
            hql = String.valueOf(hql) + " and ( p.login != ? or p.login is null) ";
            args.add(account);
        }
        hql = String.valueOf(hql) + " order by p.createDt desc ";
        return this.baseDao.search(hql, args.toArray(), 10, pageno);
    }

    public List<Employee> getPCS(String partnerId, NoticeCondition noticeCondition) throws Exception {
        String hql = "from Employee p,Partner e,EmployeePartner t where p.id = t.personId and e.id = t.id ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(noticeCondition.getContactName())) {
            hql = String.valueOf(hql) + " and p.name like ? ";
            args.add("%" + noticeCondition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(noticeCondition.getDealerId())) {
            hql = String.valueOf(hql) + " and e.id = ? ";
            args.add(noticeCondition.getDealerId());
        }
        if (StringUtils.isNotEmpty(noticeCondition.getPersontype())) {
            hql = String.valueOf(hql) + " and p.type = ? ";
            args.add(noticeCondition.getPersontype());
        }
        if (StringUtils.isNotEmpty(noticeCondition.getSaleChannelTypeCode())) {
            hql = String.valueOf(hql) + " and e.saleChannelTypeCode = ? ";
            args.add(noticeCondition.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(noticeCondition.getBigAreaCode())) {
            hql = String.valueOf(hql) + " and e.bigAreaCode = ? ";
            args.add(noticeCondition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(noticeCondition.getAreaCode())) {
            hql = String.valueOf(hql) + " and e.areaCode = ? ";
            args.add(noticeCondition.getAreaCode());
        }
        List list = this.baseDao.findEntity(hql, args.toArray(), Object[].class);
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (Object[] objs : list) {
            Employee e = (Employee)objs[0];
            e.setCurrentPartner((EmployeePartner)objs[2]);
            result.add(e);
        }
        return result;
    }

    public Partner getPT(String id) throws Exception {
        return (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
    }

    public List<Shop> getSPS() throws Exception {
        String hql = "from Shop s ";
        return this.baseDao.findEntity(hql, Shop.class);
    }

    public Shop getBySiebelShopId(String siebelShopId) throws Exception {
        String hql = "from Shop s where s.siebelShopId = ?";
        List sps = this.baseDao.findEntity(hql, new Object[]{siebelShopId}, Shop.class);
        return sps.size() == 0 ? null : (Shop)sps.get(0);
    }

    public Employee getEP(String id) throws Exception {
        return (Employee)this.baseDao.get(Employee.class, (Serializable)((Object)id));
    }

    public List<ContactRegion> getRegion(String id) {
        String hql = "from ContactRegion s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, ContactRegion.class);
    }

    public List<ContactPosition> getPost(String id) {
        String hql = "from ContactPosition s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, ContactPosition.class);
    }

    public List<ContactShop> getShop(String id) {
        String hql = "from ContactShop s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, ContactShop.class);
    }

    public Page getShop(ShopCondition condition, int pageno) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from ContactShop c,ShopView s where c.shopId = s.id and c.userId = ?";
        args.add(condition.getUserId());
        if (StringUtils.isNotEmpty(condition.getShopName())) {
            hql = String.valueOf(hql) + " and s.shopName like ? ";
            args.add("%" + condition.getShopName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNo())) {
            String[] shopNo = condition.getShopNo().split(",");
            hql = String.valueOf(hql) + " and ( s.shopNumber like ? ";
            args.add("%" + shopNo[0] + "%");
            int i = 1;
            while (i < shopNo.length) {
                hql = String.valueOf(hql) + " or s.shopNumber like ? ";
                args.add("%" + shopNo[i] + "%");
                ++i;
            }
            hql = String.valueOf(hql) + " ) ";
        }
        hql = String.valueOf(hql) + " order by s.shopNumber ";
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        ArrayList<ContactShop> list = new ArrayList<ContactShop>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            ContactShop contactShop = (ContactShop)obj[0];
            ShopView shopView = (ShopView)obj[1];
            contactShop.setShopName(shopView.getShopName());
            contactShop.setShopNo(shopView.getShopNumber());
            list.add(contactShop);
            ++i;
        }
        page.setList(list);
        return page;
    }

    public List<ContactPartner> getPartner(String userId) {
        String hql = "from ContactPartner s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{userId}, ContactPartner.class);
    }

    public String getPartnerIds(String userId) {
        List<ContactPartner> list = this.getPartner(userId);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (ContactPartner iter : list) {
            if (iter.getEnddate() != null && DateUtils.now().compareTo(iter.getEnddate()) < 0) {
                set.add(iter.getApplyerId());
                continue;
            }
            if (iter.getEnddate() != null) continue;
            set.add(iter.getApplyerId());
        }
        StringBuffer sb = new StringBuffer();
        if (set.size() > 0) {
            for (String p : set) {
                sb.append("'").append(p).append("',");
            }
        } else {
            sb.append("'1-2-3',");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<String> getPartnerIdsByUserId(String userId) {
        List<ContactPartner> list = this.getPartner(userId);
        ArrayList<String> set = new ArrayList<String>();
        for (ContactPartner iter : list) {
            if (iter.getEnddate() != null && DateUtils.now().compareTo(iter.getEnddate()) < 0) {
                set.add(iter.getApplyerId());
                continue;
            }
            if (iter.getEnddate() != null) continue;
            set.add(iter.getApplyerId());
        }
        return set;
    }

    public Page getPagePartner(ShopCondition condition, int pageno) {
        String hql = "from ContactPartner s where s.userId = ?";
        return this.baseDao.search(hql.toString(), new Object[]{condition.getUserId()}, condition.getRowsize().intValue(), pageno);
    }

    public Contact get(String id) throws Exception {
        Contact v = (Contact)this.baseDao.get(Contact.class, (Serializable)((Object)id));
        v.setRegion(this.getRegion(id));
        v.setPosition(this.getPost(id));
        v.setPartner(this.getPartner(id));
        v.setShop(this.getShop(id));
        return v;
    }

    public Contact setContacts(Contact contact, Employee me) throws Exception {
        String id = Beans.isEmpty((Object)contact.getId()) ? "" : contact.getId();
        Contact v = (Contact)this.baseDao.get(Contact.class, (Serializable)((Object)id));
        List<ContactRegion> regionList = this.getRegion(id);
        List<ContactPosition> positionList = this.getPost(id);
        List<ContactPartner> partnerList = this.getPartner(id);
        List<ContactShop> shopList = this.getShop(id);
        HashMap<String, ContactRegion> mapRegion = new HashMap<String, ContactRegion>();
        for (ContactRegion region : regionList) {
            mapRegion.put(region.getId(), region);
        }
        for (ContactRegion region : contact.getRegion()) {
            region.fillInitData((ContactRegion)mapRegion.get(region.getId()), me);
        }
        HashMap<String, ContactPosition> mapPosition = new HashMap<String, ContactPosition>();
        for (ContactPosition position : positionList) {
            mapPosition.put(position.getId(), position);
        }
        for (ContactPosition position : contact.getPosition()) {
            position.fillInitData((ContactPosition)mapPosition.get(position.getId()), me);
        }
        HashMap<String, ContactPartner> mapPartner = new HashMap<String, ContactPartner>();
        for (ContactPartner partner : partnerList) {
            mapPartner.put(partner.getId(), partner);
        }
        for (ContactPartner partner : contact.getPartner()) {
            partner.fillInitData((ContactPartner)mapPartner.get(partner.getId()), me);
        }
        HashMap<String, ContactShop> mapShop = new HashMap<String, ContactShop>();
        for (ContactShop shop : shopList) {
            mapShop.put(shop.getId(), shop);
        }
        for (ContactShop shop : contact.getShop()) {
            shop.fillInitData((ContactShop)mapShop.get(shop.getId()), me);
        }
        contact.fillInitData(v, me);
        if (Beans.isEmpty((Object)id)) {
            return contact;
        }
        Beans.copy((Object)v, (Object)contact);
        v.setRegion(contact.getRegion());
        v.setPosition(contact.getPosition());
        v.setPartner(contact.getPartner());
        v.setShop(contact.getShop());
        return v;
    }

    public Contact getByEpno(String empNo, String partnerId) {
        ArrayList<String> obj = new ArrayList<String>();
        obj.add(empNo);
        String hql = " from Contact where 1=1 ";
        hql = String.valueOf(hql) + " and empno = ? and partnerOrgId = ?";
        obj.add(partnerId);
        Contact contact = (Contact)this.baseDao.findFirstEntity(hql, obj.toArray(), Contact.class);
        if (contact == null) {
            contact = new Contact();
            contact.setStartdate(DateUtils.now());
            contact.setHiredate(DateUtils.now());
            contact.setState("insert");
            contact.setPersontype("\u5185\u90e8");
        } else {
            contact.setState("update");
            contact.setPersontype("\u5185\u90e8");
        }
        return contact;
    }

    public void findContactByEmpNo(Contact ep) {
        Contact contact;
        String empNo = ep.getEmpno();
        String id = ep.getId();
        ArrayList<String> obj = new ArrayList<String>();
        String hql = " from Contact where 1=1 ";
        if (StringUtils.isNotEmpty(empNo)) {
            hql = String.valueOf(hql) + " and empno = ? ";
            obj.add(empNo);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id <> ? ";
            obj.add(id);
        }
        if (StringUtils.isNotEmpty(ep.getPartnerOrgId())) {
            hql = String.valueOf(hql) + " and partnerOrgId = ? ";
            obj.add(ep.getPartnerOrgId());
        }
        if ((contact = (Contact)this.baseDao.findFirstEntity(hql, obj.toArray(), Contact.class)) != null) {
            throw new AppException("0010", "\u5458\u5de5\u7f16\u53f7\uff1a" + empNo + "\u5df2\u5b58\u5728\uff0c\u8bf7\u586b\u5199\u5176\u4ed6\u7f16\u53f7");
        }
    }

    public void add(Employee ep) throws Exception {
        this.baseDao.save((Object)ep);
    }

    public void addRegion(List<ContactRegion> sps, List<ContactPartner> cps, List<ContactShop> sts, List<ContactPosition> cts) {
        this.baseDao.save(sps);
        this.baseDao.save(cps);
        this.baseDao.save(sts);
        this.baseDao.save(cts);
    }

    public void addPartner(List<ContactPartner> cps) {
        this.baseDao.save(cps);
    }

    public void updateRegionAndPosition(Contact cv) {
        int n;
        int n2;
        String[] stringArray;
        Object[] args = new Object[]{cv.getId()};
        this.baseDao.executeHQL("delete ContactRegion where userId=?", args);
        this.baseDao.executeHQL("delete ContactPosition where userId=?", args);
        this.baseDao.save(cv.getRegion());
        this.baseDao.save(cv.getPosition());
        if (StringUtils.isNotEmpty(cv.getPartnerIds())) {
            stringArray = cv.getPartnerIds().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                this.baseDao.deleteById(ContactPartner.class, (Serializable)((Object)id));
                ++n;
            }
        }
        int i = 0;
        while (i < cv.getPartner().size()) {
            if (StringUtils.isNotEmpty(cv.getPartner().get(i).getId())) {
                this.baseDao.update((Object)cv.getPartner().get(i));
            } else {
                this.baseDao.save((Object)cv.getPartner().get(i));
            }
            ++i;
        }
        if (StringUtils.isNotEmpty(cv.getShopIds())) {
            stringArray = cv.getShopIds().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                this.baseDao.deleteById(ContactShop.class, (Serializable)((Object)id));
                ++n;
            }
        }
        i = 0;
        while (i < cv.getShop().size()) {
            if (StringUtils.isNotEmpty(cv.getShop().get(i).getId())) {
                this.baseDao.update((Object)cv.getShop().get(i));
            } else {
                this.baseDao.save((Object)cv.getShop().get(i));
            }
            ++i;
        }
    }

    public void addPosition(List<ContactPosition> sts) {
        this.baseDao.save(sts);
    }

    public void updatePosition(List<ContactPosition> sts) {
        this.baseDao.update(sts);
    }

    public void update(Employee ep) throws Exception {
        this.baseDao.update((Object)ep);
    }

    public void delete(Contact ep) throws Exception {
        this.baseDao.delete((Object)ep);
    }

    public Partner getById(String id) throws Exception {
        return (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
    }

    public String getChildNodeTree(String id, String orgId) throws JSONException {
        String str = "";
        JSONArray nodes = new JSONArray();
        List pns = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pns) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)pn.getId());
            node.put("pId", (Object)pn.getParentId());
            node.put("name", (Object)pn.getRegionName());
            node.put("iconSkin", (Object)"start");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
        }
        List cts = this.baseDao.findEntity("from Customer c where c.areaCode = ? and c.supplierId = ? order by startDate ", new Object[]{id, orgId}, Customer.class);
        for (Customer ct : cts) {
            JSONObject node1 = new JSONObject();
            node1.put("id", (Object)ct.getApplyerId());
            node1.put("pId", (Object)ct.getSupplierId());
            node1.put("name", (Object)ct.getApplyerName());
            node1.put("iconSkin", (Object)"root");
            node1.put("partnerId", (Object)"partnerId");
            node1.put("isParent", (Object)"true");
            node1.put("url", (Object)"/employee/list");
            nodes.put((Object)node1);
        }
        List cms = this.baseDao.findEntity("from Customer c where c.supplierId = ? order by startDate ", new Object[]{id}, Customer.class);
        for (Customer cm : cms) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)cm.getApplyerId());
            node2.put("pId", (Object)cm.getSupplierId());
            node2.put("name", (Object)cm.getApplyerName());
            node2.put("iconSkin", (Object)"root");
            node2.put("partnerId", (Object)"partnerId");
            node2.put("isParent", (Object)"true");
            node2.put("url", (Object)"/employee/list");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public List<Partner> getPTS(String parentPartnerId) {
        String hql = "from Partner p where p.parentPartnerId = ?";
        return this.baseDao.findEntity(hql, new Object[]{parentPartnerId}, Partner.class);
    }

    public String getOrgTree(Partner pt) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)pt.getId());
        rootNode.put("pId", (Object)pt.getParentPartnerId());
        rootNode.put("name", (Object)pt.getName());
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("open", (Object)"true");
        rootNode.put("url", (Object)"/employee/list");
        rootNode.put("partnerId", (Object)"partnerId");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by c.created ", new Object[]{pt.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)pt.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("iconSkin", (Object)"start");
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        List<DictionaryItem> des = Cache.getItems("TCBJ_STORE_TYPE");
        for (DictionaryItem de : des) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)de.getName());
            node.put("pId", (Object)pt.getId());
            node.put("name", (Object)de.getVal());
            node.put("url", (Object)"/employee/list");
            node.put("level", (Object)"level");
            node.put("iconSkin", (Object)"MD");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
            List sps = this.baseDao.findEntity("from ShopView s where s.parentDealerId = ? and s.shopType = ? order by startDate", new Object[]{pt.getId(), de.getName()}, ShopView.class);
            for (ShopView sp : sps) {
                JSONObject node1 = new JSONObject();
                node1.put("id", (Object)sp.getId());
                node1.put("pId", (Object)de.getName());
                node1.put("name", (Object)sp.getShopName());
                node1.put("isParent", (Object)"true");
                node1.put("nocheck", (Object)"true");
                node1.put("url", (Object)"/employee/list");
                node1.put("level", (Object)"level");
                nodes.put((Object)node1);
            }
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public void save(RoleC rc) throws Exception {
        this.baseDao.save((Object)rc);
    }

    public void delete(String id) {
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete RoleC where userId=?", args);
    }

    public List<RoleC> getRCS(String id) throws Exception {
        String hql = " from RoleC r where r.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, RoleC.class);
    }

    public boolean isAccount(String account) throws Exception {
        boolean isExist = false;
        String hql = "from Employee e where e.account =? ";
        List emps = this.baseDao.findEntity(hql, new Object[]{account}, Employee.class);
        if (emps.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public String getChildTree(String id, String orgId, String check) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentId());
            node2.put("name", (Object)pn.getRegionName());
            node2.put("isParent", (Object)"true");
            if ("true".equals(check)) {
                node2.put("checked", (Object)"true");
            }
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public String areaTree(Partner p, String ids, String orgId) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)"1");
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u533a\u57df\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and startDt < ? and (endDt > ? or endDt is null) order by created ", new Object[]{p.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)p.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            nodes.put((Object)node2);
            map.put(dt.getId(), node2);
        }
        if (StringUtils.isNotEmpty(ids)) {
            String[] nodeId;
            String[] stringArray = nodeId = ids.split(",");
            int n = nodeId.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Region region = (Region)this.baseDao.uniqueFindByHql("from Region p where p.id = ?", new Object[]{id}, Region.class);
                if (region == null || map.get(id) != null) {
                    ((JSONObject)map.get(id)).put("checked", (Object)"true");
                } else {
                    boolean condition = true;
                    String parentId = region.getParentId();
                    while (condition) {
                        List regions = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{parentId, orgId, new Date(), new Date()}, Region.class);
                        for (Region region3 : regions) {
                            if (map.get(region3.getId()) != null) continue;
                            JSONObject node2 = new JSONObject();
                            node2.put("id", (Object)region3.getId());
                            node2.put("pId", (Object)parentId);
                            node2.put("name", (Object)region3.getRegionName());
                            node2.put("isParent", (Object)"true");
                            if (region.getId().equals(region3.getId())) {
                                node2.put("checked", (Object)"true");
                            }
                            nodes.put((Object)node2);
                            map.put(region3.getId(), node2);
                        }
                        Region region2 = (Region)this.baseDao.uniqueFindByHql("from Region p where p.id = ?", new Object[]{parentId}, Region.class);
                        if (region2 == null) {
                            condition = false;
                            continue;
                        }
                        parentId = region2.getParentId();
                        if (!p.getId().equals(parentId)) continue;
                        condition = false;
                    }
                }
                ++n2;
            }
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public EmployeePartner getByPId(String personId) throws Exception {
        String hql = "from EmployeePartner e where e.personId = ? ";
        List eps = this.baseDao.findEntity(hql, new Object[]{personId}, EmployeePartner.class);
        return eps.size() == 0 ? null : (EmployeePartner)eps.get(0);
    }

    public List<PartnerContact> getByPartnerId(String partnerId) {
        String hql = " select distinct(p) from PartnerContact p where p.partnerId =? ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId}, PartnerContact.class);
    }

    public List<ContactRegion> getRegionsByUser(String userId) {
        String hql = " from ContactRegion  c , ShopViewContats  sc  where c.userId = ? and sc.dutyType='Region Manager' ";
        return this.baseDao.findEntity(hql, new Object[]{userId}, ContactRegion.class);
    }

    public List<ContactRegion> getRegionsByUserId(String userId) {
        String hql = " from ContactRegion c where c.userId = ? ";
        hql = String.valueOf(hql) + " and sysdate between nvl(c.startDate, sysdate-1) and nvl(c.endDate, sysdate+1) ";
        return this.baseDao.findEntity(hql, new Object[]{userId}, ContactRegion.class);
    }

    public String getFRegionsByUserId(String userId) {
        List<Region> newlist = this.getRegions(userId);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region iter : newlist) {
            if (iter.getEndDate() != null && DateUtils.now().compareTo(iter.getEndDate()) < 0) {
                set.add(iter.getId());
                continue;
            }
            if (iter.getEndDate() != null) continue;
            set.add(iter.getId());
        }
        StringBuffer sb = this.getIdBySb(set);
        return sb.substring(0, sb.length() - 1);
    }

    private List<Region> getRegions(String userId) {
        List<ContactRegion> list = this.getRegionsByUserId(userId);
        Map<String, Region> map = Cache.getRegion();
        ArrayList<Region> newlist = new ArrayList<Region>();
        for (ContactRegion contactRegion : list) {
            newlist.add(map.get(contactRegion.getRegionId()));
            if (map.get(contactRegion.getRegionId()).getChildList().size() <= 0) continue;
            for (Region region : map.get(contactRegion.getRegionId()).getChildList()) {
                newlist.add(region);
            }
        }
        return newlist;
    }

    private StringBuffer getIdBySb(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        if (set.size() > 0) {
            for (String p : set) {
                sb.append("'").append(p).append("',");
            }
        } else {
            sb.append("'1-2-3',");
        }
        return sb;
    }

    public String getPartnerIdByName(String name) {
        Partner partner = (Partner)this.baseDao.uniqueFindByHql("from Partner p where p.name = ?", new Object[]{name}, Partner.class);
        if (Beans.isEmpty((Object)partner)) {
            return "";
        }
        return partner.getId();
    }

    public String getChannelIdByUserId(String userId) {
        List<Region> newlist = this.getRegions(userId);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region iter : newlist) {
            if (iter.getEndDate() != null && DateUtils.now().compareTo(iter.getEndDate()) < 0) {
                set.add(iter.getParentId());
                continue;
            }
            if (iter.getEndDate() != null) continue;
            set.add(iter.getParentId());
        }
        String hql = " from ChannelType c where c.id in (?) and startDt < ? and (endDt > ? or endDt is null) ";
        StringBuffer sb = this.getIdBySb(set);
        List list = this.baseDao.findEntity(hql, new Object[]{sb.toString(), new Date(), new Date()}, ChannelType.class);
        if (list.size() > 0) {
            for (ChannelType p : list) {
                sb.append("'").append(p.getId()).append("',");
            }
        } else {
            sb.append("'1-2-3',");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<Region> getBigareasByList(String userId) {
        String idString = this.getFRegionsByUserId(userId);
        String hql = "select r from ChannelType ct,Region r where r.parentId = ct.id and r.id in(" + idString + ") ";
        return this.baseDao.findEntity(hql, Region.class);
    }

    public List<Region> getAreasByList(String userId) {
        String idString = this.getFRegionsByUserId(userId);
        String hql = "from Region where id in (" + idString + ") and id not in( select r from ChannelType ct,Region r where r.parentId = ct.id and r.id in(" + idString + ")) ";
        return this.baseDao.findEntity(hql, Region.class);
    }

    public String getFRegionsById(String paetnerId, String saleChannelTypeId, String bigAreaId) {
        List list = null;
        list = StringUtils.isEmpty(bigAreaId) ? this.baseDao.findEntity("from Region where parentId =? and orgId = ? ", new Object[]{saleChannelTypeId, paetnerId}, Region.class) : this.baseDao.findEntity("from Region where parentId =? and orgId = ? ", new Object[]{bigAreaId, paetnerId}, Region.class);
        Map<String, Region> map = Cache.getRegion();
        ArrayList<Region> newlist = new ArrayList<Region>();
        for (Region region : list) {
            newlist.add(map.get(region.getId()));
            if (map.get(region.getId()).getChildList().size() <= 0) continue;
            for (Region region2 : map.get(region.getId()).getChildList()) {
                newlist.add(region2);
            }
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region region : newlist) {
            if (region.getEndDate() != null && DateUtils.now().compareTo(region.getEndDate()) < 0) {
                set.add(region.getId());
                continue;
            }
            if (region.getEndDate() != null) continue;
            set.add(region.getId());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (set.size() > 0) {
            for (String string : set) {
                stringBuffer.append("'").append(string).append("',");
            }
        } else {
            stringBuffer.append("'1-2-3',");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public Set<String> getRegionsByDutyType(String userId) {
        List<ContactRegion> list = this.getRegionsByUser(userId);
        Map<String, Region> map = Cache.getRegion();
        ArrayList<Region> newlist = new ArrayList<Region>();
        for (ContactRegion contactRegion : list) {
            newlist.add(map.get(contactRegion.getRegionId()));
            if (map.get(contactRegion.getRegionId()).getChildList().size() <= 0) continue;
            for (Region region : map.get(contactRegion.getRegionId()).getChildList()) {
                newlist.add(region);
            }
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region iter : newlist) {
            if (iter.getEndDate() != null && DateUtils.now().compareTo(iter.getEndDate()) < 0) {
                set.add(iter.getId());
                continue;
            }
            if (iter.getEndDate() != null) continue;
            set.add(iter.getId());
        }
        System.out.println(set.size());
        return set;
    }

    public void deleteRegionAndPosition(String id) {
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete ContactRegion where userId=?", args);
        this.baseDao.executeHQL("delete ContactPosition where userId=?", args);
        this.baseDao.executeHQL("delete ContactPartner where userId=?", args);
        this.baseDao.executeHQL("delete ContactShop where userId=?", args);
    }

    public List<ContactRegion> getUserByRegion(String regionId) {
        String hql = " from ContactRegion where regionId= ? ";
        return this.baseDao.findEntity(hql, new Object[]{regionId}, ContactRegion.class);
    }

    public List<Partner> getOrgPartners(String orgId) {
        String hql = "from Partner p where p.masterOuId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{orgId}, Partner.class);
    }

    public List<PartnerContact> getByOrgId(String orgId) {
        String hql = "from PartnerContact p where p.partnerId = ?";
        return this.baseDao.findEntity(hql, new Object[]{orgId}, PartnerContact.class);
    }

    public void addShop(List<ContactShop> sts) {
        this.baseDao.save(sts);
    }

    public List<Employee> getEmps() {
        String hql = "from Employee";
        return this.baseDao.findEntity(hql, new Object[0], Employee.class);
    }

    public Map<String, String> getByOrgMap(String orgId) {
        String hql = "from PartnerContact p where p.partnerId = ?";
        List list = this.baseDao.findEntity(hql, new Object[]{orgId}, PartnerContact.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PartnerContact pc : list) {
            map.put(String.valueOf(pc.getContactName()) + "_" + pc.getMobile(), pc.getId());
        }
        return map;
    }

    public Contact getReport(String id) throws Exception {
        Contact v = (Contact)this.baseDao.get(Contact.class, (Serializable)((Object)id));
        v.setRegion(this.getRegion(id));
        return v;
    }

    public String getRegoinIdByName(String name) {
        List<Map<String, Object>> list = this.newBaseDao.findBySql("select row_id as \"id\"  from CX_REGION_MAIN where REGION_NAME = '" + name + "' and ORG_ID ='" + StringUtils.getOrgId() + "' ");
        if (Beans.isEmpty(list)) {
            return "";
        }
        return list.get(0).get("id").toString();
    }

    public String getChannelTypeIdByName(String name) {
        List<Map<String, Object>> list = this.newBaseDao.findBySql("select row_id as \"id\" from CX_CHANNEL_TYPE p where p.name = '" + name + "'");
        if (Beans.isEmpty(list)) {
            return "";
        }
        return list.get(0).get("id").toString();
    }

    public Customer getByApplyid(String applyid) {
        ArrayList<String> obj = new ArrayList<String>();
        obj.add(applyid);
        String hql = " from Customer where 1=1 ";
        hql = String.valueOf(hql) + " and applyerCode = ? ";
        Customer c = (Customer)this.baseDao.findFirstEntity(hql, obj.toArray(), Customer.class);
        return c;
    }

    public Map<String, String> validateExcelsheet(List<Map> data, String orgId) {
        TreeMap<String, String> errorMsg = new TreeMap<String, String>();
        HashMap<String, String> duplicate = new HashMap<String, String>();
        new HashMap();
        if (Beans.isNotEmpty(data)) {
            int i = 2;
            for (Map m : data) {
                if (Beans.isEmpty(m.get("empno")) || Beans.isEmpty(m.get("fullname")) || Beans.isEmpty(m.get("roletype")) || Beans.isEmpty(m.get("phonenumber")) || Beans.isEmpty(m.get("belong"))) {
                    errorMsg.put("\u884c " + String.valueOf(i), "\u5de5\u53f7,\u59d3\u540d,\u804c\u52a1\u5206\u7c7b,\u79fb\u52a8\u7535\u8bdd,\u6240\u5c5e\u6e20\u9053\u533a\u57df\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                    ++i;
                    continue;
                }
                if (Beans.isNotEmpty(m.get("applyerId")) && Beans.isEmpty((Object)Cache.getPartnerByNo(m.get("applyerId").toString()))) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u7ecf\u9500\u5546\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                if (Beans.isNotEmpty(m.get("regionname")) && Beans.isEmpty((Object)Cache.getRegionById(this.getRegoinIdByName(m.get("regionname").toString())))) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u533a\u57df\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                if (Beans.isNotEmpty(m.get("districtname")) && Beans.isEmpty((Object)Cache.getRegionById(this.getRegoinIdByName(m.get("districtname").toString())))) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u5927\u533a\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                if (Beans.isNotEmpty((Object)m.get("channelnamae").toString()) && this.validateChannel(m.get("channelnamae").toString()).booleanValue()) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u6e20\u9053\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                if (Beans.isEmpty((Object)Cache.getItemType("CONTACT_TYPE", m.get("roletype").toString()))) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u804c\u52a1\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                if (!this.validateEmpno(m.get("empno").toString()).booleanValue()) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u975e\u6cd5\u7684\u5458\u5de5\u53f7\uff0c\u8bf7\u6362\u4e00\u4e2a");
                    ++i;
                    continue;
                }
                PartnerShop partnerShop = Cache.getPartnerShopByNo(m.get("belong").toString());
                if (Beans.isEmpty((Object)partnerShop)) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                m.put("orgId", partnerShop.getId());
                if (Beans.isNotEmpty(m.get("endDt")) && DateUtils.autoFormatDate((String)m.get("endDt").toString(), (String[])new String[0]) == null) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u6362\u4e00\u4e2a");
                    ++i;
                    continue;
                }
                String empno = m.get("empno").toString();
                String roletype = m.get("roletype").toString();
                if (!duplicate.containsKey(empno)) {
                    duplicate.put(empno, roletype);
                } else if (!roletype.equals(duplicate.get(empno))) {
                    errorMsg.put("\u884c" + String.valueOf(i), "\u4e00\u4e2a\u5458\u5de5\u53f7\u53ea\u80fd\u5339\u914d\u4e00\u4e2a\u804c\u52a1");
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        return Beans.isEmpty(errorMsg) ? null : errorMsg;
    }

    public Boolean validateEmpno(String empno) {
        ArrayList<String> obj = new ArrayList<String>();
        obj.add(empno);
        String hql = " from Contact where 1=1 ";
        hql = String.valueOf(hql) + " and empno = ? and partnerOrgId = ? ";
        obj.add(StringUtils.getOrgId());
        List contact = this.baseDao.findEntity(hql, obj.toArray(), Contact.class);
        if (contact.size() > 1) {
            return false;
        }
        return true;
    }

    public String getFRegionsByName(String channelname, String partnerId) {
        ChannelType ct = (ChannelType)this.baseDao.uniqueFindByHql("from ChannelType p where p.name = ? and partnerId = ?", new Object[]{channelname, StringUtils.getOrgId()}, ChannelType.class);
        String channelid = ct.getId();
        List list = this.baseDao.findEntity("from Region where parentId =? and orgId = ? ", new Object[]{channelid, partnerId}, Region.class);
        StringBuffer sb = new StringBuffer();
        for (Region p : list) {
            sb.append(p.getId()).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void addFromExcel(Contact cv) {
        this.baseDao.save(cv.getRegion());
        this.baseDao.save(cv.getPartner());
    }

    public List<AdjustStockUtil> addFromExcel(List<List<Object>> objs, Employee employee) {
        ArrayList<AdjustStockUtil> msgList = new ArrayList<AdjustStockUtil>();
        HashMap<String, String> shopListMap = new HashMap<String, String>();
        HashMap<String, String> partnerContactsMap = new HashMap<String, String>();
        ArrayList<ContactShop> list = new ArrayList<ContactShop>();
        ContactShop t = null;
        int i = 0;
        while (i < objs.size()) {
            List<Object> item = objs.get(i);
            Contact ep = new Contact();
            ep.setEmpno(ep.getEmpno().trim());
            this.findContactByEmpNo(ep.getEmpno(), ep.getId());
            if (ep.getPersontype().equals("\u5916\u90e8")) {
                ep.setPersontype("External");
            }
            ep.fillInitData(employee);
            ep.setMf(ep.getMfName());
            ep.setPersontype(ep.getPersontypeName());
            ep.setRoletype(ep.getRoletypeName());
            ep.setPartnerOrgId(employee.getCurrentPartner().getOrganizationid());
            ep.setState("insert");
            String shopNumber = (String)item.get(0);
            if (StringUtils.isEmpty(shopNumber)) {
                msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            } else {
                ShopView shopView = (ShopView)this.baseDao.findFirstEntity("from ShopView where shopNumber = ? ", new Object[]{shopNumber}, ShopView.class);
                if (shopView == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u95e8\u5e97\u7f16\u53f7\u4e0d\u6b63\u786e\u3002"));
                } else {
                    shopListMap.put(shopView.getShopNumber(), shopView.getId());
                }
            }
            HashSet<String> set = new HashSet<String>();
            if (StringUtils.isNotEmpty(shopNumber)) {
                String scdb;
                String csjl;
                String qyjl;
                String dqjl = (String)item.get(2);
                if (StringUtils.isNotEmpty(dqjl)) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{dqjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u5927\u533a\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(dqjl);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                if (StringUtils.isNotEmpty(qyjl = (String)item.get(3))) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{qyjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u533a\u57df\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(qyjl);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                if (StringUtils.isNotEmpty(csjl = (String)item.get(4))) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{csjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u57ce\u5e02\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(csjl);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                if (StringUtils.isNotEmpty(scdb = (String)item.get(5))) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{csjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u57ce\u5e02\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(scdb);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                for (String name : set) {
                    ContactShop contactShop = (ContactShop)this.baseDao.findFirstEntity("from ContactShop where userId = ? and shopId = ? ", new Object[]{partnerContactsMap.get(name), shopListMap.get(shopNumber)}, ContactShop.class);
                    if (contactShop != null || !StringUtils.isNotEmpty((String)partnerContactsMap.get(name)) || shopListMap.get(shopNumber) == null || !StringUtils.isNotEmpty((String)shopListMap.get(shopNumber))) continue;
                    t = new ContactShop();
                    t.setShopId((String)shopListMap.get(shopNumber));
                    t.setUserId((String)partnerContactsMap.get(name));
                    t.setCreateDt(new Date());
                    t.setStartDate(new Date());
                    t.setLastUpdateDt(new Date());
                    t.setLastUpdatorId("0-8");
                    t.setCreatorId("0-8");
                    list.add(t);
                }
            }
            ++i;
        }
        if (msgList.size() > 0) {
            return msgList;
        }
        return msgList;
    }

    public void findContactByEmpNo(String empNo, String id) {
        Contact contact;
        ArrayList<String> obj = new ArrayList<String>();
        String hql = " from Contact where 1=1 ";
        if (StringUtils.isNotEmpty(empNo)) {
            hql = String.valueOf(hql) + " and empno = ? ";
            obj.add(empNo);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id <> ? ";
            obj.add(id);
        }
        if ((contact = (Contact)this.baseDao.findFirstEntity(hql, obj.toArray(), Contact.class)) != null) {
            throw new AppException("0010", "\u5458\u5de5\u7f16\u53f7\uff1a" + empNo + "\u5df2\u5b58\u5728\uff0c\u8bf7\u586b\u5199\u5176\u4ed6\u7f16\u53f7");
        }
    }

    public void updateFromExcel(Contact cv) {
        Object[] args = new Object[]{cv.getId()};
        this.baseDao.executeHQL("delete ContactRegion where userId=?", args);
        this.baseDao.executeHQL("delete ContactPartner where userId=?", args);
        this.baseDao.save(cv.getRegion());
        this.baseDao.save(cv.getPartner());
    }

    public Boolean validateChannel(String channelname) {
        ChannelType ct = (ChannelType)this.baseDao.uniqueFindByHql("from ChannelType p where p.partnerId = ? and p.name = ?", new Object[]{StringUtils.getOrgId(), channelname}, ChannelType.class);
        if (Beans.isEmpty((Object)ct)) {
            return true;
        }
        return false;
    }

    public List<Contact> getExportExcelData(String partnerId, String contactName, String mobile, String no, String nodeType) {
        String hql = "select c from PartnerContact p, Contact c  where p.id = c.id and  p.partnerId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        if (StringUtils.isNotBlank(contactName)) {
            hql = String.valueOf(hql) + " and p.contactName like ? ";
            args.add("%" + contactName.trim() + "%");
        }
        if (StringUtils.isNotEmpty(no)) {
            hql = String.valueOf(hql) + " and p.no like ? ";
            args.add("%" + no.trim() + "%");
        }
        if (StringUtils.isNotEmpty(mobile)) {
            hql = String.valueOf(hql) + "and p.mobile = ?";
            args.add(mobile);
        }
        hql = String.valueOf(hql) + " order by p.createDt desc ";
        List contacts = this.baseDao.findEntity(hql, args.toArray(), Contact.class);
        for (Contact contact : contacts) {
            contact.setRegion(this.getRegion(contact.getId()));
            contact.setPartner(this.getPartner(contact.getId()));
        }
        return contacts;
    }

    public Map<String, String> getByOrgMapJustName(String organizationid) {
        String hql = "from PartnerContact p where p.partnerId = ?";
        List list = this.baseDao.findEntity(hql, new Object[]{organizationid}, PartnerContact.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PartnerContact pc : list) {
            map.put(pc.getContactName(), pc.getId());
        }
        return map;
    }

    public String belongTree(Map<String, Object> param) throws Exception {
        JSONObject node;
        Partner pt = (Partner)param.get("pt");
        String nodeType = (String)param.get("nodeType");
        String id = (String)param.get("id");
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        HashMap<String, JSONObject> nodeMap = new HashMap<String, JSONObject>();
        rootNode.put("id", (Object)pt.getId());
        rootNode.put("pId", (Object)pt.getParentPartnerId());
        rootNode.put("name", (Object)pt.getName());
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("open", (Object)"true");
        rootNode.put("nodeType", (Object)"org");
        rootNode.put("isParent", (Object)"true");
        if (StringUtils.isEmpty(nodeType)) {
            rootNode.put("nocheck", (Object)"true");
        }
        nodeMap.put(pt.getId(), rootNode);
        nodes.put((Object)rootNode);
        if (StringUtils.isNotEmpty(nodeType)) {
            List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by c.created ", new Object[]{pt.getId(), new Date(), new Date()}, ChannelType.class);
            for (ChannelType dt : dts) {
                JSONObject node2 = new JSONObject();
                node2.put("id", (Object)dt.getId());
                node2.put("pId", (Object)pt.getId());
                node2.put("name", (Object)dt.getName());
                node2.put("iconSkin", (Object)"start");
                node2.put("isParent", (Object)"true");
                node2.put("nodeType", (Object)"channel");
                if (Beans.isNotEmpty((Object)param.get("channelNocheck"))) {
                    node2.put("nocheck", param.get("channelNocheck"));
                }
                rootNode.put("nocheck", (Object)"true");
                nodeMap.put(dt.getId(), node2);
                nodes.put((Object)node2);
            }
        }
        if (StringUtils.isEmpty(nodeType)) {
            List<DictionaryItem> des = Cache.getItems("TCBJ_STORE_TYPE");
            for (DictionaryItem de : des) {
                JSONObject node2 = new JSONObject();
                node2.put("id", (Object)de.getName());
                node2.put("pId", (Object)pt.getId());
                node2.put("name", (Object)de.getVal());
                node2.put("level", (Object)"level");
                node2.put("iconSkin", (Object)"MD");
                node2.put("isParent", (Object)"true");
                node2.put("nocheck", (Object)"true");
                nodeMap.put(pt.getId(), node2);
                nodes.put((Object)node2);
                List sps = this.baseDao.findEntity("from ShopView s where s.parentDealerId = ? and s.shopType = ? order by startDate", new Object[]{pt.getId(), de.getName()}, ShopView.class);
                for (ShopView sp : sps) {
                    JSONObject node1 = new JSONObject();
                    node1.put("id", (Object)sp.getId());
                    node1.put("pId", (Object)de.getName());
                    node1.put("name", (Object)sp.getShopName());
                    node1.put("isParent", (Object)"true");
                    node1.put("nocheck", (Object)"false");
                    node1.put("level", (Object)"level");
                    nodeMap.put(sp.getId(), node1);
                    nodes.put((Object)node1);
                }
            }
        }
        Region region = (Region)this.baseDao.findFirstEntity("from Region p where p.orgId = ? and p.id = ? order by startDate ", new Object[]{pt.getId(), id}, Region.class);
        Customer customer = null;
        if (region == null && customer != null && nodeMap.get(id) == null) {
            region = (Region)this.baseDao.findFirstEntity("from Region p where p.orgId = ? and p.id = ? order by startDate ", new Object[]{pt.getId(), customer.getAreaCode()}, Region.class);
        }
        if (customer != null && nodeMap.get(id) == null) {
            List cts = this.baseDao.findEntity("from Customer c where c.areaCode = ? and c.supplierId = ? order by startDate ", new Object[]{customer.getAreaCode(), pt.getId()}, Customer.class);
            for (Customer ct : cts) {
                JSONObject node1 = new JSONObject();
                node1.put("id", (Object)ct.getApplyerId());
                node1.put("pId", (Object)ct.getAreaCode());
                node1.put("name", (Object)ct.getApplyerName());
                node1.put("iconSkin", (Object)"root");
                node1.put("nodeType", (Object)"customer");
                node1.put("isParent", (Object)"true");
                nodeMap.put(ct.getApplyerId(), node1);
                nodes.put((Object)node1);
            }
        }
        if (region != null) {
            List rts = this.baseDao.findEntity("from Region p where p.orgId = ? and p.parentId = ? order by startDate ", new Object[]{pt.getId(), region.getParentId()}, Region.class);
            if (!region.getParentId().equals(region.getChannelCode())) {
                List rts2 = this.baseDao.findEntity("from Region p where p.orgId = ? and p.channelCode = ? and p.parentId = ? order by startDate ", new Object[]{pt.getId(), region.getChannelCode(), region.getChannelCode()}, Region.class);
                rts.addAll(rts2);
            }
            for (Region pn : rts) {
                JSONObject node2 = new JSONObject();
                node2.put("id", (Object)pn.getId());
                node2.put("pId", (Object)pn.getParentId());
                node2.put("name", (Object)pn.getRegionName());
                node2.put("iconSkin", (Object)"start");
                node2.put("isParent", (Object)"true");
                node2.put("nodeType", (Object)"region");
                nodeMap.put(pn.getId(), node2);
                nodes.put((Object)node2);
            }
        }
        if ((node = (JSONObject)nodeMap.get(id)) != null) {
            node.put("checked", (Object)"true");
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public String ajaxGetBelongChildNode(String id, String orgId) throws JSONException {
        String str = "";
        JSONArray nodes = new JSONArray();
        List pns = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pns) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)pn.getId());
            node.put("pId", (Object)pn.getParentId());
            node.put("name", (Object)pn.getRegionName());
            node.put("iconSkin", (Object)"start");
            node.put("isParent", (Object)"true");
            node.put("nodeType", (Object)"region");
            nodes.put((Object)node);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }
}

