/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PartnerAndShop {
    private String id;
    private String crmId;
    private String area;
    private String city;
    private String county;
    private String isMenberShop;
    private String province;
    private String name;
    private String shortName;
    private String no;
    private String superiorShopId;
    private String addressDetails;
    private String bigArea;
    private String shopClassify;
    private String shopType;
    private Date startDate;
    private Date endDate;
    private String shopTel;
    private String approveRemark;
    private String auditorId;
    private Date auditDate;
    private String parentPartnerId;
    private String parentPartnerNo;
    private String siebelShopId;
    private String approveState;
    private String applyType;
    private String phone;
    private String dssIfaceFlag = "0";
    private String sfaIfaceFlag = "0";
    private String type;
    private Date createDt;
    private String createdBy;
    private Date lastUpdateDt;
    private String lastUpdBy;
    private String terminalLevel;
    private Long latitude;
    private Long longitude;
    private Double shopTotalArea;
    private Double shopBrandArea;
    private String promotionMode;
    private String outerClientNo;
    private Long promotionNumber;
    private Long shoppeNumber;
    private String isReceiveAllot;
    private String sourceSystem;
    private String isTopPartner;
    private String orgId;

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public PartnerAndShop() {
    }

    public PartnerAndShop(Shop shop) {
        this.type = "Store";
        this.bigArea = shop.getBigAreaName();
        this.area = shop.getAreaName();
        this.city = shop.getCityName();
        this.county = shop.getCountyName();
        this.initParentPartner(Cache.getPartner(shop.getParentDealerId()));
        this.parentPartnerNo = Cache.getPartnerCSN(this.parentPartnerId);
        this.province = shop.getProvinceName();
        this.crmId = shop.getId();
        this.name = shop.getShopName();
        this.no = shop.getShopNumber();
        this.siebelShopId = shop.getSiebelShopId();
        this.shopTel = shop.getShopTel();
        this.shopType = shop.getShopTypeName();
        this.shopClassify = shop.getShopClassifyName();
        this.isMenberShop = shop.getIsMenberShop();
        this.startDate = shop.getStartDate();
        this.endDate = shop.getEndDate();
        this.applyType = shop.getApplyType();
        this.approveState = shop.getApproveState();
        this.addressDetails = shop.getAddressDetails();
        this.lastUpdateDt = new Date();
        this.terminalLevel = shop.getTerminalLevelName();
        this.latitude = shop.getLatitude();
        this.longitude = shop.getLongitude();
        this.shopTotalArea = shop.getShopTotalArea();
        this.shopBrandArea = shop.getShopBrandArea();
        this.promotionMode = shop.getPromotionMode();
        this.outerClientNo = shop.getOuterClientNo();
        this.promotionNumber = shop.getPromotionNumber();
        this.shoppeNumber = shop.getShoppeNumber();
        this.isReceiveAllot = shop.getIsReceiveAllot();
    }

    public void updateShop(Shop shop, String sourceSystem) {
        this.type = "Store";
        this.sourceSystem = sourceSystem;
        if (StringUtils.isNotEmpty(shop.getBigAreaName())) {
            this.bigArea = shop.getBigAreaName();
        }
        if (StringUtils.isNotEmpty(shop.getAreaName())) {
            this.area = shop.getAreaName();
        }
        this.city = shop.getCityName();
        this.county = shop.getCountyName();
        this.initParentPartner(Cache.getPartner(shop.getParentDealerId()));
        this.parentPartnerNo = Cache.getPartnerCSN(this.parentPartnerId);
        this.province = shop.getProvinceName();
        this.crmId = shop.getId();
        this.name = shop.getShopName();
        this.no = shop.getShopNumber();
        this.siebelShopId = shop.getSiebelShopId();
        this.shopTel = shop.getShopTel();
        this.shopType = shop.getShopTypeName();
        this.shopClassify = shop.getShopClassifyName();
        this.isMenberShop = shop.getIsMenberShop();
        this.startDate = shop.getStartDate();
        this.endDate = shop.getEndDate();
        this.applyType = shop.getApplyType();
        this.approveState = shop.getApproveState();
        this.addressDetails = shop.getAddressDetails();
        this.lastUpdateDt = new Date();
        this.dssIfaceFlag = "0";
        this.sfaIfaceFlag = "0";
        this.terminalLevel = shop.getTerminalLevelName();
        this.latitude = shop.getLatitude();
        this.longitude = shop.getLongitude();
        this.shopTotalArea = shop.getShopTotalArea();
        this.shopBrandArea = shop.getShopBrandArea();
        this.promotionMode = shop.getPromotionMode();
        this.outerClientNo = shop.getOuterClientNo();
        this.promotionNumber = shop.getPromotionNumber();
        this.shoppeNumber = shop.getShoppeNumber();
        this.isReceiveAllot = shop.getIsReceiveAllot();
    }

    public PartnerAndShop(PartnerRecord partner) {
        this.type = "Partner";
        this.crmId = partner.getId();
        this.bigArea = partner.getBigAreaName();
        this.area = partner.getAreaName();
        this.province = partner.getProvinceName();
        this.city = partner.getCityName();
        this.county = partner.getCountyName();
        this.initParentPartner(Cache.getPartner(partner.getParentPartnerId()));
        this.parentPartnerNo = Cache.getPartnerCSN(this.getParentPartnerId());
        this.name = partner.getName();
        this.no = partner.getNo();
        this.shortName = partner.getShortName();
        this.startDate = partner.getStartDt();
        this.endDate = partner.getEndDt();
        this.phone = partner.getPhone();
        this.applyType = partner.getApplyType();
        this.approveState = partner.getApplyState();
        this.addressDetails = partner.getAddress();
        this.lastUpdateDt = new Date();
        this.lastUpdBy = partner.getLastUpdatorId();
        this.outerClientNo = partner.getClientAppNo();
        this.shopType = Cache.getItemName("TCBJ_STORE_TYPE", partner.getTaxNo());
    }

    public void updatePartner(PartnerRecord partner, String sourceSystem) {
        this.type = "Partner";
        this.sourceSystem = sourceSystem;
        this.crmId = partner.getId();
        this.bigArea = partner.getBigAreaName();
        this.area = partner.getAreaName();
        this.province = partner.getProvinceName();
        this.city = partner.getCityName();
        this.county = partner.getCountyName();
        this.initParentPartner(Cache.getPartner(partner.getParentPartnerId()));
        this.parentPartnerNo = Cache.getPartnerCSN(this.getParentPartnerId());
        this.name = partner.getName();
        this.no = partner.getNo();
        this.shortName = partner.getShortName();
        this.startDate = partner.getStartDt();
        this.endDate = partner.getEndDt();
        this.phone = partner.getPhone();
        this.applyType = partner.getApplyType();
        this.approveState = partner.getApplyState();
        this.addressDetails = partner.getAddress();
        this.lastUpdateDt = new Date();
        this.lastUpdBy = partner.getLastUpdatorId();
        this.outerClientNo = partner.getClientAppNo();
        this.dssIfaceFlag = "0";
        this.sfaIfaceFlag = "0";
        this.shopType = Cache.getItemName("TCBJ_STORE_TYPE", partner.getTaxNo());
    }

    public void fillInitData(Employee e) {
        this.setCreatedBy("0-1");
        this.setLastUpdBy("0-1");
        this.setCreateDt(new Date());
        this.setLastUpdateDt(new Date());
    }

    public PartnerAndShop initialize() {
        this.setIsMenberShop("N");
        this.setStartDate(DateUtils.now());
        return this;
    }

    public String getIsMenberShopName() {
        return "Y".equals(this.getIsMenberShop()) ? "\u662f" : "\u5426";
    }

    public String getSuperiorShopId() {
        return this.superiorShopId;
    }

    public void setSuperiorShopId(String superiorShopId) {
        this.superiorShopId = superiorShopId;
    }

    public String getAddressDetails() {
        return this.addressDetails;
    }

    public void setAddressDetails(String addressDetails) {
        this.addressDetails = addressDetails;
    }

    public String getShopClassify() {
        return this.shopClassify;
    }

    public void setShopClassify(String shopClassify) {
        this.shopClassify = shopClassify;
    }

    public String getShopClassifyName() {
        return Cache.getItemName("TCBJ_STORE_SUBTYPE", this.getShopClassify());
    }

    public String getShopType() {
        return this.shopType;
    }

    public void setShopType(String shopType) {
        this.shopType = shopType;
    }

    public String getShopTypeName() {
        return Cache.getItemName("TCBJ_STORE_TYPE", this.getShopType());
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getApproveState() {
        return this.approveState;
    }

    public void setApproveState(String approveState) {
        this.approveState = approveState;
    }

    public String getApproveRemark() {
        return this.approveRemark;
    }

    public void setApproveRemark(String approveRemark) {
        this.approveRemark = approveRemark;
    }

    public String getAuditorId() {
        return this.auditorId;
    }

    public void setAuditorId(String auditorId) {
        this.auditorId = auditorId;
    }

    public Date getAuditDate() {
        return this.auditDate;
    }

    public String getShopTel() {
        return this.shopTel;
    }

    public void setShopTel(String shopTel) {
        this.shopTel = shopTel;
    }

    public void setAuditDate(Date auditDate) {
        this.auditDate = auditDate;
    }

    public Date getCreateDt() {
        return this.createDt;
    }

    public Date getLastUpdateDt() {
        return this.lastUpdateDt;
    }

    public void setCreateDt(Date createDt) {
        this.createDt = createDt;
    }

    public void setLastUpdateDt(Date lastUpdateDt) {
        this.lastUpdateDt = lastUpdateDt;
    }

    public String getApproveStateName() {
        String name = "\u672a\u77e5";
        if (StringUtils.isEmpty(this.approveState) || this.approveState.equals("0")) {
            name = "\u8349\u7a3f";
        } else if (this.approveState.equals("1")) {
            name = "\u5f85\u5ba1\u6279";
        } else if (this.approveState.equals("2")) {
            name = "\u5ba1\u6279\u901a\u8fc7";
        } else if (this.approveState.equals("3")) {
            name = "\u5ba1\u6279\u4e0d\u901a\u8fc7";
        } else if (this.approveState.equals("9")) {
            name = "\u4f5c\u5e9f";
        }
        return "<span>" + name + "</span>";
    }

    public String getSiebelShopId() {
        return this.siebelShopId;
    }

    public void setSiebelShopId(String siebelShopId) {
        this.siebelShopId = siebelShopId;
    }

    public String getApplyTypeName() {
        String name = "\u672a\u77e5";
        if (this.applyType == null) {
            return "<span>" + name + "</span>";
        }
        name = this.applyType.equals("1") ? "\u65b0\u589e" : "\u4fee\u6539";
        return "<span>" + name + "</span>";
    }

    public String getAuditorName() {
        return Cache.getEmployeeName(this.getAuditorId());
    }

    public boolean getCanedit() {
        if (StringUtils.isEmpty(this.approveState)) {
            return false;
        }
        return this.approveState.equals(ShopEnum.ApproveState.draft.getValue()) || this.approveState.equals(ShopEnum.ApproveState.notpass.getValue());
    }

    public boolean getCandelete() {
        if (StringUtils.isEmpty(this.approveState)) {
            return false;
        }
        return this.approveState.equals(ShopEnum.ApproveState.draft.getValue()) || this.approveState.equals(ShopEnum.ApproveState.notpass.getValue());
    }

    public String getApplyType() {
        return this.applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getIsMenberShop() {
        return this.isMenberShop;
    }

    public void setIsMenberShop(String isMenberShop) {
        this.isMenberShop = isMenberShop;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getBigArea() {
        return this.bigArea;
    }

    public void setBigArea(String bigArea) {
        this.bigArea = bigArea;
    }

    public String getParentPartnerId() {
        return this.parentPartnerId;
    }

    public void setParentPartnerId(String parentPartnerId) {
        this.parentPartnerId = parentPartnerId;
    }

    public String getParentPartnerNo() {
        return this.parentPartnerNo;
    }

    public void setParentPartnerNo(String parentPartnerNo) {
        this.parentPartnerNo = parentPartnerNo;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getDssIfaceFlag() {
        return this.dssIfaceFlag;
    }

    public void setDssIfaceFlag(String dssIfaceFlag) {
        this.dssIfaceFlag = dssIfaceFlag;
    }

    public String getSfaIfaceFlag() {
        return this.sfaIfaceFlag;
    }

    public void setSfaIfaceFlag(String sfaIfaceFlag) {
        this.sfaIfaceFlag = sfaIfaceFlag;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getLastUpdBy() {
        return this.lastUpdBy;
    }

    public void setLastUpdBy(String lastUpdBy) {
        this.lastUpdBy = lastUpdBy;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getCrmId() {
        return this.crmId;
    }

    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    public String getTerminalLevel() {
        return this.terminalLevel;
    }

    public void setTerminalLevel(String terminalLevel) {
        this.terminalLevel = terminalLevel;
    }

    public Long getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Long latitude) {
        this.latitude = latitude;
    }

    public Long getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Long longitude) {
        this.longitude = longitude;
    }

    public Double getShopTotalArea() {
        return this.shopTotalArea;
    }

    public void setShopTotalArea(Double shopTotalArea) {
        this.shopTotalArea = shopTotalArea;
    }

    public Double getShopBrandArea() {
        return this.shopBrandArea;
    }

    public void setShopBrandArea(Double shopBrandArea) {
        this.shopBrandArea = shopBrandArea;
    }

    public String getPromotionMode() {
        return this.promotionMode;
    }

    public void setPromotionMode(String promotionMode) {
        this.promotionMode = promotionMode;
    }

    public String getOuterClientNo() {
        return this.outerClientNo;
    }

    public void setOuterClientNo(String outerClientNo) {
        this.outerClientNo = outerClientNo;
    }

    public Long getPromotionNumber() {
        return this.promotionNumber;
    }

    public void setPromotionNumber(Long promotionNumber) {
        this.promotionNumber = promotionNumber;
    }

    public Long getShoppeNumber() {
        return this.shoppeNumber;
    }

    public void setShoppeNumber(Long shoppeNumber) {
        this.shoppeNumber = shoppeNumber;
    }

    public String getIsReceiveAllot() {
        return this.isReceiveAllot;
    }

    public String getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public void setIsReceiveAllot(String isReceiveAllot) {
        this.isReceiveAllot = isReceiveAllot;
    }

    public void initParentPartner(Partner parentPartner) {
        Partner partnerOrg1 = Cache.getPartner(parentPartner.getParentPartnerId());
        if (parentPartner.isOrg() || partnerOrg1.isOrg()) {
            this.parentPartnerId = parentPartner.getId();
            this.isTopPartner = "Y";
        } else {
            Partner partnerOrg2 = Cache.getPartner(partnerOrg1.getParentPartnerId());
            if (partnerOrg2.isOrg()) {
                this.parentPartnerId = partnerOrg1.getId();
            } else {
                Partner partner3 = Cache.getPartner(partnerOrg2.getParentPartnerId());
                if (partner3.isOrg()) {
                    this.parentPartnerId = partnerOrg2.getId();
                } else {
                    Partner partner4 = Cache.getPartner(partner3.getParentPartnerId());
                    if (partner4.isOrg()) {
                        this.parentPartnerId = partner3.getId();
                    }
                }
            }
            this.isTopPartner = "N";
        }
    }

    public String getIsTopPartner() {
        return this.isTopPartner;
    }

    public void setIsTopPartner(String isTopPartner) {
        this.isTopPartner = isTopPartner;
    }
}

