/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.exception;

import com.tcbj.crm.exception.AuthenticateException;
import com.tcbj.crm.exception.BaseException;
import com.tcbj.crm.exception.ErrorInfo;
import com.tcbj.crm.exception.ValidateException;
import com.tcbj.crm.util.ServletContextUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

public class ErrorResult {
    private String status;
    private String type;
    private Object data;

    public ErrorResult() {
    }

    public ErrorResult(String status, String type, Object data) {
        this.status = status;
        this.type = type;
        this.data = data;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static ErrorResult getErrorResult(Exception ex) {
        String status = "-1";
        String type = null;
        Object data = null;
        if (ex instanceof AuthenticateException) {
            type = "authentication";
        } else if (ex instanceof MaxUploadSizeExceededException) {
            type = "other";
            ApplicationContext ac = ServletContextUtils.getContext();
            data = ac.getMessage("0090", null, null);
        } else if (ex instanceof ValidateException) {
            type = "validation";
            ApplicationContext ac = ServletContextUtils.getContext();
            BindingResult errors = ((ValidateException)ex).getErrors();
            List fes = errors.getFieldErrors();
            ArrayList<ErrorInfo> infos = new ArrayList<ErrorInfo>();
            for (FieldError fe : fes) {
                String msg = ac.getMessage(fe.getCode(), null, null);
                infos.add(new ErrorInfo(fe.getField(), msg));
            }
            data = infos;
        } else if (ex instanceof BaseException) {
            type = "business";
            ApplicationContext ac = ServletContextUtils.getContext();
            String code = ((BaseException)ex).getCode();
            Object[] args = ((BaseException)ex).getArgs();
            if (StringUtils.isNotEmpty((String)code)) {
                data = ac.getMessage(code, args, null);
            }
        } else {
            type = "other";
            data = "\u7cfb\u7edf\u51fa\u73b0\u4e86\u5c0f\u95ee\u9898,\u8bf7\u7a0d\u540e\u91cd\u8bd5......";
        }
        return new ErrorResult(status, type, data);
    }
}

