/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.exception;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.exception.BaseException;
import com.tcbj.crm.exception.ErrorResult;
import com.tcbj.crm.util.ServletContextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class MyExceptionResolver
extends SimpleMappingExceptionResolver {
    Logger logger = LoggerFactory.getLogger(MyExceptionResolver.class);

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.logger.error(ex.getMessage(), (Throwable)ex);
        if (request.getHeader("accept").indexOf("application/json") <= -1 && (request.getHeader("X-Requested-With") == null || request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") <= -1)) {
            String message = null;
            if (ex instanceof BaseException) {
                ApplicationContext ac = ServletContextUtils.getContext();
                String code = ((BaseException)ex).getCode();
                Object[] args = ((BaseException)ex).getArgs();
                if (StringUtils.isNotEmpty((String)code)) {
                    message = ac.getMessage(code, args, null);
                }
            } else {
                if (ex instanceof MaxUploadSizeExceededException) {
                    try {
                        PrintWriter writer = response.getWriter();
                        writer.write(JSON.toJSONString((Object)ErrorResult.getErrorResult(ex)));
                        writer.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
                message = null;
            }
            request.setAttribute("ctx", (Object)request.getContextPath());
            request.setAttribute("SYSTEM_ERROR", message);
            return super.doResolveException(request, response, handler, ex);
        }
        try {
            response.setContentType("application/json;charset=utf-8");
            try (PrintWriter writer = null;){
                writer = response.getWriter();
                writer.write(JSON.toJSONString((Object)ErrorResult.getErrorResult(ex)));
                writer.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

