/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.expbalance;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.expbalance.ExcelService;
import com.tcbj.crm.expbalance.ExpBalanceCondition;
import com.tcbj.crm.expbalance.ExpBalanceService;
import com.tcbj.crm.expbalance.excel.AreaExc;
import com.tcbj.crm.expbalance.excel.BigAreaExc;
import com.tcbj.crm.expbalance.excel.ChannelExc;
import com.tcbj.crm.expbalance.excel.CustomerExc;
import com.tcbj.crm.expbalance.excel.DetailCostExc;
import com.tcbj.crm.expbalance.excel.SubTypeExc;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/expbalance"})
public class ExReportController
extends BaseController {
    @Autowired
    ExpBalanceService service;
    @Autowired
    ExcelService excelService;

    @RequestMapping(value={"/subType.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String subTypeData(@ModelAttribute(value="condition") ExpBalanceCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        Page page = this.service.subTypeQuery(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/subType.ftl";
    }

    @RequestMapping(value={"/customer.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String customer_data(@ModelAttribute(value="condition") ExpBalanceCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        Page page = this.service.customerQuery(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/customer.ftl";
    }

    @RequestMapping(value={"/channel.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String channelData(ExpBalanceCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        Page page = this.service.channelQuery(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/channel.ftl";
    }

    @RequestMapping(value={"/bigarea.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String bigareaData(@ModelAttribute(value="condition") ExpBalanceCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        Page page = this.service.bigareaQuery(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/bigarea.ftl";
    }

    @RequestMapping(value={"/area.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String areaData(ExpBalanceCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        Page page = this.service.areaQuery(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/area.ftl";
    }

    @RequestMapping(value={"/detailed.do"})
    public String detailed(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ExpBalanceCondition con, Model model) {
        Page page = this.service.getDetailed(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/detailed.ftl";
    }

    @RequestMapping(value={"/excel.do"}, method={RequestMethod.GET})
    public String excel() {
        return "expbalance/excel.ftl";
    }

    @RequestMapping(value={"/excel.do"}, method={RequestMethod.POST})
    public String excelPost(Long year, HttpServletRequest request, Model model) {
        IUploadFile file;
        List<List<Object>> datas;
        List<String> errorList;
        List<IUploadFile> list = this.uploadFile(request, "expbalance");
        Employee emp = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() > 0 && (errorList = this.excelService.saveExcel(year, emp, datas = ExcelHandle.readExcel((file = list.get(0)).getRealPath()))).size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(errorList)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/dlist.do"}, method={RequestMethod.GET})
    public String dlist(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String type, String budgetTargetType, String expensesItemCode, Model model) {
        Employee emp = this.getCurrentEmployee();
        Page page = this.service.getExpApply(type, budgetTargetType, expensesItemCode, emp.getCurrentPartner().getId(), pageno);
        model.addAttribute("page", (Object)page);
        return "expbalance/view/dlist.ftl";
    }

    @RequestMapping(value={"/my.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String my_data(@ModelAttribute(value="condition") ExpBalanceCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getOrganizationid());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        con.setName(this.getCurrentEmployee().getCurrentPartner().getName());
        Page page = this.service.customerQuery(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/view/my.ftl";
    }

    @RequestMapping(value={"/export.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(ExpBalanceCondition con, HttpServletRequest request, HttpServletResponse response) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setYear(con.getYear() == null ? (long)DateUtils.getYear() : con.getYear());
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            if ("subType".equals(con.getByType())) {
                List<SubTypeExc> excels = this.service.getSubTypeExcel(con);
                String[] titles = new String[]{"\u8d39\u7528\u7c7b\u578b", "\u8d39\u7528\u9879\u76ee", "\u9884\u7b97\u8d39\u7528", "\u7533\u8bf7\u8d39\u7528", "\u6838\u9500\u8d39\u7528", "\u53ef\u7528\u8d39\u7528"};
                ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u9879\u76ee\u8d39\u7528\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u9879\u76ee\u8d39\u7528", titles, excels, response);
            } else if ("channel".equals(con.getByType())) {
                List<ChannelExc> excels = this.service.getChannelExcel(con);
                String[] titles = new String[]{"\u6e20\u9053\u540d\u79f0", "\u8d39\u7528\u7c7b\u578b", "\u8d39\u7528\u9879\u76ee", "\u9884\u7b97\u8d39\u7528", "\u7533\u8bf7\u8d39\u7528", "\u6838\u9500\u8d39\u7528", "\u53ef\u7528\u8d39\u7528"};
                ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u6e20\u9053\u8d39\u7528\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6e20\u9053\u8d39\u7528", titles, excels, response);
            } else if ("bigarea".equals(con.getByType())) {
                List<BigAreaExc> excels = this.service.getBigAreaExcel(con);
                String[] titles = new String[]{"\u5927\u533a\u540d\u79f0", "\u8d39\u7528\u7c7b\u578b", "\u8d39\u7528\u9879\u76ee", "\u9884\u7b97\u8d39\u7528", "\u7533\u8bf7\u8d39\u7528", "\u6838\u9500\u8d39\u7528", "\u53ef\u7528\u8d39\u7528"};
                ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u5927\u533a\u8d39\u7528\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u5927\u533a\u8d39\u7528", titles, excels, response);
            } else if ("area".equals(con.getByType())) {
                List<AreaExc> excels = this.service.getAreaExcel(con);
                String[] titles = new String[]{"\u533a\u57df\u540d\u79f0", "\u8d39\u7528\u7c7b\u578b", "\u8d39\u7528\u9879\u76ee", "\u9884\u7b97\u8d39\u7528", "\u7533\u8bf7\u8d39\u7528", "\u6838\u9500\u8d39\u7528", "\u53ef\u7528\u8d39\u7528"};
                ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u533a\u57df\u8d39\u7528\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u533a\u57df\u8d39\u7528", titles, excels, response);
            } else if ("customer".equals(con.getByType())) {
                List<CustomerExc> excels = this.service.getCustomerExcel(con);
                String[] titles = new String[]{"\u5ba2\u6237\u540d\u79f0", "\u8d39\u7528\u7c7b\u578b", "\u8d39\u7528\u9879\u76ee", "\u9884\u7b97\u8d39\u7528", "\u7533\u8bf7\u8d39\u7528", "\u6838\u9500\u8d39\u7528", "\u53ef\u7528\u8d39\u7528"};
                ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u5ba2\u6237\u8d39\u7528\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u5ba2\u6237\u8d39\u7528", titles, excels, response);
            } else if ("detailed".equals(con.getByType())) {
                List<DetailCostExc> excels = this.service.getDetailExcel(con);
                String[] titles = new String[]{"\u8d39\u7528\u7c7b\u578b", "\u8d39\u7528\u9879\u76ee", "\u7533\u8bf7\u65b9", "\u88ab\u7533\u8bf7\u65b9", "\u7533\u8bf7\u91d1\u989d", "\u6838\u9500\u91d1\u989d", "\u5e74\u4efd"};
                ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u8d39\u7528\u660e\u7ec6\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u8d39\u7528\u660e\u7ec6", titles, excels, response);
            }
        }
        catch (Exception e) {
            throw new AppException("\u8d39\u7528\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }
}

