/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.fgift;

import com.tcbj.crm.aplfine.AplfineCondition;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.FreeBalance;
import com.tcbj.crm.entity.GiftHis;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.fgift.FGiftCondition;
import com.tcbj.crm.fgift.FGiftService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fgift"})
public class FGiftController
extends BaseController {
    @Autowired
    FGiftService fGiftService;
    @Autowired
    ProductService productService;
    @Autowired
    ClientService clientService;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    protected PactMainService pactMainService;

    @RequestMapping(value={"/remainderlist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String remainder(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, FGiftCondition con) {
        con.setEm(this.getCurrentEmployee());
        model.addAttribute("page", (Object)this.fGiftService.getgiftremainder(con, pageno));
        model.addAttribute("con", (Object)con);
        return "fgift/remainderlist.ftl";
    }

    @RequestMapping(value={"/getContract.do"})
    @ResponseBody
    public Result getContract(String applyerId) {
        String supplierId = this.getCurrentEmployee().getCurrentPartner().getId();
        Date dt = DateUtils.now();
        return this.getSuccessResult(this.pactMainService.getPactMain(applyerId, supplierId, dt));
    }

    @RequestMapping(value={"/remainderadd.do"}, method={RequestMethod.GET})
    public String remainderadd() {
        return "fgift/remainderadd.ftl";
    }

    @RequestMapping(value={"/remainderadd.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String remainderaddsbm(FreeBalance giftBalance) {
        Date dt;
        String supplierId = this.getCurrentEmployee().getCurrentPartner().getId();
        String applyerId = giftBalance.getApplyerId();
        PactMain contract = this.pactMainService.getPactMain(applyerId, supplierId, dt = DateUtils.now());
        if (contract == null) {
            return "false";
        }
        giftBalance.setSupplierId(supplierId);
        giftBalance.setGiftType(contract.getFreeScaleType());
        giftBalance.fillInitData(this.getCurrentEmployee());
        if (contract.getFreeScaleType().equals(Constant.SCALETYPE_QUANTITY)) {
            giftBalance.setInitCount(giftBalance.getInit());
            giftBalance.setInitAmount(giftBalance.getInit() * Constant.FREE_RATE);
        } else {
            giftBalance.setInitAmount(giftBalance.getInit());
        }
        try {
            return this.fGiftService.saveGiftRemainder(giftBalance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/remainderview.do"}, method={RequestMethod.GET})
    public String remainderview(@RequestParam(value="id", required=false) String id, Model model) {
        model.addAttribute("entity", (Object)this.fGiftService.getGiftRemainder(id));
        return "fgift/remainderview.ftl";
    }

    @RequestMapping(value={"/remainderedit.do"}, method={RequestMethod.GET})
    public String remainderedit(FGiftCondition con, Model model) {
        model.addAttribute("entity", (Object)this.fGiftService.getGiftRemainder(con.getId()));
        return "fgift/remainderedit.ftl";
    }

    @RequestMapping(value={"/remainderedit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String remaindereditsbm(FreeBalance giftBalance, Model model) {
        try {
            this.fGiftService.updateGiftRemainder(giftBalance);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/seriallist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String seriallist(AplfineCondition condition, Model model) {
        model.addAttribute("list", this.fGiftService.getserialList(condition));
        model.addAttribute("con", (Object)condition);
        return "fgift/seriallist.ftl";
    }

    @RequestMapping(value={"/serialAdd.do"}, method={RequestMethod.GET})
    public String serialAdd(@RequestParam(value="balanceId", required=false, defaultValue="") String balanceId, Model model) {
        if (StringUtils.isEmpty(balanceId)) {
            return null;
        }
        FreeBalance balance = this.fGiftService.getGiftRemainder(balanceId);
        model.addAttribute("balance", (Object)balance);
        return "fgift/serialAdd.ftl";
    }

    @RequestMapping(value={"/serialAdd.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result serialAdd_do(GiftHis giftHis) {
        giftHis.setType("fgift");
        giftHis.setState(3);
        giftHis.fillInitData(this.getCurrentEmployee());
        giftHis.setLastupdatorId(this.getCurrentEmployee().getId());
        giftHis.setLastupdateDt(DateUtils.now());
        this.fGiftService.addGiftHis(giftHis);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/addrebatearea.do"}, method={RequestMethod.GET})
    public String addRebateArea(Model model) {
        return "fgift/addrebatearea.ftl";
    }
}

