/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.fgift;

import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.FreeBalance;
import com.tcbj.crm.entity.GiftHis;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.fgift.FGiftService;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.util.ActivityRequestHelper;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fGiftFacadeService")
public class FGiftFacadeService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PactMainService pactMainService;
    @Autowired
    FGiftService fGiftService;
    private static Double rate = 4.0;
    private String URL = StringUtils.getActicity();
    private String organization = StringUtils.getPrefix();
    @Autowired
    ClientService clientService;
    @Autowired
    OrderApplyService orderApplyService;

    public Double getGiftBalance(String applyerId, String supplierId, Integer precision) {
        FreeBalance gb = (FreeBalance)this.baseDao.findFirstEntity(" from FreeBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{applyerId, supplierId}, FreeBalance.class);
        if (gb == null) {
            return 0.0;
        }
        Double result = gb.getRemainderAmount();
        if (result == null) {
            return 0.0;
        }
        result = MathUtils.getPrecision((Double)result, (Integer)precision);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Double getCurrentGiftBalance(OrderApply order, Integer precision) {
        void var9_15;
        Date orderDate = order.getDt() == null ? new Date() : order.getDt();
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), orderDate);
        List<OrderApplyItem> list = order.getOrderApplyItems();
        Double totalAmount = 0.0;
        Double totalQuantity = 0.0;
        Double currentAmount = 0.0;
        for (OrderApplyItem orderApplyItem : list) {
            if (!"PRODUCT".equals(orderApplyItem.getProductType()) || !"0".equals(orderApplyItem.getActivityFlag())) continue;
            double quantity = orderApplyItem.getActQuantity() == null ? orderApplyItem.getQuantity() : orderApplyItem.getActQuantity();
            double price = orderApplyItem.getActPrice() == null || orderApplyItem.getActPrice() == 0.0 ? orderApplyItem.getPrice() : orderApplyItem.getActPrice();
            totalAmount = MathUtils.add((Double)totalAmount, (Double)MathUtils.mul((Double)quantity, (Double)price));
            totalQuantity = totalQuantity + (orderApplyItem.getActQuantity() == null ? orderApplyItem.getQuantity() : orderApplyItem.getActQuantity());
        }
        for (OrderActivityProduct orderActivityProduct : order.getActivityProducts()) {
            Product product = Cache.getProduct(orderActivityProduct.getProductId());
            if (!"PRODUCT".equals(product.getOrderProdType()) || !"\u5426".equals(orderActivityProduct.getIsFree())) continue;
            double quantity = orderActivityProduct.getQuantity();
            double price = orderActivityProduct.getPrice();
            totalAmount = MathUtils.add((Double)totalAmount, (Double)MathUtils.mul((Double)quantity, (Double)price));
            totalQuantity = totalQuantity + orderActivityProduct.getQuantity();
        }
        Double d = pactMain.getFreeScale();
        if (d == null) {
            Double d2 = 0.0;
        }
        if (Constant.FreeMoneyType.PRODUCT_DISCOUNTMONEY.name().equals(pactMain.getFreeMoneyType())) {
            totalAmount = MathUtils.sub((Double)totalAmount, (Double)order.getDiscountMoney());
            totalAmount = (totalAmount = MathUtils.sub((Double)totalAmount, (Double)order.getFullDiscountMoney())) <= 0.0 ? 0.0 : totalAmount;
        }
        currentAmount = "QUANTITY".equals(pactMain.getFreeScaleType()) ? Double.valueOf(MathUtils.div((Double)MathUtils.mul((Double)totalQuantity, (Double)var9_15), (Double)100.0) * rate) : MathUtils.div((Double)MathUtils.mul((Double)totalAmount, (Double)var9_15), (Double)100.0);
        currentAmount = MathUtils.getPrecision((Double)currentAmount, (Integer)precision);
        return currentAmount;
    }

    public Activity actView(String code) {
        String url = String.valueOf(this.URL) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", this.organization);
        map.put("code", code);
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        Map<String, Object> activityInfo = EsbAnalyUtil.getResult(body, "activityInfo");
        Activity activity = new Activity();
        Beans.copy((Object)activity, activityInfo);
        ArrayList ruleList = new ArrayList();
        Map<String, Object> variabls = EsbAnalyUtil.getResult(body, "variabls");
        HashMap<String, Object> ruleData = new HashMap<String, Object>();
        if (variabls != null) {
            activity.setPartnerJson(variabls.get("fwList").toString());
            ruleData.put("activityType", variabls.get("activityType").toString());
            ruleData.put("droolsRuleCode", variabls.get("droolsRuleCode").toString());
            ruleData.put("creatDate", variabls.get("creatDate").toString());
            ruleData.put("priceFlag", variabls.get("priceFlag").toString());
            ruleData.put("partFlag", variabls.get("partFlag").toString());
            List zpList = (List)Jsons.toBean((String)variabls.get("zpList").toString(), List.class);
            variabls.put("rulePrivilege", zpList);
            List tjList = (List)Jsons.toBean((String)variabls.get("tjList").toString(), List.class);
            variabls.put("ruleCondition", tjList);
            variabls.remove("fwList");
            variabls.remove("zpList");
            variabls.remove("tjList");
            variabls.remove("channel_id");
            variabls.remove("district_id");
            variabls.remove("region_id");
            variabls.remove("partner_id");
            ruleData.put("ruleInfo", variabls);
        }
        ruleList.add(ruleData);
        activity.setRuleJson(Jsons.toJson(ruleList));
        return activity;
    }

    public OrderActivityInfo findOrderActivityInfoByActId(String activityId) {
        return (OrderActivityInfo)this.baseDao.findFirstEntity(" from OrderActivityInfo where activityId = ? ", new Object[]{activityId}, OrderActivityInfo.class);
    }

    /*
     * WARNING - void declaration
     */
    public Double[] getExtendGiftAmountAndQuantity(OrderApply order, Integer precision) {
        void var10_16;
        Date orderDate = order.getDt() == null ? new Date() : order.getDt();
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), orderDate);
        List<OrderApplyItem> list = order.getOrderApplyItems();
        Double totalAmount = 0.0;
        Double totalQuantity = 0.0;
        Double currentAmount = 0.0;
        Double currentQuantity = 0.0;
        for (OrderApplyItem orderApplyItem : list) {
            if (!"PRODUCT".equals(orderApplyItem.getProductType()) || !"0".equals(orderApplyItem.getActivityFlag())) continue;
            double quantity = orderApplyItem.getActQuantity() == null ? orderApplyItem.getQuantity() : orderApplyItem.getActQuantity();
            double price = orderApplyItem.getActPrice() == null || orderApplyItem.getActPrice() == 0.0 ? orderApplyItem.getPrice() : orderApplyItem.getActPrice();
            totalAmount = MathUtils.add((Double)totalAmount, (Double)MathUtils.mul((Double)quantity, (Double)price));
            totalQuantity = totalQuantity + (orderApplyItem.getActQuantity() == null ? orderApplyItem.getQuantity() : orderApplyItem.getActQuantity());
        }
        for (OrderActivityProduct orderActivityProduct : order.getActivityProducts()) {
            Product product = Cache.getProduct(orderActivityProduct.getProductId());
            if (!"PRODUCT".equals(product.getOrderProdType()) || !"\u5426".equals(orderActivityProduct.getIsFree())) continue;
            double quantity = orderActivityProduct.getQuantity();
            double price = orderActivityProduct.getPrice();
            totalAmount = MathUtils.add((Double)totalAmount, (Double)MathUtils.mul((Double)quantity, (Double)price));
            totalQuantity = totalQuantity + orderActivityProduct.getQuantity();
        }
        Double d = pactMain.getFreeScale();
        if (d == null) {
            Double d2 = 0.0;
        }
        if (Constant.FreeMoneyType.PRODUCT_DISCOUNTMONEY.name().equals(pactMain.getFreeMoneyType())) {
            totalAmount = MathUtils.sub((Double)totalAmount, (Double)order.getDiscountMoney());
            totalAmount = (totalAmount = MathUtils.sub((Double)totalAmount, (Double)order.getFullDiscountMoney())) <= 0.0 ? 0.0 : totalAmount;
        }
        if ("QUANTITY".equals(pactMain.getFreeScaleType())) {
            currentQuantity = MathUtils.div((Double)MathUtils.mul((Double)totalQuantity, (Double)var10_16), (Double)100.0);
            currentAmount = currentQuantity * rate;
        } else {
            currentAmount = MathUtils.div((Double)MathUtils.mul((Double)totalAmount, (Double)var10_16), (Double)100.0);
        }
        currentAmount = MathUtils.getPrecision((Double)currentAmount, (Integer)precision);
        currentQuantity = MathUtils.getPrecision((Double)currentQuantity, (Integer)precision);
        Double[] rtn = new Double[]{currentAmount, currentQuantity};
        return rtn;
    }

    public void use(OrderApply order, Double actGiftQuantity, Double actAmount, Integer precision) {
        double useCount;
        Double[] tmp;
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), order.getDt());
        FreeBalance gb = (FreeBalance)this.baseDao.findFirstEntity(" from FreeBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{order.getApplyerId(), order.getSupplierId()}, FreeBalance.class);
        if (gb == null) {
            gb = new FreeBalance();
            gb.setGiftType(pactMain.getFreeScaleType());
            gb.setApplyerId(order.getApplyerId());
            gb.setSupplierId(order.getSupplierId());
            gb.setCreateDt(DateUtils.now());
            gb.setLastUpdateDt(gb.getCreateDt());
            gb.setCreatorId(order.getApproverId());
            gb.setLastUpdatorId(gb.getCreatorId());
            this.baseDao.save((Object)gb);
        }
        Double extendAmount = (tmp = this.getExtendGiftAmountAndQuantity(order, precision))[0] == null ? 0.0 : tmp[0];
        Double extendCount = tmp[1] == null ? 0.0 : tmp[1];
        double useAmount = actAmount == null ? 0.0 : actAmount;
        double d = useCount = actGiftQuantity == null ? 0.0 : actGiftQuantity;
        if (extendAmount == 0.0 && useAmount == 0.0 && useCount == 0.0) {
            return;
        }
        gb.setExtendCount(MathUtils.add((Double)gb.getExtendCount(), (Double)extendCount));
        gb.setUseCount(MathUtils.add((Double)gb.getUseCount(), (Double)useCount));
        gb.setExtendAmount(MathUtils.add((Double)gb.getExtendAmount(), (Double)extendAmount));
        gb.setUseAmount(MathUtils.add((Double)gb.getUseAmount(), (Double)useAmount));
        this.baseDao.update((Object)gb);
        if (useAmount != 0.0 || extendAmount != null && extendAmount != 0.0) {
            GiftHis giftHis = new GiftHis();
            giftHis.setGiftBalanceId(gb.getId());
            giftHis.setGiftType(gb.getGiftType());
            giftHis.setUseCount(useCount);
            if (Constant.SCALETYPE_QUANTITY.equals(gb.getGiftType())) {
                giftHis.setOrderGetCount(extendCount);
            } else {
                giftHis.setOrderGetCount(0.0);
            }
            giftHis.setUseAmount(useAmount);
            giftHis.setOrderGetAmount(extendAmount);
            giftHis.setOrderId(order.getId());
            giftHis.setOrderNo(order.getNo());
            giftHis.setCreatorId(order.getApproverId());
            giftHis.setLastupdatorId(order.getApproverId());
            giftHis.setType("fgift");
            this.baseDao.save((Object)giftHis);
        }
    }

    public void unuse(String orderId) {
        GiftHis gh = (GiftHis)this.baseDao.findFirstEntity("from GiftHis g where g.orderId = ? and state = '1' and type='fgift' order by useDate desc ", new Object[]{orderId}, GiftHis.class);
        if (gh == null) {
            return;
        }
        OrderApply order = this.orderApplyService.getSimpleOrderApply(orderId);
        FreeBalance gb = (FreeBalance)this.baseDao.findFirstEntity(" from FreeBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{order.getApplyerId(), order.getSupplierId()}, FreeBalance.class);
        if (Constant.SCALETYPE_QUANTITY.equals(gh.getGiftType())) {
            double extendCount = MathUtils.sub((Double)gb.getExtendCount(), (Double)gh.getOrderGetCount());
            double useCount = MathUtils.sub((Double)gb.getUseCount(), (Double)gh.getUseCount());
            this.baseDao.executeHQL(" update FreeBalance set extendCount = ? ,useCount = ?  where id = ?", new Object[]{extendCount, useCount, gb.getId()});
        }
        double extendAmount = MathUtils.sub((Double)gb.getExtendAmount(), (Double)gh.getOrderGetAmount());
        double useAmount = MathUtils.sub((Double)gb.getUseAmount(), (Double)gh.getUseAmount());
        this.baseDao.executeHQL(" update FreeBalance set extendAmount = ? ,useAmount = ?  where id = ?", new Object[]{extendAmount, useAmount, gb.getId()});
        this.baseDao.executeHQL(" update GiftHis set state = ? where id = ?", new Object[]{0, gh.getId()});
    }
}

