/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.freegift;

import com.tcbj.crm.account.AccountService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.GiftIntRebate;
import com.tcbj.crm.entity.GiftIntRebatemg;
import com.tcbj.crm.entity.RebateArea;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.freegift.FreeGiftCondition;
import com.tcbj.crm.freegift.GiftIntRebatemgWrap;
import com.tcbj.crm.gift.GiftCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FreeGiftService {
    @Autowired
    PersonnelService personnelService;
    @Autowired
    AccountService accountService;
    @Autowired
    BaseDao baseDao;

    public Page getRebateAreaList(int pageno, GiftCondition condition) {
        String regionids = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from RebateArea o where o.areaId in(" + regionids + ")");
        ArrayList args = new ArrayList();
        HQL.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), pageno);
        return page;
    }

    public List<GiftIntRebatemgWrap> getGiftIntRebatemg(String id) {
        ArrayList<GiftIntRebatemgWrap> result = new ArrayList<GiftIntRebatemgWrap>();
        List list = this.baseDao.findEntity(" from Customer c ,GiftIntRebatemg g where g.giftRegionIntrebatemgId = ? and c.supplierId = g.supplierId and c.applyerId = g.applyerId ", (Object)id, Object[].class);
        for (Object[] objs : list) {
            GiftIntRebatemgWrap wrap = new GiftIntRebatemgWrap(objs);
            result.add(wrap);
        }
        return result;
    }

    public void saveAllot(Employee emp, FreeGiftCondition condition) {
        if (condition.getDelIds() != null) {
            String[] ids;
            String[] stringArray = ids = condition.getDelIds().split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    List giftIntRebateList = this.baseDao.findEntity("from GiftIntRebate g where g.rebateId = ? ", new Object[]{id}, GiftIntRebate.class);
                    if (giftIntRebateList != null && giftIntRebateList.size() > 0) {
                        throw new AppException("9222");
                    }
                    this.baseDao.executeHQL("delete GiftIntRebatemg where id= ?", args);
                }
                ++n2;
            }
        }
        RebateArea rebateArea = (RebateArea)this.baseDao.get(RebateArea.class, (Serializable)((Object)condition.getGiftRegionIntrebatemgId()));
        List<GiftIntRebatemgWrap> list = condition.getGiftIntRebatemgList();
        if (list != null && list.size() > 0) {
            for (GiftIntRebatemgWrap wrap : list) {
                if (StringUtils.isNotEmpty(wrap.getId())) {
                    GiftIntRebatemg mg = (GiftIntRebatemg)this.baseDao.get(GiftIntRebatemg.class, (Serializable)((Object)wrap.getId()));
                    if (wrap.getAmount() < mg.getWithheldMoney()) {
                        throw new AppException("9223");
                    }
                }
                GiftIntRebatemg intRebatemg = new GiftIntRebatemg();
                intRebatemg.fillInitData(emp);
                intRebatemg.setApplyerId(wrap.getCustomerId());
                intRebatemg.setSupplierId(emp.getCurrentPartner().getId());
                intRebatemg.setGiftRegionIntrebatemgId(condition.getGiftRegionIntrebatemgId());
                intRebatemg.setId(StringUtils.isNotEmpty(wrap.getId()) ? wrap.getId() : null);
                intRebatemg.setStartDate(rebateArea.getStartDt());
                intRebatemg.setEndDate(rebateArea.getEndDt());
                intRebatemg.setRebateMoney(wrap.getAmount());
                intRebatemg.setIndentMoneyPercent(0.0);
                intRebatemg.setRebateNo("0_1");
                intRebatemg.setProducttype("GIFT");
                if (intRebatemg.getId() != null) {
                    this.baseDao.deleteById(GiftIntRebatemg.class, (Serializable)((Object)intRebatemg.getId()));
                }
                this.baseDao.save((Object)intRebatemg);
            }
        }
        List giftIntRebatemgList = this.baseDao.findEntity("from GiftIntRebatemg g where g.giftRegionIntrebatemgId = ? ", new Object[]{condition.getGiftRegionIntrebatemgId()}, GiftIntRebatemg.class);
        RebateArea r = (RebateArea)this.baseDao.get(RebateArea.class, (Serializable)((Object)condition.getGiftRegionIntrebatemgId()));
        double all = 0.0;
        for (GiftIntRebatemg mg : giftIntRebatemgList) {
            all += mg.getRebateMoney().doubleValue();
        }
        if (all > r.getAmount()) {
            throw new AppException("9224");
        }
        r.setAllotAmount(all);
        this.baseDao.update((Object)r);
    }

    public void updateRebateArea(RebateArea rebateArea) {
        List giftIntRebatemgList = this.baseDao.findEntity("from GiftIntRebatemg g where g.giftRegionIntrebatemgId = ? ", new Object[]{rebateArea.getId()}, GiftIntRebatemg.class);
        double all = 0.0;
        for (GiftIntRebatemg mg : giftIntRebatemgList) {
            all += mg.getRebateMoney().doubleValue();
        }
        if (all > rebateArea.getAmount()) {
            throw new AppException("9224");
        }
        this.baseDao.update((Object)rebateArea);
        if (rebateArea.getEndDt() != null) {
            this.baseDao.executeHQL(" update GiftIntRebatemg g set g.startDate = ? , g.endDate = ? where g.giftRegionIntrebatemgId = ? ", new Object[]{rebateArea.getStartDt(), rebateArea.getEndDt(), rebateArea.getId()});
        } else {
            this.baseDao.executeHQL(" update GiftIntRebatemg g set g.startDate = ? where g.giftRegionIntrebatemgId = ? ", new Object[]{rebateArea.getStartDt(), rebateArea.getId()});
        }
    }

    public void saveRebateArea(RebateArea rebateArea) {
        this.baseDao.save((Object)rebateArea);
    }

    public RebateArea getRebateArea(String id) {
        return (RebateArea)this.baseDao.get(RebateArea.class, (Serializable)((Object)id));
    }

    public void deleteRebateArea(String id) {
        List list = this.baseDao.findEntity(" from GiftIntRebatemg g where g.giftRegionIntrebatemgId = ? ", (Object)id, GiftIntRebatemg.class);
        if (list != null && list.size() > 0) {
            throw new AppException("");
        }
        this.baseDao.delete(this.baseDao.load(RebateArea.class, (Serializable)((Object)id)));
    }

    public Page getGiftInterbatemgList(int pageno, FreeGiftCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        HQL.append(" from GiftIntRebatemg o,Customer c where 1=1 ");
        HQL.append(" and c.applyerId = o.applyerId and c.supplierId = o.supplierId ");
        HQL.append(" and (c.bigAreaCode in ( ");
        HQL.append(sb);
        HQL.append(") or c.areaCode in ( ");
        HQL.append(sb);
        HQL.append(" ))");
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        HQL.append(" order by o.lastUpdateDt desc");
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<GiftIntRebatemg> list = new ArrayList<GiftIntRebatemg>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((GiftIntRebatemg)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public List<GiftIntRebate> getIntRebateHistoryById(String id) {
        List list = this.baseDao.findEntity(" from GiftIntRebate where rebateId = ? order by createDt", (Object)id, GiftIntRebate.class);
        return list;
    }

    public void saveJobRebateMonth(String orgId) throws Exception {
        Calendar calendar = Calendar.getInstance();
        String preMonth = String.valueOf(String.valueOf(calendar.get(1))) + "-" + String.valueOf(calendar.get(2));
        String currMonth = String.valueOf(String.valueOf(calendar.get(1))) + "-" + String.valueOf(calendar.get(3));
        List<Object[]> rebateArea = this.accountService.getAreaAmountVListByMonth("area", preMonth);
        this.saveRebate("area", rebateArea, currMonth, orgId);
        List<Object[]> rebateBigArea = this.accountService.getAreaAmountVListByMonth("bigArea", preMonth);
        this.saveRebate("bigArea", rebateBigArea, currMonth, orgId);
    }

    private void saveRebate(String type, List<Object[]> rebateInfo, String currMonth, String orgId) {
        for (Object[] object : rebateInfo) {
            if (object[1] == null) continue;
            RebateArea rebateArea = new RebateArea();
            double amount = 0.0;
            if ("area".equals(type)) {
                amount = ((BigDecimal)object[0]).doubleValue() * 0.02;
                rebateArea.setRemark("\u533a\u57df\u540e\u53f0\u81ea\u52a8\u8ba1\u7b97");
            } else if ("bigArea".equals(type)) {
                amount = ((BigDecimal)object[0]).doubleValue() * 0.01;
                rebateArea.setRemark("\u5927\u533a\u57df\u540e\u53f0\u81ea\u52a8\u8ba1\u7b97");
            }
            rebateArea.setAmount(amount);
            rebateArea.setAllotAmount(0.0);
            rebateArea.setAreaId(object[1].toString());
            rebateArea.setPartnerId(orgId);
            rebateArea.setYearmonth(currMonth);
            rebateArea.setStartDt(new Date());
            rebateArea.setCreatorId("1-1");
            rebateArea.setLastUpdatorId("1-1");
            rebateArea.setSource("\u81ea\u52a8");
            rebateArea.setCreateDt(new Date());
            rebateArea.setCreated(new Date());
            rebateArea.setLastUpdateDt(new Date());
            this.baseDao.save((Object)rebateArea);
        }
    }
}

