/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.function;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.SystemOrgService;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.Function;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.function.FunctionService;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.DateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/function"})
public class FunctionController
extends BaseController {
    @Autowired
    EmployeeService service;
    @Autowired
    FunctionService functionService;
    @Autowired
    SystemOrgService systemOrgService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(String name, Model model) {
        Employee e = this.getCurrentEmployee();
        String userId = e.getId();
        if (this.systemOrgService.isSuperMan(e).booleanValue()) {
            userId = null;
        }
        List<Function> list = this.functionService.getRootList(userId);
        model.addAttribute("function", list);
        return "function/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(Function role, Model model) {
        return "function/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save(@Valid @RequestBody Function function, Model model) {
        Employee e = this.getCurrentEmployee();
        this.storageCode(function.getFunctionCode());
        function.fillInitData(e);
        this.functionService.save(function);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/addChild.do"}, method={RequestMethod.GET})
    public String addChild(String id, Model model) {
        model.addAttribute("function", (Object)this.functionService.findById(id));
        return "function/addChild.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        Function function = this.functionService.findById(id);
        model.addAttribute("function", (Object)function);
        return "function/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String update(Function form, Model model) throws IOException {
        Employee e = this.getCurrentEmployee();
        form.setLastUpdBy(e.getId());
        form.setLastUpd(DateUtils.now());
        this.functionService.update(form);
        return this.redirect("/function/list.do");
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String id, Model model) throws IOException {
        this.functionService.delete(id);
        return this.redirect("/function/list.do");
    }

    public void storageCode(String functionCode) {
        String vaildate = this.functionService.findCode(functionCode);
        if (vaildate == "false") {
            throw new AppException("5104");
        }
    }

    @RequestMapping(value={"/validateDel.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String validateDel(String id, Model model) {
        boolean isExist = this.functionService.isDel(id);
        return String.valueOf(isExist);
    }

    @RequestMapping(value={"/deleteFunctions.do"})
    public String deleteFunctions(String id, Model model) {
        List<Function> functions = this.functionService.findChilds(id, new ArrayList<Function>());
        this.functionService.deleteAll(functions);
        return this.redirect("/function/list.do");
    }
}

