/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.function;

import com.tcbj.crm.entity.Function;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="functionService")
public class FunctionService {
    @Autowired
    private BaseDao baseDao;

    public Page getList(String name, int pageNo) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Function where 1=1 ");
        if (StringUtils.isNotEmpty(name)) {
            hql.append(" and ");
            hql.append(" ( ");
            hql.append(" functionName like ? ");
            hql.append(" ) ");
            args.add("%" + name + "%");
        }
        hql.append(" order by createDt asc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), 2, pageNo);
        return page;
    }

    public List<Function> getList(String name) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Function where 1=1 ");
        if (StringUtils.isNotEmpty(name)) {
            hql.append(" and ");
            hql.append(" ( ");
            hql.append(" functionName like ? ");
            hql.append(" ) ");
            args.add("%" + name + "%");
        }
        hql.append(" order by createDt asc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Function.class);
    }

    public List<Function> getRootList(String userId) {
        List<Function> list = null;
        list = StringUtils.isNotEmpty(userId) ? this.getUserList(userId) : this.getAllList();
        ArrayList<Function> result = new ArrayList<Function>();
        HashMap<String, Function> map = new HashMap<String, Function>();
        for (Function fun : list) {
            map.put(fun.getId(), fun);
            if (!"0".equals(fun.getParentId())) continue;
            result.add(fun);
        }
        for (Function fun : list) {
            if ("0".equals(fun.getParentId()) || fun.getParentId() == null) continue;
            Function parentFunction = (Function)map.get(fun.getParentId());
            if (parentFunction == null) {
                throw new NullPointerException("\u6743\u9650\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5");
            }
            parentFunction.addChild(fun);
        }
        return result;
    }

    public List<Function> getAllList() {
        StringBuffer hql = new StringBuffer();
        hql.append("from Function ");
        hql.append(" order by createDt asc ");
        return this.baseDao.findEntity(hql.toString(), Function.class);
    }

    public List<Function> getUserList(String userId) {
        StringBuffer hql = new StringBuffer();
        hql.append("from RoleF r,Function f,RoleC c where c.userId = ? and c.roleId = r.roleId and r.functionId = f.id ");
        hql.append(" order by f.createDt asc ");
        List list = this.baseDao.findEntity(hql.toString(), new Object[]{userId}, Object[].class);
        ArrayList<Function> result = new ArrayList<Function>();
        for (Object[] objs : list) {
            result.add((Function)objs[1]);
        }
        HashSet<Function> set = new HashSet<Function>();
        ArrayList<Function> newList = new ArrayList<Function>();
        for (Function element : result) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    public void save(Function role) {
        this.baseDao.save((Object)role);
    }

    public Function findById(String id) {
        return (Function)this.baseDao.get(Function.class, (Serializable)((Object)id));
    }

    public void update(Function form) {
        Function function = (Function)this.baseDao.get(Function.class, (Serializable)((Object)form.getId()));
        function.setLastUpd(form.getLastUpd());
        function.setLastUpdBy(form.getLastUpdBy());
        function.setFunctionCode(form.getFunctionCode());
        function.setFunctionName(form.getFunctionName());
        function.setFutureType(form.getFutureType());
        function.setFutureDescription(form.getFutureDescription());
        function.setFutureParameter(form.getFutureParameter());
        function.setFutureUrlInvoking(form.getFutureUrlInvoking());
        this.baseDao.update((Object)function);
    }

    public void delete(String id) {
        this.baseDao.deleteById(Function.class, (Serializable)((Object)id));
    }

    public boolean isDel(String id) {
        boolean isExist = false;
        List list = this.baseDao.findEntity("from Function where parentId = ?", new Object[]{id});
        if (list.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public String findCode(String functionCode) {
        List list = this.baseDao.findEntity("from Function where functionCode = ?", new Object[]{functionCode}, Function.class);
        if (list.size() > 0) {
            return "false";
        }
        return "true";
    }

    public List<Function> findChilds(String id, List<Function> functions) {
        if (functions.size() == 0) {
            functions.add(this.findById(id));
        }
        List childs = this.baseDao.findEntity("from Function where parentId = ?", new Object[]{id}, Function.class);
        if (functions.size() > 0) {
            for (Function function : childs) {
                functions.add(function);
                this.findChilds(function.getId(), functions);
            }
        }
        return functions;
    }

    public void deleteAll(List<Function> ids) {
        this.baseDao.deleteAll(ids);
    }
}

