/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.gift;

import com.tcbj.crm.aplfine.AplfineCondition;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Gift;
import com.tcbj.crm.entity.GiftBalance;
import com.tcbj.crm.entity.RebateArea;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.gift.GiftCondition;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.gift.GiftWrap;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/gift"})
public class GiftController
extends BaseController {
    @Autowired
    GiftService giftService;
    @Autowired
    ProductService productService;
    @Autowired
    ClientService clientService;
    @Autowired
    PersonnelService personnelservice;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody Gift gift, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        gift.fillInitData(e);
        gift.setOrganizationId(e.getCurrentPartner().getId());
        this.giftService.save(gift);
        return this.getSuccessResult(null);
    }

    public void validateGift(String orgId, String giftId) {
        boolean isExist = this.giftService.isGift(orgId, giftId);
        if (isExist) {
            throw new AppException("6101");
        }
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody Gift gift, BindingResult errors, Model model, HttpServletRequest request) {
        Gift cf = this.giftService.get(gift.getId());
        Employee e = this.getCurrentEmployee();
        gift.setOrganizationId(e.getCurrentPartner().getId());
        gift.setCreatedBy(cf.getCreatedBy());
        gift.setCreatorId(cf.getCreatorId());
        this.giftService.update(gift);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/rowadd.do"}, method={RequestMethod.GET})
    public String rowadd_get(Model model, PartnerCondition con, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        ProductCondition ct = new ProductCondition();
        if (e.getCurrentPartner().getParPartnerId() == null) {
            Page page = this.productService.findPartners(ct, null, 1);
            List<Product> products = this.productService.getByPartnerIdTCBJ(e.getCurrentPartner());
            model.addAttribute("products", products);
            model.addAttribute("page", (Object)page);
        } else {
            List<Product> pds = this.productService.getProductPrice(e.getCurrentPartner().getId(), Product.class);
            List<Product> pcs = this.productService.getByPartnerId(e.getCurrentPartner().getId());
            model.addAttribute("pds", pds);
            model.addAttribute("pcs", pcs);
        }
        List<Customer> pts = this.clientService.findPartnerApplys(e.getCurrentPartner().getId());
        Date date = new Date();
        date = DateUtils.now();
        model.addAttribute("pts", pts);
        model.addAttribute("date", (Object)date);
        return "gift/rowadd.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Model model, PartnerCondition con, HttpServletRequest request) throws Exception {
        return "gift/add.ftl";
    }

    @RequestMapping(value={"/list.do"})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, GiftCondition condition, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        condition.setOrgId(e.getCurrentPartner().getId());
        condition.setEm(this.getCurrentEmployee());
        model.addAttribute("page", (Object)this.giftService.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "gift/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model, HttpServletRequest request) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        ProductCondition ct = new ProductCondition();
        Employee e = this.getCurrentEmployee();
        if (e.getCurrentPartner().getParPartnerId() == null) {
            Page page = this.productService.findPartners(ct, null, 1);
            List<Product> products = this.productService.getByPartnerIdTCBJ(e.getCurrentPartner());
            model.addAttribute("products", products);
            model.addAttribute("page", (Object)page);
        } else {
            List<Product> pds = this.productService.getProductPrice(e.getCurrentPartner().getId(), Product.class);
            List<Product> pcs = this.productService.getByPartnerId(e.getCurrentPartner().getId());
            model.addAttribute("pds", pds);
            model.addAttribute("pcs", pcs);
        }
        List<Customer> pts = this.clientService.findRegionApplys(e.getCurrentPartner().getId(), e.getId());
        model.addAttribute("pts", pts);
        Gift cxgift = this.giftService.get(id);
        model.addAttribute("master", (Object)cxgift);
        return "gift/edit.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, HttpServletRequest request) {
        this.giftService.delete(id);
        return "redirect:/gift/list.do";
    }

    @RequestMapping(value={"view.do"})
    public String view(String id, Model model) throws Exception {
        Gift cf = this.giftService.get(id);
        model.addAttribute("cf", (Object)cf);
        return "gift/view.ftl";
    }

    @RequestMapping(value={"/getProduct.do"}, method={RequestMethod.POST})
    public void getProduct(String id, HttpServletResponse response) throws Exception {
        Product p = this.productService.get(id);
        JSONObject rootNode = new JSONObject();
        rootNode.put("productName", (Object)p.getName());
        rootNode.put("productSpec", (Object)p.getSpec());
        rootNode.put("giftName", (Object)p.getName());
        response.getWriter().write(rootNode.toString());
    }

    @RequestMapping(value={"/editGifts.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editGifts(GiftCondition con, int pageno) {
        con.setOrgId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEm(this.getCurrentEmployee());
        return this.giftService.getList(pageno, con);
    }

    @RequestMapping(value={"/editGifts.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post_grd(@Valid @RequestBody GiftWrap wrap, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = wrap.getDelIds();
        List<Gift> gifts = wrap.getGifts();
        this.giftService.update(gifts, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/remainderlist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String remainder(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, GiftCondition con) {
        con.setEm(this.getCurrentEmployee());
        model.addAttribute("page", (Object)this.giftService.getgiftremainder(con, pageno));
        model.addAttribute("con", (Object)con);
        return "gift/remainderlist.ftl";
    }

    @RequestMapping(value={"/remainderadd.do"}, method={RequestMethod.GET})
    public String remainderadd() {
        return "gift/remainderadd.ftl";
    }

    @RequestMapping(value={"/remainderadd.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String remainderaddsbm(GiftBalance giftBalance) {
        try {
            Employee em = this.getCurrentEmployee();
            giftBalance.fillInitData(em);
            giftBalance.setSupplierId(em.getCurrentPartner().getId());
            return this.giftService.saveGiftRemainder(giftBalance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/remainderview.do"}, method={RequestMethod.GET})
    public String remainderview(GiftCondition con, Model model) {
        model.addAttribute("entity", (Object)this.giftService.getGiftRemainder(con.getId()));
        return "gift/remainderview.ftl";
    }

    @RequestMapping(value={"/remainderedit.do"}, method={RequestMethod.GET})
    public String remainderedit(GiftCondition con, Model model) {
        model.addAttribute("entity", (Object)this.giftService.getGiftRemainder(con.getId()));
        return "gift/remainderedit.ftl";
    }

    @RequestMapping(value={"/remainderedit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String remaindereditsbm(GiftBalance giftBalance, Model model) {
        try {
            this.giftService.updateGiftRemainder(giftBalance);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/seriallist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String seriallist(AplfineCondition condition, Model model) {
        model.addAttribute("list", this.giftService.getserialList(condition));
        return "gift/seriallist.ftl";
    }

    @RequestMapping(value={"/fastselect.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String fastselect(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, ProductCondition con) {
        con.setEm(this.getCurrentEmployee());
        Page product = this.giftService.getFastSelect(this.getCurrentEmployee().getCurrentPartner().getId(), con, pageno);
        model.addAttribute("partners", (Object)product);
        model.addAttribute("con", (Object)con);
        Employee e = this.getCurrentEmployee();
        ProductCondition ct = new ProductCondition();
        if (e.getCurrentPartner().getParPartnerId() == null) {
            Page page = this.productService.findPartners(ct, null, 1);
            List<Product> products = this.productService.getByPartnerIdTCBJ(e.getCurrentPartner());
            model.addAttribute("products", products);
            model.addAttribute("page", (Object)page);
        } else {
            List<Product> pds = this.productService.getProductPrice(e.getCurrentPartner().getId(), Product.class);
            List<Product> pcs = this.productService.getByPartnerId(e.getCurrentPartner().getId());
            model.addAttribute("pds", pds);
            model.addAttribute("pcs", pcs);
        }
        List<Customer> pts = this.clientService.findPartnerApplys(e.getCurrentPartner().getId());
        Date date = new Date();
        date = DateUtils.now();
        model.addAttribute("pts", pts);
        model.addAttribute("date", (Object)date);
        return "gift/allot.ftl";
    }

    @RequestMapping(value={"/allot.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String allot(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, ProductCondition con) {
        con.getGift().fillInitData(this.getCurrentEmployee());
        con.getGift().setOrganizationId(this.getCurrentEmployee().getCurrentPartner().getId());
        String[] sr = id.split(":");
        try {
            this.giftService.updateProduct(sr, pageno, con.getGift());
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/addrebatearea.do"}, method={RequestMethod.GET})
    public String addRebateArea(Model model) {
        return "gift/addrebatearea.ftl";
    }

    @RequestMapping(value={"/editRebateArea.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editRebateArea(GiftCondition con, int pageno) {
        con.setOrgId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEm(this.getCurrentEmployee());
        return this.giftService.getRebateAreaList(pageno, con);
    }

    @RequestMapping(value={"/editRebateArea.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editRebateAreaP(@Valid @RequestBody GiftWrap wrap, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = wrap.getDelIds();
        List<RebateArea> gifts = wrap.getRebateAreas();
        this.giftService.updateRebateArea(gifts, delIds, me);
        return this.getSuccessResult(null);
    }
}

